/*
 * Decompiled with CFR 0.152.
 */
package isabelle.graphbrowser;

import isabelle.graphbrowser.Directory;
import isabelle.graphbrowser.Graph;
import isabelle.graphbrowser.ParseError;
import isabelle.graphbrowser.TreeNode;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public class Console {
    Graph g;
    String gfname;

    public Console(String string) {
        this.gfname = string;
    }

    public void PS(String string, boolean bl) throws IOException {
        this.g.layout(null);
        this.g.PS(string, bl);
    }

    public void collapseNodes(Vector vector) {
        Enumeration enumeration = vector.elements();
        Graph graph = (Graph)this.g.clone();
        while (enumeration.hasMoreElements()) {
            Directory directory = (Directory)enumeration.nextElement();
            Vector vector2 = graph.decode(directory.getCollapsed());
            if (vector2.isEmpty()) continue;
            graph.collapse(vector2, "[" + directory.getName() + "]", directory.getCollapsed());
        }
        this.g = graph;
    }

    public void initBrowser(InputStream inputStream) {
        try {
            TreeNode treeNode = new TreeNode("Root", "", -1, true);
            this.g = new Graph(inputStream, treeNode);
            Vector vector = new Vector(10, 10);
            treeNode.collapsedDirectories(vector);
            this.collapseNodes(vector);
        }
        catch (IOException iOException) {
            System.err.println("\nI/O error while reading graph file.");
        }
        catch (ParseError parseError) {
            System.err.println("\nParse error in graph file:");
            System.err.println(parseError.getMessage());
            System.err.println("\nSyntax:\n<vertexname> <vertexID> <dirname> [ + ] <path> [ < | > ] [ <vertexID> [ ... [ <vertexID> ] ... ] ] ;");
        }
    }

    public static void main(String[] stringArray) {
        block7: {
            try {
                if (stringArray.length <= 1) {
                    System.err.println("Graph and output file expected.");
                    return;
                }
                Console console = new Console(stringArray[0]);
                FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
                console.initBrowser(fileInputStream);
                ((InputStream)fileInputStream).close();
                try {
                    if (stringArray[1].endsWith(".ps")) {
                        console.PS(stringArray[1], true);
                        break block7;
                    }
                    if (stringArray[1].endsWith(".eps")) {
                        console.PS(stringArray[1], false);
                        break block7;
                    }
                    System.err.println("Unknown file type: " + stringArray[1]);
                }
                catch (IOException iOException) {
                    System.err.println("Unable to write file " + stringArray[1]);
                }
            }
            catch (IOException iOException) {
                System.err.println("Can't open graph file " + stringArray[0]);
            }
        }
    }
}

