/*
 * Decompiled with CFR 0.152.
 */
package isabelle.graphbrowser;

import isabelle.graphbrowser.Box;
import isabelle.graphbrowser.DummyVertex;
import isabelle.graphbrowser.NormalVertex;
import isabelle.graphbrowser.ParseError;
import isabelle.graphbrowser.Points;
import isabelle.graphbrowser.Region;
import isabelle.graphbrowser.Spline;
import isabelle.graphbrowser.TreeNode;
import isabelle.graphbrowser.Vertex;
import java.awt.Graphics;
import java.awt.Point;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class Graph {
    public int box_height = 0;
    public int box_height2;
    public Graphics gfx;
    Vector vertices = new Vector(10, 10);
    Vector splines = new Vector(10, 10);
    Vector numEdges = new Vector(10, 10);
    Vertex[] vertices2;
    public int min_x = 0;
    public int min_y = 0;
    public int max_x = 10;
    public int max_y = 10;

    public Object clone() {
        Graph graph = new Graph();
        graph.splines = (Vector)this.splines.clone();
        Enumeration enumeration = this.vertices.elements();
        while (enumeration.hasMoreElements()) {
            graph.addVertex((Vertex)((Vertex)enumeration.nextElement()).clone());
        }
        for (int i = 0; i < this.vertices.size(); ++i) {
            Vertex vertex = (Vertex)graph.vertices.elementAt(i);
            enumeration = ((Vertex)this.vertices.elementAt(i)).getChildren();
            while (enumeration.hasMoreElements()) {
                Vertex vertex2 = (Vertex)graph.vertices.elementAt(this.vertices.indexOf(enumeration.nextElement()));
                vertex.addChild(vertex2);
            }
        }
        graph.vertices2 = new Vertex[this.vertices.size()];
        graph.vertices.copyInto(graph.vertices2);
        graph.min_x = this.min_x;
        graph.max_x = this.max_x;
        graph.min_y = this.min_y;
        graph.max_y = this.max_y;
        return graph;
    }

    Graph() {
    }

    public Graph(InputStream inputStream, TreeNode treeNode) throws IOException, ParseError {
        StreamTokenizer streamTokenizer = new StreamTokenizer(new InputStreamReader(inputStream));
        int n = 0;
        streamTokenizer.nextToken();
        while (streamTokenizer.ttype != -1) {
            boolean bl;
            boolean bl2;
            if (streamTokenizer.ttype != -3 && streamTokenizer.ttype != 34) {
                throw new ParseError("expected: vertex name\nfound   : " + streamTokenizer.toString());
            }
            String string = streamTokenizer.sval;
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype != -3 && streamTokenizer.ttype != 34) {
                throw new ParseError("expected: vertex identifier\nfound   : " + streamTokenizer.toString());
            }
            String string2 = streamTokenizer.sval;
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype != -3 && streamTokenizer.ttype != 34) {
                throw new ParseError("expected: directory name\nfound   : " + streamTokenizer.toString());
            }
            String string3 = streamTokenizer.sval;
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == 43) {
                bl2 = true;
                streamTokenizer.nextToken();
            } else {
                bl2 = false;
            }
            if (streamTokenizer.ttype != -3 && streamTokenizer.ttype != 34) {
                throw new ParseError("expected: path name\nfound   : " + streamTokenizer.toString());
            }
            Vertex vertex = this.findVertex(string2);
            if (vertex == null) {
                vertex = new NormalVertex("");
                vertex.setID(string2);
                vertex.setNumber(n++);
                this.addVertex(vertex);
            }
            vertex.setPath(streamTokenizer.sval);
            vertex.setDir(string3);
            vertex.setLabel(string);
            treeNode.insertNode(string, string3, streamTokenizer.sval, vertex.getNumber(), bl2);
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == 60) {
                bl = true;
                streamTokenizer.nextToken();
            } else if (streamTokenizer.ttype == 62) {
                bl = false;
                streamTokenizer.nextToken();
            } else {
                bl = true;
            }
            while (streamTokenizer.ttype != 59) {
                if (streamTokenizer.ttype != -3 && streamTokenizer.ttype != 34) {
                    throw new ParseError("expected: child vertex identifier or ';'\nfound   : " + streamTokenizer.toString());
                }
                Vertex vertex2 = this.findVertex(streamTokenizer.sval);
                if (vertex2 == null) {
                    vertex2 = new NormalVertex("");
                    vertex2.setID(streamTokenizer.sval);
                    vertex2.setNumber(n++);
                    this.addVertex(vertex2);
                }
                if (bl) {
                    vertex.addChild(vertex2);
                } else {
                    vertex.addParent(vertex2);
                }
                streamTokenizer.nextToken();
            }
            streamTokenizer.nextToken();
        }
        this.vertices2 = new Vertex[this.vertices.size()];
        this.vertices.copyInto(this.vertices2);
    }

    public Vertex findVertex(String string) {
        Enumeration enumeration = this.vertices.elements();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            if (!vertex.getID().equals(string)) continue;
            return vertex;
        }
        return null;
    }

    public void addVertex(Vertex vertex) {
        this.vertices.addElement(vertex);
        vertex.setGraph(this);
    }

    public void removeVertex(Vertex vertex) {
        this.vertices.removeElement(vertex);
    }

    public Enumeration getVertices() {
        return this.vertices.elements();
    }

    public void layout(Graphics graphics) {
        this.splines.removeAllElements();
        this.hasseDiagram();
        Vector vector = this.min_crossings(this.insert_dummies((Vector)this.sort().elementAt(0)));
        this.setParameters(graphics);
        this.init_coordinates(vector);
        this.pendulum(vector);
        this.rubberband(vector);
        this.calcSplines(vector);
        this.calcBoundingBox();
    }

    public void setParameters(Graphics graphics) {
        Enumeration enumeration = this.vertices.elements();
        int n = Integer.MIN_VALUE;
        while (enumeration.hasMoreElements()) {
            Box box = ((Vertex)enumeration.nextElement()).getLabelSize(graphics);
            n = Math.max(n, box.height);
        }
        this.box_height = n + 4;
        this.box_height2 = this.box_height / 2;
        this.gfx = graphics;
    }

    public Vector sort() {
        Enumeration enumeration;
        Vertex vertex;
        Vector<Vertex> vector = (Vector<Vertex>)this.vertices.clone();
        Vector vector2 = new Vector(10, 10);
        Enumeration enumeration2 = this.vertices.elements();
        while (enumeration2.hasMoreElements()) {
            ((Vertex)enumeration2.nextElement()).setDegree(0);
        }
        enumeration2 = this.vertices.elements();
        while (enumeration2.hasMoreElements()) {
            vertex = (Vertex)enumeration2.nextElement();
            enumeration = vertex.getChildren();
            while (enumeration.hasMoreElements()) {
                Vertex vertex2 = (Vertex)enumeration.nextElement();
                vector.removeElement(vertex2);
                vertex2.setDegree(1 + vertex2.getDegree());
            }
        }
        while (!vector.isEmpty()) {
            vector2.addElement(vector);
            Vector<Vertex> vector3 = new Vector<Vertex>(10, 10);
            enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                enumeration = ((Vertex)enumeration2.nextElement()).getChildren();
                while (enumeration.hasMoreElements()) {
                    vertex = (Vertex)enumeration.nextElement();
                    vertex.setDegree(vertex.getDegree() - 1);
                    if (vertex.getDegree() != 0) continue;
                    vector3.addElement(vertex);
                    vertex.setDegree(vector2.size());
                }
            }
            vector = vector3;
        }
        return vector2;
    }

    public void hasseDiagram() {
        int n;
        int n2;
        Vertex vertex;
        Vertex vertex2;
        int n3;
        int n4 = this.vertices.size();
        boolean[][] blArray = new boolean[n4][n4];
        boolean[][] blArray2 = new boolean[n4][n4];
        Enumeration enumeration = this.getVertices();
        for (n3 = 0; n3 < n4; ++n3) {
            vertex2 = (Vertex)enumeration.nextElement();
            Enumeration enumeration2 = vertex2.getChildren();
            while (enumeration2.hasMoreElements()) {
                vertex = (Vertex)enumeration2.nextElement();
                n2 = this.vertices.indexOf(vertex);
                blArray[n3][n2] = true;
                blArray2[n3][n2] = true;
            }
        }
        for (n = 0; n < n4; ++n) {
            for (n3 = 0; n3 < n4; ++n3) {
                if (!blArray[n3][n]) continue;
                for (n2 = 0; n2 < n4; ++n2) {
                    blArray[n3][n2] = blArray[n3][n2] || blArray[n][n2];
                }
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            block6: for (n2 = 0; n2 < n4; ++n2) {
                if (!blArray2[n3][n2]) continue;
                vertex2 = (Vertex)this.vertices.elementAt(n3);
                vertex = (Vertex)this.vertices.elementAt(n2);
                for (n = 0; n < n4; ++n) {
                    if (!blArray[n3][n] || !blArray[n][n2]) continue;
                    vertex2.removeChild(vertex);
                    continue block6;
                }
            }
        }
    }

    public Vector insert_dummies(Vector vector) {
        Vector vector2 = new Vector(10, 10);
        do {
            Enumeration enumeration = vector.elements();
            Vector<Vertex> vector3 = new Vector<Vertex>(10, 10);
            vector2.addElement(vector);
            int n = 0;
            while (enumeration.hasMoreElements()) {
                Vertex vertex = (Vertex)enumeration.nextElement();
                Enumeration enumeration2 = vertex.getChildren();
                while (enumeration2.hasMoreElements()) {
                    ++n;
                    Vertex vertex2 = (Vertex)enumeration2.nextElement();
                    if (vertex2.getDegree() != vertex.getDegree() + 1) {
                        DummyVertex dummyVertex = new DummyVertex();
                        dummyVertex.addChild(vertex2);
                        dummyVertex.setDegree(vertex.getDegree() + 1);
                        vertex.removeChild(vertex2);
                        vertex.addChild(dummyVertex);
                        vector3.addElement(dummyVertex);
                        this.addVertex(dummyVertex);
                        continue;
                    }
                    if (vector3.indexOf(vertex2) >= 0) continue;
                    vector3.addElement(vertex2);
                }
            }
            vector = vector3;
            this.numEdges.addElement(n);
        } while (!vector.isEmpty());
        return vector2;
    }

    public int count_crossings(Vector vector, int n) {
        int n2 = 0;
        for (int i = 0; i < vector.size() - 1; ++i) {
            Vector vector2 = (Vector)vector.elementAt(i);
            for (int j = 0; j < vector2.size(); ++j) {
                Enumeration enumeration = ((Vertex)vector2.elementAt(j)).getChildren();
                while (enumeration.hasMoreElements()) {
                    int n3 = ((Vector)vector.elementAt(i + 1)).indexOf(enumeration.nextElement());
                    for (int k = 0; k < j; ++k) {
                        Enumeration enumeration2 = ((Vertex)vector2.elementAt(k)).getChildren();
                        while (enumeration2.hasMoreElements()) {
                            int n4 = ((Vector)vector.elementAt(i + 1)).indexOf(enumeration2.nextElement());
                            if (n3 >= n4 || ++n2 < n) continue;
                            return n2;
                        }
                    }
                }
            }
        }
        return n2;
    }

    public int count_crossings_2(Vector vector, Vertex vertex, Vertex vertex2, int n) {
        Vertex vertex3;
        Enumeration enumeration;
        int n2;
        Vertex vertex4;
        Enumeration enumeration2;
        Vector vector2;
        int n3 = 0;
        int n4 = vertex.getDegree();
        if (n4 > 0) {
            vector2 = (Vector)vector.elementAt(n4 - 1);
            enumeration2 = vertex.getParents();
            while (enumeration2.hasMoreElements()) {
                vertex4 = (Vertex)enumeration2.nextElement();
                n2 = vector2.indexOf(vertex4);
                enumeration = vertex2.getParents();
                while (enumeration.hasMoreElements()) {
                    vertex3 = (Vertex)enumeration.nextElement();
                    if (vector2.indexOf(vertex3) >= n2 || ++n3 < n) continue;
                    return n3;
                }
            }
        }
        if (n4 < vector.size() - 1) {
            vector2 = (Vector)vector.elementAt(n4 + 1);
            enumeration2 = vertex.getChildren();
            while (enumeration2.hasMoreElements()) {
                vertex4 = (Vertex)enumeration2.nextElement();
                n2 = vector2.indexOf(vertex4);
                enumeration = vertex2.getChildren();
                while (enumeration.hasMoreElements()) {
                    vertex3 = (Vertex)enumeration.nextElement();
                    if (vector2.indexOf(vertex3) >= n2 || ++n3 < n) continue;
                    return n3;
                }
            }
        }
        return n3;
    }

    public void exchangeVertices(Vector vector, int n) {
        for (int i = 0; i < vector.size(); ++i) {
            Vector vector2 = (Vector)vector.elementAt(i);
            for (int j = 0; j < vector2.size() - 1; ++j) {
                int n2;
                Vertex vertex = (Vertex)vector2.elementAt(j);
                Vertex vertex2 = (Vertex)vector2.elementAt(j + 1);
                int n3 = this.count_crossings_2(vector, vertex2, vertex, n2 = this.count_crossings_2(vector, vertex, vertex2, n));
                if (n3 >= n2) continue;
                vector2.setElementAt(vertex2, j);
                vector2.setElementAt(vertex, j + 1);
            }
        }
    }

    public Vector min_crossings(Vector vector) {
        int n;
        int n2 = 0;
        int n3 = this.count_crossings(vector, Integer.MAX_VALUE);
        boolean bl = true;
        boolean bl2 = true;
        Vector<Object> vector2 = null;
        Vector<Object> vector3 = vector;
        int n4 = 0;
        while (n4 < 3 && n3 > 0) {
            int n5;
            Enumeration enumeration;
            int n6;
            Vertex vertex;
            Enumeration enumeration2;
            Vector<Vertex> vector4;
            Vector vector5;
            int n7;
            if (bl) {
                vector2 = new Vector<Object>(10, 10);
                for (n7 = 0; n7 < vector.size(); ++n7) {
                    vector5 = (Vector)vector.elementAt(n7);
                    if (n7 == 0) {
                        vector2.addElement(vector5.clone());
                        continue;
                    }
                    vector4 = new Vector<Vertex>(10, 10);
                    vector2.addElement(vector4);
                    enumeration2 = vector5.elements();
                    while (enumeration2.hasMoreElements()) {
                        vertex = (Vertex)enumeration2.nextElement();
                        n6 = 0;
                        n2 = 0;
                        enumeration = vertex.getParents();
                        while (enumeration.hasMoreElements()) {
                            n6 += ((Vector)vector2.elementAt(n7 - 1)).indexOf(enumeration.nextElement());
                            ++n2;
                        }
                        if (n2 > 0) {
                            vertex.setWeight((double)n6 / (double)n2);
                        } else if (bl2) {
                            vertex.setWeight(Double.MAX_VALUE);
                        }
                        for (n5 = 0; n5 < vector4.size() && !(vertex.getWeight() < ((Vertex)vector4.elementAt(n5)).getWeight()); ++n5) {
                        }
                        if (n5 == vector4.size()) {
                            vector4.addElement(vertex);
                            continue;
                        }
                        vector4.insertElementAt(vertex, n5);
                    }
                }
            } else {
                vector2 = new Vector(10, 10);
                for (n7 = vector.size() - 1; n7 >= 0; --n7) {
                    vector5 = (Vector)vector.elementAt(n7);
                    if (n7 == vector.size() - 1) {
                        vector2.addElement(vector5.clone());
                        continue;
                    }
                    vector4 = new Vector(10, 10);
                    vector2.insertElementAt(vector4, 0);
                    enumeration2 = vector5.elements();
                    while (enumeration2.hasMoreElements()) {
                        vertex = (Vertex)enumeration2.nextElement();
                        n6 = 0;
                        n2 = 0;
                        enumeration = vertex.getChildren();
                        while (enumeration.hasMoreElements()) {
                            n6 += ((Vector)vector2.elementAt(1)).indexOf(enumeration.nextElement());
                            ++n2;
                        }
                        if (n2 > 0) {
                            vertex.setWeight((double)n6 / (double)n2);
                        } else if (bl2) {
                            vertex.setWeight(Double.MAX_VALUE);
                        }
                        for (n5 = 0; n5 < vector4.size() && !(vertex.getWeight() < ((Vertex)vector4.elementAt(n5)).getWeight()); ++n5) {
                        }
                        if (n5 == vector4.size()) {
                            vector4.addElement(vertex);
                            continue;
                        }
                        vector4.insertElementAt(vertex, n5);
                    }
                }
            }
            bl = !bl;
            bl2 = false;
            vector = vector2;
            n = this.count_crossings(vector2, n3);
            if (n < n3) {
                vector3 = vector2;
                n3 = n;
                continue;
            }
            ++n4;
        }
        while (true) {
            this.exchangeVertices(vector3, n3);
            n = this.count_crossings(vector3, n3);
            if (n >= n3) break;
            n3 = n;
        }
        return vector3;
    }

    public void init_coordinates(Vector vector) {
        int n = 0;
        Enumeration enumeration = vector.elements();
        Enumeration enumeration2 = this.numEdges.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector2 = (Vector)enumeration.nextElement();
            Enumeration enumeration3 = vector2.elements();
            int n2 = 0;
            while (enumeration3.hasMoreElements()) {
                Vertex vertex = (Vertex)enumeration3.nextElement();
                vertex.setX(n2 + vertex.box_width2());
                vertex.setY(n);
                n2 += vertex.box_width() + 20;
            }
            n += this.box_height + Math.max(35, 7 * (Integer)enumeration2.nextElement());
        }
    }

    public void pendulum(Vector vector) {
        Vector vector2;
        Vector<Vector> vector3 = new Vector<Vector>(10, 10);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Enumeration enumeration2 = ((Vector)enumeration.nextElement()).elements();
            vector2 = new Vector(10, 10);
            vector3.addElement(vector2);
            while (enumeration2.hasMoreElements()) {
                Region region = new Region(this);
                region.addVertex((Vertex)enumeration2.nextElement());
                vector2.addElement(region);
            }
        }
        for (int i = 0; i < 10; ++i) {
            int n = 0;
            for (int j = 1; j < vector3.size(); ++j) {
                Region region;
                int n2;
                int n3;
                vector2 = (Vector)vector3.elementAt(j);
                if (vector2.size() >= 2) {
                    boolean bl;
                    do {
                        bl = false;
                        n3 = ((Region)vector2.firstElement()).pred_deflection();
                        for (n2 = 0; n2 < vector2.size() - 1; ++n2) {
                            region = (Region)vector2.elementAt(n2);
                            Region region2 = (Region)vector2.elementAt(n2 + 1);
                            int n4 = region2.pred_deflection();
                            if (region.touching(region2) && (n3 <= 0 && n4 < n3 || n4 > 0 && n3 > n4 || n3 > 0 && n4 < 0)) {
                                region.combine(region2);
                                vector2.removeElement(region2);
                                bl = true;
                                n4 = region.pred_deflection();
                            }
                            n3 = n4;
                        }
                    } while (bl);
                }
                for (n2 = 0; n2 < vector2.size(); ++n2) {
                    region = (Region)vector2.elementAt(n2);
                    int n5 = n3 = region.pred_deflection();
                    if (n3 < 0 && n2 > 0) {
                        n5 = -Math.min(((Region)vector2.elementAt(n2 - 1)).spaceBetween(region), -n3);
                    }
                    if (n3 >= 0 && n2 < vector2.size() - 1) {
                        n5 = Math.min(region.spaceBetween((Region)vector2.elementAt(n2 + 1)), n3);
                    }
                    region.move(n5);
                    n += Math.abs(n3);
                }
            }
            if (n == 0) break;
        }
    }

    public void rubberband(Vector vector) {
        for (int i = 0; i < 10; ++i) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Vector vector2 = (Vector)enumeration.nextElement();
                for (int j = 0; j < vector2.size(); ++j) {
                    int n;
                    int n2 = 0;
                    int n3 = 0;
                    Vertex vertex = (Vertex)vector2.elementAt(j);
                    Enumeration enumeration2 = vertex.getChildren();
                    while (enumeration2.hasMoreElements()) {
                        n3 += ((Vertex)enumeration2.nextElement()).getX() - vertex.getX();
                        ++n2;
                    }
                    enumeration2 = vertex.getParents();
                    while (enumeration2.hasMoreElements()) {
                        n3 += ((Vertex)enumeration2.nextElement()).getX() - vertex.getX();
                        ++n2;
                    }
                    int n4 = n = n2 != 0 ? n3 / n2 : 0;
                    if ((n3 >= 0 || j != 0 && ((Vertex)vector2.elementAt(j - 1)).rightX() + 20 >= vertex.leftX() + n) && (n3 <= 0 || j != vector2.size() - 1 && ((Vertex)vector2.elementAt(j + 1)).leftX() - 20 <= vertex.rightX() + n)) continue;
                    vertex.setX(vertex.getX() + n);
                }
            }
        }
    }

    Point intersect(Point point, Point point2, Point point3, Point point4, Point point5) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (point.x != point2.x) {
            f3 = (float)(point2.y - point.y) / (float)(point2.x - point.x);
        }
        if (point3.x != point4.x) {
            f4 = (float)(point4.y - point3.y) / (float)(point4.x - point3.x);
        }
        if (point.x == point2.x) {
            f = point5.x;
            f2 = f4 * (float)(point5.x - point3.x) + (float)point3.y;
        } else if (point3.x == point4.x) {
            f = point3.x;
            f2 = f3 * (float)(point3.x - point5.x) + (float)point5.y;
        } else {
            f = ((float)point5.x * f3 - (float)point3.x * f4 + (float)point3.y - (float)point5.y) / (f3 - f4);
            f2 = f4 * (f - (float)point3.x) + (float)point3.y;
        }
        return new Point(Math.round(f), Math.round(f2));
    }

    Points calcPoint(Point point, Point point2, Point point3, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        boolean bl = n3 >= point.y && n3 <= point3.y || n3 >= point3.y && n3 <= point.y;
        boolean bl2 = n3 + this.box_height >= point.y && n3 + this.box_height <= point3.y || n3 + this.box_height >= point3.y && n3 + this.box_height <= point.y;
        boolean bl3 = false;
        int n6 = point.x + (n3 - point.y) * (point3.x - point.x) / (point3.y - point.y);
        int n7 = point.x + (n3 + this.box_height - point.y) * (point3.x - point.x) / (point3.y - point.y);
        if (n6 <= n && bl && n7 <= n && bl2) {
            bl3 = true;
            n4 = n;
            n5 = n3 + (n6 < n7 ? 0 : this.box_height);
        } else if (n6 >= n2 && bl && n7 >= n2 && bl2) {
            bl3 = true;
            n4 = n2;
            n5 = n3 + (n6 > n7 ? 0 : this.box_height);
        } else if ((n6 <= n || n6 >= n2) && bl) {
            bl3 = true;
            n4 = n6 <= n ? n : n2;
            n5 = n3;
        } else if ((n7 <= n || n7 >= n2) && bl2) {
            bl3 = true;
            n4 = n7 <= n ? n : n2;
            n5 = n3 + this.box_height;
        }
        Point point4 = new Point(n4, n5);
        if (bl3) {
            return new Points(this.intersect(point, point3, point, point2, point4), this.intersect(point, point3, point2, point3, point4));
        }
        return new Points(point, point3);
    }

    public void calcSplines(Vector vector) {
        Enumeration enumeration = this.vertices.elements();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            if (vertex.isDummy()) continue;
            Enumeration enumeration2 = vertex.getChildren();
            while (enumeration2.hasMoreElements()) {
                int n;
                int n2;
                int n3;
                Vector vector2;
                int n4;
                int n5;
                Vertex vertex2 = (Vertex)enumeration2.nextElement();
                if (!vertex2.isDummy()) continue;
                Vertex vertex3 = vertex2;
                Vector<Integer> vector3 = new Vector<Integer>(10, 10);
                int n6 = vertex.getX();
                int n7 = vertex.getY() + this.box_height;
                do {
                    n5 = vertex2.getX();
                    n4 = vertex2.getY();
                    vector2 = (Vector)vector.elementAt(vertex2.getDegree());
                    n3 = vector2.indexOf(vertex2);
                    vertex2 = (Vertex)vertex2.getChildren().nextElement();
                    n2 = vertex2.getX();
                    n = vertex2.getY();
                    int n8 = 0;
                    int n9 = n3 == 0 ? Integer.MIN_VALUE : ((Vertex)vector2.elementAt(n3 - 1)).rightX() + n8;
                    int n10 = n3 == vector2.size() - 1 ? Integer.MAX_VALUE : ((Vertex)vector2.elementAt(n3 + 1)).leftX() - n8;
                    int n11 = n5 + this.box_height * (n2 - n5) / (n - n4);
                    if (!(n5 <= n2 && n11 >= n10 || n5 > n2 && n11 <= n9)) {
                        vector3.addElement(1);
                        n7 = n4;
                    } else {
                        n11 = n6 + (n4 - n7) * (n5 - n6) / (n4 + this.box_height - n7);
                        if (!(n5 <= n6 && n11 >= n10 || n5 > n6 && n11 <= n9)) {
                            vector3.addElement(2);
                        } else {
                            vector3.addElement(3);
                        }
                        n7 = n4 + this.box_height;
                    }
                    n6 = n5;
                } while (vertex2.isDummy());
                vector3.addElement(1);
                vertex2 = vertex3;
                int n12 = 0;
                Vector<Point> vector4 = new Vector<Point>(10, 10);
                n6 = vertex.getX();
                n7 = vertex.getY() + this.box_height;
                vector4.addElement(new Point(n6, n7));
                do {
                    Points points;
                    Point point;
                    n5 = vertex2.getX();
                    n4 = vertex2.getY();
                    int n13 = (Integer)vector3.elementAt(n12);
                    int n14 = (Integer)vector3.elementAt(n12 + 1);
                    ++n12;
                    vector2 = (Vector)vector.elementAt(vertex2.getDegree());
                    n3 = vector2.indexOf(vertex2);
                    int n15 = vertex2.getY();
                    vertex2 = (Vertex)vertex2.getChildren().nextElement();
                    n2 = vertex2.getX();
                    n = vertex2.getY();
                    if (n13 == 2) {
                        n4 += this.box_height;
                    }
                    if (n14 == 2) {
                        n += this.box_height;
                    }
                    int n16 = n3 == 0 ? Integer.MIN_VALUE : ((Vertex)vector2.elementAt(n3 - 1)).rightX();
                    int n17 = n3 == vector2.size() - 1 ? Integer.MAX_VALUE : ((Vertex)vector2.elementAt(n3 + 1)).leftX();
                    Point point2 = new Point((n6 + n5) / 2, (n7 + n4) / 2);
                    if (n13 <= 2) {
                        point = new Point(n5, n4);
                        points = this.calcPoint(point2, point, new Point((n5 + n2) / 2, (n4 + n) / 2), n16, n17, n15);
                        vector4.addElement(points.p);
                        vector4.addElement(point);
                        vector4.addElement(points.q);
                    } else {
                        point = new Point(n5, n4 - this.box_height);
                        Point point3 = new Point(n5, n4 + this.box_height2);
                        points = this.calcPoint(point2, point, point3, n16, n17, n15);
                        vector4.addElement(points.p);
                        vector4.addElement(point);
                        vector4.addElement(points.q);
                        point = new Point(n5, n4 + this.box_height * 2);
                        points = this.calcPoint(point3, point, new Point((point.x + n2) / 2, (point.y + n) / 2), n16, n17, n15);
                        vector4.addElement(points.p);
                        vector4.addElement(point);
                        vector4.addElement(points.q);
                    }
                    n6 = point.x;
                    n7 = point.y;
                } while (vertex2.isDummy());
                vector4.addElement(new Point(vertex2.getX(), vertex2.getY()));
                this.splines.addElement(new Spline(vector4));
            }
        }
    }

    public void calcBoundingBox() {
        this.min_x = Integer.MAX_VALUE;
        this.min_y = Integer.MAX_VALUE;
        this.max_x = Integer.MIN_VALUE;
        this.max_y = Integer.MIN_VALUE;
        Enumeration enumeration = this.vertices.elements();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            this.min_x = Math.min(this.min_x, vertex.leftX());
            this.max_x = Math.max(this.max_x, vertex.rightX());
            this.min_y = Math.min(this.min_y, vertex.getY());
            this.max_y = Math.max(this.max_y, vertex.getY() + this.box_height);
        }
        this.min_x -= 20;
        this.min_y -= 20;
        this.max_x += 20;
        this.max_y += 20;
    }

    public void draw(Graphics graphics) {
        if (this.box_height == 0) {
            this.layout(graphics);
        }
        graphics.translate(-this.min_x, -this.min_y);
        Enumeration enumeration = this.vertices.elements();
        while (enumeration.hasMoreElements()) {
            ((Vertex)enumeration.nextElement()).draw(graphics);
        }
        enumeration = this.splines.elements();
        while (enumeration.hasMoreElements()) {
            ((Spline)enumeration.nextElement()).draw(graphics);
        }
    }

    public Vertex vertexAt(int n, int n2) {
        Enumeration enumeration = this.vertices.elements();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            if (!vertex.contains(n, n2)) continue;
            return vertex;
        }
        return null;
    }

    public Vector encode(Vector vector) {
        Vector<Integer> vector2 = new Vector<Integer>(10, 10);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            if (vertex.getNumber() < 0) continue;
            vector2.addElement(vertex.getNumber());
        }
        return vector2;
    }

    public Vertex getVertexByNum(int n) {
        Enumeration enumeration = this.vertices.elements();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            if (vertex.getNumber() != n) continue;
            return vertex;
        }
        return null;
    }

    public Vector decode(Vector vector) {
        Enumeration enumeration = vector.elements();
        Vector<Vertex> vector2 = new Vector<Vertex>(10, 10);
        while (enumeration.hasMoreElements()) {
            int n = (Integer)enumeration.nextElement();
            vector2.addElement(this.vertices2[n]);
        }
        return vector2;
    }

    public void collapse(Vector vector, String string, Vector vector2) {
        boolean bl = false;
        Enumeration enumeration = this.vertices.elements();
        NormalVertex normalVertex = new NormalVertex(string);
        ((Vertex)normalVertex).setInflate(vector2);
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            if (vector.indexOf(vertex) < 0) {
                Vertex vertex2;
                Enumeration enumeration2 = vertex.getParents();
                while (enumeration2.hasMoreElements()) {
                    vertex2 = (Vertex)enumeration2.nextElement();
                    if (vector.indexOf(vertex2) < 0) continue;
                    if (!normalVertex.isChild(vertex)) {
                        normalVertex.addChild(vertex);
                    }
                    vertex2.removeChild(vertex);
                }
                enumeration2 = vertex.getChildren();
                while (enumeration2.hasMoreElements()) {
                    vertex2 = (Vertex)enumeration2.nextElement();
                    if (vector.indexOf(vertex2) < 0) continue;
                    if (!vertex.isChild(normalVertex)) {
                        vertex.addChild(normalVertex);
                    }
                    vertex.removeChild(vertex2);
                }
                continue;
            }
            bl = true;
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            try {
                this.removeVertex((Vertex)enumeration.nextElement());
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        if (bl) {
            this.addVertex(normalVertex);
        }
    }

    public void PS(String string, boolean bl) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        PrintWriter printWriter = new PrintWriter(fileOutputStream, true);
        if (bl) {
            printWriter.println("%!PS-Adobe-2.0\n\n%%BeginProlog");
        } else {
            printWriter.println("%!PS-Adobe-2.0 EPSF-2.0\n%%Orientation: Portrait");
            printWriter.println("%%BoundingBox: " + this.min_x + " " + this.min_y + " " + this.max_x + " " + this.max_y);
            printWriter.println("%%EndComments\n\n%%BeginProlog");
        }
        printWriter.println("/m { moveto } def /l { lineto } def /n { newpath } def");
        printWriter.println("/s { stroke } def /c { curveto } def");
        printWriter.println("/b { n 0 0 m dup true charpath pathbbox 1 index 4 index sub");
        printWriter.println("7 index exch sub 2 div 9 index add 1 index 4 index sub 7 index exch sub");
        printWriter.println("2 div 9 index add 2 index add m pop pop pop pop");
        printWriter.println("1 -1 scale show 1 -1 scale n 3 index 3 index m 1 index 0 rlineto");
        printWriter.println("0 exch rlineto neg 0 rlineto closepath s pop pop } def");
        printWriter.println("%%EndProlog\n");
        if (bl) {
            double d;
            double d2;
            double d3;
            int n = this.max_x - this.min_x;
            int n2 = this.max_y - this.min_y;
            if (n > n2) {
                d3 = Math.min(1.0, Math.min(750.0 / (double)n, 500.0 / (double)n2));
                d2 = 50.0 + (double)this.max_y * d3 + (500.0 - d3 * (double)n2) / 2.0;
                d = 50.0 + (double)this.max_x * d3 + (750.0 - d3 * (double)n) / 2.0;
                printWriter.println(d2 + " " + d + " translate");
                printWriter.println("-90 rotate");
                printWriter.println(d3 + " " + -d3 + " scale");
            } else {
                d3 = Math.min(1.0, Math.min(500.0 / (double)n, 750.0 / (double)n2));
                d2 = 50.0 - (double)this.min_x * d3 + (500.0 - d3 * (double)n) / 2.0;
                d = 50.0 + (double)this.max_y * d3 + (750.0 - d3 * (double)n2) / 2.0;
                printWriter.println(d2 + " " + d + " translate");
                printWriter.println(d3 + " " + -d3 + " scale");
            }
        } else {
            printWriter.println("0 " + (this.max_y + this.min_y) + " translate\n1 -1 scale");
        }
        printWriter.println("/Helvetica findfont 12 scalefont setfont");
        printWriter.println("0.5 setlinewidth");
        Enumeration enumeration = this.vertices.elements();
        while (enumeration.hasMoreElements()) {
            ((Vertex)enumeration.nextElement()).PS(printWriter);
        }
        enumeration = this.splines.elements();
        while (enumeration.hasMoreElements()) {
            ((Spline)enumeration.nextElement()).PS(printWriter);
        }
        if (bl) {
            printWriter.println("showpage");
        }
        fileOutputStream.close();
    }
}

