/*
 * Decompiled with CFR 0.152.
 */
package isabelle.graphbrowser;

import isabelle.awt.Border;
import isabelle.awt.TextFrame;
import isabelle.graphbrowser.Graph;
import isabelle.graphbrowser.GraphBrowserFrame;
import isabelle.graphbrowser.GraphView;
import isabelle.graphbrowser.ParseError;
import isabelle.graphbrowser.TreeBrowser;
import isabelle.graphbrowser.TreeNode;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.Vector;

public class GraphBrowser
extends Panel {
    GraphView gv;
    TreeBrowser tb = null;
    String gfname;
    static Frame f;

    public GraphBrowser(String string) {
        this.gfname = string;
    }

    public GraphBrowser() {
    }

    public void showWaitMessage() {
        f.setCursor(new Cursor(3));
    }

    public void showReadyMessage() {
        f.setCursor(new Cursor(0));
    }

    public void viewFile(String string) {
        try {
            Object object;
            String string2;
            Reader reader;
            String string3 = this.gfname.substring(0, this.gfname.lastIndexOf(47) + 1);
            String string4 = "";
            try {
                reader = new BufferedReader(new InputStreamReader(new URI(string).toURL().openConnection().getInputStream()));
            }
            catch (Exception exception) {
                reader = new FileReader(string3 + string);
            }
            BufferedReader bufferedReader = new BufferedReader(reader);
            while ((string2 = bufferedReader.readLine()) != null) {
                string4 = string4 + string2 + "\n";
            }
            if (string.endsWith(".html")) {
                object = "";
                int n = 0;
                boolean bl = false;
                boolean bl2 = false;
                char[] cArray = string4.toCharArray();
                char[] cArray2 = new char[string4.length()];
                for (int i = 0; i < string4.length(); ++i) {
                    char c = cArray[i];
                    if (c == '&') {
                        bl = true;
                        object = "";
                        continue;
                    }
                    if (bl) {
                        if (c == ';') {
                            bl = false;
                            if (((String)object).equals("lt")) {
                                cArray2[n++] = 60;
                                continue;
                            }
                            if (((String)object).equals("gt")) {
                                cArray2[n++] = 62;
                                continue;
                            }
                            if (!((String)object).equals("amp")) continue;
                            cArray2[n++] = 38;
                            continue;
                        }
                        object = (String)object + c;
                        continue;
                    }
                    if (c == '<') {
                        bl2 = true;
                        char c2 = cArray[i + 1];
                        continue;
                    }
                    if (c == '>') {
                        bl2 = false;
                        continue;
                    }
                    if (bl2) continue;
                    cArray2[n++] = c;
                }
                string4 = String.valueOf(cArray2);
            }
            object = new TextFrame(string.substring(string.lastIndexOf(47) + 1), string4);
            ((Window)object).setSize(500, 600);
            ((Window)object).setVisible(true);
        }
        catch (Exception exception) {
            System.err.println("Can't read file " + string);
        }
    }

    public void PS(String string, boolean bl) throws IOException {
        this.gv.PS(string, bl);
    }

    public boolean isEmpty() {
        return this.tb == null;
    }

    public void initBrowser(InputStream inputStream, boolean bl) {
        try {
            Font font = bl ? null : new Font("Helvetica", 0, 12);
            TreeNode treeNode = new TreeNode("Root", "", -1, true);
            this.gv = new GraphView(new Graph(inputStream, treeNode), this, font);
            this.tb = new TreeBrowser(treeNode, this.gv, font);
            this.gv.setTreeBrowser(this.tb);
            Vector vector = new Vector(10, 10);
            treeNode.collapsedDirectories(vector);
            this.gv.collapseDir(vector);
            ScrollPane scrollPane = new ScrollPane();
            ScrollPane scrollPane2 = new ScrollPane();
            scrollPane.add(this.gv);
            scrollPane2.add(this.tb);
            scrollPane.getHAdjustable().setUnitIncrement(20);
            scrollPane.getVAdjustable().setUnitIncrement(20);
            scrollPane2.getHAdjustable().setUnitIncrement(20);
            scrollPane2.getVAdjustable().setUnitIncrement(20);
            Border border = new Border(scrollPane, 3);
            Border border2 = new Border(scrollPane2, 3);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(border2, gridBagConstraints);
            this.add(border2);
            gridBagConstraints.weightx = 2.5;
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(border, gridBagConstraints);
            this.add(border);
        }
        catch (IOException iOException) {
            System.err.println("\nI/O error while reading graph file.");
        }
        catch (ParseError parseError) {
            System.err.println("\nParse error in graph file:");
            System.err.println(parseError.getMessage());
            System.err.println("\nSyntax:\n<vertexname> <vertexID> <dirname> [ + ] <path> [ < | > ] [ <vertexID> [ ... [ <vertexID> ] ... ] ] ;");
        }
    }

    public static void main(String[] stringArray) {
        block8: {
            try {
                GraphBrowser graphBrowser = new GraphBrowser(stringArray.length > 0 ? stringArray[0] : "");
                if (stringArray.length > 0) {
                    FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
                    graphBrowser.initBrowser(fileInputStream, stringArray.length > 1);
                    ((InputStream)fileInputStream).close();
                }
                if (stringArray.length > 1) {
                    try {
                        if (stringArray[1].endsWith(".ps")) {
                            graphBrowser.gv.PS(stringArray[1], true);
                            break block8;
                        }
                        if (stringArray[1].endsWith(".eps")) {
                            graphBrowser.gv.PS(stringArray[1], false);
                            break block8;
                        }
                        System.err.println("Unknown file type: " + stringArray[1]);
                    }
                    catch (IOException iOException) {
                        System.err.println("Unable to write file " + stringArray[1]);
                    }
                    break block8;
                }
                f = new GraphBrowserFrame(graphBrowser);
                f.setSize(700, 500);
                f.setVisible(true);
            }
            catch (IOException iOException) {
                System.err.println("Can't open graph file " + stringArray[0]);
            }
        }
    }
}

