/*
 * Decompiled with CFR 0.152.
 */
package isabelle.graphbrowser;

import isabelle.graphbrowser.Graph;
import isabelle.graphbrowser.Vertex;
import java.util.Enumeration;
import java.util.Vector;

class Region {
    Vector vertices = new Vector(10, 10);
    Graph gra;

    public Region(Graph graph) {
        this.gra = graph;
    }

    public void addVertex(Vertex vertex) {
        this.vertices.addElement(vertex);
    }

    public Enumeration getVertices() {
        return this.vertices.elements();
    }

    public int pred_deflection() {
        float f = 0.0f;
        int n = 0;
        Enumeration enumeration = this.vertices.elements();
        while (enumeration.hasMoreElements()) {
            float f2 = 0.0f;
            int n2 = 0;
            ++n;
            Vertex vertex = (Vertex)enumeration.nextElement();
            Enumeration enumeration2 = vertex.getParents();
            while (enumeration2.hasMoreElements()) {
                ++n2;
                f2 += (float)(((Vertex)enumeration2.nextElement()).getX() - vertex.getX());
            }
            if (n2 <= 0) continue;
            f += f2 / (float)n2;
        }
        return Math.round(f / (float)n);
    }

    public int succ_deflection() {
        float f = 0.0f;
        int n = 0;
        Enumeration enumeration = this.vertices.elements();
        while (enumeration.hasMoreElements()) {
            float f2 = 0.0f;
            int n2 = 0;
            ++n;
            Vertex vertex = (Vertex)enumeration.nextElement();
            Enumeration enumeration2 = vertex.getChildren();
            while (enumeration2.hasMoreElements()) {
                ++n2;
                f2 += (float)(((Vertex)enumeration2.nextElement()).getX() - vertex.getX());
            }
            if (n2 <= 0) continue;
            f += f2 / (float)n2;
        }
        return Math.round(f / (float)n);
    }

    public void move(int n) {
        Enumeration enumeration = this.vertices.elements();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            vertex.setX(vertex.getX() + n);
        }
    }

    public void combine(Region region) {
        Enumeration enumeration = region.getVertices();
        while (enumeration.hasMoreElements()) {
            this.addVertex((Vertex)enumeration.nextElement());
        }
    }

    public int spaceBetween(Region region) {
        return ((Vertex)region.getVertices().nextElement()).leftX() - ((Vertex)this.vertices.lastElement()).rightX() - 20;
    }

    public boolean touching(Region region) {
        return this.spaceBetween(region) == 0;
    }
}

