/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Component_CSDP;
import isabelle.Component_CSDP$Flags$;
import isabelle.Components;
import isabelle.Components$Directory$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.Date$;
import isabelle.Date$Format$;
import isabelle.Executable$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Isabelle_Platform$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.Isabelle_Tool$;
import isabelle.MinGW;
import isabelle.MinGW$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Platform$;
import isabelle.Progress;
import isabelle.Properties$Eq$;
import isabelle.SSH;
import isabelle.Scala_Project$;
import isabelle.package$;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.matching.Regex;

public final class Component_CSDP$
implements Serializable {
    private static final String default_download_url;
    public static final Component_CSDP$Flags$ Flags;
    private static final List build_flags;
    private static final Isabelle_Tool isabelle_tool;
    public static final Component_CSDP$ MODULE$;

    private Component_CSDP$() {
    }

    static {
        MODULE$ = new Component_CSDP$();
        default_download_url = "https://github.com/coin-or/Csdp/archive/releases/6.1.1.tar.gz";
        build_flags = (List)new .colon.colon((Object)Component_CSDP$Flags$.MODULE$.apply("arm64-linux", "-O3 -ansi -Wall -DNOSHORTS -DBIT64 -DUSESIGTERM -DUSEGETTIME -I../include", "-static -L../lib -lsdp -llapack -lblas -lgfortran -lm"), (List)new .colon.colon((Object)Component_CSDP$Flags$.MODULE$.apply("x86_64-linux", "-O3 -ansi -Wall -DNOSHORTS -DBIT64 -DUSESIGTERM -DUSEGETTIME -I../include", "-static -L../lib -lsdp -llapack -lblas -lgfortran -lquadmath -lm"), (List)new .colon.colon((Object)Component_CSDP$Flags$.MODULE$.apply("arm64-darwin", "-O3 -Wall -DNOSHORTS -DBIT64 -DUSESIGTERM -DUSEGETTIME -I../include", "-L../lib -lsdp -llapack -lblas -lm"), (List)new .colon.colon((Object)Component_CSDP$Flags$.MODULE$.apply("x86_64-darwin", "-O3 -Wall -DNOSHORTS -DBIT64 -DUSESIGTERM -DUSEGETTIME -I../include", "-L../lib -lsdp -llapack -lblas -lm"), (List)new .colon.colon((Object)Component_CSDP$Flags$.MODULE$.apply("x86_64-windows", Component_CSDP$Flags$.MODULE$.$lessinit$greater$default$2(), Component_CSDP$Flags$.MODULE$.$lessinit$greater$default$3()), (List)Nil$.MODULE$)))));
        isabelle_tool = Isabelle_Tool$.MODULE$.apply("component_csdp", "build prover component from official download", Scala_Project$.MODULE$.here(), (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)args -> {
            ObjectRef target_dir = ObjectRef.create((Object)Path$.MODULE$.current());
            ObjectRef mingw = ObjectRef.create((Object)MinGW$.MODULE$.none());
            ObjectRef download_url = ObjectRef.create((Object)this.default_download_url());
            BooleanRef verbose = BooleanRef.create((boolean)false);
            Object[] objectArray = new Tuple2[4];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"D:");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)arg -> {
                target_dir$1.elem = Path$.MODULE$.explode((String)arg);
            });
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"M:");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (JProcedure1 & Serializable)arg -> {
                mingw$1.elem = MinGW$.MODULE$.apply(Path$.MODULE$.explode((String)arg));
            });
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"U:");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (JProcedure1 & Serializable)arg -> {
                download_url$1.elem = arg;
            });
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"v");
            objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (JProcedure1 & Serializable)_$3 -> {
                verbose$1.elem = true;
            });
            Getopts getopts = Getopts$.MODULE$.apply((Function0<String>)((Function0 & Serializable)this::$anonfun$1), (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            List<String> more_args = getopts.apply((List<String>)args);
            if (more_args.nonEmpty()) {
                throw getopts.usage(getopts.usage$default$1());
            }
            Console_Progress progress = new Console_Progress(verbose.elem, Console_Progress$.MODULE$.$lessinit$greater$default$2(), Console_Progress$.MODULE$.$lessinit$greater$default$3(), Console_Progress$.MODULE$.$lessinit$greater$default$4());
            this.build_csdp((String)download_url.elem, progress, (Path)target_dir.elem, (MinGW)mingw.elem);
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Component_CSDP$.class);
    }

    public String default_download_url() {
        return default_download_url;
    }

    public List<Component_CSDP.Flags> build_flags() {
        return build_flags;
    }

    public void build_csdp(String download_url, Progress progress, Path target_dir, MinGW mingw) {
        mingw.check();
        Isabelle_System$.MODULE$.with_tmp_dir("build", Isabelle_System$.MODULE$.with_tmp_dir$default$2(), (JProcedure1 & Serializable)tmp_dir -> {
            String string;
            String version;
            List list;
            Option option;
            String string2;
            String name;
            List list2;
            Option option2;
            String archive_name;
            Regex Archive_Name = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^.*?([^/]+)$"));
            Regex Version2 = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^[^0-9]*([0-9].*)\\.tar.gz$"));
            String string3 = download_url;
            String string4 = archive_name = string3 != null && !(option2 = Archive_Name.unapplySeq((CharSequence)string3)).isEmpty() && (list2 = (List)option2.get()).lengthCompare(1) == 0 ? (name = (string2 = (String)list2.apply(0))) : (String)package$.MODULE$.error().apply((Object)("Failed to determine source archive name from " + package$.MODULE$.quote().apply((Object)download_url)));
            String version2 = string4 != null && !(option = Version2.unapplySeq((CharSequence)string4)).isEmpty() && (list = (List)option.get()).lengthCompare(1) == 0 ? (version = (string = (String)list.apply(0))) : (String)package$.MODULE$.error().apply((Object)("Failed to determine component version from " + package$.MODULE$.quote().apply((Object)archive_name)));
            String component_name = "csdp-" + version2;
            Components.Directory directory = Components$Directory$.MODULE$.apply(target_dir.$plus(Path$.MODULE$.basic(component_name)), Components$Directory$.MODULE$.apply$default$2());
            Components.Directory component_dir = directory.create(progress, directory.create$default$2());
            String platform_name = Isabelle_Platform$.MODULE$.local().ISABELLE_PLATFORM(true, true);
            Path platform_dir = Isabelle_System$.MODULE$.make_directory(component_dir.path().$plus(Path$.MODULE$.basic(platform_name)));
            Path archive_path = tmp_dir.$plus(Path$.MODULE$.basic(archive_name));
            Isabelle_System$.MODULE$.download_file(download_url, archive_path, progress);
            Isabelle_System$.MODULE$.extract(archive_path, (Path)tmp_dir, Isabelle_System$.MODULE$.extract$default$3());
            Path source_dir = File$.MODULE$.get_dir((Path)tmp_dir, download_url);
            Isabelle_System$.MODULE$.extract(archive_path, component_dir.src(), true);
            progress.echo("Building CSDP for " + platform_name + " ...", progress.echo$default$2());
            Option option3 = MODULE$.build_flags().find((Function1 & Serializable)flags -> {
                String string = flags.platform();
                String string2 = platform_name;
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
            if (None$.MODULE$.equals(option3)) {
                package$.MODULE$.error().apply((Object)("No build flags for platform " + package$.MODULE$.quote().apply((Object)platform_name)));
            } else if (option3 instanceof Some) {
                Component_CSDP.Flags flags2 = (Component_CSDP.Flags)((Some)option3).value();
                File$.MODULE$.find_files(source_dir.file(), (Function1<File, Object>)(Function1 & Serializable)file -> {
                    String string = file.getName();
                    String string2 = "Makefile";
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }, File$.MODULE$.find_files$default$3(), File$.MODULE$.find_files$default$4()).foreach((Function1)(JProcedure1 & Serializable)file -> flags2.change(File$.MODULE$.path((File)file)));
            } else {
                throw new MatchError((Object)option3);
            }
            String string5 = mingw.bash_script("make", mingw.bash_script$default$2());
            boolean bl = progress.verbose();
            SSH.System system = progress.bash$default$2();
            Map<String, String> map = progress.bash$default$4();
            boolean bl2 = progress.bash$default$5();
            long l = progress.bash$default$7();
            boolean bl3 = progress.bash$default$8();
            progress.bash(string5, system, source_dir, map, bl2, bl, l, bl3).check();
            Isabelle_System$.MODULE$.copy_file(source_dir.$plus(Path$.MODULE$.explode("LICENSE")), component_dir.path());
            Isabelle_System$.MODULE$.copy_file(source_dir.$plus(Path$.MODULE$.explode("solver/csdp").platform_exe()), platform_dir);
            if (Platform$.MODULE$.is_windows()) {
                Path path = platform_dir.$plus(Path$.MODULE$.explode("csdp.exe"));
                Set set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"libblas", "liblapack", "libgfortran", "libgcc_s_seh", "libquadmath", "libwinpthread"}));
                String string6 = Executable$.MODULE$.library_closure$default$2();
                Executable$.MODULE$.library_closure(path, string6, mingw, (Function1<String, Object>)set);
            }
            component_dir.write_settings("\nISABELLE_CSDP=\"$COMPONENT/\"${ISABELLE_WINDOWS_PLATFORM64:-${ISABELLE_APPLE_PLATFORM64:-$ISABELLE_PLATFORM64}}\"/csdp\"\n");
            File$.MODULE$.write(component_dir.README(), "This is CSDP " + version2 + " from\n" + download_url + "\n\nMakefile flags have been changed for various platforms as follows:\n\n" + MODULE$.build_flags().flatMap((Function1 & Serializable)_$2 -> _$2.print()).mkString("\n\n") + "\n\nThe distribution has been built like this:\n\n    cd src && make\n\nOnly the bare \"solver/csdp\" program is used for Isabelle.\n\n\n        Makarius\n        " + Date$Format$.MODULE$.date().apply(Date$.MODULE$.now(Date$.MODULE$.now$default$1())) + "\n");
        });
    }

    public String build_csdp$default$1() {
        return this.default_download_url();
    }

    public Progress build_csdp$default$2() {
        return new Progress();
    }

    public Path build_csdp$default$3() {
        return Path$.MODULE$.current();
    }

    public MinGW build_csdp$default$4() {
        return MinGW$.MODULE$.none();
    }

    public Isabelle_Tool isabelle_tool() {
        return isabelle_tool;
    }

    private final String $anonfun$1() {
        return "\nUsage: isabelle component_csdp [OPTIONS]\n\n  Options are:\n    -D DIR       target directory (default \".\")\n    -M DIR       msys/mingw root specification for Windows\n    -U URL       download URL\n                 (default: \"" + this.default_download_url() + "\")\n    -v           verbose\n\n  Build prover component from official download.\n";
    }

    public static final /* synthetic */ String isabelle$Component_CSDP$Flags$$_$print$$anonfun$1(Tuple2 p) {
        return "    " + Properties$Eq$.MODULE$.apply((Tuple2<String, String>)p);
    }
}

