/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Components;
import isabelle.Components$Directory$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.Date$;
import isabelle.Date$Format$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.Isabelle_Tool$;
import isabelle.Library$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Progress;
import isabelle.Scala_Project$;
import isabelle.package$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class Component_Easychair$
implements Serializable {
    private static final String default_url;
    private static final Isabelle_Tool isabelle_tool;
    public static final Component_Easychair$ MODULE$;

    private Component_Easychair$() {
    }

    static {
        MODULE$ = new Component_Easychair$();
        default_url = "https://easychair.org/publications/easychair.zip";
        isabelle_tool = Isabelle_Tool$.MODULE$.apply("component_easychair", "build component for Easychair LaTeX style", Scala_Project$.MODULE$.here(), (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)args -> {
            ObjectRef target_dir = ObjectRef.create((Object)Path$.MODULE$.current());
            ObjectRef download_url = ObjectRef.create((Object)this.default_url());
            Object[] objectArray = new Tuple2[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"D:");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)arg -> {
                target_dir$1.elem = Path$.MODULE$.explode((String)arg);
            });
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"U:");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (JProcedure1 & Serializable)arg -> {
                download_url$1.elem = arg;
            });
            Getopts getopts = Getopts$.MODULE$.apply((Function0<String>)((Function0 & Serializable)this::$anonfun$1), (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            List<String> more_args = getopts.apply((List<String>)args);
            if (more_args.nonEmpty()) {
                throw getopts.usage(getopts.usage$default$1());
            }
            Console_Progress progress = new Console_Progress(Console_Progress$.MODULE$.$lessinit$greater$default$1(), Console_Progress$.MODULE$.$lessinit$greater$default$2(), Console_Progress$.MODULE$.$lessinit$greater$default$3(), Console_Progress$.MODULE$.$lessinit$greater$default$4());
            this.build_easychair((String)download_url.elem, (Path)target_dir.elem, progress);
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Component_Easychair$.class);
    }

    public String default_url() {
        return default_url;
    }

    public void build_easychair(String download_url, Path target_dir, Progress progress) {
        Isabelle_System$.MODULE$.with_tmp_file("download", "zip", Isabelle_System$.MODULE$.with_tmp_file$default$3(), (JProcedure1 & Serializable)download_file -> Isabelle_System$.MODULE$.with_tmp_dir("download", Isabelle_System$.MODULE$.with_tmp_dir$default$2(), (JProcedure1 & Serializable)download_dir -> {
            Isabelle_System$.MODULE$.download_file(download_url, (Path)download_file, progress);
            Isabelle_System$.MODULE$.extract((Path)download_file, (Path)download_dir, Isabelle_System$.MODULE$.extract$default$3());
            Path easychair_dir = File$.MODULE$.get_dir((Path)download_dir, download_url);
            String version = (String)Library$.MODULE$.try_unprefix("EasyChair", easychair_dir.file_name()).getOrElse(() -> Component_Easychair$.$anonfun$4(easychair_dir));
            String component = "easychair-" + version;
            Components.Directory directory = Components$Directory$.MODULE$.apply(target_dir.$plus(Path$.MODULE$.basic(component)), Components$Directory$.MODULE$.apply$default$2());
            Components.Directory component_dir = directory.create(progress, directory.create$default$2());
            Isabelle_System$.MODULE$.extract((Path)download_file, component_dir.path(), true);
            component_dir.write_settings("\nISABELLE_EASYCHAIR_HOME=\"$COMPONENT\"\n");
            File$.MODULE$.write(component_dir.README(), "This is the Easychair style for authors from\n" + download_url + "\n\n\n    Makarius\n    " + Date$Format$.MODULE$.date().apply(Date$.MODULE$.now(Date$.MODULE$.now$default$1())) + "\n");
        }));
    }

    public String build_easychair$default$1() {
        return this.default_url();
    }

    public Path build_easychair$default$2() {
        return Path$.MODULE$.current();
    }

    public Progress build_easychair$default$3() {
        return new Progress();
    }

    public Isabelle_Tool isabelle_tool() {
        return isabelle_tool;
    }

    private final String $anonfun$1() {
        return "\nUsage: isabelle component_easychair [OPTIONS]\n\n  Options are:\n    -D DIR       target directory (default \".\")\n    -U URL       download URL (default: \"" + this.default_url() + "\")\n\n  Build component for Easychair LaTeX style.\n";
    }

    private static final String $anonfun$4(Path easychair_dir$1) {
        return "Failed to detect version from " + package$.MODULE$.quote().apply((Object)easychair_dir$1.file_name());
    }
}

