/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Components;
import isabelle.Components$Directory$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.Date$;
import isabelle.Date$Format$;
import isabelle.Executable$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Isabelle_Platform$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.Isabelle_Tool$;
import isabelle.MinGW;
import isabelle.MinGW$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Platform$;
import isabelle.Progress;
import isabelle.SSH;
import isabelle.Scala_Project$;
import isabelle.package$;
import java.io.Serializable;
import java.util.Map;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.matching.Regex;

public final class Component_VeriT$
implements Serializable {
    private static final String default_download_url;
    private static final Isabelle_Tool isabelle_tool;
    public static final Component_VeriT$ MODULE$;

    private Component_VeriT$() {
    }

    static {
        MODULE$ = new Component_VeriT$();
        default_download_url = "https://www.verit-solver.org/download/2021.06.2/verit-2021.06.2-rmx.tar.gz";
        isabelle_tool = Isabelle_Tool$.MODULE$.apply("component_verit", "build prover component from official download", Scala_Project$.MODULE$.here(), (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)args -> {
            ObjectRef target_dir = ObjectRef.create((Object)Path$.MODULE$.current());
            ObjectRef mingw = ObjectRef.create((Object)MinGW$.MODULE$.none());
            ObjectRef download_url = ObjectRef.create((Object)this.default_download_url());
            BooleanRef verbose = BooleanRef.create((boolean)false);
            Object[] objectArray = new Tuple2[4];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"D:");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)arg -> {
                target_dir$1.elem = Path$.MODULE$.explode((String)arg);
            });
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"M:");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (JProcedure1 & Serializable)arg -> {
                mingw$1.elem = MinGW$.MODULE$.apply(Path$.MODULE$.explode((String)arg));
            });
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"U:");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (JProcedure1 & Serializable)arg -> {
                download_url$1.elem = arg;
            });
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"v");
            objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (JProcedure1 & Serializable)_$1 -> {
                verbose$1.elem = true;
            });
            Getopts getopts = Getopts$.MODULE$.apply((Function0<String>)((Function0 & Serializable)this::$anonfun$1), (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            List<String> more_args = getopts.apply((List<String>)args);
            if (more_args.nonEmpty()) {
                throw getopts.usage(getopts.usage$default$1());
            }
            Console_Progress progress = new Console_Progress(verbose.elem, Console_Progress$.MODULE$.$lessinit$greater$default$2(), Console_Progress$.MODULE$.$lessinit$greater$default$3(), Console_Progress$.MODULE$.$lessinit$greater$default$4());
            this.build_verit((String)download_url.elem, progress, (Path)target_dir.elem, (MinGW)mingw.elem);
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Component_VeriT$.class);
    }

    public String default_download_url() {
        return default_download_url;
    }

    public void build_verit(String download_url, Progress progress, Path target_dir, MinGW mingw) {
        mingw.check();
        Isabelle_System$.MODULE$.with_tmp_dir("build", Isabelle_System$.MODULE$.with_tmp_dir$default$2(), (JProcedure1 & Serializable)tmp_dir -> {
            String string;
            String version;
            List list;
            Option option;
            String string2;
            String name;
            List list2;
            Option option2;
            String archive_name;
            Regex Archive_Name = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^.*?([^/]+)$"));
            Regex Version2 = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^[^-]+-(.+)\\.tar.gz$"));
            String string3 = download_url;
            String string4 = archive_name = string3 != null && !(option2 = Archive_Name.unapplySeq((CharSequence)string3)).isEmpty() && (list2 = (List)option2.get()).lengthCompare(1) == 0 ? (name = (string2 = (String)list2.apply(0))) : (String)package$.MODULE$.error().apply((Object)("Failed to determine source archive name from " + package$.MODULE$.quote().apply((Object)download_url)));
            String version2 = string4 != null && !(option = Version2.unapplySeq((CharSequence)string4)).isEmpty() && (list = (List)option.get()).lengthCompare(1) == 0 ? (version = (string = (String)list.apply(0))) : (String)package$.MODULE$.error().apply((Object)("Failed to determine component version from " + package$.MODULE$.quote().apply((Object)archive_name)));
            String component_name = "verit-" + version2;
            Components.Directory directory = Components$Directory$.MODULE$.apply(target_dir.$plus(Path$.MODULE$.basic(component_name)), Components$Directory$.MODULE$.apply$default$2());
            Components.Directory component_dir = directory.create(progress, directory.create$default$2());
            String platform_name = Isabelle_Platform$.MODULE$.local().ISABELLE_PLATFORM(true, true);
            Path platform_dir = Isabelle_System$.MODULE$.make_directory(component_dir.path().$plus(Path$.MODULE$.basic(platform_name)));
            Path archive_path = tmp_dir.$plus(Path$.MODULE$.basic(archive_name));
            Isabelle_System$.MODULE$.download_file(download_url, archive_path, progress);
            Isabelle_System$.MODULE$.extract(archive_path, (Path)tmp_dir, Isabelle_System$.MODULE$.extract$default$3());
            Path source_dir = File$.MODULE$.get_dir((Path)tmp_dir, download_url);
            Isabelle_System$.MODULE$.extract(archive_path, component_dir.src(), true);
            progress.echo("Building veriT for " + platform_name + " ...", progress.echo$default$2());
            String configure_options = Platform$.MODULE$.is_linux() ? "LDFLAGS=-Wl,-rpath,_DUMMY_" : "";
            String string5 = mingw.bash_script("set -e\n./configure " + configure_options + "\nmake", mingw.bash_script$default$2());
            boolean bl = progress.verbose();
            SSH.System system = progress.bash$default$2();
            Map<String, String> map = progress.bash$default$4();
            boolean bl2 = progress.bash$default$5();
            long l = progress.bash$default$7();
            boolean bl3 = progress.bash$default$8();
            progress.bash(string5, system, source_dir, map, bl2, bl, l, bl3).check();
            Isabelle_System$.MODULE$.copy_file(source_dir.$plus(Path$.MODULE$.explode("LICENSE")), component_dir.path());
            Path exe_path = Path$.MODULE$.basic("veriT").platform_exe();
            Isabelle_System$.MODULE$.copy_file(source_dir.$plus(exe_path), platform_dir);
            Path path = platform_dir.$plus(exe_path);
            Set set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"libgmp"}));
            String string6 = Executable$.MODULE$.library_closure$default$2();
            Executable$.MODULE$.library_closure(path, string6, mingw, (Function1<String, Object>)set);
            component_dir.write_settings("\nISABELLE_VERIT=\"$COMPONENT/${ISABELLE_WINDOWS_PLATFORM64:-${ISABELLE_APPLE_PLATFORM64:-$ISABELLE_PLATFORM64}}/veriT\"\n");
            File$.MODULE$.write(component_dir.README(), "This is veriT " + version2 + " from\n" + download_url + "\n\nIt has been built from sources like this:\n\n  cd src\n  ./configure\n  make\n\n\n        Makarius\n        " + Date$Format$.MODULE$.date().apply(Date$.MODULE$.now(Date$.MODULE$.now$default$1())) + "\n");
        });
    }

    public String build_verit$default$1() {
        return this.default_download_url();
    }

    public Progress build_verit$default$2() {
        return new Progress();
    }

    public Path build_verit$default$3() {
        return Path$.MODULE$.current();
    }

    public MinGW build_verit$default$4() {
        return MinGW$.MODULE$.none();
    }

    public Isabelle_Tool isabelle_tool() {
        return isabelle_tool;
    }

    private final String $anonfun$1() {
        return "\nUsage: isabelle component_verit [OPTIONS]\n\n  Options are:\n    -D DIR       target directory (default \".\")\n    -M DIR       msys/mingw root specification for Windows\n    -U URL       download URL\n                 (default: \"" + this.default_download_url() + "\")\n    -v           verbose\n\n  Build prover component from official download.\n";
    }
}

