/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Components;
import isabelle.Components$Directory$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.Date$;
import isabelle.Date$Format$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.Isabelle_Tool$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Progress;
import isabelle.Scala_Project$;
import isabelle.package$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class Component_XZ$
implements Serializable {
    private static final String main_url;
    private static final String default_source_url;
    private static final String default_download_url;
    private static final String default_version;
    private static final Isabelle_Tool isabelle_tool;
    public static final Component_XZ$ MODULE$;

    private Component_XZ$() {
    }

    static {
        MODULE$ = new Component_XZ$();
        main_url = "https://tukaani.org/xz/java.html";
        default_source_url = "https://github.com/tukaani-project/xz-java/releases/download";
        default_download_url = "https://repo1.maven.org/maven2/org/tukaani/xz";
        default_version = "1.10";
        isabelle_tool = Isabelle_Tool$.MODULE$.apply("component_xz", "build Isabelle xz-java component from official download", Scala_Project$.MODULE$.here(), (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)args -> {
            ObjectRef target_dir = ObjectRef.create((Object)Path$.MODULE$.current());
            ObjectRef source_url = ObjectRef.create((Object)this.default_source_url());
            ObjectRef download_url = ObjectRef.create((Object)this.default_download_url());
            ObjectRef version = ObjectRef.create((Object)this.default_version());
            Object[] objectArray = new Tuple2[4];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"D:");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)arg -> {
                target_dir$1.elem = Path$.MODULE$.explode((String)arg);
            });
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"S:");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (JProcedure1 & Serializable)arg -> {
                source_url$1.elem = arg;
            });
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"U:");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (JProcedure1 & Serializable)arg -> {
                download_url$1.elem = arg;
            });
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"V:");
            objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (JProcedure1 & Serializable)arg -> {
                version$1.elem = arg;
            });
            Getopts getopts = Getopts$.MODULE$.apply((Function0<String>)((Function0 & Serializable)this::$anonfun$1), (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            List<String> more_args = getopts.apply((List<String>)args);
            if (more_args.nonEmpty()) {
                throw getopts.usage(getopts.usage$default$1());
            }
            Console_Progress progress = new Console_Progress(Console_Progress$.MODULE$.$lessinit$greater$default$1(), Console_Progress$.MODULE$.$lessinit$greater$default$2(), Console_Progress$.MODULE$.$lessinit$greater$default$3(), Console_Progress$.MODULE$.$lessinit$greater$default$4());
            this.build_xz((Path)target_dir.elem, (String)source_url.elem, (String)download_url.elem, (String)version.elem, progress);
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Component_XZ$.class);
    }

    public String main_url() {
        return main_url;
    }

    public String default_source_url() {
        return default_source_url;
    }

    public String default_download_url() {
        return default_download_url;
    }

    public String default_version() {
        return default_version;
    }

    public void build_xz(Path target_dir, String source_url, String download_url, String version, Progress progress) {
        String component_name = "xz-java-" + version;
        Components.Directory directory = Components$Directory$.MODULE$.apply(target_dir.$plus(Path$.MODULE$.basic(component_name)), Components$Directory$.MODULE$.apply$default$2());
        Components.Directory component_dir = directory.create(progress, directory.create$default$2());
        File$.MODULE$.write(component_dir.README(), "This is " + component_name + " from " + this.main_url() + "\n\n        Makarius\n        " + Date$Format$.MODULE$.date().apply(Date$.MODULE$.now(Date$.MODULE$.now$default$1())) + "\n");
        Isabelle_System$.MODULE$.with_tmp_file("tmp", "zip", Isabelle_System$.MODULE$.with_tmp_file$default$3(), (JProcedure1 & Serializable)tmp -> {
            Isabelle_System$.MODULE$.download_file(source_url + "/v" + version + "/xz-java-" + version + ".zip", (Path)tmp, progress);
            Isabelle_System$.MODULE$.extract((Path)tmp, component_dir.path(), Isabelle_System$.MODULE$.extract$default$3());
        });
        String jar_name = "xz-" + version + ".jar";
        Isabelle_System$.MODULE$.make_directory(component_dir.lib());
        Isabelle_System$.MODULE$.download_file(download_url + "/" + version + "/" + jar_name, component_dir.lib().$plus(Path$.MODULE$.basic(jar_name)), progress);
        component_dir.write_settings("\nISABELLE_XZ_HOME=\"$COMPONENT\"\n\nclasspath \"$ISABELLE_XZ_HOME/lib/" + jar_name + "\"\n");
    }

    public Path build_xz$default$1() {
        return Path$.MODULE$.current();
    }

    public String build_xz$default$2() {
        return this.default_source_url();
    }

    public String build_xz$default$3() {
        return this.default_download_url();
    }

    public String build_xz$default$4() {
        return this.default_version();
    }

    public Progress build_xz$default$5() {
        return new Progress();
    }

    public Isabelle_Tool isabelle_tool() {
        return isabelle_tool;
    }

    private final String $anonfun$1() {
        return "\nUsage: isabelle component_xz [OPTIONS]\n\n  Options are:\n    -D DIR       target directory (default \".\")\n    -S URL       source URL (default: " + package$.MODULE$.quote().apply((Object)this.default_source_url()) + ")\n    -U URL       download URL (default: " + package$.MODULE$.quote().apply((Object)this.default_download_url()) + ")\n    -V VERSION   version (default: " + package$.MODULE$.quote().apply((Object)this.default_version()) + ")\n\n  Build xz-java component from the specified download base URL and VERSION,\n  see also " + this.main_url() + "\n";
    }
}

