/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Command;
import isabelle.Debugger$;
import isabelle.Debugger$Context$;
import isabelle.Debugger$Debug_State$;
import isabelle.Debugger$State$;
import isabelle.Debugger$Update$;
import isabelle.Delay;
import isabelle.Delay$;
import isabelle.Document_ID$;
import isabelle.Markup;
import isabelle.Markup$;
import isabelle.Markup$Debugger_Output$;
import isabelle.Markup$Debugger_State$;
import isabelle.Protocol$;
import isabelle.Prover;
import isabelle.Session;
import isabelle.Symbol$;
import isabelle.Synchronized;
import isabelle.Synchronized$;
import isabelle.Time;
import isabelle.Value$Boolean$;
import isabelle.XML;
import isabelle.XML$;
import isabelle.XML$Decode$;
import isabelle.XML$Elem$;
import isabelle.XML$Encode$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.SortedMap;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Debugger {
    private final Session session;
    private final Synchronized<State> state;
    private final Delay delay_update;

    public Debugger(Session session) {
        this.session = session;
        this.state = Synchronized$.MODULE$.apply(Debugger$State$.MODULE$.apply(Debugger$State$.MODULE$.$lessinit$greater$default$1(), Debugger$State$.MODULE$.$lessinit$greater$default$2(), Debugger$State$.MODULE$.$lessinit$greater$default$3(), Debugger$State$.MODULE$.$lessinit$greater$default$4(), Debugger$State$.MODULE$.$lessinit$greater$default$5(), Debugger$State$.MODULE$.$lessinit$greater$default$6()));
        this.delay_update = Delay$.MODULE$.first((Function0<Time>)(Function0 & Serializable)() -> new Time(Debugger.$init$$$anonfun$1(session)), Delay$.MODULE$.first$default$2(), Delay$.MODULE$.first$default$3(), (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            Debugger.$init$$$anonfun$2(session);
            return BoxedUnit.UNIT;
        });
    }

    public void update_thread(String thread_name, List<Debug_State> debug_states) {
        this.state.change((Function1<State, State>)(Function1 & Serializable)_$2 -> _$2.update_thread(thread_name, debug_states));
        this.delay_update.invoke(this.delay_update.invoke$default$1());
    }

    public void add_output(String thread_name, Tuple2<Object, XML.Elem> entry) {
        this.state.change((Function1<State, State>)(Function1 & Serializable)_$3 -> _$3.add_output(thread_name, entry));
        this.delay_update.invoke(this.delay_update.invoke$default$1());
    }

    public boolean is_active() {
        return this.session.is_ready() && this.state.value().is_active();
    }

    public void ready() {
        if (this.is_active()) {
            this.session.protocol_command("Debugger.init", (Seq<List<XML.Tree>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new List[0]));
            return;
        }
    }

    public void init(Object id) {
        this.state.change((Function1<State, State>)(Function1 & Serializable)st -> {
            State st1 = st.register_active(id);
            if (this.session.is_ready() && !st.is_active() && st1.is_active()) {
                this.session.protocol_command("Debugger.init", (Seq<List<XML.Tree>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new List[0]));
            }
            return st1;
        });
    }

    public void exit(Object id) {
        this.state.change((Function1<State, State>)(Function1 & Serializable)st -> {
            State st1 = st.unregister_active(id);
            if (this.session.is_ready() && st.is_active() && !st1.is_active()) {
                this.session.protocol_command("Debugger.exit", (Seq<List<XML.Tree>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new List[0]));
            }
            return st1;
        });
    }

    public boolean is_break() {
        return this.state.value().break();
    }

    public void set_break(boolean b) {
        this.state.change((Function1<State, State>)(Function1 & Serializable)st -> {
            State st1 = st.set_break(b);
            this.session.protocol_command("Debugger.break", (Seq<List<XML.Tree>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new List[]{XML$.MODULE$.string(Value$Boolean$.MODULE$.apply(b))}));
            return st1;
        });
        this.delay_update.invoke(this.delay_update.invoke$default$1());
    }

    public Option<Object> active_breakpoint_state(long breakpoint) {
        State st = this.state.value();
        if (st.is_active()) {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)st.active_breakpoints().apply$mcZJ$sp(breakpoint)));
        }
        return None$.MODULE$;
    }

    public boolean breakpoint_state(long breakpoint) {
        return this.state.value().active_breakpoints().apply$mcZJ$sp(breakpoint);
    }

    public void toggle_breakpoint(Command command, long breakpoint) {
        this.state.change((Function1<State, State>)(Function1 & Serializable)st -> {
            Tuple2<Object, State> tuple2 = st.toggle_breakpoint(breakpoint);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            boolean breakpoint_state = BoxesRunTime.unboxToBoolean((Object)tuple2._1());
            State st1 = (State)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)breakpoint_state), (Object)st1);
            boolean breakpoint_state2 = BoxesRunTime.unboxToBoolean((Object)tuple22._1());
            State st12 = (State)tuple22._2();
            this.session.protocol_command("Debugger.breakpoint", (Seq<List<XML.Tree>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new List[]{XML$.MODULE$.string(command.node_name().node()), Document_ID$.MODULE$.encode(command.id()), (List)XML$Encode$.MODULE$.long().apply((Object)BoxesRunTime.boxToLong((long)breakpoint)), XML$.MODULE$.string(Value$Boolean$.MODULE$.apply(breakpoint_state2))}));
            return st12;
        });
    }

    public Tuple2<SortedMap<String, List<Debug_State>>, List<XML.Elem>> status(Option<Context> focus) {
        Nil$ nil$;
        State st = this.state.value();
        Option<Context> option = focus;
        if (None$.MODULE$.equals(option)) {
            nil$ = package$.MODULE$.Nil();
        } else if (option instanceof Some) {
            Context c = (Context)((Some)option).value();
            nil$ = ((IterableOnceOps)st.output().withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String thread_name = (String)tuple2._1();
                    Command.Results results = (Command.Results)tuple2._2();
                    return true;
                }
                return false;
            }).withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String thread_name = (String)tuple2._1();
                    Command.Results results = (Command.Results)tuple2._2();
                    String string = thread_name;
                    String string2 = c.thread_name();
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }
                throw new MatchError((Object)tuple2);
            }).flatMap((Function1 & Serializable)x$12 -> {
                Tuple2 tuple2 = x$12;
                if (tuple2 != null) {
                    String thread_name = (String)tuple2._1();
                    Command.Results results = (Command.Results)tuple2._2();
                    return results.iterator().withFilter((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            XML.Elem msg = (XML.Elem)tuple2._2();
                            return true;
                        }
                        return false;
                    }).map((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            XML.Elem msg = (XML.Elem)tuple2._2();
                            return msg;
                        }
                        throw new MatchError((Object)tuple2);
                    });
                }
                throw new MatchError((Object)tuple2);
            })).toList();
        } else {
            throw new MatchError(option);
        }
        Nil$ output = nil$;
        return Tuple2$.MODULE$.apply(st.threads(), (Object)output);
    }

    public List<Context> focus() {
        return this.state.value().focus().toList().map((Function1 & Serializable)_$4 -> (Context)_$4._2());
    }

    public void set_focus(Context c) {
        this.state.change((Function1<State, State>)(Function1 & Serializable)_$5 -> _$5.set_focus(c));
        this.delay_update.invoke(this.delay_update.invoke$default$1());
    }

    public void input(String thread_name, Seq<String> msg) {
        this.session.protocol_command_args("Debugger.input", (List<List<XML.Tree>>)msg.toList().$colon$colon((Object)thread_name).map((Function1 & Serializable)s -> XML$.MODULE$.string((String)s)));
    }

    public void continue(String thread_name) {
        this.input(thread_name, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"continue"}));
    }

    public void step(String thread_name) {
        this.input(thread_name, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"step"}));
    }

    public void step_over(String thread_name) {
        this.input(thread_name, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"step_over"}));
    }

    public void step_out(String thread_name) {
        this.input(thread_name, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"step_out"}));
    }

    public void clear_output(String thread_name) {
        this.state.change((Function1<State, State>)(Function1 & Serializable)_$6 -> _$6.clear_output(thread_name));
        this.delay_update.invoke(this.delay_update.invoke$default$1());
    }

    public void eval(Context c, boolean SML, String context, String expression) {
        this.state.change((Function1<State, State>)(Function1 & Serializable)st -> {
            this.input(c.thread_name(), (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"eval", c.debug_index().getOrElse(Debugger::eval$$anonfun$1$$anonfun$1).toString(), BoxesRunTime.boxToBoolean((boolean)SML).toString(), Symbol$.MODULE$.encode(context), Symbol$.MODULE$.encode(expression)}));
            return st.clear_output(c.thread_name());
        });
        this.delay_update.invoke(this.delay_update.invoke$default$1());
    }

    public void print_vals(Context c, boolean SML, String context) {
        Predef$.MODULE$.require(c.debug_index().isDefined());
        this.state.change((Function1<State, State>)(Function1 & Serializable)st -> {
            this.input(c.thread_name(), (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"print_vals", c.debug_index().getOrElse(Debugger::print_vals$$anonfun$1$$anonfun$1).toString(), BoxesRunTime.boxToBoolean((boolean)SML).toString(), Symbol$.MODULE$.encode(context)}));
            return st.clear_output(c.thread_name());
        });
        this.delay_update.invoke(this.delay_update.invoke$default$1());
    }

    private static final long $init$$$anonfun$1(Session session$1) {
        return session$1.output_delay();
    }

    private static final void $init$$$anonfun$2(Session session$2) {
        session$2.debugger_updates().post(Debugger$Update$.MODULE$);
    }

    private static final int eval$$anonfun$1$$anonfun$1() {
        return 0;
    }

    private static final int print_vals$$anonfun$1$$anonfun$1() {
        return 0;
    }

    public static class Context
    implements Product,
    Serializable {
        private final String thread_name;
        private final List debug_states;
        private final int index;

        public static Context apply(String string, List<Debug_State> list, int n) {
            return Debugger$Context$.MODULE$.apply(string, list, n);
        }

        public static Context fromProduct(Product product) {
            return Debugger$Context$.MODULE$.fromProduct(product);
        }

        public static Context unapply(Context context) {
            return Debugger$Context$.MODULE$.unapply(context);
        }

        public static int $lessinit$greater$default$3() {
            return Debugger$Context$.MODULE$.$lessinit$greater$default$3();
        }

        public Context(String thread_name, List<Debug_State> debug_states, int index) {
            this.thread_name = thread_name;
            this.debug_states = debug_states;
            this.index = index;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.thread_name()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.debug_states()));
            n = Statics.mix((int)n, (int)this.index());
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Context)) return false;
            Context context = (Context)object;
            if (this.index() != context.index()) return false;
            String string = this.thread_name();
            String string2 = context.thread_name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            List<Debug_State> list = this.debug_states();
            List<Debug_State> list2 = context.debug_states();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            if (!context.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof Context;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Context";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "thread_name";
                }
                case 1: {
                    return "debug_states";
                }
                case 2: {
                    return "index";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String thread_name() {
            return this.thread_name;
        }

        public List<Debug_State> debug_states() {
            return this.debug_states;
        }

        public int index() {
            return this.index;
        }

        public int size() {
            return this.debug_states().length() + 1;
        }

        public Context reset() {
            return this.copy(this.copy$default$1(), this.copy$default$2(), 0);
        }

        public Context select(int i) {
            int n = i + 1;
            String string = this.copy$default$1();
            List<Debug_State> list = this.copy$default$2();
            return this.copy(string, list, n);
        }

        public Option<Debug_State> thread_state() {
            return this.debug_states().headOption();
        }

        public Option<Debug_State> stack_state() {
            if (1 <= this.index() && this.index() <= this.debug_states().length()) {
                return Some$.MODULE$.apply(this.debug_states().apply(this.index() - 1));
            }
            return None$.MODULE$;
        }

        public Option<Object> debug_index() {
            if (this.stack_state().isDefined()) {
                return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(this.index() - 1)));
            }
            if (this.debug_states().nonEmpty()) {
                return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0));
            }
            return None$.MODULE$;
        }

        public Option<Debug_State> debug_state() {
            return this.stack_state().orElse(this::debug_state$$anonfun$1);
        }

        public Option<List<Tuple2<String, String>>> debug_position() {
            return this.debug_state().map(Debugger$::isabelle$Debugger$Context$$_$debug_position$$anonfun$1);
        }

        public String toString() {
            Option<Debug_State> option = this.stack_state();
            if (None$.MODULE$.equals(option)) {
                return this.thread_name();
            }
            if (option instanceof Some) {
                Debug_State d = (Debug_State)((Some)option).value();
                return d.function();
            }
            throw new MatchError(option);
        }

        public Context copy(String thread_name, List<Debug_State> debug_states, int index) {
            return new Context(thread_name, debug_states, index);
        }

        public String copy$default$1() {
            return this.thread_name();
        }

        public List<Debug_State> copy$default$2() {
            return this.debug_states();
        }

        public int copy$default$3() {
            return this.index();
        }

        public String _1() {
            return this.thread_name();
        }

        public List<Debug_State> _2() {
            return this.debug_states();
        }

        public int _3() {
            return this.index();
        }

        private final Option debug_state$$anonfun$1() {
            return this.thread_state();
        }
    }

    public static class Debug_State
    implements Product,
    Serializable {
        private final List pos;
        private final String function;

        public static Debug_State apply(List<Tuple2<String, String>> list, String string) {
            return Debugger$Debug_State$.MODULE$.apply(list, string);
        }

        public static Debug_State fromProduct(Product product) {
            return Debugger$Debug_State$.MODULE$.fromProduct(product);
        }

        public static Debug_State unapply(Debug_State debug_State) {
            return Debugger$Debug_State$.MODULE$.unapply(debug_State);
        }

        public Debug_State(List<Tuple2<String, String>> pos, String function) {
            this.pos = pos;
            this.function = function;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Debug_State)) return false;
            Debug_State debug_State = (Debug_State)object;
            List<Tuple2<String, String>> list = this.pos();
            List<Tuple2<String, String>> list2 = debug_State.pos();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            String string = this.function();
            String string2 = debug_State.function();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!debug_State.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Debug_State;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Debug_State";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "pos";
            }
            if (1 == n2) {
                return "function";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public List<Tuple2<String, String>> pos() {
            return this.pos;
        }

        public String function() {
            return this.function;
        }

        public Debug_State copy(List<Tuple2<String, String>> pos, String function) {
            return new Debug_State(pos, function);
        }

        public List<Tuple2<String, String>> copy$default$1() {
            return this.pos();
        }

        public String copy$default$2() {
            return this.function();
        }

        public List<Tuple2<String, String>> _1() {
            return this.pos();
        }

        public String _2() {
            return this.function();
        }
    }

    public static class Handler
    extends Session.Protocol_Handler {
        private final Session session;
        private final Debugger debugger;
        private final List functions;

        public Handler(Session session) {
            this.session = session;
            this.debugger = new Debugger(session);
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)Markup$.MODULE$.DEBUGGER_STATE());
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)Markup$.MODULE$.DEBUGGER_OUTPUT());
            this.functions = (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Function1 & Serializable)msg -> this.debugger_state((Prover.Protocol_Output)msg)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Function1 & Serializable)msg -> this.debugger_output((Prover.Protocol_Output)msg)), (List)Nil$.MODULE$));
        }

        public Debugger debugger() {
            return this.debugger;
        }

        private boolean debugger_state(Prover.Protocol_Output msg) {
            Option<String> option;
            List<Tuple2<String, String>> list = msg.properties();
            if (list != null && !(option = Markup$Debugger_State$.MODULE$.unapply(list)).isEmpty()) {
                String string;
                String thread_name = string = (String)option.get();
                List<XML.Tree> msg_body = Symbol$.MODULE$.decode_yxml_failsafe(msg.text(), Symbol$.MODULE$.decode_yxml_failsafe$default$2());
                List debug_states = ((List)XML$Decode$.MODULE$.list(XML$Decode$.MODULE$.pair(XML$Decode$.MODULE$.properties(), XML$Decode$.MODULE$.string())).apply(msg_body)).map(Debugger$::isabelle$Debugger$Handler$$_$_$$anonfun$4);
                this.debugger().update_thread(thread_name, (List<Debug_State>)debug_states);
                return true;
            }
            return false;
        }

        private boolean debugger_output(Prover.Protocol_Output msg) {
            Option<String> option;
            List<Tuple2<String, String>> list = msg.properties();
            if (list != null && !(option = Markup$Debugger_Output$.MODULE$.unapply(list)).isEmpty()) {
                XML.Tree tree;
                SeqOps seqOps;
                String string;
                String thread_name = string = (String)option.get();
                List<XML.Tree> list2 = Symbol$.MODULE$.decode_yxml_failsafe(msg.text(), Symbol$.MODULE$.decode_yxml_failsafe$default$2());
                if (list2 != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = package$.MODULE$.List().unapplySeq(list2), 1) == 0 && (tree = (XML.Tree)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0)) instanceof XML.Elem) {
                    XML.Elem elem = XML$Elem$.MODULE$.unapply((XML.Elem)tree);
                    Markup markup = elem._1();
                    List<XML.Tree> list3 = elem._2();
                    if (markup != null) {
                        Option<Object> option2;
                        Markup markup2 = Markup$.MODULE$.unapply(markup);
                        String string2 = markup2._1();
                        List<Tuple2<String, String>> list4 = markup2._2();
                        String name = string2;
                        if (list4 != null && !(option2 = Markup$.MODULE$.Serial().unapply(list4)).isEmpty()) {
                            long l;
                            long i = l = BoxesRunTime.unboxToLong((Object)option2.get());
                            List<Tuple2<String, String>> props = list4;
                            List<XML.Tree> body = list3;
                            XML.Elem message = Protocol$.MODULE$.make_message(body, name, props);
                            Long l2 = (Long)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)i));
                            this.debugger().add_output(thread_name, (Tuple2<Object, XML.Elem>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)l2, (Object)this.session.cache().elem(message)));
                            return true;
                        }
                    }
                }
                return false;
            }
            return false;
        }

        @Override
        public List<Tuple2<String, Function1<Prover.Protocol_Output, Object>>> functions() {
            return this.functions;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class State
    implements Product,
    Serializable {
        private final Set active;
        private final boolean break;
        private final Set active_breakpoints;
        private final SortedMap threads;
        private final Map focus;
        private final Map output;

        public static State apply(Set<Object> set, boolean bl, Set<Object> set2, SortedMap<String, List<Debug_State>> sortedMap, Map<String, Context> map, Map<String, Command.Results> map2) {
            return Debugger$State$.MODULE$.apply(set, bl, set2, sortedMap, map, map2);
        }

        public static State fromProduct(Product product) {
            return Debugger$State$.MODULE$.fromProduct(product);
        }

        public static State unapply(State state) {
            return Debugger$State$.MODULE$.unapply(state);
        }

        public static Set<Object> $lessinit$greater$default$1() {
            return Debugger$State$.MODULE$.$lessinit$greater$default$1();
        }

        public static boolean $lessinit$greater$default$2() {
            return Debugger$State$.MODULE$.$lessinit$greater$default$2();
        }

        public static Set<Object> $lessinit$greater$default$3() {
            return Debugger$State$.MODULE$.$lessinit$greater$default$3();
        }

        public static SortedMap<String, List<Debug_State>> $lessinit$greater$default$4() {
            return Debugger$State$.MODULE$.$lessinit$greater$default$4();
        }

        public static Map<String, Context> $lessinit$greater$default$5() {
            return Debugger$State$.MODULE$.$lessinit$greater$default$5();
        }

        public static Map<String, Command.Results> $lessinit$greater$default$6() {
            return Debugger$State$.MODULE$.$lessinit$greater$default$6();
        }

        public State(Set<Object> active, boolean bl, Set<Object> active_breakpoints, SortedMap<String, List<Debug_State>> threads, Map<String, Context> focus, Map<String, Command.Results> output) {
            this.active = active;
            this.break = bl;
            this.active_breakpoints = active_breakpoints;
            this.threads = threads;
            this.focus = focus;
            this.output = output;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.active()));
            n = Statics.mix((int)n, (int)(this.break() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.active_breakpoints()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.threads()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.focus()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.output()));
            return Statics.finalizeHash((int)n, (int)6);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state = (State)object;
            if (this.break() != state.break()) return false;
            Set<Object> set = this.active();
            Set<Object> set2 = state.active();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            Set<Object> set3 = this.active_breakpoints();
            Set<Object> set4 = state.active_breakpoints();
            if (set3 == null) {
                if (set4 != null) {
                    return false;
                }
            } else if (!set3.equals(set4)) return false;
            SortedMap<String, List<Debug_State>> sortedMap = this.threads();
            SortedMap<String, List<Debug_State>> sortedMap2 = state.threads();
            if (sortedMap == null) {
                if (sortedMap2 != null) {
                    return false;
                }
            } else if (!sortedMap.equals(sortedMap2)) return false;
            Map<String, Context> map = this.focus();
            Map<String, Context> map2 = state.focus();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            Map<String, Command.Results> map3 = this.output();
            Map<String, Command.Results> map4 = state.output();
            if (map3 == null) {
                if (map4 != null) {
                    return false;
                }
            } else if (!map3.equals(map4)) return false;
            if (!state.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 6;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToBoolean((boolean)this._2());
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "active";
                }
                case 1: {
                    return "break";
                }
                case 2: {
                    return "active_breakpoints";
                }
                case 3: {
                    return "threads";
                }
                case 4: {
                    return "focus";
                }
                case 5: {
                    return "output";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Set<Object> active() {
            return this.active;
        }

        public boolean break() {
            return this.break;
        }

        public Set<Object> active_breakpoints() {
            return this.active_breakpoints;
        }

        public SortedMap<String, List<Debug_State>> threads() {
            return this.threads;
        }

        public Map<String, Context> focus() {
            return this.focus;
        }

        public Map<String, Command.Results> output() {
            return this.output;
        }

        public State set_break(boolean b) {
            return this.copy(this.copy$default$1(), b, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
        }

        public boolean is_active() {
            return this.active().nonEmpty();
        }

        public State register_active(Object id) {
            return this.copy((Set<Object>)((Set)this.active().$plus(id)), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
        }

        public State unregister_active(Object id) {
            return this.copy((Set<Object>)((Set)this.active().$minus(id)), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
        }

        public Tuple2<Object, State> toggle_breakpoint(long breakpoint) {
            Set active_breakpoints1 = this.active_breakpoints().apply$mcZJ$sp(breakpoint) ? (Set)this.active_breakpoints().$minus((Object)BoxesRunTime.boxToLong((long)breakpoint)) : (Set)this.active_breakpoints().$plus((Object)BoxesRunTime.boxToLong((long)breakpoint));
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)active_breakpoints1.apply$mcZJ$sp(breakpoint)), (Object)this.copy(this.copy$default$1(), this.copy$default$2(), (Set<Object>)active_breakpoints1, this.copy$default$4(), this.copy$default$5(), this.copy$default$6()));
        }

        public List<Debug_State> get_thread(String thread_name) {
            return (List)this.threads().getOrElse((Object)thread_name, Debugger$::isabelle$Debugger$State$$_$get_thread$$anonfun$1);
        }

        /*
         * Unable to fully structure code
         */
        public State update_thread(String thread_name, List<Debug_State> debug_states) {
            if (debug_states.nonEmpty()) {
                var4_3 = (String)Predef$.MODULE$.ArrowAssoc((Object)thread_name);
                v0 = (SortedMap)this.threads().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)var4_3, debug_states));
            } else {
                v0 = (SortedMap)this.threads().$minus((Object)thread_name);
            }
            threads1 = v0;
            var6_5 = this.focus().get((Object)thread_name);
            if (!(var6_5 instanceof Some)) ** GOTO lbl-1000
            c = (Context)((Some)var6_5).value();
            if (debug_states.nonEmpty()) {
                var8_7 = (String)Predef$.MODULE$.ArrowAssoc((Object)thread_name);
                v1 = (Map)this.focus().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)var8_7, (Object)Debugger$Context$.MODULE$.apply(thread_name, debug_states, Debugger$Context$.MODULE$.$lessinit$greater$default$3())));
            } else lbl-1000:
            // 2 sources

            {
                v1 = (Map)this.focus().$minus((Object)thread_name);
            }
            focus1 = v1;
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), (SortedMap<String, List<Debug_State>>)threads1, (Map<String, Context>)focus1, this.copy$default$6());
        }

        public State set_focus(Context c) {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)c.thread_name());
            Map map = (Map)this.focus().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)c));
            Set<Object> set = this.copy$default$1();
            boolean bl = this.copy$default$2();
            Set<Object> set2 = this.copy$default$3();
            SortedMap<String, List<Debug_State>> sortedMap = this.copy$default$4();
            Map<String, Command.Results> map2 = this.copy$default$6();
            return this.copy(set, bl, set2, sortedMap, (Map<String, Context>)map, map2);
        }

        public Command.Results get_output(String thread_name) {
            return (Command.Results)this.output().getOrElse((Object)thread_name, Debugger$::isabelle$Debugger$State$$_$get_output$$anonfun$1);
        }

        public State add_output(String thread_name, Tuple2<Object, XML.Elem> entry) {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)thread_name);
            Map map = (Map)this.output().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.get_output(thread_name).$plus(entry)));
            Set<Object> set = this.copy$default$1();
            boolean bl = this.copy$default$2();
            Set<Object> set2 = this.copy$default$3();
            SortedMap<String, List<Debug_State>> sortedMap = this.copy$default$4();
            Map<String, Context> map2 = this.copy$default$5();
            return this.copy(set, bl, set2, sortedMap, map2, (Map<String, Command.Results>)map);
        }

        public State clear_output(String thread_name) {
            Map map = (Map)this.output().$minus((Object)thread_name);
            Set<Object> set = this.copy$default$1();
            boolean bl = this.copy$default$2();
            Set<Object> set2 = this.copy$default$3();
            SortedMap<String, List<Debug_State>> sortedMap = this.copy$default$4();
            Map<String, Context> map2 = this.copy$default$5();
            return this.copy(set, bl, set2, sortedMap, map2, (Map<String, Command.Results>)map);
        }

        public State copy(Set<Object> active, boolean bl, Set<Object> active_breakpoints, SortedMap<String, List<Debug_State>> threads, Map<String, Context> focus, Map<String, Command.Results> output) {
            return new State(active, bl, active_breakpoints, threads, focus, output);
        }

        public Set<Object> copy$default$1() {
            return this.active();
        }

        public boolean copy$default$2() {
            return this.break();
        }

        public Set<Object> copy$default$3() {
            return this.active_breakpoints();
        }

        public SortedMap<String, List<Debug_State>> copy$default$4() {
            return this.threads();
        }

        public Map<String, Context> copy$default$5() {
            return this.focus();
        }

        public Map<String, Command.Results> copy$default$6() {
            return this.output();
        }

        public Set<Object> _1() {
            return this.active();
        }

        public boolean _2() {
            return this.break();
        }

        public Set<Object> _3() {
            return this.active_breakpoints();
        }

        public SortedMap<String, List<Debug_State>> _4() {
            return this.threads();
        }

        public Map<String, Context> _5() {
            return this.focus();
        }

        public Map<String, Command.Results> _6() {
            return this.output();
        }
    }
}

