/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import com.github.luben.zstd.ZstdInputStream;
import com.github.luben.zstd.ZstdOutputStream;
import isabelle.Bash$;
import isabelle.Bytes;
import isabelle.Bytes$;
import isabelle.Compress;
import isabelle.Compress$Options_XZ$;
import isabelle.Compress$Options_Zstd$;
import isabelle.File;
import isabelle.Isabelle_System$;
import isabelle.Library$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Platform$;
import isabelle.Space$;
import isabelle.UTF8$;
import isabelle.Url;
import isabelle.Url$;
import isabelle.XML;
import isabelle.Zstd$;
import isabelle.package$;
import isabelle.setup.Environment;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Properties;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.XZInputStream;
import org.tukaani.xz.XZOutputStream;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordering;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;

public final class File$
implements Serializable {
    private static final List<PosixFilePermission> restrict_perms;
    public static final File$ MODULE$;

    private File$() {
    }

    static {
        MODULE$ = new File$();
        restrict_perms = (List)new .colon.colon((Object)PosixFilePermission.GROUP_READ, (List)new .colon.colon((Object)PosixFilePermission.GROUP_WRITE, (List)new .colon.colon((Object)PosixFilePermission.GROUP_EXECUTE, (List)new .colon.colon((Object)PosixFilePermission.OTHERS_READ, (List)new .colon.colon((Object)PosixFilePermission.OTHERS_WRITE, (List)new .colon.colon((Object)PosixFilePermission.OTHERS_EXECUTE, (List)Nil$.MODULE$))))));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(File$.class);
    }

    public String standard_path(Path path) {
        return path.expand().implode();
    }

    public String standard_path(String platform_path) {
        return Environment.standard_path((String)platform_path);
    }

    public String standard_path(File file) {
        return this.standard_path(file.getPath());
    }

    public String standard_url(String name) {
        String string;
        try {
            URL url = new URI(name).toURL();
            String string2 = url.getProtocol();
            String string3 = "file";
            string = !(string2 != null ? !string2.equals(string3) : string3 != null) && Url$.MODULE$.is_wellformed_file(name) ? this.standard_path(Url$.MODULE$.parse_file(name)) : name;
        }
        catch (Throwable throwable) {
            Throwable exn;
            Throwable throwable2 = throwable;
            if (throwable2 != null && Url$.MODULE$.is_malformed(exn = throwable2)) {
                string = this.standard_path(name);
            }
            throw throwable;
        }
        return string;
    }

    public String platform_path(String standard_path) {
        return Environment.platform_path((String)standard_path);
    }

    public String platform_path(Path path) {
        return this.platform_path(this.standard_path(path));
    }

    public File platform_file(Path path) {
        return new File(this.platform_path(path));
    }

    public String symbolic_path(Path path) {
        List directories = ((List)package$.MODULE$.space_explode().apply((Object)BoxesRunTime.boxToCharacter((char)':'), (Object)Isabelle_System$.MODULE$.getenv("ISABELLE_DIRECTORIES", Isabelle_System$.MODULE$.getenv$default$2()))).reverse();
        String full_name = this.standard_path(path);
        return (String)((IterableOps)directories.view().flatMap((Function1 & Serializable)a -> {
            Some some;
            block6: {
                try {
                    String b = MODULE$.standard_path(Path$.MODULE$.explode((String)a));
                    String string = full_name;
                    String string2 = b;
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        some = Some$.MODULE$.apply(a);
                        break block6;
                    }
                    Option<String> option = Library$.MODULE$.try_unprefix(b + "/", full_name);
                    if (option instanceof Some) {
                        String name = (String)((Some)option).value();
                        some = Some$.MODULE$.apply((Object)(a + "/" + name));
                        break block6;
                    }
                    if (None$.MODULE$.equals(option)) {
                        some = None$.MODULE$;
                        break block6;
                    }
                    throw new MatchError(option);
                }
                catch (Throwable throwable) {
                    Option<String> option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = package$.MODULE$.ERROR().unapply(throwable2)).isEmpty()) {
                        String string = (String)option.get();
                        some = None$.MODULE$;
                    }
                    throw throwable;
                }
            }
            return some;
        })).headOption().getOrElse(() -> File$.symbolic_path$$anonfun$2(path));
    }

    public File absolute(File file) {
        return file.toPath().toAbsolutePath().normalize().toFile();
    }

    public File canonical(File file) {
        return file.getCanonicalFile();
    }

    public Path path(File file) {
        return Path$.MODULE$.explode(this.standard_path(file));
    }

    public Path path(java.nio.file.Path java_path) {
        return this.path(java_path.toFile());
    }

    public URI uri(File file) {
        return file.toURI();
    }

    public URI uri(Path path) {
        return path.file().toURI();
    }

    public Url url(File file) {
        return Url$.MODULE$.apply(this.uri(file));
    }

    public Url url(Path path) {
        return this.url(path.file());
    }

    public boolean is_ML(String s) {
        return s.endsWith(".ML");
    }

    public boolean is_bib(String s) {
        return s.endsWith(".bib");
    }

    public boolean is_dll(String s) {
        return s.endsWith(".dll");
    }

    public boolean is_exe(String s) {
        return s.endsWith(".exe");
    }

    public boolean is_gz(String s) {
        return s.endsWith(".gz");
    }

    public boolean is_html(String s) {
        return s.endsWith(".html");
    }

    public boolean is_jar(String s) {
        return s.endsWith(".jar");
    }

    public boolean is_java(String s) {
        return s.endsWith(".java");
    }

    public boolean is_node(String s) {
        return s.endsWith(".node");
    }

    public boolean is_pdf(String s) {
        return s.endsWith(".pdf");
    }

    public boolean is_png(String s) {
        return s.endsWith(".png");
    }

    public boolean is_scala(String s) {
        return s.endsWith(".scala");
    }

    public boolean is_svg(String s) {
        return s.endsWith(".svg");
    }

    public boolean is_tar_bz2(String s) {
        return s.endsWith(".tar.bz2");
    }

    public boolean is_tar_gz(String s) {
        return s.endsWith(".tar.gz");
    }

    public boolean is_tar_xz(String s) {
        return s.endsWith(".tar.xz");
    }

    public boolean is_tgz(String s) {
        return s.endsWith(".tgz");
    }

    public boolean is_thy(String s) {
        return s.endsWith(".thy");
    }

    public boolean is_xz(String s) {
        return s.endsWith(".xz");
    }

    public boolean is_zip(String s) {
        return s.endsWith(".zip");
    }

    public boolean is_zst(String s) {
        return s.endsWith(".zst");
    }

    public boolean is_backup(String s) {
        return s.endsWith("~") || s.endsWith(".orig");
    }

    public Option<Path> relative_path(Path base, Path other) {
        java.nio.file.Path base_path = base.java_path();
        java.nio.file.Path other_path = other.java_path();
        if (other_path.startsWith(base_path)) {
            return Some$.MODULE$.apply((Object)this.path(base_path.relativize(other_path).toFile()));
        }
        return None$.MODULE$;
    }

    public Path perhaps_relative_path(Path base, Path other) {
        return (Path)this.relative_path(base, other).getOrElse(() -> File$.perhaps_relative_path$$anonfun$1(other));
    }

    public String bash_path(Path path) {
        return Bash$.MODULE$.string(this.standard_path(path));
    }

    public String bash_path(File file) {
        return Bash$.MODULE$.string(this.standard_path(file));
    }

    public String bash_platform_path(Path path) {
        return Bash$.MODULE$.string(this.platform_path(path));
    }

    public List<String> read_dir(Path dir) {
        Object[] files;
        if (!dir.is_dir()) {
            package$.MODULE$.error().apply((Object)("No such directory: " + dir.toString()));
        }
        if ((files = dir.file().listFiles()) == null) {
            return scala.package$.MODULE$.Nil();
        }
        return (List)Predef$.MODULE$.wrapRefArray(files).toList().map((Function1 & Serializable)_$1 -> _$1.getName()).sorted((Ordering)Ordering.String$.MODULE$);
    }

    public Path get_entry(Path dir, Function1<Path, Object> pred, String title) {
        SeqOps seqOps;
        List list = this.read_dir(dir).filter((Function1 & Serializable)name -> BoxesRunTime.unboxToBoolean((Object)pred.apply((Object)dir.$plus(Path$.MODULE$.basic((String)name)))));
        if (list != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = scala.package$.MODULE$.List().unapplySeq((SeqOps)list), 1) == 0) {
            String string;
            String entry = string = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
            return dir.$plus(Path$.MODULE$.basic(entry));
        }
        List bad = list;
        return (Path)package$.MODULE$.error().apply((Object)("Bad directory content in " + (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(title)) ? title : dir.toString()) + "\nexpected a single entry, but found" + (bad.isEmpty() ? " nothing" : ((List)bad.sorted((Ordering)Ordering.String$.MODULE$)).map(package$.MODULE$.quote()).mkString(":\n  ", "\n  ", ""))));
    }

    public Function1<Path, Object> get_entry$default$2() {
        return (Function1 & Serializable)_$2 -> true;
    }

    public String get_entry$default$3() {
        return "";
    }

    public Path get_file(Path dir, String title) {
        return this.get_entry(dir, (Function1<Path, Object>)(Function1 & Serializable)_$3 -> _$3.is_file(), title);
    }

    public String get_file$default$2() {
        return "";
    }

    public Path get_dir(Path dir, String title) {
        return this.get_entry(dir, (Function1<Path, Object>)(Function1 & Serializable)_$4 -> _$4.is_dir(), title);
    }

    public String get_dir$default$2() {
        return "";
    }

    public List<File> find_files(File start, Function1<File, Object> pred, boolean include_dirs, boolean follow_links) {
        ListBuffer result = new ListBuffer();
        if (start.isFile()) {
            this.isabelle$File$$$_$check$1(pred, result, start);
        } else if (start.isDirectory()) {
            EnumSet<FileVisitOption> options = follow_links ? EnumSet.of(FileVisitOption.FOLLOW_LINKS) : EnumSet.noneOf(FileVisitOption.class);
            Files.walkFileTree(start.toPath(), options, Integer.MAX_VALUE, (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(include_dirs, pred, result){
                private final boolean include_dirs$1;
                private final Function1 pred$3;
                private final ListBuffer result$2;
                {
                    this.include_dirs$1 = include_dirs$2;
                    this.pred$3 = pred$4;
                    this.result$2 = result$3;
                }

                public FileVisitResult preVisitDirectory(java.nio.file.Path path, BasicFileAttributes attrs) {
                    if (this.include_dirs$1) {
                        File$.MODULE$.isabelle$File$$$_$check$1(this.pred$3, this.result$2, path.toFile());
                    }
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult visitFile(java.nio.file.Path path, BasicFileAttributes attrs) {
                    File file = path.toFile();
                    if (this.include_dirs$1 || !file.isDirectory()) {
                        File$.MODULE$.isabelle$File$$$_$check$1(this.pred$3, this.result$2, file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return result.toList();
    }

    public Function1<File, Object> find_files$default$2() {
        return (Function1 & Serializable)_$5 -> true;
    }

    public boolean find_files$default$3() {
        return false;
    }

    public boolean find_files$default$4() {
        return false;
    }

    public String read(File file) {
        return Bytes$.MODULE$.read(file).text();
    }

    public String read(Path path) {
        return this.read(path.file());
    }

    public String read_stream(InputStream stream) {
        return Bytes$.MODULE$.read_stream(stream, Bytes$.MODULE$.read_stream$default$2(), Bytes$.MODULE$.read_stream$default$3()).text();
    }

    public String read_gzip(File file) {
        return this.read_stream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(file))));
    }

    public String read_gzip(Path path) {
        return this.read_gzip(path.file());
    }

    public String read_xz(File file) {
        return this.read_stream((InputStream)new XZInputStream((InputStream)new BufferedInputStream(new FileInputStream(file))));
    }

    public String read_xz(Path path) {
        return this.read_xz(path.file());
    }

    public String read_zstd(File file) {
        Zstd$.MODULE$.init();
        return this.read_stream((InputStream)new ZstdInputStream((InputStream)new BufferedInputStream(new FileInputStream(file))));
    }

    public String read_zstd(Path path) {
        return this.read_zstd(path.file());
    }

    public Option<String> read_line(BufferedReader reader) {
        String string;
        try {
            string = reader.readLine();
        }
        catch (IOException iOException) {
            string = null;
        }
        String line = string;
        return Option$.MODULE$.apply((Object)line).map((Function1 & Serializable)s -> Library$.MODULE$.trim_line((String)s));
    }

    public List<String> read_lines(BufferedReader reader, Function1<String, BoxedUnit> progress) {
        ListBuffer result = new ListBuffer();
        Option<String> line = None$.MODULE$;
        while ((line = this.read_line(reader)).isDefined()) {
            progress.apply(line.get());
            result.$plus$eq(line.get());
        }
        reader.close();
        return result.toList();
    }

    public Properties read_props(Path path) {
        Properties props = new Properties();
        props.load(Files.newBufferedReader(path.java_path()));
        return props;
    }

    public BufferedWriter writer(File file) {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), UTF8$.MODULE$.charset()));
    }

    public void write_file(File file, String text, Function1<OutputStream, OutputStream> make_stream) {
        OutputStream stream = (OutputStream)make_stream.apply((Object)new FileOutputStream(file));
        package$.MODULE$.using(new BufferedWriter(new OutputStreamWriter(stream, UTF8$.MODULE$.charset())), (Function1 & Serializable)_$6 -> _$6.append(text));
    }

    public void write(File file, String text) {
        this.write_file(file, text, (Function1<OutputStream, OutputStream>)(Function1 & Serializable)s -> s);
    }

    public void write(Path path, String text) {
        this.write(path.file(), text);
    }

    public void write_gzip(File file, String text) {
        this.write_file(file, text, (Function1<OutputStream, OutputStream>)(Function1 & Serializable)s -> new GZIPOutputStream(new BufferedOutputStream((OutputStream)s)));
    }

    public void write_gzip(Path path, String text) {
        this.write_gzip(path.file(), text);
    }

    public void write_xz(File file, String text, Compress.Options_XZ options) {
        this.write_file(file, text, (Function1<OutputStream, OutputStream>)(Function1 & Serializable)s -> new XZOutputStream((OutputStream)new BufferedOutputStream((OutputStream)s), (FilterOptions)options.make()));
    }

    public void write_xz(File file, String text) {
        this.write_xz(file, text, Compress$Options_XZ$.MODULE$.apply(Compress$Options_XZ$.MODULE$.$lessinit$greater$default$1()));
    }

    public void write_xz(Path path, String text, Compress.Options_XZ options) {
        this.write_xz(path.file(), text, options);
    }

    public void write_xz(Path path, String text) {
        this.write_xz(path, text, Compress$Options_XZ$.MODULE$.apply(Compress$Options_XZ$.MODULE$.$lessinit$greater$default$1()));
    }

    public void write_zstd(File file, String text, Compress.Options_Zstd options) {
        Zstd$.MODULE$.init();
        this.write_file(file, text, (Function1<OutputStream, OutputStream>)(Function1 & Serializable)s -> new ZstdOutputStream((OutputStream)new BufferedOutputStream((OutputStream)s), options.level()));
    }

    public void write_zstd(File file, String text) {
        this.write_zstd(file, text, Compress$Options_Zstd$.MODULE$.apply(Compress$Options_Zstd$.MODULE$.$lessinit$greater$default$1()));
    }

    public void write_zstd(Path path, String text, Compress.Options_Zstd options) {
        this.write_zstd(path.file(), text, options);
    }

    public void write_zstd(Path path, String text) {
        this.write_zstd(path, text, Compress$Options_Zstd$.MODULE$.apply(Compress$Options_Zstd$.MODULE$.$lessinit$greater$default$1()));
    }

    public void write_backup(Path path, String text) {
        if (path.is_file()) {
            Isabelle_System$.MODULE$.move_file(path, path.backup());
        }
        this.write(path, text);
    }

    public void write_backup2(Path path, String text) {
        if (path.is_file()) {
            Isabelle_System$.MODULE$.move_file(path, path.backup2());
        }
        this.write(path, text);
    }

    public void append(File file, String text) {
        Files.write(file.toPath(), UTF8$.MODULE$.bytes(text), StandardOpenOption.APPEND, StandardOpenOption.CREATE);
    }

    public void append(Path path, String text) {
        this.append(path.file(), text);
    }

    public void change(Path path, boolean init, boolean strict, Function1<String, String> f) {
        if (!path.is_file() && init) {
            this.write(path, "");
        }
        String x = this.read(path);
        String y = (String)f.apply((Object)x);
        String string = x;
        String string2 = y;
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.write(path, y);
            return;
        }
        if (strict) {
            package$.MODULE$.error().apply((Object)("Unchanged file: " + path));
            return;
        }
    }

    public boolean change$default$2() {
        return false;
    }

    public boolean change$default$3() {
        return false;
    }

    public void change_lines(Path path, boolean init, boolean strict, Function1<List<String>, List<String>> f) {
        this.change(path, init, strict, (Function1<String, String>)(Function1 & Serializable)text -> (String)package$.MODULE$.cat_lines().apply(f.apply(package$.MODULE$.split_lines().apply(text))));
    }

    public boolean change_lines$default$2() {
        return false;
    }

    public boolean change_lines$default$3() {
        return false;
    }

    public boolean eq(File file1, File file2) {
        boolean bl;
        try {
            bl = Files.isSameFile(file1.toPath(), file2.toPath());
        }
        catch (Throwable throwable) {
            Option<String> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = package$.MODULE$.ERROR().unapply(throwable2)).isEmpty()) {
                String string = (String)option.get();
                bl = false;
            }
            throw throwable;
        }
        return bl;
    }

    public boolean eq(Path path1, Path path2) {
        return this.eq(path1.file(), path2.file());
    }

    public boolean eq_content(File file1, File file2) {
        if (this.eq(file1, file2)) {
            return true;
        }
        if (file1.length() != file2.length()) {
            return false;
        }
        Bytes bytes = Bytes$.MODULE$.read(file1);
        Bytes bytes2 = Bytes$.MODULE$.read(file2);
        return !(bytes != null ? !((Object)bytes).equals(bytes2) : bytes2 != null);
    }

    public boolean eq_content(Path path1, Path path2) {
        return this.eq_content(path1.file(), path2.file());
    }

    public void restrict(Path path) {
        if (Platform$.MODULE$.is_windows()) {
            Isabelle_System$.MODULE$.chmod("g-rwx,o-rwx", path);
            return;
        }
        Set<PosixFilePermission> perms = Files.getPosixFilePermissions(path.java_path(), new LinkOption[0]);
        BooleanRef perms_changed = BooleanRef.create((boolean)false);
        restrict_perms.withFilter((Function1 & Serializable)p -> perms.contains(p)).foreach((Function1)(JProcedure1 & Serializable)p -> {
            perms.remove(p);
            perms_changed$1.elem = true;
        });
        if (perms_changed.elem) {
            Files.setPosixFilePermissions(path.java_path(), perms);
            return;
        }
    }

    public boolean is_executable(Path path) {
        if (Platform$.MODULE$.is_windows()) {
            return Isabelle_System$.MODULE$.bash("test -x " + this.bash_path(path), Isabelle_System$.MODULE$.bash$default$2(), Isabelle_System$.MODULE$.bash$default$3(), Isabelle_System$.MODULE$.bash$default$4(), Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), Isabelle_System$.MODULE$.bash$default$8(), Isabelle_System$.MODULE$.bash$default$9(), Isabelle_System$.MODULE$.bash$default$10(), Isabelle_System$.MODULE$.bash$default$11(), Isabelle_System$.MODULE$.bash$default$12()).check().ok();
        }
        return path.file().canExecute();
    }

    public void set_executable(Path path, boolean reset) {
        if (Platform$.MODULE$.is_windows()) {
            Isabelle_System$.MODULE$.chmod(reset ? "a-x" : "a+x", path);
            return;
        }
        path.file().setExecutable(!reset, false);
    }

    public boolean set_executable$default$2() {
        return false;
    }

    public File.Content content(Path path, Bytes content) {
        return new File.Content(path, content);
    }

    public File.Content content(Path path, String content) {
        return new File.Content(path, Bytes$.MODULE$.apply(content));
    }

    public File.Content_XML content(Path path, List<XML.Tree> content) {
        return new File.Content_XML(path, content);
    }

    public long size(Path path) {
        return path.check_file().file().length();
    }

    public long space(Path path) {
        return Space$.MODULE$.bytes(this.size(path));
    }

    private static final String symbolic_path$$anonfun$2(Path path$1) {
        return path$1.implode();
    }

    private static final Path perhaps_relative_path$$anonfun$1(Path other$1) {
        return other$1;
    }

    public final void isabelle$File$$$_$check$1(Function1 pred$2, ListBuffer result$1, File file) {
        if (BoxesRunTime.unboxToBoolean((Object)pred$2.apply((Object)file))) {
            result$1.$plus$eq((Object)file);
            return;
        }
    }
}

