/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import isabelle.File$;
import isabelle.Isabelle_Fonts$;
import isabelle.package$;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.imageio.ImageIO;
import org.jfree.chart.JFreeChart;
import scala.Float$;
import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichFloat$;
import scala.runtime.function.JProcedure1;

public final class Graphics_File$
implements Serializable {
    public static final Graphics_File$ MODULE$ = new Graphics_File$();

    private Graphics_File$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Graphics_File$.class);
    }

    public void write_png(File file, Function1<Graphics2D, BoxedUnit> paint, int width, int height, int dpi) {
        float scale = (float)dpi / 72.0f;
        int w = RichFloat$.MODULE$.round$extension(Predef$.MODULE$.floatWrapper((float)width * scale));
        int h = RichFloat$.MODULE$.round$extension(Predef$.MODULE$.floatWrapper((float)height * scale));
        BufferedImage img = new BufferedImage(w, h, 2);
        Graphics2D gfx = img.createGraphics();
        try {
            gfx.scale(Float$.MODULE$.float2double(scale), Float$.MODULE$.float2double(scale));
            paint.apply((Object)gfx);
            ImageIO.write((RenderedImage)img, "png", file);
        }
        finally {
            gfx.dispose();
        }
    }

    public int write_png$default$5() {
        return 72;
    }

    private FontMapper font_mapper() {
        DefaultFontMapper mapper = new DefaultFontMapper();
        Isabelle_Fonts$.MODULE$.fonts(Isabelle_Fonts$.MODULE$.fonts$default$1()).foreach((Function1)(JProcedure1 & Serializable)entry -> {
            DefaultFontMapper.BaseFontParameters params = new DefaultFontMapper.BaseFontParameters(File$.MODULE$.platform_path(entry.path()));
            params.encoding = "Identity-H";
            params.embedded = true;
            params.ttfAfm = entry.bytes().make_array();
            mapper.putName(entry.name(), params);
        });
        return mapper;
    }

    public void write_pdf(File file, Function1<Graphics2D, BoxedUnit> paint, int width, int height) {
        package$.MODULE$.using(new BufferedOutputStream(new FileOutputStream(file)), (JProcedure1 & Serializable)out -> {
            try (Document document = new Document();){
                document.setPageSize(new Rectangle((float)width, (float)height));
                PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)out);
                document.open();
                PdfContentByte cb = writer.getDirectContent();
                PdfTemplate tp = cb.createTemplate((float)width, (float)height);
                Graphics2D gfx = tp.createGraphics((float)width, (float)height, MODULE$.font_mapper());
                paint.apply((Object)gfx);
                gfx.dispose();
                cb.addTemplate(tp, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            }
        });
    }

    public void paint_chart(Graphics2D gfx, JFreeChart chart, int width, int height) {
        chart.draw(gfx, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, Int$.MODULE$.int2double(width), Int$.MODULE$.int2double(height)));
    }

    public void write_chart_png(File file, JFreeChart chart, int width, int height) {
        this.write_png(file, (Function1<Graphics2D, BoxedUnit>)(JProcedure1 & Serializable)_$1 -> MODULE$.paint_chart((Graphics2D)_$1, chart, width, height), width, height, this.write_png$default$5());
    }

    public void write_chart_pdf(File file, JFreeChart chart, int width, int height) {
        this.write_pdf(file, (Function1<Graphics2D, BoxedUnit>)(JProcedure1 & Serializable)_$2 -> MODULE$.paint_chart((Graphics2D)_$2, chart, width, height), width, height);
    }
}

