/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Bytes;
import isabelle.Bytes$;
import isabelle.Compress;
import isabelle.Compress$Cache$;
import isabelle.File$;
import isabelle.Isabelle_System$;
import isabelle.Logger;
import isabelle.ML_Heap;
import isabelle.ML_Heap$Log_DB$;
import isabelle.ML_Heap$private_data$;
import isabelle.ML_Heap$private_data$Base$;
import isabelle.ML_Heap$private_data$Slices$;
import isabelle.Path;
import isabelle.Progress;
import isabelle.SHA1;
import isabelle.SHA1$;
import isabelle.SQL;
import isabelle.SQL$;
import isabelle.Space$;
import isabelle.Store;
import isabelle.Store$;
import isabelle.package$;
import java.io.File;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public final class ML_Heap$
implements Serializable {
    private static final String sha1_prefix;
    private static final int sha1_length;
    public static final ML_Heap$Log_DB$ Log_DB;
    public static final ML_Heap$private_data$ private_data;
    public static final ML_Heap$ MODULE$;

    private ML_Heap$() {
    }

    static {
        MODULE$ = new ML_Heap$();
        sha1_prefix = "SHA1:";
        sha1_length = sha1_prefix.length() + SHA1$.MODULE$.digest_length();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ML_Heap$.class);
    }

    public Option<SHA1.Digest> read_file_digest(Path heap) {
        if (heap.is_file()) {
            Bytes bs = Bytes$.MODULE$.read_file(heap, File$.MODULE$.size(heap) - (long)sha1_length, Bytes$.MODULE$.read_file$default$3());
            if (bs.size() == (long)sha1_length) {
                String s = bs.text();
                if (s.startsWith(sha1_prefix)) {
                    return Some$.MODULE$.apply((Object)SHA1$.MODULE$.fake_digest(s.substring(sha1_prefix.length())));
                }
                return None$.MODULE$;
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public SHA1.Digest write_file_digest(Path heap) {
        return (SHA1.Digest)this.read_file_digest(heap).getOrElse(() -> ML_Heap$.write_file_digest$$anonfun$1(heap));
    }

    public void clean_entry(SQL.Database db, String session_name) {
        ML_Heap$private_data$.MODULE$.transaction_lock(db, true, "ML_Heap.clean_entry", ML_Heap$private_data$.MODULE$.transaction_lock$default$4(), (Function0 & Serializable)() -> {
            ML_Heap$.clean_entry$$anonfun$2(db, session_name);
            return BoxedUnit.UNIT;
        });
    }

    public Map<String, SHA1.Digest> read_digests(SQL.Database db, Iterable<String> names) {
        if (names.isEmpty()) {
            return Predef$.MODULE$.Map().empty();
        }
        return (Map)ML_Heap$private_data$.MODULE$.transaction_lock(db, true, "ML_Heap.read_digests", ML_Heap$private_data$.MODULE$.transaction_lock$default$4(), () -> ML_Heap$.read_digests$$anonfun$3(db, names));
    }

    public void store(SQL.Database db, Store.Session session, long slice, Compress.Cache cache, Progress progress) {
        long l;
        Option log_db = session.log_db().flatMap((Function1 & Serializable)path -> ((Option)package$.MODULE$.proper_string().apply((Object)Store$.MODULE$.read_build_uuid((Path)path, session.name()))).map((Function1 & Serializable)uuid -> ML_Heap$Log_DB$.MODULE$.apply((String)uuid, Bytes$.MODULE$.read((Path)path))));
        Option heap_digest = session.heap().map((Function1 & Serializable)heap -> MODULE$.write_file_digest((Path)heap));
        Option<Path> option = session.heap();
        if (option instanceof Some) {
            Path heap2 = (Path)((Some)option).value();
            l = File$.MODULE$.size(heap2) - (long)sha1_length;
        } else if (None$.MODULE$.equals(option)) {
            l = 0L;
        } else {
            throw new MatchError(option);
        }
        long heap_size = l;
        long slice_size = RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(slice), Space$.MODULE$.MiB(1.0));
        int slices = (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)heap_size / (double)slice_size));
        long step = slices == 0 ? 0L : (long)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)heap_size / (double)slices));
        try {
            None$ content0;
            if (slices > 0) {
                progress.echo("Storing " + session.name() + " ...", progress.echo$default$2());
            }
            Tuple2 tuple2 = slices > 1 ? Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0L), (Object)None$.MODULE$) : Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)heap_size), (Object)heap_digest);
            long heap_size0 = BoxesRunTime.unboxToLong((Object)tuple2._1());
            Option heap_digest0 = (Option)tuple2._2();
            Option log_db0 = slices <= 1 ? log_db : None$.MODULE$;
            Object object = content0 = slices > 0 ? Some$.MODULE$.apply((Object)this.slice_content$1(step, slices, heap_size, session, cache, 0)) : None$.MODULE$;
            if (log_db0.isDefined()) {
                progress.echo("Storing " + session.log_db_name() + " ...", progress.echo$default$2());
            }
            ML_Heap$private_data$.MODULE$.transaction_lock(db, true, "ML_Heap.store", ML_Heap$private_data$.MODULE$.transaction_lock$default$4(), () -> ML_Heap$.store$$anonfun$adapted$1(db, session, heap_size0, heap_digest0, log_db0, (Option)content0));
            if (slices > 1) {
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), slices).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    Bytes content = this.slice_content$1(step, slices, heap_size, session, cache, i);
                    String string = "ML_Heap.store" + i;
                    boolean bl = ML_Heap$private_data$.MODULE$.transaction_lock$default$2();
                    Logger logger = ML_Heap$private_data$.MODULE$.transaction_lock$default$4();
                    ML_Heap$private_data$.MODULE$.transaction_lock(db, bl, string, logger, (Function0 & Serializable)() -> {
                        ML_Heap$.store$$anonfun$2$$anonfun$1(db, session, i, content);
                        return BoxedUnit.UNIT;
                    });
                });
                if (log_db.isDefined()) {
                    progress.echo("Storing " + session.log_db_name() + " ...", progress.echo$default$2());
                }
                ML_Heap$private_data$.MODULE$.transaction_lock(db, ML_Heap$private_data$.MODULE$.transaction_lock$default$2(), "ML_Heap.store_update", ML_Heap$private_data$.MODULE$.transaction_lock$default$4(), (Function0 & Serializable)() -> {
                    ML_Heap$.store$$anonfun$3(db, session, heap_size, heap_digest, log_db);
                    return BoxedUnit.UNIT;
                });
            }
        }
        catch (Throwable exn) {
            ML_Heap$private_data$.MODULE$.transaction_lock(db, true, "ML_Heap.store_clean", ML_Heap$private_data$.MODULE$.transaction_lock$default$4(), (Function0 & Serializable)() -> {
                ML_Heap$.store$$anonfun$4(db, session);
                return BoxedUnit.UNIT;
            });
            throw exn;
        }
    }

    public Compress.Cache store$default$4() {
        return Compress$Cache$.MODULE$.none();
    }

    public Progress store$default$5() {
        return new Progress();
    }

    public void restore(SQL.Database db, List<Store.Session> sessions, Compress.Cache cache, Progress progress) {
        if (sessions.exists((Function1 & Serializable)_$8 -> _$8.defined())) {
            ML_Heap$private_data$.MODULE$.transaction_lock(db, true, "ML_Heap.restore", ML_Heap$private_data$.MODULE$.transaction_lock$default$4(), (Function0 & Serializable)() -> {
                ML_Heap$.restore$$anonfun$2(sessions, db, progress, cache);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public Compress.Cache restore$default$3() {
        return Compress$Cache$.MODULE$.none();
    }

    public Progress restore$default$4() {
        return new Progress();
    }

    private static final SHA1.Digest write_file_digest$$anonfun$1(Path heap$1) {
        SHA1.Digest digest = SHA1$.MODULE$.digest(heap$1);
        File$.MODULE$.append(heap$1, sha1_prefix + digest.toString());
        return digest;
    }

    public static final /* synthetic */ List isabelle$ML_Heap$private_data$$$_$read_digests$$anonfun$1(IterableOnce coll) {
        return scala.package$.MODULE$.List().from(coll);
    }

    public static final /* synthetic */ Tuple2 isabelle$ML_Heap$private_data$$$_$read_digests$$anonfun$2(SQL.Result res) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)res.string(ML_Heap$private_data$Base$.MODULE$.name()));
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)res.string(ML_Heap$private_data$Base$.MODULE$.heap_digest()));
    }

    public static final /* synthetic */ List isabelle$ML_Heap$private_data$$$_$read_slices$$anonfun$1(IterableOnce coll) {
        return scala.package$.MODULE$.List().from(coll);
    }

    public static final /* synthetic */ Bytes isabelle$ML_Heap$private_data$$$_$read_slices$$anonfun$2(SQL.Result _$1) {
        return _$1.bytes(ML_Heap$private_data$Slices$.MODULE$.content());
    }

    public static final String isabelle$ML_Heap$private_data$$$_$_$$anonfun$1(String old_uuid$1) {
        return ML_Heap$private_data$Base$.MODULE$.uuid().ident() + " <> " + SQL$.MODULE$.string(old_uuid$1);
    }

    public static final /* synthetic */ List isabelle$ML_Heap$private_data$$$_$read_log_db$$anonfun$1(IterableOnce coll) {
        return scala.package$.MODULE$.List().from(coll);
    }

    public static final /* synthetic */ Tuple2 isabelle$ML_Heap$private_data$$$_$read_log_db$$anonfun$2(SQL.Result res) {
        return Tuple2$.MODULE$.apply((Object)res.string(ML_Heap$private_data$Base$.MODULE$.uuid()), (Object)res.bytes(ML_Heap$private_data$Base$.MODULE$.log_db()));
    }

    public static final /* synthetic */ void isabelle$ML_Heap$private_data$$$_$write_slice$$anonfun$1(String name$2, int slice$1, Bytes content$1, SQL.Statement stmt) {
        stmt.string().update(1, name$2);
        stmt.int().update(2, slice$1);
        stmt.bytes().update(3, content$1);
    }

    public static final /* synthetic */ void isabelle$ML_Heap$private_data$$$_$clean_entry$$anonfun$1(SQL.Database db$1, String name$3, SQL.Table table) {
        db$1.execute_statement(table.delete(ML_Heap$private_data$Base$.MODULE$.name().where_equal(name$3)), db$1.execute_statement$default$2());
    }

    public static final /* synthetic */ void isabelle$ML_Heap$private_data$$$_$init_entry$$anonfun$1(SQL.Database db$2, SQL.Table table) {
        db$2.create_view(table);
    }

    public static final /* synthetic */ void isabelle$ML_Heap$private_data$$$_$init_entry$$anonfun$2(String name$4, long heap_size$1, Option heap_digest$1, Option log_db$1, SQL.Statement stmt) {
        stmt.string().update(1, name$4);
        stmt.long().update(2, heap_size$1);
        stmt.string().update(3, (Option<String>)heap_digest$1.map((Function1 & Serializable)_$2 -> _$2.toString()));
        stmt.string().update(4, (Option<String>)log_db$1.map((Function1 & Serializable)_$3 -> _$3.uuid()));
        stmt.bytes().update(5, (Option<Bytes>)log_db$1.map((Function1 & Serializable)_$4 -> _$4.content()));
    }

    public static final /* synthetic */ void isabelle$ML_Heap$private_data$$$_$update_entry$$anonfun$1(long heap_size$2, Option heap_digest$2, Option log_db$2, SQL.Statement stmt) {
        stmt.long().update(1, heap_size$2);
        stmt.string().update(2, (Option<String>)heap_digest$2.map((Function1 & Serializable)_$5 -> _$5.toString()));
        stmt.string().update(3, (Option<String>)log_db$2.map((Function1 & Serializable)_$6 -> _$6.uuid()));
        stmt.bytes().update(4, (Option<Bytes>)log_db$2.map((Function1 & Serializable)_$7 -> _$7.content()));
    }

    private static final void clean_entry$$anonfun$2(SQL.Database db$3, String session_name$1) {
        ML_Heap$private_data$.MODULE$.clean_entry(db$3, session_name$1);
    }

    private static final Map read_digests$$anonfun$3(SQL.Database db$4, Iterable names$1) {
        return ML_Heap$private_data$.MODULE$.read_digests(db$4, (Iterable<String>)names$1);
    }

    private final Bytes slice_content$1(long step$1, int slices$1, long heap_size$3, Store.Session session$2, Compress.Cache cache$1, int i) {
        int j = i + 1;
        long offset = step$1 * (long)i;
        long limit = j < slices$1 ? step$1 * (long)j : heap_size$3;
        Bytes bytes = Bytes$.MODULE$.read_file(session$2.the_heap(), offset, limit);
        return bytes.compress(bytes.compress$default$1(), cache$1);
    }

    private static final void store$$anonfun$1(SQL.Database db$5, Store.Session session$3, long heap_size0$1, Option heap_digest0$1, Option log_db0$1, Option content0$1) {
        ML_Heap$private_data$.MODULE$.init_entry(db$5, session$3.name(), heap_size0$1, (Option<SHA1.Digest>)heap_digest0$1, (Option<ML_Heap.Log_DB>)log_db0$1);
        content0$1.foreach((Function1)(JProcedure1 & Serializable)content -> ML_Heap$private_data$.MODULE$.write_slice(db$5, session$3.name(), 0, (Bytes)content));
    }

    private static /* bridge */ /* synthetic */ Object store$$anonfun$adapted$1(SQL.Database db$17, Store.Session session$12, long heap_size0$2, Option heap_digest0$2, Option log_db0$2, Option content0$2) {
        ML_Heap$.store$$anonfun$1(db$17, session$12, heap_size0$2, heap_digest0$2, log_db0$2, content0$2);
        return BoxedUnit.UNIT;
    }

    private static final void store$$anonfun$2$$anonfun$1(SQL.Database db$8, Store.Session session$6, int i$1, Bytes content$2) {
        ML_Heap$private_data$.MODULE$.write_slice(db$8, session$6.name(), i$1, content$2);
    }

    private static final void store$$anonfun$3(SQL.Database db$9, Store.Session session$7, long heap_size$5, Option heap_digest$3, Option log_db$3) {
        ML_Heap$private_data$.MODULE$.update_entry(db$9, session$7.name(), heap_size$5, (Option<SHA1.Digest>)heap_digest$3, (Option<ML_Heap.Log_DB>)log_db$3);
    }

    private static final void store$$anonfun$4(SQL.Database db$10, Store.Session session$8) {
        ML_Heap$private_data$.MODULE$.clean_entry(db$10, session$8.name());
    }

    private static final void restore$$anonfun$2(List sessions$1, SQL.Database db$11, Progress progress$1, Compress.Cache cache$3) {
        List defined_heaps = sessions$1.flatMap((Function1 & Serializable)session -> session.heap().map((Function1 & Serializable)heap -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)session.name());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, heap);
        }));
        Map<String, SHA1.Digest> db_digests = ML_Heap$private_data$.MODULE$.read_digests(db$11, (Iterable<String>)defined_heaps.map((Function1 & Serializable)_$9 -> (String)_$9._1()));
        defined_heaps.withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String session_name = (String)tuple2._1();
                Path heap = (Path)tuple2._2();
                return true;
            }
            return false;
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String session_name = (String)tuple2._1();
                Path heap = (Path)tuple2._2();
                Option<SHA1.Digest> file_digest = MODULE$.read_file_digest(heap);
                Option db_digest = db_digests.get((Object)session_name);
                if (db_digest.isDefined()) {
                    Option option = db_digest;
                    Option<SHA1.Digest> option2 = file_digest;
                    if (option == null ? option2 != null : !option.equals(option2)) {
                        progress$1.echo("Restoring " + session_name + " ...", progress$1.echo$default$2());
                        Path base_dir = Isabelle_System$.MODULE$.make_directory(heap.expand().dir());
                        String string = session_name + "_";
                        File file = base_dir.file();
                        String string2 = Isabelle_System$.MODULE$.with_tmp_file$default$2();
                        Isabelle_System$.MODULE$.with_tmp_file(string, string2, file, (JProcedure1 & Serializable)tmp -> {
                            tmp.file().delete();
                            ML_Heap$private_data$.MODULE$.read_slices(db$11, session_name).foreach((Function1)(JProcedure1 & Serializable)slice -> Bytes$.MODULE$.append((Path)tmp, slice.uncompress(cache$3)));
                            SHA1.Digest digest = MODULE$.write_file_digest((Path)tmp);
                            Object object = db_digest.get();
                            SHA1.Digest digest2 = digest;
                            if (!(object != null ? !object.equals(digest2) : digest2 != null)) {
                                Isabelle_System$.MODULE$.move_file((Path)tmp, heap);
                                return;
                            }
                            package$.MODULE$.error().apply((Object)("Incoherent content for session heap " + heap.expand()));
                        });
                        return;
                    }
                }
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        sessions$1.foreach((Function1)(JProcedure1 & Serializable)session -> session.log_db().foreach((Function1)(JProcedure1 & Serializable)path -> {
            String old_uuid = Store$.MODULE$.read_build_uuid((Path)path, session.name());
            ML_Heap$private_data$.MODULE$.read_log_db(db$11, session.name(), old_uuid).foreach((Function1)(JProcedure1 & Serializable)log_db -> {
                if (old_uuid.isEmpty()) {
                    progress$1.echo("Restoring " + session.log_db_name() + " ...", progress$1.echo$default$2());
                    Isabelle_System$.MODULE$.make_directory(path.expand().dir());
                    Bytes$.MODULE$.write((Path)path, log_db.content());
                    return;
                }
                package$.MODULE$.error().apply((Object)("Incoherent content for session database " + path.expand()));
            });
        }));
    }
}

