/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Bash$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.Docker_Build$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.Isabelle_Tool$;
import isabelle.JSON$;
import isabelle.JSON$Object$;
import isabelle.JSON$Value$String$;
import isabelle.Library$;
import isabelle.Linux;
import isabelle.Linux$;
import isabelle.Linux$Release$;
import isabelle.Options;
import isabelle.Options$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Phabricator;
import isabelle.Phabricator$API$;
import isabelle.Phabricator$API$User$;
import isabelle.Phabricator$Apache$;
import isabelle.Phabricator$Config$;
import isabelle.Phabricator$Nginx$;
import isabelle.Process_Result;
import isabelle.Progress;
import isabelle.SQL$;
import isabelle.SSH;
import isabelle.Scala_Project$;
import isabelle.Symbol$;
import isabelle.Url$;
import isabelle.Value$Int$;
import isabelle.package$;
import java.io.Serializable;
import java.util.Map;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.matching.Regex;

public final class Phabricator$
implements Serializable {
    private static final List packages_ubuntu_22_04;
    private static final List packages_ubuntu_24_04;
    public static final Phabricator$Apache$ Apache;
    public static final Phabricator$Nginx$ Nginx;
    private static final List all_webservers;
    private static final Phabricator.Webserver default_webserver;
    private static final String www_user;
    private static final String daemon_user;
    private static final Path sshd_config;
    private static final String default_name;
    private static final Path default_mailers;
    private static final int default_system_port;
    private static final int alternative_system_port;
    private static final int default_server_port;
    private static final Path global_config;
    public static final Phabricator$Config$ Config;
    private static final Isabelle_Tool isabelle_tool1;
    private static final Isabelle_Tool isabelle_tool2;
    private static final String mailers_template;
    private static final Isabelle_Tool isabelle_tool3;
    private static final Regex Port;
    private static final Regex No_Port;
    private static final Regex Any_Port;
    private static final Isabelle_Tool isabelle_tool4;
    public static final Phabricator$API$ API;
    public static final Phabricator$ MODULE$;

    private Phabricator$() {
    }

    static {
        MODULE$ = new Phabricator$();
        List<String> list = Docker_Build$.MODULE$.packages();
        packages_ubuntu_22_04 = ((List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"git", "mysql-server", "php", "php-mysql", "php-gd", "php-curl", "php-apcu", "php-cli", "php-json", "php-mbstring", "php-xml", "php-zip", "python3-pygments", "ssh", "subversion", "make", "gcc", "python3", "python3-dev", "python3-docutils"}))).$colon$colon$colon(list);
        List<String> list2 = Docker_Build$.MODULE$.packages();
        packages_ubuntu_24_04 = ((List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"git", "mysql-server", "php", "php-mysql", "php-gd", "php-curl", "php-apcu", "php-cli", "php-json", "php-mbstring", "php-xml", "php-zip", "python3-pygments", "ssh", "subversion", "make", "gcc", "gettext", "python3", "python3-dev", "python3-docutils", "python3-setuptools"}))).$colon$colon$colon(list2);
        all_webservers = (List)new .colon.colon((Object)Phabricator$Apache$.MODULE$, (List)new .colon.colon((Object)Phabricator$Nginx$.MODULE$, (List)Nil$.MODULE$));
        default_webserver = Phabricator$Apache$.MODULE$;
        www_user = "www-data";
        daemon_user = "phabricator";
        sshd_config = Path$.MODULE$.explode("/etc/ssh/sshd_config");
        default_name = "vcs";
        default_mailers = Path$.MODULE$.explode("mailers.json");
        default_system_port = 22;
        alternative_system_port = 222;
        default_server_port = 2222;
        global_config = Path$.MODULE$.explode("/etc/" + MODULE$.isabelle_phabricator_name(MODULE$.isabelle_phabricator_name$default$1(), "conf"));
        isabelle_tool1 = Isabelle_Tool$.MODULE$.apply("phabricator", "invoke command-line tool within Phorge home directory", Scala_Project$.MODULE$.here(), (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)args -> {
            boolean bl;
            long l;
            boolean bl2;
            Map<String, String> map;
            BooleanRef list = BooleanRef.create((boolean)false);
            ObjectRef name = ObjectRef.create((Object)this.default_name());
            Object[] objectArray = new Tuple2[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"l");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)_$1 -> {
                list$1.elem = true;
            });
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"n:");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (JProcedure1 & Serializable)arg -> {
                name$1.elem = arg;
            });
            Getopts getopts = Getopts$.MODULE$.apply((Function0<String>)((Function0 & Serializable)this::$anonfun$1), (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            List<String> more_args = getopts.apply((List<String>)args);
            if (more_args.isEmpty() && !list.elem) {
                throw getopts.usage(getopts.usage$default$1());
            }
            Console_Progress progress = new Console_Progress(Console_Progress$.MODULE$.$lessinit$greater$default$1(), Console_Progress$.MODULE$.$lessinit$greater$default$2(), Console_Progress$.MODULE$.$lessinit$greater$default$3(), Console_Progress$.MODULE$.$lessinit$greater$default$4());
            if (list.elem) {
                this.read_config().foreach((Function1)(JProcedure1 & Serializable)config -> progress.echo("phabricator " + package$.MODULE$.quote().apply((Object)config.name()) + " root " + config.root(), progress.echo$default$2()));
                return;
            }
            Phabricator.Config config2 = this.get_config((String)name.elem);
            String string3 = Bash$.MODULE$.strings((Iterable<String>)more_args);
            Path path = config2.home();
            SSH.System system = progress.bash$default$2();
            Process_Result result = progress.bash(string3, system, path, map = progress.bash$default$4(), bl2 = progress.bash$default$5(), true, l = progress.bash$default$7(), bl = progress.bash$default$8());
            if (!result.ok()) {
                package$.MODULE$.error().apply((Object)result.print_return_code());
                return;
            }
        });
        isabelle_tool2 = Isabelle_Tool$.MODULE$.apply("phabricator_setup", "setup Phorge server on Ubuntu Linux", Scala_Project$.MODULE$.here(), (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)args -> {
            ObjectRef mercurial_source = ObjectRef.create((Object)"");
            ObjectRef repo = ObjectRef.create((Object)"");
            BooleanRef package_update = BooleanRef.create((boolean)false);
            ObjectRef name = ObjectRef.create((Object)this.default_name());
            ObjectRef options = ObjectRef.create((Object)Options$.MODULE$.init(Options$.MODULE$.init$default$1(), Options$.MODULE$.init$default$2()));
            ObjectRef root = ObjectRef.create((Object)"");
            ObjectRef webserver = ObjectRef.create((Object)this.default_webserver());
            Object[] objectArray = new Tuple2[7];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"M:");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)arg -> {
                String string = arg;
                String string2 = ":";
                mercurial_source$1.elem = !(string != null ? !string.equals(string2) : string2 != null) ? this.standard_mercurial_source() : arg;
            });
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"R:");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (JProcedure1 & Serializable)arg -> {
                repo$1.elem = arg;
            });
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"U");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (JProcedure1 & Serializable)_$2 -> {
                package_update$1.elem = true;
            });
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"n:");
            objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (JProcedure1 & Serializable)arg -> {
                name$2.elem = arg;
            });
            String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"o:");
            objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (JProcedure1 & Serializable)arg -> {
                options$1.elem = ((Options)options$1.elem).$plus((String)arg);
            });
            String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"r:");
            objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (JProcedure1 & Serializable)arg -> {
                root$1.elem = arg;
            });
            String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)"w:");
            objectArray[6] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (JProcedure1 & Serializable)arg -> {
                webserver$1.elem = this.get_webserver((String)arg);
            });
            Getopts getopts = Getopts$.MODULE$.apply((Function0<String>)((Function0 & Serializable)this::$anonfun$4), (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            List<String> more_args = getopts.apply((List<String>)args);
            if (more_args.nonEmpty()) {
                throw getopts.usage(getopts.usage$default$1());
            }
            Console_Progress progress = new Console_Progress(Console_Progress$.MODULE$.$lessinit$greater$default$1(), Console_Progress$.MODULE$.$lessinit$greater$default$2(), Console_Progress$.MODULE$.$lessinit$greater$default$3(), Console_Progress$.MODULE$.$lessinit$greater$default$4());
            this.phabricator_setup((Options)options.elem, (String)name.elem, (String)root.elem, (String)repo.elem, (Phabricator.Webserver)webserver.elem, package_update.elem, (String)mercurial_source.elem, progress);
        });
        mailers_template = "[\n  {\n    \"key\": \"example.org\",\n    \"type\": \"smtp\",\n    \"options\": {\n      \"host\": \"mail.example.org\",\n      \"port\": 465,\n      \"user\": \"phabricator@example.org\",\n      \"password\": \"********\",\n      \"protocol\": \"ssl\",\n      \"message-id\": true\n    }\n  }\n]";
        isabelle_tool3 = Isabelle_Tool$.MODULE$.apply("phabricator_setup_mail", "setup mail for one Phorge installation", Scala_Project$.MODULE$.here(), (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)args -> {
            ObjectRef test_user = ObjectRef.create((Object)"");
            ObjectRef name = ObjectRef.create((Object)this.default_name());
            ObjectRef config_file = ObjectRef.create((Object)None$.MODULE$);
            Object[] objectArray = new Tuple2[3];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"T:");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)arg -> {
                test_user$1.elem = arg;
            });
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"f:");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (JProcedure1 & Serializable)arg -> {
                config_file$1.elem = Some$.MODULE$.apply((Object)Path$.MODULE$.explode((String)arg));
            });
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"n:");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (JProcedure1 & Serializable)arg -> {
                name$3.elem = arg;
            });
            Getopts getopts = Getopts$.MODULE$.apply((Function0<String>)((Function0 & Serializable)this::$anonfun$12), (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            List<String> more_args = getopts.apply((List<String>)args);
            if (more_args.nonEmpty()) {
                throw getopts.usage(getopts.usage$default$1());
            }
            Console_Progress progress = new Console_Progress(Console_Progress$.MODULE$.$lessinit$greater$default$1(), Console_Progress$.MODULE$.$lessinit$greater$default$2(), Console_Progress$.MODULE$.$lessinit$greater$default$3(), Console_Progress$.MODULE$.$lessinit$greater$default$4());
            this.phabricator_setup_mail((String)name.elem, (Option<Path>)((Option)config_file.elem), (String)test_user.elem, progress);
        });
        Port = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^\\s*Port\\s+(\\d+)\\s*$"));
        No_Port = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^#\\s*Port\\b.*$"));
        Any_Port = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^#?\\s*Port\\b.*$"));
        isabelle_tool4 = Isabelle_Tool$.MODULE$.apply("phabricator_setup_ssh", "setup ssh service for all Phorge installations", Scala_Project$.MODULE$.here(), (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)args -> {
            IntRef server_port = IntRef.create((int)this.default_server_port());
            IntRef system_port = IntRef.create((int)this.default_system_port());
            Object[] objectArray = new Tuple2[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"p:");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)arg -> {
                server_port$1.elem = Value$Int$.MODULE$.parse((String)arg);
            });
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"q:");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (JProcedure1 & Serializable)arg -> {
                system_port$1.elem = Value$Int$.MODULE$.parse((String)arg);
            });
            Getopts getopts = Getopts$.MODULE$.apply((Function0<String>)((Function0 & Serializable)this::$anonfun$16), (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            List<String> more_args = getopts.apply((List<String>)args);
            if (more_args.nonEmpty()) {
                throw getopts.usage(getopts.usage$default$1());
            }
            Console_Progress progress = new Console_Progress(Console_Progress$.MODULE$.$lessinit$greater$default$1(), Console_Progress$.MODULE$.$lessinit$greater$default$2(), Console_Progress$.MODULE$.$lessinit$greater$default$3(), Console_Progress$.MODULE$.$lessinit$greater$default$4());
            this.phabricator_setup_ssh(server_port.elem, system_port.elem, progress);
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Phabricator$.class);
    }

    public List<String> packages_ubuntu_22_04() {
        return packages_ubuntu_22_04;
    }

    public List<String> packages_ubuntu_24_04() {
        return packages_ubuntu_24_04;
    }

    public List<String> system_packages() {
        Linux.Release release = Linux$Release$.MODULE$.apply();
        if (release.is_ubuntu_22_04()) {
            return this.packages_ubuntu_22_04();
        }
        if (release.is_ubuntu_24_04()) {
            return this.packages_ubuntu_24_04();
        }
        return (List)package$.MODULE$.error().apply((Object)"Bad Linux version: expected Ubuntu 20.04 or 22.04 or 24.04 LTS");
    }

    public List<Phabricator.Webserver> all_webservers() {
        return all_webservers;
    }

    public Phabricator.Webserver get_webserver(String name) {
        return (Phabricator.Webserver)this.all_webservers().find((Function1 & Serializable)w -> {
            String string = w.user_name();
            String string2 = name;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).getOrElse(() -> Phabricator$.get_webserver$$anonfun$2(name));
    }

    public Phabricator.Webserver default_webserver() {
        return default_webserver;
    }

    public String www_user() {
        return www_user;
    }

    public String daemon_user() {
        return daemon_user;
    }

    public Path sshd_config() {
        return sshd_config;
    }

    public String default_name() {
        return default_name;
    }

    public String phabricator_name(String name, String ext) {
        return "phabricator" + package$.MODULE$.if_proper(Predef$.MODULE$.wrapString(name), (Function0<String>)((Function0 & Serializable)() -> Phabricator$.phabricator_name$$anonfun$1(name))) + package$.MODULE$.if_proper(Predef$.MODULE$.wrapString(ext), (Function0<String>)((Function0 & Serializable)() -> Phabricator$.phabricator_name$$anonfun$2(ext)));
    }

    public String phabricator_name$default$1() {
        return "";
    }

    public String phabricator_name$default$2() {
        return "";
    }

    public String isabelle_phabricator_name(String name, String ext) {
        return "isabelle-" + this.phabricator_name(name, ext);
    }

    public String isabelle_phabricator_name$default$1() {
        return "";
    }

    public String isabelle_phabricator_name$default$2() {
        return "";
    }

    public Path default_root(String name) {
        return Path$.MODULE$.explode("/var/www").$plus(Path$.MODULE$.basic(this.phabricator_name(name, this.phabricator_name$default$2())));
    }

    public Path default_repo(String name) {
        return this.default_root(name).$plus(Path$.MODULE$.basic("repo"));
    }

    public Path default_mailers() {
        return default_mailers;
    }

    public int default_system_port() {
        return default_system_port;
    }

    public int alternative_system_port() {
        return alternative_system_port;
    }

    public int default_server_port() {
        return default_server_port;
    }

    public String standard_mercurial_source() {
        Linux.Release release = Linux$Release$.MODULE$.apply();
        if (release.is_ubuntu_22_04()) {
            return "https://www.mercurial-scm.org/release/mercurial-6.1.4.tar.gz";
        }
        return "https://www.mercurial-scm.org/release/mercurial-6.8.2.tar.gz";
    }

    public Path global_config() {
        return global_config;
    }

    public String global_config_script(String init, String body, String exit) {
        return "#!/bin/bash\n" + package$.MODULE$.if_proper(Predef$.MODULE$.wrapString(init), (Function0<String>)((Function0 & Serializable)() -> Phabricator$.global_config_script$$anonfun$1(init))) + "\n{\n  while { unset REPLY; read -r; test \"$?\" = 0 -o -n \"$REPLY\"; }\n  do\n    NAME=\"$(echo \"$REPLY\" | cut -d: -f1)\"\n    ROOT=\"$(echo \"$REPLY\" | cut -d: -f2)\"\n    {\n" + Library$.MODULE$.indent_lines(6, body) + "\n    } < /dev/null\n  done\n} < " + File$.MODULE$.bash_path(this.global_config()) + "\n" + package$.MODULE$.if_proper(Predef$.MODULE$.wrapString(exit), (Function0<String>)((Function0 & Serializable)() -> Phabricator$.global_config_script$$anonfun$2(exit)));
    }

    public String global_config_script$default$1() {
        return "";
    }

    public String global_config_script$default$2() {
        return "";
    }

    public String global_config_script$default$3() {
        return "";
    }

    public List<Phabricator.Config> read_config() {
        if (this.global_config().is_file()) {
            return (List)Library$.MODULE$.trim_split_lines(File$.MODULE$.read(this.global_config())).withFilter((Function1 & Serializable)entry -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(entry))).map((Function1 & Serializable)entry -> {
                SeqOps seqOps;
                List list = (List)package$.MODULE$.space_explode().apply((Object)BoxesRunTime.boxToCharacter((char)':'), entry);
                if (list != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = scala.package$.MODULE$.List().unapplySeq((SeqOps)list), 2) == 0) {
                    String string = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                    String string2 = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 1);
                    String name = string;
                    String root = string2;
                    return Phabricator$Config$.MODULE$.apply(name, Path$.MODULE$.explode(root));
                }
                return (Phabricator.Config)package$.MODULE$.error().apply((Object)("Malformed config file " + MODULE$.global_config() + "\nentry " + package$.MODULE$.quote().apply(entry)));
            });
        }
        return scala.package$.MODULE$.Nil();
    }

    public void write_config(List<Phabricator.Config> configs) {
        File$.MODULE$.write(this.global_config(), configs.map((Function1 & Serializable)config -> config.name() + ":" + config.root().implode()).mkString("", "\n", "\n"));
    }

    public Phabricator.Config get_config(String name) {
        return (Phabricator.Config)this.read_config().find((Function1 & Serializable)config -> {
            String string = config.name();
            String string2 = name;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).getOrElse(() -> Phabricator$.get_config$$anonfun$2(name));
    }

    public Isabelle_Tool isabelle_tool1() {
        return isabelle_tool1;
    }

    public void user_setup(String name, String description, boolean ssh_setup) {
        if (!Linux$.MODULE$.user_exists(name)) {
            Linux$.MODULE$.user_add(name, description, true, ssh_setup);
            return;
        }
        String string = Linux$.MODULE$.user_description(name);
        String string2 = description;
        if (string == null ? string2 != null : !string.equals(string2)) {
            package$.MODULE$.error().apply((Object)("User " + package$.MODULE$.quote().apply((Object)name) + " already exists -- for Phorge it should have the description:\n  " + package$.MODULE$.quote().apply((Object)description)));
            return;
        }
    }

    public boolean user_setup$default$3() {
        return false;
    }

    public Path command_setup(String name, String init, String body, String exit) {
        Path command = Path$.MODULE$.explode("/usr/local/bin").$plus(Path$.MODULE$.basic(name));
        File$.MODULE$.write(command, this.global_config_script(init, body, exit));
        Isabelle_System$.MODULE$.chmod("755", command);
        Isabelle_System$.MODULE$.chown("root:root", command);
        return command;
    }

    public String command_setup$default$2() {
        return "";
    }

    public String command_setup$default$3() {
        return "";
    }

    public String command_setup$default$4() {
        return "";
    }

    public void mercurial_setup(String mercurial_source, Progress progress) {
        progress.echo("\nMercurial installation from source " + package$.MODULE$.quote().apply((Object)mercurial_source) + " ...", progress.echo$default$2());
        Isabelle_System$.MODULE$.with_tmp_dir("mercurial", Isabelle_System$.MODULE$.with_tmp_dir$default$2(), (Function1 & Serializable)tmp_dir -> {
            Path path;
            if (Url$.MODULE$.is_wellformed(mercurial_source)) {
                Path archive = tmp_dir.$plus(Path$.MODULE$.basic("mercurial.tar.gz"));
                Isabelle_System$.MODULE$.download_file(mercurial_source, archive, Isabelle_System$.MODULE$.download_file$default$3());
                path = archive;
            } else {
                path = Path$.MODULE$.explode(mercurial_source);
            }
            Path archive = path;
            Isabelle_System$.MODULE$.extract(archive, (Path)tmp_dir, Isabelle_System$.MODULE$.extract$default$3());
            Path build_dir = File$.MODULE$.get_dir((Path)tmp_dir, mercurial_source);
            return progress.bash("make all && make install", progress.bash$default$2(), build_dir, progress.bash$default$4(), progress.bash$default$5(), true, progress.bash$default$7(), progress.bash$default$8()).check();
        });
    }

    public Progress mercurial_setup$default$2() {
        return new Progress();
    }

    public void phabricator_setup(Options options, String name2, String root, String repo, Phabricator.Webserver webserver, boolean package_update, String mercurial_source, Progress progress) {
        Linux$.MODULE$.check_system_root();
        progress.echo("System packages ...", progress.echo$default$2());
        if (package_update) {
            Linux$.MODULE$.package_update(progress);
            Linux$.MODULE$.check_reboot_required();
        }
        Linux$.MODULE$.package_install(webserver.packages(), progress);
        Linux$.MODULE$.package_install(this.system_packages(), progress);
        Linux$.MODULE$.check_reboot_required();
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(mercurial_source))) {
            ((IterableOps)new .colon.colon((Object)"mercurial", (List)new .colon.colon((Object)"mercurial-common", (List)Nil$.MODULE$))).withFilter((Function1 & Serializable)name -> Linux$.MODULE$.package_installed((String)name)).foreach((Function1 & Serializable)name -> package$.MODULE$.error().apply((Object)("Cannot install Mercurial from source:\npackage package " + package$.MODULE$.quote().apply(name) + " already installed")));
            this.mercurial_setup(mercurial_source, progress);
        }
        if (StringOps$.MODULE$.exists$extension(Predef$.MODULE$.augmentString(name2), (Function1 & Serializable)c -> Phabricator$.phabricator_setup$$anonfun$3(BoxesRunTime.unboxToChar((Object)c))) || ((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "ssh", "phd", "dump", this.daemon_user()}))).contains((Object)name2)) {
            package$.MODULE$.error().apply((Object)("Bad installation name: " + package$.MODULE$.quote().apply((Object)name2)));
        }
        this.user_setup(this.daemon_user(), "Phorge Daemon User", true);
        this.user_setup(name2, "Phorge SSH User", this.user_setup$default$3());
        progress.echo("\nPhorge installation ...", progress.echo$default$2());
        Path root_path = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(root)) ? Path$.MODULE$.explode(root) : this.default_root(name2);
        Path repo_path = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(repo)) ? Path$.MODULE$.explode(repo) : this.default_repo(name2);
        List<Phabricator.Config> configs = this.read_config();
        configs.withFilter((Function1 & Serializable)config -> {
            String string = config.name();
            String string2 = name2;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).foreach((Function1 & Serializable)config -> package$.MODULE$.error().apply((Object)("Duplicate Phorge installation " + package$.MODULE$.quote().apply((Object)name2) + " in " + config.root())));
        if (!Isabelle_System$.MODULE$.bash("mkdir -p " + File$.MODULE$.bash_path(root_path), Isabelle_System$.MODULE$.bash$default$2(), Isabelle_System$.MODULE$.bash$default$3(), Isabelle_System$.MODULE$.bash$default$4(), Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), Isabelle_System$.MODULE$.bash$default$8(), Isabelle_System$.MODULE$.bash$default$9(), Isabelle_System$.MODULE$.bash$default$10(), Isabelle_System$.MODULE$.bash$default$11(), Isabelle_System$.MODULE$.bash$default$12()).ok()) {
            package$.MODULE$.error().apply((Object)("Failed to create root directory " + root_path));
        }
        Isabelle_System$.MODULE$.chown(Bash$.MODULE$.string(this.www_user()) + ":" + Bash$.MODULE$.string(this.www_user()), root_path);
        Isabelle_System$.MODULE$.chmod("755", root_path);
        String string = "\n        set -e\n        echo \"Cloning distribution repositories:\"\n\n        git clone --branch stable https://we.phorge.it/source/arcanist.git\n        git -C arcanist reset --hard " + Bash$.MODULE$.string(options.string().apply("phabricator_version_arcanist")) + "\n\n        git clone --branch stable https://we.phorge.it/source/phorge.git phabricator\n        git -C phabricator reset --hard " + Bash$.MODULE$.string(options.string().apply("phabricator_version_phabricator")) + "\n      ";
        SSH.System system = progress.bash$default$2();
        Map<String, String> map = progress.bash$default$4();
        boolean bl = progress.bash$default$5();
        long l = progress.bash$default$7();
        boolean bl2 = progress.bash$default$8();
        progress.bash(string, system, root_path, map, bl, true, l, bl2).check();
        Phabricator.Config config2 = Phabricator$Config$.MODULE$.apply(name2, root_path);
        this.write_config((List<Phabricator.Config>)((List)new .colon.colon((Object)config2, (List)Nil$.MODULE$)).$colon$colon$colon(configs));
        config2.execute("config set pygments.enabled true");
        progress.echo("\nRepository hosting setup ...", progress.echo$default$2());
        if (!Isabelle_System$.MODULE$.bash("mkdir -p " + File$.MODULE$.bash_path(repo_path), Isabelle_System$.MODULE$.bash$default$2(), Isabelle_System$.MODULE$.bash$default$3(), Isabelle_System$.MODULE$.bash$default$4(), Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), Isabelle_System$.MODULE$.bash$default$8(), Isabelle_System$.MODULE$.bash$default$9(), Isabelle_System$.MODULE$.bash$default$10(), Isabelle_System$.MODULE$.bash$default$11(), Isabelle_System$.MODULE$.bash$default$12()).ok()) {
            package$.MODULE$.error().apply((Object)("Failed to create local repository directory " + repo_path));
        }
        Isabelle_System$.MODULE$.chown("-R " + Bash$.MODULE$.string(this.daemon_user()) + ":" + Bash$.MODULE$.string(this.daemon_user()), repo_path);
        Isabelle_System$.MODULE$.chmod("755", repo_path);
        config2.execute("config set repository.default-local-path " + File$.MODULE$.bash_path(repo_path));
        Path sudoers_file = Path$.MODULE$.explode("/etc/sudoers.d").$plus(Path$.MODULE$.basic(this.isabelle_phabricator_name(name2, this.isabelle_phabricator_name$default$2())));
        File$.MODULE$.write(sudoers_file, this.www_user() + " ALL=(" + this.daemon_user() + ") SETENV: NOPASSWD: /usr/bin/git, /usr/local/bin/hg, /usr/bin/hg, /usr/bin/ssh, /usr/bin/id\n" + name2 + " ALL=(" + this.daemon_user() + ") SETENV: NOPASSWD: /usr/bin/git, /usr/bin/git-upload-pack, /usr/bin/git-receive-pack, /usr/local/bin/hg, /usr/bin/hg, /usr/bin/svnserve, /usr/bin/ssh, /usr/bin/id\n");
        Isabelle_System$.MODULE$.chmod("440", sudoers_file);
        config2.execute("config set diffusion.ssh-user " + Bash$.MODULE$.string(config2.name()));
        progress.echo("\nMySQL setup ...", progress.echo$default$2());
        File$.MODULE$.write(Path$.MODULE$.explode("/etc/mysql/mysql.conf.d/" + this.phabricator_name(this.phabricator_name$default$1(), "cnf")), "[mysqld]\nmax_allowed_packet = 32M\ninnodb_buffer_pool_size = 1600M\nlocal_infile = 0\n");
        Linux$.MODULE$.service_restart("mysql");
        String mysql_root_user = this.mysql_conf$1(StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^user\\s*=\\s*(\\S*)\\s*$")), "superuser name");
        String mysql_root_password = this.mysql_conf$1(StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^password\\s*=\\s*(\\S*)\\s*$")), "superuser password");
        String mysql_name = this.phabricator_name(name2, this.phabricator_name$default$2()).replace("-", "_");
        String mysql_user_string = SQL$.MODULE$.string(mysql_name) + "@'localhost'";
        String mysql_password = Linux$.MODULE$.generate_password(Linux$.MODULE$.generate_password$default$1());
        Isabelle_System$.MODULE$.bash("mysql --user=" + Bash$.MODULE$.string(mysql_root_user) + " --password=" + Bash$.MODULE$.string(mysql_root_password) + " --execute=" + Bash$.MODULE$.string("DROP USER IF EXISTS " + mysql_user_string + "; CREATE USER " + mysql_user_string + " IDENTIFIED BY " + SQL$.MODULE$.string(mysql_password) + " PASSWORD EXPIRE NEVER; GRANT ALL ON `" + (mysql_name + "_%").replace("_", "\\_") + "`.* TO " + mysql_user_string + "; GRANT PROCESS ON *.* TO " + mysql_user_string + ";"), Isabelle_System$.MODULE$.bash$default$2(), Isabelle_System$.MODULE$.bash$default$3(), Isabelle_System$.MODULE$.bash$default$4(), Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), Isabelle_System$.MODULE$.bash$default$8(), Isabelle_System$.MODULE$.bash$default$9(), Isabelle_System$.MODULE$.bash$default$10(), Isabelle_System$.MODULE$.bash$default$11(), Isabelle_System$.MODULE$.bash$default$12()).check();
        config2.execute("config set mysql.user " + Bash$.MODULE$.string(mysql_name));
        config2.execute("config set mysql.pass " + Bash$.MODULE$.string(mysql_password));
        config2.execute("config set phabricator.cache-namespace " + Bash$.MODULE$.string(mysql_name));
        config2.execute("config set storage.default-namespace " + Bash$.MODULE$.string(mysql_name));
        config2.execute("config set storage.mysql-engine.max-size 8388608");
        Path path = config2.home();
        SSH.System system2 = progress.bash$default$2();
        Map<String, String> map2 = progress.bash$default$4();
        boolean bl3 = progress.bash$default$5();
        long l2 = progress.bash$default$7();
        boolean bl4 = progress.bash$default$8();
        progress.bash("bin/storage upgrade --force", system2, path, map2, bl3, true, l2, bl4).check();
        String dump_name = this.isabelle_phabricator_name("dump", this.isabelle_phabricator_name$default$2());
        this.command_setup(dump_name, this.command_setup$default$2(), "mkdir -p \"$ROOT/database\" && chown root:root \"$ROOT/database\" && chmod 700 \"$ROOT/database\"\n[ -e \"$ROOT/database/dump.sql.gz\" ] && mv -f \"$ROOT/database/dump.sql.gz\" \"$ROOT/database/dump-old.sql.gz\"\necho -n \"Creating $ROOT/database/dump.sql.gz ...\"\n\"$ROOT/phabricator/bin/storage\" dump --compress --output \"$ROOT/database/dump.sql.gz\" 2>&1 | fgrep -v '[Warning] Using a password on the command line interface can be insecure'\necho \" $(ls -hs \"$ROOT/database/dump.sql.gz\" | cut -d\" \" -f1)\" ", this.command_setup$default$4());
        this.command_setup(this.isabelle_phabricator_name("upgrade", this.isabelle_phabricator_name$default$2()), "BRANCH=\"${1:-stable}\"\nif [ \"$BRANCH\" != \"master\" -a \"$BRANCH\" != \"stable\" ]\nthen\n  echo \"Bad branch: \\\"$BRANCH\\\"\"\n  exit 1\nfi\n\nsystemctl stop isabelle-phabricator-phd\nsystemctl stop " + webserver.system_name(), "echo -e \"\\nUpgrading phabricator \\\"$NAME\\\" root \\\"$ROOT\\\" ...\"\nfor REPO in arcanist phabricator\ndo\n  cd \"$ROOT/$REPO\"\n  echo -e \"\\nUpdating \\\"$REPO\\\" ...\"\n  git checkout \"$BRANCH\"\n  git pull\ndone\necho -e \"\\nUpgrading storage ...\"\n\"$ROOT/phabricator/bin/storage\" upgrade --force\n", "systemctl start " + webserver.system_name() + "\nsystemctl start isabelle-phabricator-phd");
        progress.echo(webserver.user_name() + " setup ...", progress.echo$default$2());
        Path sites_dir = webserver.sites_dir();
        if (!sites_dir.is_dir()) {
            package$.MODULE$.error().apply((Object)("Bad " + webserver + " sites directory " + sites_dir));
        }
        String server_name = this.phabricator_name(name2, "localhost");
        String server_url = "http://" + server_name;
        webserver.php_init();
        webserver.site_init(name2, server_name, config2.webroot());
        config2.execute("config set phabricator.base-uri " + Bash$.MODULE$.string(server_url));
        webserver.restart();
        progress.echo("\nFurther manual configuration via " + server_url, progress.echo$default$2());
        progress.echo("\nPHP daemon setup ...", progress.echo$default$2());
        Path phd_log_path = Isabelle_System$.MODULE$.make_directory(Path$.MODULE$.explode("/var/tmp/phd"));
        Isabelle_System$.MODULE$.chown("-R " + Bash$.MODULE$.string(this.daemon_user()) + ":" + Bash$.MODULE$.string(this.daemon_user()), phd_log_path);
        Isabelle_System$.MODULE$.chmod("755", phd_log_path);
        config2.execute("config set phd.user " + Bash$.MODULE$.string(this.daemon_user()));
        config2.execute("config set phd.log-directory /var/tmp/phd/" + this.isabelle_phabricator_name(name2, this.isabelle_phabricator_name$default$2()) + "/log");
        String phd_name = this.isabelle_phabricator_name("phd", this.isabelle_phabricator_name$default$2());
        Linux$.MODULE$.service_shutdown(phd_name);
        Path phd_command = this.command_setup(phd_name, this.command_setup$default$2(), "\"$ROOT/phabricator/bin/phd\" \"$@\" ", this.command_setup$default$4());
        try {
            Linux$.MODULE$.service_install(phd_name, "[Unit]\nDescription=PHP daemon manager for Isabelle/Phorge\nAfter=syslog.target network.target " + webserver.system_name() + ".service mysql.service\n\n[Service]\nType=oneshot\nUser=" + this.daemon_user() + "\nGroup=" + this.daemon_user() + "\nEnvironment=PATH=/sbin:/usr/sbin:/usr/local/sbin:/usr/local/bin:/usr/bin:/bin\nExecStart=" + phd_command.implode() + " start --force\nExecStop=" + phd_command.implode() + " stop\nRemainAfterExit=yes\n\n[Install]\nWantedBy=multi-user.target\n");
        }
        catch (Throwable throwable) {
            String string2;
            Option<String> option;
            Throwable throwable2 = throwable;
            if (throwable2 == null || (option = package$.MODULE$.ERROR().unapply(throwable2)).isEmpty()) {
                throw throwable;
            }
            String msg = string2 = (String)option.get();
            Path path2 = config2.home();
            SSH.System system3 = progress.bash$default$2();
            Map<String, String> map3 = progress.bash$default$4();
            boolean bl5 = progress.bash$default$5();
            long l3 = progress.bash$default$7();
            boolean bl6 = progress.bash$default$8();
            progress.bash("bin/phd status", system3, path2, map3, bl5, true, l3, bl6).check();
            throw (Nothing$)package$.MODULE$.error().apply((Object)msg);
        }
    }

    public String phabricator_setup$default$2() {
        return this.default_name();
    }

    public String phabricator_setup$default$3() {
        return "";
    }

    public String phabricator_setup$default$4() {
        return "";
    }

    public Phabricator.Webserver phabricator_setup$default$5() {
        return this.default_webserver();
    }

    public boolean phabricator_setup$default$6() {
        return false;
    }

    public String phabricator_setup$default$7() {
        return "";
    }

    public Progress phabricator_setup$default$8() {
        return new Progress();
    }

    public Isabelle_Tool isabelle_tool2() {
        return isabelle_tool2;
    }

    public String mailers_template() {
        return mailers_template;
    }

    public void phabricator_setup_mail(String name, Option<Path> config_file, String test_user, Progress progress) {
        Linux$.MODULE$.check_system_root();
        Phabricator.Config config = this.get_config(name);
        Path default_config_file = config.root().$plus(this.default_mailers());
        Path mail_config = (Path)config_file.getOrElse(() -> Phabricator$.$anonfun$19(default_config_file));
        if (config_file.isEmpty()) {
            if (!default_config_file.is_file()) {
                File$.MODULE$.write(default_config_file, this.mailers_template());
                Isabelle_System$.MODULE$.chmod("600", default_config_file);
            }
            String string = File$.MODULE$.read(default_config_file);
            String string2 = this.mailers_template();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                progress.echo("Please invoke the tool again, after providing details in\n  " + default_config_file.implode() + "\n", progress.echo$default$2());
                return;
            }
            this.setup_mail$1(progress, mail_config, config, test_user);
            return;
        }
        this.setup_mail$1(progress, mail_config, config, test_user);
    }

    public String phabricator_setup_mail$default$1() {
        return this.default_name();
    }

    public Option<Path> phabricator_setup_mail$default$2() {
        return None$.MODULE$;
    }

    public String phabricator_setup_mail$default$3() {
        return "";
    }

    public Progress phabricator_setup_mail$default$4() {
        return new Progress();
    }

    public Isabelle_Tool isabelle_tool3() {
        return isabelle_tool3;
    }

    public String conf_ssh_port(int port) {
        if (port == this.default_system_port()) {
            return "#Port " + this.default_system_port();
        }
        return "Port " + port;
    }

    public int read_ssh_port(Path conf) {
        SeqOps seqOps;
        List lines = (List)package$.MODULE$.split_lines().apply((Object)File$.MODULE$.read(conf));
        List ports = lines.flatMap((Function1 & Serializable)x$1 -> {
            String string = x$1;
            if (string != null) {
                List list;
                Option<Object> option;
                String string2;
                List list2;
                Option option2 = Port.unapplySeq((CharSequence)string);
                if (!option2.isEmpty() && (list2 = (List)option2.get()).lengthCompare(1) == 0 && (string2 = (String)list2.apply(0)) != null && !(option = Value$Int$.MODULE$.unapply(string2)).isEmpty()) {
                    int n;
                    int p = n = BoxesRunTime.unboxToInt((Object)option.get());
                    return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)p));
                }
                Option option3 = No_Port.unapplySeq((CharSequence)string);
                if (!option3.isEmpty() && (list = (List)option3.get()).lengthCompare(0) == 0) {
                    return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)MODULE$.default_system_port()));
                }
            }
            return None$.MODULE$;
        });
        List list = ports;
        if (list != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = scala.package$.MODULE$.List().unapplySeq((SeqOps)list), 1) == 0) {
            int n;
            int port = n = BoxesRunTime.unboxToInt((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0));
            return port;
        }
        Nil$ nil$ = scala.package$.MODULE$.Nil();
        List list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return BoxesRunTime.unboxToInt((Object)package$.MODULE$.error().apply((Object)("Missing Port specification in " + conf)));
        }
        return BoxesRunTime.unboxToInt((Object)package$.MODULE$.error().apply((Object)("Multiple Port specifications in " + conf)));
    }

    public boolean write_ssh_port(Path conf, int port) {
        int old_port = this.read_ssh_port(conf);
        if (old_port == port) {
            return false;
        }
        List lines = (List)package$.MODULE$.split_lines().apply((Object)File$.MODULE$.read(conf));
        List lines1 = lines.map((Function1 & Serializable)x$1 -> {
            List list;
            Option option;
            String string = x$1;
            if (string != null && !(option = Any_Port.unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(0) == 0) {
                return MODULE$.conf_ssh_port(port);
            }
            String line = string;
            return line;
        });
        File$.MODULE$.write(conf, (String)package$.MODULE$.cat_lines().apply((Object)lines1));
        return true;
    }

    public void phabricator_setup_ssh(int server_port, int system_port, Progress progress) {
        Linux$.MODULE$.check_system_root();
        List<Phabricator.Config> configs = this.read_config();
        if (server_port == system_port) {
            package$.MODULE$.error().apply((Object)("Port for Phorge sshd coincides with system port: " + system_port));
        }
        Path sshd_conf_system = Path$.MODULE$.explode("/etc/ssh/sshd_config");
        Path sshd_conf_server = sshd_conf_system.ext(this.isabelle_phabricator_name(this.isabelle_phabricator_name$default$1(), this.isabelle_phabricator_name$default$2()));
        String ssh_name = this.isabelle_phabricator_name("ssh", this.isabelle_phabricator_name$default$2());
        Linux$.MODULE$.service_shutdown(ssh_name);
        int old_system_port = this.read_ssh_port(sshd_conf_system);
        if (old_system_port != system_port) {
            progress.echo("Reconfigurig system ssh service", progress.echo$default$2());
            Linux$.MODULE$.service_shutdown("ssh");
            this.write_ssh_port(sshd_conf_system, system_port);
            Linux$.MODULE$.service_start("ssh");
        }
        progress.echo("Configuring " + ssh_name + " service", progress.echo$default$2());
        Path ssh_command = this.command_setup(ssh_name, this.command_setup$default$2(), "if [ \"$1\" = \"$NAME\" ]\nthen\n  exec \"$ROOT/phabricator/bin/ssh-auth\" \"$@\"\nfi", "exit 1");
        File$.MODULE$.write(sshd_conf_server, "# OpenBSD Secure Shell server for Isabelle/Phorge\nAuthorizedKeysCommand " + ssh_command.implode() + "\nAuthorizedKeysCommandUser " + this.daemon_user() + "\nAuthorizedKeysFile none\nAllowUsers " + configs.map((Function1 & Serializable)_$3 -> _$3.name()).mkString(" ") + "\nPort " + server_port + "\nProtocol 2\nPermitRootLogin no\nAllowAgentForwarding no\nAllowTcpForwarding no\nPrintMotd no\nPrintLastLog no\nPasswordAuthentication no\nChallengeResponseAuthentication no\nPidFile /var/run/" + ssh_name + ".pid\n");
        Linux$.MODULE$.service_install(ssh_name, "[Unit]\nDescription=OpenBSD Secure Shell server for Isabelle/Phorge\nAfter=network.target auditd.service ssh.service isabelle-phabricator-phd.service\nConditionPathExists=!/etc/ssh/sshd_not_to_be_run\n\n[Service]\nEnvironmentFile=-/etc/default/ssh\nExecStartPre=/usr/sbin/sshd -f " + sshd_conf_server.implode() + " -t\nExecStart=/usr/sbin/sshd -f " + sshd_conf_server.implode() + " -D $SSHD_OPTS\nExecReload=/usr/sbin/sshd -f " + sshd_conf_server.implode() + " -t\nExecReload=/bin/kill -HUP $MAINPID\nKillMode=process\nRestart=on-failure\nRestartPreventExitStatus=255\nType=notify\nRuntimeDirectory=sshd-phabricator\nRuntimeDirectoryMode=0755\n\n[Install]\nWantedBy=multi-user.target\nAlias=" + ssh_name + ".service\n");
        configs.foreach((Function1)(JProcedure1 & Serializable)config -> {
            progress.echo("phabricator " + package$.MODULE$.quote().apply((Object)config.name()) + " port " + server_port, progress.echo$default$2());
            config.execute("config set diffusion.ssh-port " + Bash$.MODULE$.string(BoxesRunTime.boxToInteger((int)server_port).toString()));
            if (server_port == MODULE$.default_system_port()) {
                config.execute("config delete diffusion.ssh-port");
                return;
            }
        });
    }

    public int phabricator_setup_ssh$default$1() {
        return this.default_server_port();
    }

    public int phabricator_setup_ssh$default$2() {
        return this.default_system_port();
    }

    public Progress phabricator_setup_ssh$default$3() {
        return new Progress();
    }

    public Isabelle_Tool isabelle_tool4() {
        return isabelle_tool4;
    }

    private final String $anonfun$1() {
        return "\nUsage: isabelle phabricator [OPTIONS] COMMAND [ARGS...]\n\n  Options are:\n    -l           list available Phorge installations\n    -n NAME      Phorge installation name (default: " + package$.MODULE$.quote().apply((Object)this.default_name()) + ")\n\n  Invoke a command-line tool within the home directory of the named\n  Phorge installation.\n";
    }

    private final String $anonfun$4() {
        return "\nUsage: isabelle phabricator_setup [OPTIONS]\n\n  Options are:\n    -M SOURCE    install Mercurial from source: local PATH, or URL, or \":\" for\n                 " + this.standard_mercurial_source() + "\n    -R DIR       repository directory (default: " + this.default_repo("NAME") + ")\n    -U           full update of system packages before installation\n    -n NAME      Phorge installation name (default: " + package$.MODULE$.quote().apply((Object)this.default_name()) + ")\n    -o OPTION    override Isabelle system OPTION (via NAME=VAL or NAME)\n    -r DIR       installation root directory (default: " + this.default_root("NAME") + ")\n    -w NAME      webserver name (" + this.all_webservers().map((Function1 & Serializable)w -> (String)package$.MODULE$.quote().apply((Object)w.user_name())).mkString(" or ") + ", default: " + package$.MODULE$.quote().apply((Object)this.default_webserver().user_name()) + ")\n\n  Install Phorge as Linux service, based on webserver + PHP + MySQL.\n\n  The installation name (default: " + package$.MODULE$.quote().apply((Object)this.default_name()) + ") is mapped to a regular\n  Unix user; this is relevant for public SSH access.\n";
    }

    private final String $anonfun$12() {
        return "\nUsage: isabelle phabricator_setup_mail [OPTIONS]\n\n  Options are:\n    -T USER      send test mail to Phorge user\n    -f FILE      config file (default: " + this.default_mailers() + " within Phorge root)\n    -n NAME      Phorge installation name (default: " + package$.MODULE$.quote().apply((Object)this.default_name()) + ")\n\n  Provide mail configuration for existing Phorge installation.\n";
    }

    private final String $anonfun$16() {
        return "\nUsage: isabelle phabricator_setup_ssh [OPTIONS]\n\n  Options are:\n    -p PORT      sshd port for Phorge servers (default: " + this.default_server_port() + ")\n    -q PORT      sshd port for the operating system (default: " + this.default_system_port() + ")\n\n  Configure ssh service for all Phorge installations: a separate sshd\n  is run in addition to the one of the operating system, and ports need to\n  be distinct.\n\n  A particular Phorge installation is addressed by using its\n  name as the ssh user; the actual Phorge user is determined via\n  stored ssh keys.\n";
    }

    private static final Phabricator.Webserver get_webserver$$anonfun$2(String name$5) {
        return (Phabricator.Webserver)package$.MODULE$.error().apply((Object)("Bad webserver " + package$.MODULE$.quote().apply((Object)name$5)));
    }

    private static final String phabricator_name$$anonfun$1(String name$6) {
        return "-" + name$6;
    }

    private static final String phabricator_name$$anonfun$2(String ext$1) {
        return "." + ext$1;
    }

    private static final String global_config_script$$anonfun$1(String init$1) {
        return "\n" + init$1;
    }

    private static final String global_config_script$$anonfun$2(String exit$1) {
        return "\n" + exit$1 + "\n";
    }

    private static final Phabricator.Config get_config$$anonfun$2(String name$8) {
        return (Phabricator.Config)package$.MODULE$.error().apply((Object)("Bad Isabelle/Phorge installation " + package$.MODULE$.quote().apply((Object)name$8)));
    }

    private static final /* synthetic */ boolean phabricator_setup$$anonfun$3(char c) {
        return !Symbol$.MODULE$.is_ascii_letter(c) && !Symbol$.MODULE$.is_ascii_digit(c);
    }

    private final String mysql_conf$1(Regex R, String which) {
        Path conf = Path$.MODULE$.explode("/etc/mysql/debian.cnf");
        Option option = ((IterableOnceOps)package$.MODULE$.split_lines().apply((Object)File$.MODULE$.read(conf))).collectFirst((PartialFunction)new Serializable(R){
            private final Regex R$1;
            {
                this.R$1 = R$2;
            }

            public final boolean isDefinedAt(String x) {
                List list;
                Option option;
                String string = x;
                if (string != null && !(option = this.R$1.unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(1) == 0) {
                    String string2;
                    String a = string2 = (String)list.apply(0);
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(String x, Function1 function1) {
                List list;
                Option option;
                String string = x;
                if (string != null && !(option = this.R$1.unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(1) == 0) {
                    String string2;
                    String a = string2 = (String)list.apply(0);
                    return a;
                }
                return function1.apply((Object)x);
            }
        });
        if (option instanceof Some) {
            String res = (String)((Some)option).value();
            return res;
        }
        if (None$.MODULE$.equals(option)) {
            return (String)package$.MODULE$.error().apply((Object)("Cannot determine " + which + " from " + conf));
        }
        throw new MatchError((Object)option);
    }

    private static final Path $anonfun$19(Path default_config_file$1) {
        return default_config_file$1;
    }

    private final void setup_mail$1(Progress progress$3, Path mail_config$1, Phabricator.Config config$1, String test_user$2) {
        progress$3.echo("Using mail configuration from " + mail_config$1, progress$3.echo$default$2());
        config$1.execute("config set cluster.mailers --stdin < " + File$.MODULE$.bash_path(mail_config$1));
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(test_user$2))) {
            progress$3.echo("Sending test mail to " + package$.MODULE$.quote().apply((Object)test_user$2), progress$3.echo$default$2());
            Path path = config$1.home();
            String string = "echo \"Test from Phorge ($(date))\" | bin/mail send-test --subject \"Test\" --to " + Bash$.MODULE$.string(test_user$2);
            SSH.System system = progress$3.bash$default$2();
            Map<String, String> map = progress$3.bash$default$4();
            boolean bl = progress$3.bash$default$5();
            long l = progress$3.bash$default$7();
            boolean bl2 = progress$3.bash$default$8();
            progress$3.bash(string, system, path, map, bl, true, l, bl2).check();
            return;
        }
    }

    public static final /* synthetic */ Option isabelle$Phabricator$API$$_$execute_search$$anonfun$1(Function1 unapply$1, Object _$5) {
        return JSON$.MODULE$.list(_$5, "data", unapply$1);
    }

    public static final /* synthetic */ Option isabelle$Phabricator$API$$_$execute_search$$anonfun$2(Object _$6) {
        return JSON$.MODULE$.value(_$6, "cursor", (Function1 & Serializable)_$7 -> JSON$.MODULE$.string0(_$7, "after"));
    }

    public static final /* synthetic */ Option isabelle$Phabricator$API$$_$user_phid$lzyINIT1$$anonfun$1(Object _$8) {
        return JSON$.MODULE$.string(_$8, "phid");
    }

    public static final /* synthetic */ Option isabelle$Phabricator$API$$_$user_name$lzyINIT1$$anonfun$1(Object _$9) {
        return JSON$.MODULE$.string(_$9, "userName");
    }

    public static final /* synthetic */ boolean isabelle$Phabricator$API$$_$_$$anonfun$22(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            return true;
        }
        return false;
    }

    public static final /* synthetic */ boolean isabelle$Phabricator$API$$_$_$$anonfun$23(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(value));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Tuple2 isabelle$Phabricator$API$$_$_$$anonfun$24(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            return Tuple2$.MODULE$.apply((Object)key, (Object)new .colon.colon((Object)value, (List)Nil$.MODULE$));
        }
        throw new MatchError((Object)tuple2);
    }

    private static final /* synthetic */ Option get_users$$anonfun$1$$anonfun$1$$anonfun$1(Object data$2, Object fields$1, long id) {
        return JSON$.MODULE$.string(data$2, "phid").flatMap((Function1 & Serializable)phid -> JSON$.MODULE$.string(fields$1, "username").flatMap((Function1 & Serializable)name -> JSON$.MODULE$.string0(fields$1, "realName").flatMap((Function1 & Serializable)real_name -> JSON$.MODULE$.strings(fields$1, "roles").map((Function1 & Serializable)roles -> Phabricator$API$User$.MODULE$.apply(id, (String)phid, (String)name, (String)real_name, (List<String>)roles)))));
    }

    public static final /* synthetic */ Option isabelle$Phabricator$API$$_$get_users$$anonfun$1(Object data) {
        return JSON$.MODULE$.value(data, "fields", (Function1 & Serializable)fields -> JSON$.MODULE$.long(data, "id").flatMap((Function1 & Serializable)id -> Phabricator$.get_users$$anonfun$1$$anonfun$1$$anonfun$1(data, fields, BoxesRunTime.unboxToLong((Object)id))));
    }

    public static final /* synthetic */ boolean isabelle$Phabricator$API$$_$_$$anonfun$25(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            return true;
        }
        return false;
    }

    public static final /* synthetic */ boolean isabelle$Phabricator$API$$_$_$$anonfun$26(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(value));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Tuple2 isabelle$Phabricator$API$$_$_$$anonfun$27(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            return Tuple2$.MODULE$.apply((Object)key, (Object)new .colon.colon((Object)value, (List)Nil$.MODULE$));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final Object isabelle$Phabricator$API$$_$create_repository$$anonfun$1() {
        return "bad repository name";
    }

    public static final /* synthetic */ Option isabelle$Phabricator$API$$_$_$$anonfun$28(Object _$10) {
        return JSON$.MODULE$.value(_$10, "object", (Function1 & Serializable)_$11 -> JSON$.MODULE$.string(_$11, "phid"));
    }

    public static final /* synthetic */ IterableOnce isabelle$Phabricator$API$$$_$opt_edits$$anonfun$1(String typ$1, Object _$4) {
        return Phabricator$API$.MODULE$.edits(typ$1, _$4);
    }

    public static final /* synthetic */ Option isabelle$Phabricator$API$Result$$_$get_string$$anonfun$1(Object json) {
        return JSON$Value$String$.MODULE$.unapply(json);
    }

    public static final Object isabelle$Phabricator$API$$$_$_$$anonfun$29() {
        return JSON$Object$.MODULE$.empty();
    }

    public static final Option isabelle$Phabricator$API$$$_$make_result$$anonfun$1(Option error_code$1) {
        return error_code$1;
    }
}

