/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Platform;
import isabelle.Platform$Family$;
import isabelle.Platform$Info$;
import isabelle.package$;
import isabelle.setup.Environment;
import java.io.Serializable;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.matching.Regex;

public final class Platform$
implements Serializable {
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(Platform$.class.getDeclaredField("jvm_version$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Platform$.class.getDeclaredField("jvm_platform$lzy1"));
    private static final boolean is_windows;
    private static final boolean is_linux;
    private static final boolean is_macos;
    private static final boolean is_unix;
    public static final Platform$Family$ Family;
    private static final Regex X86_64;
    private static final Regex Arm64;
    private volatile Object jvm_platform$lzy1;
    public static final Platform$Info$ Info;
    private static final Regex Version;
    private volatile Object jvm_version$lzy1;
    private static final String jvm_name;
    public static final Platform$ MODULE$;

    private Platform$() {
    }

    static {
        MODULE$ = new Platform$();
        is_windows = Predef$.MODULE$.Boolean2boolean(Environment.is_windows());
        is_linux = Predef$.MODULE$.Boolean2boolean(Environment.is_linux());
        is_macos = Predef$.MODULE$.Boolean2boolean(Environment.is_macos());
        is_unix = MODULE$.is_linux() || MODULE$.is_macos();
        X86_64 = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("amd64|x86_64"));
        Arm64 = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("arm64|aarch64"));
        Version = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("1\\.(\\d+)\\.0_(\\d+)"));
        jvm_name = System.getProperty("java.vm.name", "");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Platform$.class);
    }

    public boolean is_windows() {
        return is_windows;
    }

    public boolean is_linux() {
        return is_linux;
    }

    public boolean is_macos() {
        return is_macos;
    }

    public boolean is_unix() {
        return is_unix;
    }

    public boolean is_arm() {
        return this.cpu_arch().startsWith("arm");
    }

    public Platform.Family family() {
        if (this.is_linux() && this.is_arm()) {
            return Platform$Family$.linux_arm;
        }
        if (this.is_linux()) {
            return Platform$Family$.linux;
        }
        if (this.is_macos()) {
            return Platform$Family$.macos;
        }
        if (this.is_windows()) {
            return Platform$Family$.windows;
        }
        return (Platform.Family)package$.MODULE$.error().apply((Object)"Failed to determine current platform family");
    }

    public String cpu_arch() {
        String string = System.getProperty("os.arch", "");
        if (string != null) {
            List list;
            List list2;
            Option option = X86_64.unapplySeq((CharSequence)string);
            if (!option.isEmpty() && (list2 = (List)option.get()).lengthCompare(0) == 0) {
                return "x86_64";
            }
            Option option2 = Arm64.unapplySeq((CharSequence)string);
            if (!option2.isEmpty() && (list = (List)option2.get()).lengthCompare(0) == 0) {
                return "arm64";
            }
        }
        return (String)package$.MODULE$.error().apply((Object)"Failed to determine CPU architecture");
    }

    public String os_name() {
        Platform.Family family = this.family();
        Platform.Family family2 = Platform$Family$.linux_arm;
        Platform.Family family3 = family;
        if (!(family2 != null ? !family2.equals(family3) : family3 != null)) {
            return "linux";
        }
        Platform.Family family4 = Platform$Family$.macos;
        Platform.Family family5 = family;
        if (!(family4 != null ? !family4.equals(family5) : family5 != null)) {
            return "darwin";
        }
        return this.family().toString();
    }

    public String jvm_platform() {
        Object object = this.jvm_platform$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.jvm_platform$lzyINIT1();
    }

    private Object jvm_platform$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.jvm_platform$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = this.cpu_arch() + "-" + this.os_name();
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.jvm_platform$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String jvm_version() {
        Object object = this.jvm_version$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.jvm_version$lzyINIT1();
    }

    private Object jvm_version$lzyINIT1() {
        Object object;
        block10: {
            while (true) {
                if ((object = this.jvm_version$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        List list;
                        Option option;
                        String string2 = System.getProperty("java.version");
                        if (string2 != null && !(option = Version.unapplySeq((CharSequence)string2)).isEmpty() && (list = (List)option.get()).lengthCompare(2) == 0) {
                            String string3 = (String)list.apply(0);
                            String string4 = (String)list.apply(1);
                            String a = string3;
                            String b = string4;
                            v0 = a + "u" + b;
                        } else {
                            String a = string2;
                            v0 = string = a;
                        }
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.jvm_version$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block10;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String jvm_name() {
        return jvm_name;
    }

    public static final Platform.Family isabelle$Platform$Family$$$_$parse$$anonfun$1(String name$1) {
        return (Platform.Family)package$.MODULE$.error().apply((Object)("Bad platform family: " + package$.MODULE$.quote().apply((Object)name$1)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean isabelle$Platform$Family$$$_$from_platform$$anonfun$1(String platform$1, Platform.Family family) {
        String string = platform$1;
        Object object = Platform$Family$.MODULE$.standard().apply((Object)family);
        if (string == null) {
            if (object == null) return true;
        } else if (string.equals(object)) return true;
        String string2 = platform$1;
        Object object2 = Platform$Family$.MODULE$.native().apply((Object)family);
        if (string2 != null) {
            if (!string2.equals(object2)) return false;
            return true;
        }
        if (object2 == null) return true;
        return false;
    }

    public static final Platform.Family isabelle$Platform$Family$$$_$from_platform$$anonfun$2(String platform$2) {
        return (Platform.Family)package$.MODULE$.error().apply((Object)("Bad platform " + package$.MODULE$.quote().apply((Object)platform$2)));
    }

    public static final /* synthetic */ String isabelle$Platform$Info$$$_$_$_$$anonfun$1(Platform.Info _$1) {
        return _$1.family_name();
    }

    public static final /* synthetic */ String isabelle$Platform$Info$$$_$_$$anonfun$2(Platform.Info _$2) {
        return _$2.platform();
    }
}

