/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;

public class Popup {
    private final JLayeredPane layered;
    private final JComponent component;
    private final Point location;
    private final Dimension size;

    public Popup(JLayeredPane layered, JComponent component, Point location, Dimension size) {
        this.layered = layered;
        this.component = component;
        this.location = location;
        this.size = size;
    }

    public void show() {
        this.component.setLocation(this.location);
        this.component.setSize(this.size);
        this.component.setPreferredSize(this.size);
        this.component.setOpaque(true);
        this.layered.add((Component)this.component, JLayeredPane.POPUP_LAYER);
        this.layered.moveToFront(this.component);
        this.layered.repaint(this.component.getBounds());
    }

    public void hide() {
        Rectangle bounds = this.component.getBounds();
        this.layered.remove(this.component);
        this.layered.repaint(bounds);
    }
}

