/*
 * Decompiled with CFR 0.152.
 */
package isabelle.vscode;

import isabelle.Bytes$;
import isabelle.Components;
import isabelle.Components$Directory$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.Date$;
import isabelle.Date$Format$;
import isabelle.File;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.HTML$;
import isabelle.Isabelle_Platform;
import isabelle.Isabelle_Platform$Context$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.Isabelle_Tool$;
import isabelle.JSON$;
import isabelle.JSON$Format$;
import isabelle.JSON$Object$;
import isabelle.Library$;
import isabelle.MinGW;
import isabelle.MinGW$;
import isabelle.Nodejs;
import isabelle.Nodejs$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Progress;
import isabelle.Scala_Project$;
import isabelle.Symbol;
import isabelle.Symbol$;
import isabelle.Symbol$Symbols$;
import isabelle.package$;
import isabelle.vscode.Component_VSCodium;
import isabelle.vscode.Component_VSCodium$Build_Context$;
import java.io.File;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.Base64;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class Component_VSCodium$
implements Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Component_VSCodium$.class.getDeclaredField("symbols$lzy1"));
    private static final List linux_packages;
    private static final List windows_packages;
    private static final List macos_packages;
    private static final String default_node_version;
    private static final String default_vscodium_version;
    private static final String vscodium_repository;
    private static final String vscodium_download;
    public static final Path isabelle$vscode$Component_VSCodium$$$resources;
    private static final List build_env;
    private volatile Object symbols$lzy1;
    public static final Component_VSCodium$Build_Context$ Build_Context;
    private static final Isabelle_Tool isabelle_tool1;
    private static final Isabelle_Tool isabelle_tool2;
    public static final Component_VSCodium$ MODULE$;

    private Component_VSCodium$() {
    }

    static {
        MODULE$ = new Component_VSCodium$();
        linux_packages = (List)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"jq", "git", "python3", "gcc", "g++", "make", "pkg-config", "fakeroot", "curl", "libx11-dev", "libxkbfile-dev", "libsecret-1-dev", "libkrb5-dev", "libfontconfig1"}));
        windows_packages = (List)new .colon.colon((Object)"jq", (List)new .colon.colon((Object)"git", (List)new .colon.colon((Object)"p7zip", (List)new .colon.colon((Object)"mingw-w64-ucrt-x86_64-rustup", (List)Nil$.MODULE$))));
        macos_packages = (List)new .colon.colon((Object)"jq", (List)Nil$.MODULE$);
        default_node_version = Nodejs$.MODULE$.default_version();
        default_vscodium_version = "1.105.17075";
        vscodium_repository = "https://github.com/VSCodium/vscodium.git";
        vscodium_download = "https://github.com/VSCodium/vscodium/releases/download";
        isabelle$vscode$Component_VSCodium$$$resources = Path$.MODULE$.explode("resources");
        build_env = (List)new .colon.colon((Object)"VSCODE_QUALITY=stable", (List)new .colon.colon((Object)"VSCODE_LATEST=no", (List)new .colon.colon((Object)"CI_BUILD=no", (List)new .colon.colon((Object)"SKIP_ASSETS=yes", (List)new .colon.colon((Object)"SHOULD_BUILD=yes", (List)Nil$.MODULE$)))));
        isabelle_tool1 = Isabelle_Tool$.MODULE$.apply("component_vscodium", "build component for VSCodium", Scala_Project$.MODULE$.here(), (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)args -> {
            ObjectRef target_dir = ObjectRef.create((Object)Path$.MODULE$.current());
            BooleanRef intel = BooleanRef.create((boolean)false);
            ObjectRef mingw = ObjectRef.create((Object)MinGW$.MODULE$.none());
            ObjectRef node_version = ObjectRef.create((Object)this.default_node_version());
            ObjectRef vscodium_version = ObjectRef.create((Object)this.default_vscodium_version());
            ObjectRef node_root = ObjectRef.create((Object)None$.MODULE$);
            ObjectRef python_exe = ObjectRef.create((Object)None$.MODULE$);
            BooleanRef verbose = BooleanRef.create((boolean)false);
            Object[] objectArray = new Tuple2[8];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"D:");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)arg -> {
                target_dir$2.elem = Path$.MODULE$.explode((String)arg);
            });
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"I");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (JProcedure1 & Serializable)arg -> {
                intel$1.elem = true;
            });
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"M:");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (JProcedure1 & Serializable)arg -> {
                mingw$3.elem = MinGW$.MODULE$.apply(Path$.MODULE$.explode((String)arg));
            });
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"N:");
            objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (JProcedure1 & Serializable)arg -> {
                node_version$2.elem = arg;
                node_root$2.elem = None$.MODULE$;
            });
            String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"P:");
            objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (JProcedure1 & Serializable)arg -> {
                python_exe$2.elem = Some$.MODULE$.apply((Object)Path$.MODULE$.explode((String)arg));
            });
            String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"V:");
            objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (JProcedure1 & Serializable)arg -> {
                vscodium_version$2.elem = arg;
            });
            String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)"n:");
            objectArray[6] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (JProcedure1 & Serializable)arg -> {
                node_root$3.elem = Some$.MODULE$.apply((Object)Path$.MODULE$.explode((String)arg));
                node_version$3.elem = "";
            });
            String string8 = (String)Predef$.MODULE$.ArrowAssoc((Object)"v");
            objectArray[7] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string8, (JProcedure1 & Serializable)_$3 -> {
                verbose$1.elem = true;
            });
            Getopts getopts = Getopts$.MODULE$.apply((Function0<String>)((Function0 & Serializable)this::$anonfun$1), (scala.collection.immutable.Seq<Tuple2<String, Function1<String, BoxedUnit>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            List<String> more_args = getopts.apply((List<String>)args);
            if (more_args.nonEmpty()) {
                throw getopts.usage(getopts.usage$default$1());
            }
            Console_Progress progress = new Console_Progress(verbose.elem, Console_Progress$.MODULE$.$lessinit$greater$default$2(), Console_Progress$.MODULE$.$lessinit$greater$default$3(), Console_Progress$.MODULE$.$lessinit$greater$default$4());
            MinGW minGW = (MinGW)mingw.elem;
            boolean bl = !intel.elem;
            Isabelle_Platform isabelle_Platform = Isabelle_Platform$Context$.MODULE$.apply$default$1();
            Isabelle_Platform.Context platform_context = Isabelle_Platform$Context$.MODULE$.apply(isabelle_Platform, minGW, bl, progress);
            Path path = (Path)target_dir.elem;
            Option option = (Option)node_root.elem;
            String string9 = (String)node_version.elem;
            Option option2 = (Option)python_exe.elem;
            String string10 = (String)vscodium_version.elem;
            this.component_vscodium(path, (Option<Path>)option, string9, string10, (Option<Path>)option2, platform_context);
        });
        isabelle_tool2 = Isabelle_Tool$.MODULE$.apply("vscode_patch", "patch VSCode source tree", Scala_Project$.MODULE$.here(), (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)args -> {
            ObjectRef base_dir = ObjectRef.create((Object)Path$.MODULE$.current());
            ObjectRef mingw = ObjectRef.create((Object)MinGW$.MODULE$.none());
            BooleanRef verbose = BooleanRef.create((boolean)false);
            Object[] objectArray = new Tuple2[3];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"D:");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)arg -> {
                base_dir$1.elem = Path$.MODULE$.explode((String)arg);
            });
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"M:");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (JProcedure1 & Serializable)arg -> {
                mingw$4.elem = MinGW$.MODULE$.apply(Path$.MODULE$.explode((String)arg));
            });
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"v");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (JProcedure1 & Serializable)_$4 -> {
                verbose$2.elem = true;
            });
            Getopts getopts = Getopts$.MODULE$.apply((Function0<String>)((Function0 & Serializable)this::$anonfun$10), (scala.collection.immutable.Seq<Tuple2<String, Function1<String, BoxedUnit>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            List<String> more_args = getopts.apply((List<String>)args);
            if (more_args.nonEmpty()) {
                throw getopts.usage(getopts.usage$default$1());
            }
            Console_Progress progress = new Console_Progress(verbose.elem, Console_Progress$.MODULE$.$lessinit$greater$default$2(), Console_Progress$.MODULE$.$lessinit$greater$default$3(), Console_Progress$.MODULE$.$lessinit$greater$default$4());
            MinGW minGW = (MinGW)mingw.elem;
            Isabelle_Platform isabelle_Platform = Isabelle_Platform$Context$.MODULE$.apply$default$1();
            boolean bl = Isabelle_Platform$Context$.MODULE$.apply$default$3();
            Isabelle_Platform.Context platform_context = Isabelle_Platform$Context$.MODULE$.apply(isabelle_Platform, minGW, bl, progress);
            Component_VSCodium$Build_Context$.MODULE$.make(platform_context, Component_VSCodium$Build_Context$.MODULE$.make$default$2(), Component_VSCodium$Build_Context$.MODULE$.make$default$3(), Component_VSCodium$Build_Context$.MODULE$.make$default$4(), Component_VSCodium$Build_Context$.MODULE$.make$default$5()).patch_sources((Path)base_dir.elem);
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Component_VSCodium$.class);
    }

    public List<String> linux_packages() {
        return linux_packages;
    }

    public List<String> windows_packages() {
        return windows_packages;
    }

    public List<String> macos_packages() {
        return macos_packages;
    }

    public String default_node_version() {
        return default_node_version;
    }

    public String default_vscodium_version() {
        return default_vscodium_version;
    }

    public String vscodium_repository() {
        return vscodium_repository;
    }

    public String vscodium_download() {
        return vscodium_download;
    }

    public String vscode_arch(Isabelle_Platform.Context platform_context) {
        if (platform_context.is_arm()) {
            return "arm64";
        }
        return "x64";
    }

    public String vscode_os_name(Isabelle_Platform.Context platform_context) {
        if (platform_context.isabelle_platform().is_windows()) {
            return "windows";
        }
        if (platform_context.isabelle_platform().is_macos()) {
            return "osx";
        }
        return "linux";
    }

    public String vscode_platform_name(Isabelle_Platform.Context platform_context) {
        if (platform_context.isabelle_platform().is_windows()) {
            return "win32";
        }
        if (platform_context.isabelle_platform().is_macos()) {
            return "darwin";
        }
        return "linux";
    }

    public String vscode_platform(Isabelle_Platform.Context platform_context) {
        return this.vscode_platform_name(platform_context) + "-" + this.vscode_arch(platform_context);
    }

    public String isabelle$vscode$Component_VSCodium$$$read_patch(String name) {
        return File$.MODULE$.read(Path$.MODULE$.explode("$ISABELLE_VSCODE_HOME/patches").$plus(Path$.MODULE$.basic(name).patch()));
    }

    public List<String> build_env() {
        return build_env;
    }

    public List<String> build_upstream_env(Path dir) {
        String str = File$.MODULE$.read(dir.$plus(Path$.MODULE$.explode("upstream/stable.json")));
        Object json = JSON$.MODULE$.parse(str, JSON$.MODULE$.parse$default$2());
        return (List)JSON$.MODULE$.string(json, "tag").flatMap((Function1 & Serializable)tag -> JSON$.MODULE$.string(json, "commit").map((Function1 & Serializable)commit -> (List)new .colon.colon((Object)("MS_TAG=" + tag), (List)new .colon.colon((Object)("MS_COMMIT=" + commit), (List)Nil$.MODULE$)))).getOrElse(() -> Component_VSCodium$.build_upstream_env$$anonfun$2(str));
    }

    public Symbol.Symbols symbols() {
        Object object = this.symbols$lzy1;
        if (object instanceof Symbol.Symbols) {
            return (Symbol.Symbols)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Symbol.Symbols)this.symbols$lzyINIT1();
    }

    private Object symbols$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.symbols$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Symbol.Symbols symbols = null;
                    try {
                        symbols = Symbol$Symbols$.MODULE$.make(File$.MODULE$.read(Path$.MODULE$.explode("~~/etc/symbols")));
                        object2 = symbols == null ? LazyVals.NullValue$.MODULE$ : symbols;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.symbols$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return symbols;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Object symbol_entry(Symbol.Entry entry) {
        Object[] objectArray = new Tuple2[6];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"symbol");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)entry.symbol());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)entry.name());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"decoded");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)Symbol$.MODULE$.decode(entry.symbol()));
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"argument");
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)entry.argument().toString());
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"groups");
        objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, entry.groups());
        String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"abbrevs");
        objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, entry.abbrevs());
        return JSON$Object$.MODULE$.apply((scala.collection.immutable.Seq<Tuple2<String, Object>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).$plus$plus(JSON$.MODULE$.optional((Tuple2<String, Option<Object>>)Tuple2$.MODULE$.apply((Object)"code", entry.code())));
    }

    public File.Content make_symbols() {
        return File$.MODULE$.content(Path$.MODULE$.explode("symbols.json"), JSON$Format$.MODULE$.pretty_print(this.symbols().entries().map((Function1 & Serializable)entry -> MODULE$.symbol_entry((Symbol.Entry)entry)), JSON$Format$.MODULE$.pretty_print$default$2()));
    }

    public File.Content make_isabelle_encoding(String header) {
        String symbols_js = JSON$Format$.MODULE$.pretty_print(this.symbols().entries().flatMap((Function1 & Serializable)entry -> entry.code().map((Function1 & Serializable)code -> Component_VSCodium$.$anonfun$14$$anonfun$1(entry, BoxesRunTime.unboxToInt((Object)code)))), JSON$Format$.MODULE$.pretty_print$default$2());
        Path path = Path$.MODULE$.explode("isabelle_encoding.ts");
        String body = File$.MODULE$.read(Path$.MODULE$.explode("$ISABELLE_VSCODE_HOME/patches").$plus(path)).replace("[/*symbols*/]", symbols_js);
        return File$.MODULE$.content(path, header + "\n" + body);
    }

    private String file_checksum(Path path) {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        digest.update(Bytes$.MODULE$.read(path).make_array());
        return Bytes$.MODULE$.apply(Base64.getEncoder().encode(digest.digest())).text().replaceAll("=", "");
    }

    public String vscodium_patch(Component_VSCodium.Build_Context build_context) {
        Isabelle_Platform.Context platform_context = build_context.platform_context();
        Progress progress = build_context.progress();
        return (String)Isabelle_System$.MODULE$.with_tmp_dir("build", Isabelle_System$.MODULE$.with_tmp_dir$default$2(), (Function1 & Serializable)build_dir -> {
            build_context.get_vscodium_repository((Path)build_dir);
            Path vscode_dir = build_dir.$plus(Path$.MODULE$.explode("vscode"));
            Nodejs.Directory node_dir = build_context.node_setup((Path)build_dir);
            progress.echo("Preparing VSCode ...", progress.echo$default$2());
            return (String)Isabelle_System$.MODULE$.with_copy_dir(vscode_dir, vscode_dir.orig(), () -> Component_VSCodium$.vscodium_patch$$anonfun$1$$anonfun$1(platform_context, build_context, build_dir, node_dir, vscode_dir));
        });
    }

    public void component_vscodium(Path target_dir, Option<Path> node_root, String node_version, String vscodium_version, Option<Path> python_exe, Isabelle_Platform.Context platform_context) {
        Isabelle_Platform platform = platform_context.isabelle_platform();
        Progress progress = platform_context.progress();
        Component_VSCodium.Build_Context build_context = Component_VSCodium$Build_Context$.MODULE$.make(platform_context, node_root, node_version, vscodium_version, python_exe);
        platform_context.mingw().check();
        Isabelle_System$.MODULE$.require_command("patch", Isabelle_System$.MODULE$.require_command$default$2());
        if (!platform.is_windows()) {
            Isabelle_System$.MODULE$.require_command("git", Isabelle_System$.MODULE$.require_command$default$2());
            Isabelle_System$.MODULE$.require_command("jq", Isabelle_System$.MODULE$.require_command$default$2());
            Isabelle_System$.MODULE$.require_command("rustup", Isabelle_System$.MODULE$.require_command$default$2());
        }
        String component_name = "vscodium-" + vscodium_version;
        Components.Directory directory = Components$Directory$.MODULE$.apply(target_dir.$plus(Path$.MODULE$.explode(component_name)), Components$Directory$.MODULE$.apply$default$2());
        Components.Directory component_dir = directory.create(progress, directory.create$default$2());
        progress.echo("\n* Building patches:", progress.echo$default$2());
        Path patches_dir = Isabelle_System$.MODULE$.new_directory(component_dir.path().$plus(Path$.MODULE$.explode("patches")));
        this.write_patch$1(patches_dir, "01-vscodium", this.vscodium_patch(build_context));
        Isabelle_System$.MODULE$.with_tmp_dir("build", Isabelle_System$.MODULE$.with_tmp_dir$default$2(), (JProcedure1 & Serializable)build_dir -> {
            progress.echo("\n* Building VSCodium for " + build_context.platform_name() + ":", progress.echo$default$2());
            build_context.get_vscodium_repository((Path)build_dir);
            String string = this.isabelle$vscode$Component_VSCodium$$$read_patch("vscodium");
            int n = Isabelle_System$.MODULE$.apply_patch$default$3();
            Isabelle_System$.MODULE$.apply_patch((Path)build_dir, string, n, progress);
            String sources_patch = build_context.patch_sources((Path)build_dir);
            this.write_patch$1(patches_dir, "02-isabelle_sources", sources_patch);
            Nodejs.Directory node_dir = build_context.node_setup((Path)build_dir);
            progress.echo("Installing rust ...", progress.echo$default$2());
            platform_context.bash("rustup toolchain install stable", (Path)build_dir, platform_context.bash$default$3()).check();
            if (platform.is_macos() && !platform_context.apple()) {
                platform_context.bash("rustup target add x86_64-apple-darwin", (Path)build_dir, platform_context.bash$default$3()).check();
            }
            progress.echo("Building VSCodium ...", progress.echo$default$2());
            String environment = build_context.environment((Path)build_dir);
            progress.echo(environment, true);
            platform_context.bash(node_dir.path_setup() + "\n" + environment + "./build.sh", (Path)build_dir, build_context.settings()).check();
            Isabelle_System$.MODULE$.copy_file(build_dir.$plus(Path$.MODULE$.explode("LICENSE")), component_dir.path());
            Path platform_dir = build_context.platform_dir(component_dir.path());
            Isabelle_System$.MODULE$.copy_dir(build_context.build_dir((Path)build_dir), platform_dir, Isabelle_System$.MODULE$.copy_dir$default$3());
            if (platform.is_macos()) {
                Isabelle_System$.MODULE$.symlink(Path$.MODULE$.explode("VSCodium.app/Contents/Resources"), platform_dir.$plus(isabelle$vscode$Component_VSCodium$$$resources), Isabelle_System$.MODULE$.symlink$default$3(), Isabelle_System$.MODULE$.symlink$default$4());
            }
            build_context.setup_electron(platform_dir);
            String resources_patch = build_context.patch_resources(platform_dir);
            this.write_patch$1(patches_dir, "03-isabelle_resources", resources_patch);
            Path electron_resources = Path$.MODULE$.explode("vscode/node_modules/electron/dist").$plus(platform.is_macos() ? Path$.MODULE$.explode("Electron.app/Contents/Resources") : isabelle$vscode$Component_VSCodium$$$resources);
            Isabelle_System$.MODULE$.copy_file(build_dir.$plus(electron_resources).$plus(Path$.MODULE$.explode("default_app.asar")), platform_dir.$plus(isabelle$vscode$Component_VSCodium$$$resources));
            build_context.setup_executables(platform_dir);
        });
        Isabelle_System$.MODULE$.bash("gzip *.patch", Isabelle_System$.MODULE$.bash$default$2(), Isabelle_System$.MODULE$.bash$default$3(), patches_dir, Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), Isabelle_System$.MODULE$.bash$default$8(), Isabelle_System$.MODULE$.bash$default$9(), Isabelle_System$.MODULE$.bash$default$10(), Isabelle_System$.MODULE$.bash$default$11(), Isabelle_System$.MODULE$.bash$default$12()).check();
        component_dir.write_settings("\nISABELLE_VSCODIUM_HOME=\"$COMPONENT/${ISABELLE_WINDOWS_PLATFORM64:-${ISABELLE_APPLE_PLATFORM64:-$ISABELLE_PLATFORM64}}\"\n\ncase \"$ISABELLE_PLATFORM_FAMILY\" in\n  \"macos\"*)\n    ISABELLE_VSCODIUM_ELECTRON=\"$ISABELLE_VSCODIUM_HOME/VSCodium.app/Contents/MacOS/Electron\"\n    ISABELLE_VSCODIUM_RESOURCES=\"$ISABELLE_VSCODIUM_HOME/VSCodium.app/Contents/Resources\"\n    ;;\n  *)\n    ISABELLE_VSCODIUM_ELECTRON=\"$ISABELLE_VSCODIUM_HOME/electron\"\n    ISABELLE_VSCODIUM_RESOURCES=\"$ISABELLE_VSCODIUM_HOME/resources\"\n    ;;\nesac\n");
        File$.MODULE$.write(component_dir.README(), "This is VSCodium " + vscodium_version + " from " + this.vscodium_repository() + "\n\nIt has been built from sources using \"isabelle component_vscodium\". This applies\na few changes required for Isabelle/VSCode, see \"patches\" directory for a\nformal record. Typical build commands for special platforms are as follows.\n\n* x86_64-darwin on Apple Silicon hardware:\n\n    isabelle component_vscodium -I\n\n* x86_64-windows with Cygwin-Terminal, using prerequisites in typical locations:\n\n    isabelle component_vscodium -M \"/cygdrive/c/msys64\" -P /cygdrive/c/Python313/python.exe\n\n\n        Makarius\n        " + Date$Format$.MODULE$.date().apply(Date$.MODULE$.now(Date$.MODULE$.now$default$1())) + "\n");
    }

    public Path component_vscodium$default$1() {
        return Path$.MODULE$.current();
    }

    public Option<Path> component_vscodium$default$2() {
        return None$.MODULE$;
    }

    public String component_vscodium$default$3() {
        return this.default_node_version();
    }

    public String component_vscodium$default$4() {
        return this.default_vscodium_version();
    }

    public Option<Path> component_vscodium$default$5() {
        return None$.MODULE$;
    }

    public Isabelle_Platform.Context component_vscodium$default$6() {
        return Isabelle_Platform$Context$.MODULE$.apply(Isabelle_Platform$Context$.MODULE$.apply$default$1(), Isabelle_Platform$Context$.MODULE$.apply$default$2(), Isabelle_Platform$Context$.MODULE$.apply$default$3(), Isabelle_Platform$Context$.MODULE$.apply$default$4());
    }

    public Isabelle_Tool isabelle_tool1() {
        return isabelle_tool1;
    }

    public Isabelle_Tool isabelle_tool2() {
        return isabelle_tool2;
    }

    private final String $anonfun$1() {
        return "\nUsage: component_vscodium [OPTIONS]\n\n  Options are:\n    -D DIR       target directory (default \".\")\n    -I           force Intel platform on Apple Silicon\n    -M DIR       msys/mingw root specification for Windows\n    -N VERSION   download Node.js version (overrides option -n)\n                 (default: \"" + this.default_node_version() + "\")\n    -P FILE      Python executable (default: educated guess by node-gyp)\n    -V VERSION   VSCodium version (default: \"" + this.default_vscodium_version() + "\")\n    -n DIR       use existing Node.js directory (overrides option -N)\n    -v           verbose\n\n  Build VSCodium from sources and turn it into an Isabelle component.\n\n  Linux prerequisites:\n    - Ubuntu 20.04 LTS\n    - rustup: see https://www.rust-lang.org/tools/install\n    - apt packages:\n      sudo apt install -y " + this.linux_packages().mkString(" ") + "\n\n  Windows prerequisites:\n    - install Visual Studio 2022\n        + see https://visualstudio.microsoft.com/downloads\n        + Desktop development with C++\n        + x64/x86 C++ spectre mitigated libs\n    - install Python 3.x\n        + see https://www.python.org/downloads/windows\n        + Download Windows installer (64-bit)\n        + Customize installation: [X] for all users\n        + [X] Install Python for all users\n    - MSYS2/UCRT64: see https://www.msys2.org\n    - MSYS2 packages:\n      pacman -Su\n      pacman -S --needed --noconfirm " + this.windows_packages().mkString(" ") + "\n\n  macOS prerequisites:\n    - macOS 13 Ventura\n    - rustup: see https://www.rust-lang.org/tools/install\n    - Homebrew package manager: see https://brew.sh\n    - Homebrew packages:\n      brew install " + this.macos_packages().mkString(" ") + "\n";
    }

    private final String $anonfun$10() {
        return "\nUsage: vscode_patch [OPTIONS]\n\n  Options are:\n    -D DIR       base directory (default \".\")\n    -M DIR       msys/mingw root specification for Windows\n    -v           verbose\n\n  Patch original VSCode source tree for use with Isabelle/VSCode.\n";
    }

    private static final List build_upstream_env$$anonfun$2(String str$1) {
        return (List)package$.MODULE$.error().apply((Object)("Malformed upstream information:\n" + str$1));
    }

    private static final /* synthetic */ Map $anonfun$14$$anonfun$1(Symbol.Entry entry$1, int code) {
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"symbol");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)entry$1.symbol());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"code");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BoxesRunTime.boxToInteger((int)code));
        return JSON$Object$.MODULE$.apply((scala.collection.immutable.Seq<Tuple2<String, Object>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public static final /* synthetic */ boolean isabelle$vscode$Component_VSCodium$Build_Context$$_$_$$anonfun$15(String _$1) {
        return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$1.trim()));
    }

    public static final String isabelle$vscode$Component_VSCodium$Build_Context$$_$_$$anonfun$16(Path dir$4) {
        Path path = dir$4.$plus(Path$.MODULE$.explode("app/extensions/theme-seti/icons/vs-seti-icon-theme.json"));
        boolean bl = File$.MODULE$.change$default$2();
        File$.MODULE$.change(path, bl, true, (Function1<String, String>)(Function1 & Serializable)s -> s.replace("\"ml\":\"_ocaml\",\"mli\":\"_ocaml\",", "").replace("\"ml\":\"_ocaml_light\",\"mli\":\"_ocaml_light\",", ""));
        Path fonts_dir = dir$4.$plus(Path$.MODULE$.explode("app/out/vs/base/browser/ui/fonts"));
        HTML$.MODULE$.init_fonts(fonts_dir.dir());
        File.Content content = MODULE$.make_symbols();
        content.write(fonts_dir, content.write$default$2());
        Path workbench_css = dir$4.$plus(Path$.MODULE$.explode("app/out/vs/workbench/workbench.desktop.main.css"));
        String checksum1 = MODULE$.file_checksum(workbench_css);
        File$.MODULE$.append(workbench_css, "\n\n" + HTML$.MODULE$.fonts_css_dir("../base/browser/ui"));
        String checksum2 = MODULE$.file_checksum(workbench_css);
        String file_name = workbench_css.file_name();
        File$.MODULE$.change_lines(dir$4.$plus(Path$.MODULE$.explode("app/product.json")), File$.MODULE$.change_lines$default$2(), File$.MODULE$.change_lines$default$3(), (Function1<List<String>, List<String>>)(Function1 & Serializable)_$2 -> _$2.map((Function1 & Serializable)line -> {
            if (Predef$.MODULE$.wrapString(line).containsSlice((Seq)Predef$.MODULE$.wrapString(file_name)) && line.contains(checksum1)) {
                return line.replace(checksum1, checksum2);
            }
            return line;
        }));
        return Isabelle_System$.MODULE$.make_patch(dir$4.dir(), dir$4.orig().base(), dir$4.base(), Isabelle_System$.MODULE$.make_patch$default$4());
    }

    public static final /* synthetic */ boolean isabelle$vscode$Component_VSCodium$Build_Context$$_$_$$anonfun$17(File file) {
        String name = file.getName();
        return File$.MODULE$.is_dll(name) || File$.MODULE$.is_exe(name) || File$.MODULE$.is_node(name);
    }

    public static final /* synthetic */ void isabelle$vscode$Component_VSCodium$Build_Context$$_$setup_executables$$anonfun$1(File file) {
        File$.MODULE$.set_executable(File$.MODULE$.path(file), File$.MODULE$.set_executable$default$2());
    }

    public static final String isabelle$vscode$Component_VSCodium$Build_Context$$$_$_$$anonfun$18() {
        return MODULE$.default_node_version();
    }

    private static final String vscodium_patch$$anonfun$1$$anonfun$1(Isabelle_Platform.Context platform_context$2, Component_VSCodium.Build_Context build_context$2, Path build_dir$1, Nodejs.Directory node_dir$1, Path vscode_dir$1) {
        platform_context$2.bash(Library$.MODULE$.make_lines((scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"set -e", build_context$2.environment(build_dir$1), node_dir$1.path_setup(), "./prepare_vscode.sh", "cp vscode/resources/linux/code.png vscode/resources/linux/rpm/code.xpm"})), build_dir$1, build_context$2.settings()).check();
        return Isabelle_System$.MODULE$.make_patch(build_dir$1, vscode_dir$1.orig().base(), vscode_dir$1.base(), "--exclude=.git --exclude=node_modules");
    }

    private final void write_patch$1(Path patches_dir$1, String name, String patch) {
        File$.MODULE$.write(patches_dir$1.$plus(Path$.MODULE$.explode(name).patch()), patch);
    }
}

