/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Bash$;
import isabelle.Bash$Server$;
import isabelle.Bash$Watchdog$;
import isabelle.Bytes;
import isabelle.Document;
import isabelle.Exn;
import isabelle.Exn$;
import isabelle.Exn$Exn$;
import isabelle.Exn$Interrupt$;
import isabelle.Exn$Res$;
import isabelle.File$;
import isabelle.Future;
import isabelle.Future$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Thread$;
import isabelle.Library$;
import isabelle.Options;
import isabelle.Output$;
import isabelle.Path;
import isabelle.Platform$;
import isabelle.Process_Result;
import isabelle.Process_Result$;
import isabelle.Process_Result$RC$;
import isabelle.SSH;
import isabelle.Server;
import isabelle.Session;
import isabelle.Synchronized;
import isabelle.Synchronized$;
import isabelle.Time;
import isabelle.Time$;
import isabelle.Timing;
import isabelle.Timing$;
import isabelle.UTF8$;
import isabelle.UUID$;
import isabelle.Value$Boolean$;
import isabelle.Value$Long$;
import isabelle.Value$Seconds$;
import isabelle.Word$;
import isabelle.package$;
import isabelle.setup.Environment;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.MapFactoryDefaults;
import scala.collection.MapOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileBooleanRef;
import scala.runtime.function.JProcedure1;

public final class Bash {
    public static String context(String string, String string2, String string3, Path path) {
        return Bash$.MODULE$.context(string, string2, string3, path);
    }

    public static String exports(Seq<String> seq) {
        return Bash$.MODULE$.exports(seq);
    }

    public static String local_bash() {
        return Bash$.MODULE$.local_bash();
    }

    public static String local_bash_process() {
        return Bash$.MODULE$.local_bash_process();
    }

    public static Process process(String string, String string2, SSH.System system, Path path, Map<String, String> map, boolean bl, Function0<BoxedUnit> function0) {
        return Bash$.MODULE$.process(string, string2, system, path, map, bl, function0);
    }

    public static String remote_bash_process(SSH.Session session) {
        return Bash$.MODULE$.remote_bash_process(session);
    }

    public static String string(String string) {
        return Bash$.MODULE$.string(string);
    }

    public static String strings(Iterable<String> iterable) {
        return Bash$.MODULE$.strings(iterable);
    }

    public static String context$default$2() {
        return Bash$.MODULE$.context$default$2();
    }

    public static String process$default$2() {
        return Bash$.MODULE$.process$default$2();
    }

    public static String context$default$3() {
        return Bash$.MODULE$.context$default$3();
    }

    public static SSH.System process$default$3() {
        return Bash$.MODULE$.process$default$3();
    }

    public static Path context$default$4() {
        return Bash$.MODULE$.context$default$4();
    }

    public static Path process$default$4() {
        return Bash$.MODULE$.process$default$4();
    }

    public static Map<String, String> process$default$5() {
        return Bash$.MODULE$.process$default$5();
    }

    public static boolean process$default$6() {
        return Bash$.MODULE$.process$default$6();
    }

    public static Function0<BoxedUnit> process$default$7() {
        return Bash$.MODULE$.process$default$7();
    }

    public static class Handler
    extends Session.Protocol_Handler {
        private Server server = null;

        @Override
        public void init(Session session) {
            this.exit();
            int n = Bash$Server$.MODULE$.start$default$1();
            this.server = Bash$Server$.MODULE$.start(n, (Function0<Object>)((Function0 & Serializable)() -> this.init$$anonfun$1(session)));
        }

        public void exit() {
            if (this.server != null) {
                this.server.stop();
                this.server = null;
                return;
            }
        }

        @Override
        public void exit(Document.State exit_state) {
            this.exit();
        }

        @Override
        public Options prover_options(Options options) {
            String address = this.server == null ? "" : this.server.address();
            String password = this.server == null ? "" : this.server.password();
            return options.$plus("bash_process_address=" + address).$plus("bash_process_password=" + password);
        }

        private final boolean debugging$1$1(Session session$1) {
            return BoxesRunTime.unboxToBoolean((Object)session$1.session_options().bool().apply("bash_process_debugging"));
        }

        private final boolean init$$anonfun$1(Session session$2) {
            return this.debugging$1$1(session$2);
        }
    }

    public static class Process {
        private final String description;
        private final SSH.System ssh;
        private final Function0<BoxedUnit> cleanup;
        private final Option<File> winpid_file;
        private final Path timing_file;
        private final Path script_file;
        private final Synchronized<Option<Timing>> timing;
        private final Option<File> ssh_file;
        private final java.lang.Process proc;
        private final BufferedWriter stdin;
        private final BufferedReader stdout;
        private final BufferedReader stderr;
        private final String group_pid;
        private final Thread shutdown_hook;

        public Process(String script, String description, SSH.System ssh, Path cwd, Map<String, String> env, boolean redirect, Function0<BoxedUnit> cleanup) {
            None$ none$;
            SeqOps seqOps;
            Object object;
            this.description = description;
            this.ssh = ssh;
            this.cleanup = cleanup;
            LinkedList<String> proc_command = new LinkedList<String>();
            this.winpid_file = ssh.is_local() && Platform$.MODULE$.is_windows() ? Some$.MODULE$.apply((Object)Isabelle_System$.MODULE$.tmp_file("bash_winpid", Isabelle_System$.MODULE$.tmp_file$default$2(), Isabelle_System$.MODULE$.tmp_file$default$3(), Isabelle_System$.MODULE$.tmp_file$default$4())) : None$.MODULE$;
            Option<File> option = this.winpid_file;
            if (None$.MODULE$.equals(option)) {
                object = "";
            } else if (option instanceof Some) {
                File file = (File)((Some)option).value();
                object = "read < /proc/self/winpid > /dev/null 2> /dev/null\necho -n \"$REPLY\" > " + File$.MODULE$.bash_path(file) + "\n\n";
            } else {
                throw new MatchError(option);
            }
            String winpid_script = object;
            List<Path> list = ssh.tmp_files((List<String>)((List)new .colon.colon((Object)"bash_timing", (List)new .colon.colon((Object)"bash_script", (List)Nil$.MODULE$))));
            if (list == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = scala.package$.MODULE$.List().unapplySeq(list), 2) != 0) {
                throw new MatchError(list);
            }
            Path path = (Path)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
            Path path2 = (Path)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 1);
            Path timing_file = path;
            Path script_file = path2;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)timing_file, (Object)script_file);
            this.timing_file = (Path)tuple2._1();
            this.script_file = (Path)tuple2._2();
            this.timing = Synchronized$.MODULE$.apply(None$.MODULE$);
            ssh.write(this.script_file, (String)(ssh.is_local() ? winpid_script + script : Bash$.MODULE$.context(script, Bash$.MODULE$.context$default$2(), Bash$.MODULE$.context$default$3(), cwd)));
            Option<SSH.Session> option2 = ssh.ssh_session();
            if (None$.MODULE$.equals(option2)) {
                proc_command.add(Bash$.MODULE$.local_bash_process());
                proc_command.add(File$.MODULE$.platform_path(this.timing_file));
                proc_command.add("bash");
                proc_command.add(File$.MODULE$.platform_path(this.script_file));
                none$ = None$.MODULE$;
            } else if (option2 instanceof Some) {
                SSH.Session ssh_session = (SSH.Session)((Some)option2).value();
                String ssh_script = "exec " + Bash$.MODULE$.remote_bash_process(ssh_session) + " " + ssh.bash_path(this.timing_file) + " bash " + ssh.bash_path(this.script_file);
                File file = Isabelle_System$.MODULE$.tmp_file("bash_ssh", Isabelle_System$.MODULE$.tmp_file$default$2(), Isabelle_System$.MODULE$.tmp_file$default$3(), Isabelle_System$.MODULE$.tmp_file$default$4());
                File$.MODULE$.write(file, ssh_script);
                proc_command.add(Bash$.MODULE$.local_bash());
                proc_command.add(file.getPath());
                none$ = Some$.MODULE$.apply((Object)file);
            } else {
                throw new MatchError(option2);
            }
            this.ssh_file = none$;
            this.proc = Environment.process_builder(proc_command, !ssh.is_local() || cwd == null || cwd.is_current() ? null : cwd.file(), env, (boolean)redirect).start();
            this.stdin = new BufferedWriter(new OutputStreamWriter(this.proc.getOutputStream(), UTF8$.MODULE$.charset()));
            this.stdout = new BufferedReader(new InputStreamReader(this.proc.getInputStream(), UTF8$.MODULE$.charset()));
            this.stderr = new BufferedReader(new InputStreamReader(this.proc.getErrorStream(), UTF8$.MODULE$.charset()));
            this.group_pid = this.stdout().readLine();
            this.shutdown_hook = Isabelle_System$.MODULE$.create_shutdown_hook((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.$init$$$anonfun$1();
                return BoxedUnit.UNIT;
            });
        }

        public String toString() {
            return Bash$.MODULE$.isabelle$Bash$$$make_description(this.description);
        }

        public Timing get_timing() {
            return (Timing)this.timing.value().getOrElse(Bash$::isabelle$Bash$Process$$_$get_timing$$anonfun$1);
        }

        public BufferedWriter stdin() {
            return this.stdin;
        }

        public BufferedReader stdout() {
            return this.stdout;
        }

        public BufferedReader stderr() {
            return this.stderr;
        }

        private boolean local_process_alive(String pid) {
            return this.ssh.is_local() && BoxesRunTime.unboxToBoolean((Object)Value$Long$.MODULE$.unapply(pid).flatMap(Bash$::isabelle$Bash$Process$$_$local_process_alive$$anonfun$adapted$1).getOrElse(Bash$::isabelle$Bash$Process$$_$local_process_alive$$anonfun$2));
        }

        private boolean root_process_alive() {
            Option<File> option = this.winpid_file;
            if (None$.MODULE$.equals(option)) {
                return this.local_process_alive(this.group_pid);
            }
            if (option instanceof Some) {
                File file = (File)((Some)option).value();
                return file.exists() && this.local_process_alive(Library$.MODULE$.trim_line(File$.MODULE$.read(file)));
            }
            throw new MatchError(option);
        }

        private boolean signal(String s, int count) {
            boolean bl;
            block3: {
                block2: {
                    while (count > 0) {
                        boolean running;
                        this.ssh.kill_process(this.group_pid, s);
                        boolean bl2 = running = this.root_process_alive() || this.ssh.kill_process(this.group_pid, "0");
                        if (running) {
                            Time$.MODULE$.sleep$extension(Time$.MODULE$.seconds(this.ssh.is_local() ? 0.1 : 0.25));
                            --count;
                            continue;
                        }
                        if (!false) break block2;
                    }
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            return bl;
        }

        private int signal$default$2() {
            return 1;
        }

        public void terminate() {
            Isabelle_Thread$.MODULE$.try_uninterruptible((Function0 & Serializable)() -> {
                this.terminate$$anonfun$1();
                return BoxedUnit.UNIT;
            });
        }

        public void interrupt() {
            Isabelle_Thread$.MODULE$.try_uninterruptible(this::interrupt$$anonfun$1);
        }

        private void do_cleanup() {
            Isabelle_System$.MODULE$.remove_shutdown_hook(this.shutdown_hook);
            this.winpid_file.foreach(Bash$::isabelle$Bash$Process$$_$do_cleanup$$anonfun$1);
            this.ssh_file.foreach(Bash$::isabelle$Bash$Process$$_$do_cleanup$$anonfun$2);
            this.timing.change((Function1<Option<Timing>, Option<Timing>>)((Function1 & Serializable)this::do_cleanup$$anonfun$3));
            this.ssh.delete((Seq<Path>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Path[]{this.timing_file, this.script_file}));
            this.cleanup.apply$mcV$sp();
        }

        public int join() {
            int rc = this.proc.waitFor();
            this.do_cleanup();
            return rc;
        }

        public Process_Result result(String input, Function1<String, BoxedUnit> progress_stdout, Function1<String, BoxedUnit> progress_stderr, Watchdog watchdog, boolean strict) {
            int n;
            Future<Object> future;
            if (input.isEmpty()) {
                this.stdin().close();
                future = Future$.MODULE$.value(BoxedUnit.UNIT);
            } else {
                future = Future$.MODULE$.thread("bash_stdin", Future$.MODULE$.thread$default$2(), Future$.MODULE$.thread$default$3(), Future$.MODULE$.thread$default$4(), Future$.MODULE$.thread$default$5(), Future$.MODULE$.thread$default$6(), (Function0 & Serializable)() -> {
                    this.$anonfun$1(input);
                    return BoxedUnit.UNIT;
                });
            }
            Future<BoxedUnit> in = future;
            Future out_lines = Future$.MODULE$.thread("bash_stdout", Future$.MODULE$.thread$default$2(), Future$.MODULE$.thread$default$3(), Future$.MODULE$.thread$default$4(), Future$.MODULE$.thread$default$5(), Future$.MODULE$.thread$default$6(), () -> this.$anonfun$2(progress_stdout));
            Future err_lines = Future$.MODULE$.thread("bash_stderr", Future$.MODULE$.thread$default$2(), Future$.MODULE$.thread$default$3(), Future$.MODULE$.thread$default$4(), Future$.MODULE$.thread$default$5(), Future$.MODULE$.thread$default$6(), () -> this.$anonfun$3(progress_stderr));
            None$ watchdog_thread = watchdog.defined() ? Some$.MODULE$.apply(Future$.MODULE$.thread("bash_watchdog", Future$.MODULE$.thread$default$2(), Future$.MODULE$.thread$default$3(), Future$.MODULE$.thread$default$4(), Future$.MODULE$.thread$default$5(), Future$.MODULE$.thread$default$6(), (Function0 & Serializable)() -> {
                this.$anonfun$4(watchdog);
                return BoxedUnit.UNIT;
            })) : None$.MODULE$;
            try {
                n = this.join();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 != null && Exn$Interrupt$.MODULE$.unapply(throwable2)) {
                    this.terminate();
                    n = Process_Result$RC$.MODULE$.interrupt();
                }
                throw throwable;
            }
            int rc = n;
            watchdog_thread.foreach((Function1)((JProcedure1 & Serializable)Bash$::isabelle$Bash$Process$$_$result$$anonfun$1));
            in.join();
            out_lines.join();
            err_lines.join();
            if (strict && rc == Process_Result$RC$.MODULE$.interrupt()) {
                throw Exn$Interrupt$.MODULE$.apply();
            }
            return Process_Result$.MODULE$.apply(rc, (List<String>)((List)out_lines.join()), (List<String>)((List)err_lines.join()), this.get_timing());
        }

        public String result$default$1() {
            return "";
        }

        public Function1<String, BoxedUnit> result$default$2() {
            return Bash$::isabelle$Bash$Process$$_$result$default$2$$anonfun$1;
        }

        public Function1<String, BoxedUnit> result$default$3() {
            return Bash$::isabelle$Bash$Process$$_$result$default$3$$anonfun$1;
        }

        public Watchdog result$default$4() {
            return Bash$Watchdog$.MODULE$.none();
        }

        public boolean result$default$5() {
            return true;
        }

        private final void $init$$$anonfun$1() {
            this.terminate();
        }

        private final void terminate$$anonfun$1() {
            boolean bl = this.signal("INT", 7) && this.signal("TERM", 3) && this.signal("KILL", this.signal$default$2());
            this.proc.destroy();
            this.do_cleanup();
        }

        private final boolean interrupt$$anonfun$1() {
            return this.ssh.kill_process(this.group_pid, "INT");
        }

        /*
         * Unable to fully structure code
         */
        private final /* synthetic */ Option do_cleanup$$anonfun$3(Option x$1) {
            block5: {
                var2_2 = x$1;
                if (!None$.MODULE$.equals(var2_2)) break block5;
                try {
                    v0 = this.ssh.read(this.timing_file);
                }
                catch (Throwable var4_3) {
                    var5_4 = var4_3;
                    if (var5_4 != null && !(var6_5 = package$.MODULE$.ERROR().unapply(var5_4)).isEmpty()) {
                        var7_6 = (String)var6_5.get();
                        v0 = "";
                    }
                    throw var4_3;
                }
                timing_text = v0;
                var9_8 = Word$.MODULE$.explode(timing_text);
                if (var9_8 == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(var10_9 = scala.package$.MODULE$.List().unapplySeq(var9_8), 2) != 0) ** GOTO lbl-1000
                var11_10 = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(var10_9, 0);
                var12_11 = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(var10_9, 1);
                if (var11_10 == null || (var13_12 = Value$Long$.MODULE$.unapply(var11_10)).isEmpty()) ** GOTO lbl-1000
                elapsed = var14_13 = BoxesRunTime.unboxToLong((Object)var13_12.get());
                if (var12_11 != null && !(var18_15 = Value$Long$.MODULE$.unapply(var12_11)).isEmpty()) {
                    cpu = var19_16 = BoxesRunTime.unboxToLong((Object)var18_15.get());
                    v1 = Timing$.MODULE$.make(Time$.MODULE$.ms(elapsed), Time$.MODULE$.ms(cpu), Time$.MODULE$.zero());
                } else lbl-1000:
                // 3 sources

                {
                    v1 = Timing$.MODULE$.zero();
                }
                t = v1;
                return Some$.MODULE$.apply((Object)t);
            }
            some = var2_2;
            return some;
        }

        private final void $anonfun$1(String input$1) {
            this.stdin().write(input$1);
            this.stdin().flush();
            this.stdin().close();
        }

        private final List $anonfun$2(Function1 progress_stdout$1) {
            return File$.MODULE$.read_lines(this.stdout(), (Function1<String, BoxedUnit>)progress_stdout$1);
        }

        private final List $anonfun$3(Function1 progress_stderr$1) {
            return File$.MODULE$.read_lines(this.stderr(), (Function1<String, BoxedUnit>)progress_stderr$1);
        }

        private final void $anonfun$4(Watchdog watchdog$1) {
            while (this.proc.isAlive()) {
                Time$.MODULE$.sleep$extension(watchdog$1.time());
                if (!BoxesRunTime.unboxToBoolean((Object)watchdog$1.check().apply((Object)this))) continue;
                this.interrupt();
            }
        }
    }

    public static class Server
    extends Server.Handler {
        private final Function0<Object> debugging;
        private final Synchronized<scala.collection.immutable.Map<UUID, Process>> _processes;

        public static List<String> result(Process_Result process_Result) {
            return Bash$Server$.MODULE$.result(process_Result);
        }

        public static int start$default$1() {
            return Bash$Server$.MODULE$.start$default$1();
        }

        public static boolean start$default$2() {
            return Bash$Server$.MODULE$.start$default$2();
        }

        public Server(int port, Function0<Object> debugging) {
            this.debugging = debugging;
            super(port);
            this._processes = Synchronized$.MODULE$.apply(Predef$.MODULE$.Map().empty());
        }

        @Override
        public void stop() {
            ((MapFactoryDefaults)this._processes.value()).withFilter(Bash$::isabelle$Bash$Server$$_$stop$$anonfun$1).foreach((Function1)((JProcedure1 & Serializable)Bash$::isabelle$Bash$Server$$_$stop$$anonfun$2));
            super.stop();
        }

        @Override
        public void handle(Server.Connection connection) {
            Option option = connection.read_byte_message().map(Bash$::isabelle$Bash$Server$$_$handle$$anonfun$1);
            if (None$.MODULE$.equals(option)) {
                return;
            }
            if (option instanceof Some) {
                List list = (List)((Some)option).value();
                if (list != null) {
                    SeqOps seqOps = scala.package$.MODULE$.List().unapplySeq((SeqOps)list);
                    if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps, 2) == 0) {
                        String string = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                        String string2 = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 1);
                        String string3 = Bash$Server$.isabelle$Bash$Server$$$KILL;
                        String string4 = string;
                        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                            Option<UUID> option2;
                            if (string2 != null && !(option2 = UUID$.MODULE$.unapply(string2)).isEmpty()) {
                                UUID uUID;
                                UUID uuid = uUID = (UUID)option2.get();
                                if (this.debugging.apply$mcZ$sp()) {
                                    Output$.MODULE$.writeln("kill " + uuid, Output$.MODULE$.writeln$default$2(), Output$.MODULE$.writeln$default$3());
                                }
                                ((MapOps)this._processes.value()).get((Object)uuid).foreach((Function1)((JProcedure1 & Serializable)Bash$::isabelle$Bash$Server$$_$handle$$anonfun$2));
                                return;
                            }
                        }
                    }
                    if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps, 8) == 0) {
                        String string = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                        String string5 = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 1);
                        String string6 = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 2);
                        String string7 = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 3);
                        String string8 = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 4);
                        String string9 = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 5);
                        String string10 = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 6);
                        String string11 = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 7);
                        String string12 = Bash$Server$.isabelle$Bash$Server$$$RUN;
                        String string13 = string;
                        if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                            Option<Object> option3;
                            String script = string5;
                            String input = string6;
                            String cwd = string7;
                            String putenv = string8;
                            if (string9 != null && !(option3 = Value$Boolean$.MODULE$.unapply(string9)).isEmpty()) {
                                Option<Time> option4;
                                boolean bl;
                                boolean redirect = bl = BoxesRunTime.unboxToBoolean((Object)option3.get());
                                if (string10 != null && !(option4 = Value$Seconds$.MODULE$.unapply(string10)).isEmpty()) {
                                    Exn.Result result;
                                    long l;
                                    Object object = option4.get();
                                    long timeout = l = object == null ? BoxesRunTime.unboxToLong(null) : ((Time)object).ms();
                                    String description = string11;
                                    UUID uuid = UUID$.MODULE$.random();
                                    String descr = Bash$.MODULE$.isabelle$Bash$$$make_description(description);
                                    if (this.debugging.apply$mcZ$sp()) {
                                        Output$.MODULE$.writeln("start " + package$.MODULE$.quote().apply((Object)descr) + " (uuid=" + uuid + ", timeout=" + Time$.MODULE$.seconds$extension(timeout) + ")", Output$.MODULE$.writeln$default$2(), Output$.MODULE$.writeln$default$3());
                                    }
                                    if ((result = Exn$.MODULE$.capture(() -> Bash$.isabelle$Bash$Server$$_$handle$$anonfun$3(cwd, putenv, script, description, redirect))) instanceof Exn.Exn) {
                                        Throwable throwable;
                                        Exn.Exn exn = Exn$Exn$.MODULE$.unapply((Exn.Exn)result);
                                        Throwable exn2 = throwable = exn._1();
                                        this.reply_failure$1(connection, exn2);
                                        return;
                                    }
                                    if (result instanceof Exn.Res) {
                                        Process process;
                                        Exn.Res res = Exn$Res$.MODULE$.unapply((Exn.Res)result);
                                        Process process2 = process = (Process)res._1();
                                        this._processes.change((Function1<scala.collection.immutable.Map<UUID, Process>, scala.collection.immutable.Map<UUID, Process>>)((Function1 & Serializable)arg_0 -> Bash$.isabelle$Bash$Server$$_$handle$$anonfun$4(uuid, process2, arg_0)));
                                        this.reply$1(connection, (List)new .colon.colon((Object)Bash$Server$.isabelle$Bash$Server$$$UUID, (List)new .colon.colon((Object)uuid.toString(), (List)Nil$.MODULE$)));
                                        Isabelle_Thread$.MODULE$.fork("bash_process", Isabelle_Thread$.MODULE$.fork$default$2(), Isabelle_Thread$.MODULE$.fork$default$3(), Isabelle_Thread$.MODULE$.fork$default$4(), Isabelle_Thread$.MODULE$.fork$default$5(), Isabelle_Thread$.MODULE$.fork$default$6(), (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                                            this.handle$$anonfun$5(timeout, process2, input, descr, uuid, connection);
                                            return BoxedUnit.UNIT;
                                        });
                                        connection.await_close();
                                        return;
                                    }
                                    throw new MatchError(result);
                                }
                            }
                        }
                    }
                }
                this.reply_failure$1(connection, package$.MODULE$.ERROR().apply("Bad protocol message"));
                return;
            }
            throw new MatchError((Object)option);
        }

        private final void reply$1(Server.Connection connection$1, List chunks) {
            try {
                connection$1.write_byte_message((List<Bytes>)chunks.map(Bash$::isabelle$Bash$Server$$_$reply$1$$anonfun$1));
            }
            catch (IOException iOException) {}
        }

        private final void reply_failure$1(Server.Connection connection$3, Throwable exn) {
            this.reply$1(connection$3, Exn$.MODULE$.is_interrupt(exn) ? (List)new .colon.colon((Object)Bash$Server$.isabelle$Bash$Server$$$INTERRUPT, (List)Nil$.MODULE$) : (List)new .colon.colon((Object)Bash$Server$.isabelle$Bash$Server$$$FAILURE, (List)new .colon.colon((Object)Exn$.MODULE$.message(exn), (List)Nil$.MODULE$)));
        }

        private final void reply_result$1(Server.Connection connection$4, Process_Result result) {
            String string = Bash$Server$.isabelle$Bash$Server$$$RESULT;
            this.reply$1(connection$4, Bash$Server$.MODULE$.result(result).$colon$colon((Object)string));
        }

        private final void handle$$anonfun$5(long timeout$1, Process process$2, String input$2, String descr$1, UUID uuid$2, Server.Connection connection$2) {
            VolatileBooleanRef is_timeout = VolatileBooleanRef.create((boolean)false);
            Watchdog watchdog = Time$.MODULE$.is_zero$extension(timeout$1) ? Bash$Watchdog$.MODULE$.none() : Bash$Watchdog$.MODULE$.apply(timeout$1, (Function1<Process, Object>)((Function1 & Serializable)arg_0 -> Bash$.isabelle$Bash$Server$$_$_$$anonfun$5(is_timeout, arg_0)));
            Exn.Result result = Exn$.MODULE$.capture(() -> Bash$.isabelle$Bash$Server$$_$handle$$anonfun$5$$anonfun$1(process$2, input$2, watchdog));
            if (result instanceof Exn.Exn) {
                Throwable throwable;
                Exn.Exn exn = Exn$Exn$.MODULE$.unapply((Exn.Exn)result);
                Throwable exn2 = throwable = exn._1();
                this.reply_failure$1(connection$2, exn2);
            } else if (result instanceof Exn.Res) {
                Process_Result res;
                Exn.Res res2 = Exn$Res$.MODULE$.unapply((Exn.Res)result);
                Process_Result process_Result = (Process_Result)res2._1();
                Process_Result res0 = process_Result;
                Process_Result process_Result2 = res = !res0.ok() && is_timeout.elem ? res0.timeout_rc() : res0;
                if (this.debugging.apply$mcZ$sp()) {
                    Output$.MODULE$.writeln("stop " + package$.MODULE$.quote().apply((Object)descr$1) + " (uuid=" + uuid$2 + ", return_code=" + res.rc() + ")", Output$.MODULE$.writeln$default$2(), Output$.MODULE$.writeln$default$3());
                }
                this.reply_result$1(connection$2, res);
            } else {
                throw new MatchError(result);
            }
            this._processes.change((Function1<scala.collection.immutable.Map<UUID, Process>, scala.collection.immutable.Map<UUID, Process>>)((Function1 & Serializable)arg_0 -> Bash$.isabelle$Bash$Server$$_$handle$$anonfun$5$$anonfun$2(uuid$2, arg_0)));
        }
    }

    public static class Watchdog {
        private final long time;
        private final Function1 check;

        public static Watchdog apply(long l, Function1<Process, Object> function1) {
            return Bash$Watchdog$.MODULE$.apply(l, function1);
        }

        public static Watchdog none() {
            return Bash$Watchdog$.MODULE$.none();
        }

        public static Function1<Process, Object> apply$default$2() {
            return Bash$Watchdog$.MODULE$.apply$default$2();
        }

        public Watchdog(long time, Function1<Process, Object> check) {
            this.time = time;
            this.check = check;
        }

        public long time() {
            return this.time;
        }

        public Function1<Process, Object> check() {
            return this.check;
        }

        public String toString() {
            return "Bash.Watchdog(" + new Time(this.time()) + ")";
        }

        public boolean defined() {
            return Time$.MODULE$.$greater$extension(this.time(), Time$.MODULE$.zero());
        }
    }
}

