/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.AFP$;
import isabelle.Build_Log;
import isabelle.Build_Log$;
import isabelle.Build_Log$Column$;
import isabelle.Build_Log$Prop$;
import isabelle.Build_Log$Session_Status$;
import isabelle.Build_Log$Settings$;
import isabelle.Build_Status;
import isabelle.Build_Status$Data$;
import isabelle.Build_Status$Data_Entry$;
import isabelle.Build_Status$Entry$;
import isabelle.Build_Status$Image$;
import isabelle.Build_Status$Profile$;
import isabelle.Build_Status$Session$;
import isabelle.CSV;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.Date;
import isabelle.Date$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Graphics_File$;
import isabelle.HTML$;
import isabelle.Isabelle_Cronjob$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.Isabelle_Tool$;
import isabelle.ML_Statistics;
import isabelle.ML_Statistics$;
import isabelle.Options;
import isabelle.Options$;
import isabelle.Par_List$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Process_Result;
import isabelle.Progress;
import isabelle.Properties$;
import isabelle.Scala_Project$;
import isabelle.Sessions$;
import isabelle.Space$;
import isabelle.Symbol$;
import isabelle.Time$;
import isabelle.Value$Int$;
import isabelle.XML;
import isabelle.package$;
import java.io.Serializable;
import org.jfree.chart.JFreeChart;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.matching.Regex;

public final class Build_Status$
implements Serializable {
    private static final Path default_target_dir;
    private static final Tuple2 default_image_size;
    private static final int default_history;
    public static final Build_Status$Profile$ Profile;
    public static final Build_Status$Data$ Data;
    public static final Build_Status$Data_Entry$ Data_Entry;
    public static final Build_Status$Session$ Session;
    public static final Build_Status$Entry$ Entry;
    public static final Build_Status$Image$ Image;
    private static final Isabelle_Tool isabelle_tool;
    public static final Build_Status$ MODULE$;

    private Build_Status$() {
    }

    static {
        MODULE$ = new Build_Status$();
        default_target_dir = Path$.MODULE$.explode("build_status");
        default_image_size = new Tuple2.mcII.sp(800, 600);
        default_history = 30;
        isabelle_tool = Isabelle_Tool$.MODULE$.apply("build_status", "present recent build status information from database", Scala_Project$.MODULE$.here(), (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)args -> {
            ObjectRef target_dir = ObjectRef.create((Object)this.default_target_dir());
            BooleanRef ml_statistics = BooleanRef.create((boolean)false);
            ObjectRef only_sessions = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
            ObjectRef options = ObjectRef.create((Object)Options$.MODULE$.init(Options$.MODULE$.init$default$1(), Options$.MODULE$.init$default$2()));
            ObjectRef image_size = ObjectRef.create(this.default_image_size());
            BooleanRef verbose = BooleanRef.create((boolean)false);
            Object[] objectArray = new Tuple2[7];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"D:");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)arg -> {
                target_dir$2.elem = Path$.MODULE$.explode((String)arg);
            });
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"M");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (JProcedure1 & Serializable)_$13 -> {
                ml_statistics$2.elem = true;
            });
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"S:");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (JProcedure1 & Serializable)arg -> {
                only_sessions$2.elem = ((IterableOnceOps)package$.MODULE$.space_explode().apply((Object)BoxesRunTime.boxToCharacter((char)','), arg)).toSet();
            });
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"l:");
            objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (JProcedure1 & Serializable)arg -> {
                options$3.elem = ((Options)options$3.elem).$plus("build_log_history=" + arg);
            });
            String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"o:");
            objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (JProcedure1 & Serializable)arg -> {
                options$4.elem = ((Options)options$4.elem).$plus((String)arg);
            });
            String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"s:");
            objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (JProcedure1 & Serializable)arg -> {
                SeqOps seqOps;
                List list = ((List)package$.MODULE$.space_explode().apply((Object)BoxesRunTime.boxToCharacter((char)'x'), arg)).map((Function1 & Serializable)s -> Value$Int$.MODULE$.parse((String)s));
                if (list != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = scala.package$.MODULE$.List().unapplySeq((SeqOps)list), 2) == 0) {
                    int n = BoxesRunTime.unboxToInt((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0));
                    int n2 = BoxesRunTime.unboxToInt((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 1));
                    int w = n;
                    int h = n2;
                    if (w > 0 && h > 0) {
                        image_size$3.elem = new Tuple2.mcII.sp(w, h);
                        return;
                    }
                }
                package$.MODULE$.error().apply((Object)("Error bad PNG image size: " + package$.MODULE$.quote().apply(arg)));
            });
            String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)"v");
            objectArray[6] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (JProcedure1 & Serializable)_$14 -> {
                verbose$1.elem = true;
            });
            Getopts getopts = Getopts$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> this.$anonfun$1(options, image_size)), (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            List<String> more_args = getopts.apply((List<String>)args);
            if (more_args.nonEmpty()) {
                throw getopts.usage(getopts.usage$default$1());
            }
            Console_Progress progress = new Console_Progress(verbose.elem, Console_Progress$.MODULE$.$lessinit$greater$default$2(), Console_Progress$.MODULE$.$lessinit$greater$default$3(), Console_Progress$.MODULE$.$lessinit$greater$default$4());
            Options options2 = (Options)options.elem;
            Set set = (Set)only_sessions.elem;
            Path path = (Path)target_dir.elem;
            boolean bl = ml_statistics.elem;
            Tuple2 tuple2 = (Tuple2)image_size.elem;
            List<Build_Status.Profile> list = this.build_status$default$3();
            this.build_status(options2, progress, list, (Set<String>)set, path, bl, (Tuple2<Object, Object>)tuple2);
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Build_Status$.class);
    }

    public Path default_target_dir() {
        return default_target_dir;
    }

    public Tuple2<Object, Object> default_image_size() {
        return default_image_size;
    }

    public int default_history() {
        return default_history;
    }

    public List<Build_Status.Profile> default_profiles() {
        return Isabelle_Cronjob$.MODULE$.build_status_profiles();
    }

    public void build_status(Options options, Progress progress, List<Build_Status.Profile> profiles, Set<String> only_sessions, Path target_dir, boolean ml_statistics, Tuple2<Object, Object> image_size) {
        Set ml_statistics_domain = scala.package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ML_Statistics.Fields[]{ML_Statistics$.MODULE$.heap_fields(), ML_Statistics$.MODULE$.program_fields(), ML_Statistics$.MODULE$.tasks_fields(), ML_Statistics$.MODULE$.workers_fields()})).flatMap((Function1 & Serializable)_$1 -> _$1._2()).toSet();
        Build_Status.Data data = this.read_data(options, progress, profiles, only_sessions, ml_statistics, (Function1<String, Object>)ml_statistics_domain);
        this.present_data(data, progress, target_dir, image_size);
    }

    public Progress build_status$default$2() {
        return new Progress();
    }

    public List<Build_Status.Profile> build_status$default$3() {
        return this.default_profiles();
    }

    public Set<String> build_status$default$4() {
        return Predef$.MODULE$.Set().empty();
    }

    public Path build_status$default$5() {
        return this.default_target_dir();
    }

    public boolean build_status$default$6() {
        return false;
    }

    public Tuple2<Object, Object> build_status$default$7() {
        return this.default_image_size();
    }

    public String print_version(String isabelle_version, String afp_version, String chapter) {
        List list = ((Option)package$.MODULE$.proper_string().apply((Object)isabelle_version)).map((Function1 & Serializable)_$6 -> "Isabelle/" + _$6).toList();
        String string = chapter;
        String string2 = AFP$.MODULE$.chapter();
        List body = (!(string != null ? !string.equals(string2) : string2 != null) ? ((Option)package$.MODULE$.proper_string().apply((Object)afp_version)).map((Function1 & Serializable)_$7 -> "AFP/" + _$7) : None$.MODULE$).toList().$colon$colon$colon(list);
        return package$.MODULE$.if_proper(body, (Function0<String>)((Function0 & Serializable)() -> Build_Status$.print_version$$anonfun$1(body)));
    }

    public String print_version$default$2() {
        return "";
    }

    public String print_version$default$3() {
        return AFP$.MODULE$.chapter();
    }

    public Build_Status.Data read_data(Options options, Progress progress, List<Build_Status.Profile> profiles, Set<String> only_sessions, boolean ml_statistics, Function1<String, Object> ml_statistics_domain) {
        Date date = Date$.MODULE$.now(Date$.MODULE$.now$default$1());
        ObjectRef data_hosts = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        ObjectRef data_stretch = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        ObjectRef data_entries = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        Build_Log.Store store = Build_Log$.MODULE$.store(options, Build_Log$.MODULE$.store$default$2());
        package$.MODULE$.using(store.open_database(store.open_database$default$1()), (JProcedure1 & Serializable)db -> ((List)profiles.sortBy((Function1 & Serializable)_$9 -> _$9.description(), (Ordering)Ordering.String$.MODULE$)).foreach((Function1)(JProcedure1 & Serializable)profile -> {
            progress.echo("input " + package$.MODULE$.quote().apply((Object)profile.description()), progress.echo$default$2());
            boolean afp = profile.afp();
            Regex Threads_Option = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("threads\\s*=\\s*(\\d+)"));
            String sql = profile.select(options, ml_statistics, only_sessions);
            progress.echo(sql, true);
            db.using_statement(sql, (Function1)(JProcedure1 & Serializable)stmt -> package$.MODULE$.using(stmt.execute_query(), (JProcedure1 & Serializable)res -> {
                while (res.next()) {
                    None$ session;
                    None$ none$;
                    int n;
                    int i;
                    Option<Object> option;
                    String string;
                    List list;
                    Option option2;
                    String log_name = res.string(Build_Log$Column$.MODULE$.log_name());
                    String session_name = res.string(Build_Log$Column$.MODULE$.session_name());
                    String chapter = res.string(Build_Log$Column$.MODULE$.chapter());
                    List groups = (List)package$.MODULE$.split_lines().apply((Object)res.string(Build_Log$Column$.MODULE$.groups()));
                    String string2 = res.string(Build_Log$Settings$.MODULE$.ISABELLE_BUILD_OPTIONS());
                    int threads1 = string2 != null && !(option2 = Threads_Option.unapplySeq((CharSequence)string2)).isEmpty() && (list = (List)option2.get()).lengthCompare(1) == 0 && (string = (String)list.apply(0)) != null && !(option = Value$Int$.MODULE$.unapply(string)).isEmpty() ? (i = (n = BoxesRunTime.unboxToInt((Object)option.get()))) : 1;
                    int threads2 = BoxesRunTime.unboxToInt((Object)res.get_int(Build_Log$Column$.MODULE$.threads()).getOrElse(Build_Status$::$anonfun$14));
                    int threads = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(threads1), threads2);
                    String ml_platform = res.string(Build_Log$Settings$.MODULE$.ML_PLATFORM());
                    boolean ml_platform_64 = ml_platform.startsWith("x86_64-") || ml_platform.startsWith("arm64-");
                    String data_name = profile.description() + (ml_platform_64 ? ", 64bit" : "") + (String)(threads == 1 ? "" : ", " + threads + " threads");
                    res.get_string(Build_Log$Prop$.MODULE$.build_host()).foreach((Function1)(JProcedure1 & Serializable)host -> {
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)data_name);
                        data_hosts$6.elem = (Map)((Map)data_hosts$6.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.get_hosts$1(data_hosts, data_name).$plus(host)));
                    });
                    String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)data_name);
                    data_stretch$4.elem = (Map)((Map)data_stretch$4.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BoxesRunTime.boxToDouble((double)profile.stretch(options))));
                    String isabelle_version = res.string(Build_Log$Prop$.MODULE$.isabelle_version());
                    String afp_version = res.string(Build_Log$Prop$.MODULE$.afp_version());
                    List<List<Tuple2<String, String>>> list2 = ml_statistics ? Properties$.MODULE$.uncompress(res.bytes(Build_Log$Column$.MODULE$.ml_statistics()), store.cache()) : scala.package$.MODULE$.Nil();
                    String string4 = session_name + this.print_version(isabelle_version, afp_version, chapter);
                    ML_Statistics ml_stats = ML_Statistics$.MODULE$.apply(list2, string4, ml_statistics_domain);
                    Build_Status.Entry entry = Build_Status$Entry$.MODULE$.apply(chapter, res.date(Build_Log$Prop$.MODULE$.build_start()), res.date(Build_Log$Column$.MODULE$.pull_date(false)), afp ? res.get_date(Build_Log$Column$.MODULE$.pull_date(true)) : None$.MODULE$, isabelle_version, afp_version, res.timing(Build_Log$Column$.MODULE$.timing_elapsed(), Build_Log$Column$.MODULE$.timing_cpu(), Build_Log$Column$.MODULE$.timing_gc()), res.timing(Build_Log$Column$.MODULE$.ml_timing_elapsed(), Build_Log$Column$.MODULE$.ml_timing_cpu(), Build_Log$Column$.MODULE$.ml_timing_gc()), Space$.MODULE$.B(ml_stats.maximum(ML_Statistics$.MODULE$.CODE_SIZE())), Space$.MODULE$.B(ml_stats.average(ML_Statistics$.MODULE$.CODE_SIZE())), Space$.MODULE$.B(ml_stats.maximum(ML_Statistics$.MODULE$.STACK_SIZE())), Space$.MODULE$.B(ml_stats.average(ML_Statistics$.MODULE$.STACK_SIZE())), Space$.MODULE$.B(ml_stats.maximum(ML_Statistics$.MODULE$.HEAP_SIZE())), Space$.MODULE$.B(ml_stats.average(ML_Statistics$.MODULE$.HEAP_SIZE())), Space$.MODULE$.bytes(res.long(Build_Log$Column$.MODULE$.heap_size())), Build_Log$Session_Status$.MODULE$.valueOf(res.string(Build_Log$Column$.MODULE$.status())), Build_Log$.MODULE$.uncompress_errors(res.bytes(Build_Log$Column$.MODULE$.errors()), store.cache()));
                    Map sessions = (Map)((Map)data_entries$4.elem).getOrElse((Object)data_name, Build_Status$::$anonfun$15);
                    Option option3 = sessions.get((Object)session_name);
                    if (None$.MODULE$.equals(option3)) {
                        Object[] objectArray = new Tuple2[1];
                        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)log_name);
                        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)entry);
                        Map entries = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                        none$ = Some$.MODULE$.apply((Object)Build_Status$Session$.MODULE$.apply(session_name, threads, (Map<String, Build_Status.Entry>)entries, ml_stats, entry.date()));
                    } else if (option3 instanceof Some) {
                        Build_Status.Session old = (Build_Status.Session)((Some)option3).value();
                        if (!old.entries().isDefinedAt((Object)log_name)) {
                            String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)log_name);
                            Map entries1 = (Map)old.entries().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)entry));
                            Tuple2 tuple2 = entry.date() > old.ml_statistics_date() ? Tuple2$.MODULE$.apply((Object)ml_stats, (Object)BoxesRunTime.boxToLong((long)entry.date())) : Tuple2$.MODULE$.apply((Object)old.ml_statistics(), (Object)BoxesRunTime.boxToLong((long)old.ml_statistics_date()));
                            ML_Statistics ml_stats1 = (ML_Statistics)tuple2._1();
                            long ml_stats1_date = BoxesRunTime.unboxToLong((Object)tuple2._2());
                            none$ = Some$.MODULE$.apply((Object)Build_Status$Session$.MODULE$.apply(session_name, threads, (Map<String, Build_Status.Entry>)entries1, ml_stats1, ml_stats1_date));
                        } else {
                            none$ = None$.MODULE$;
                        }
                    } else {
                        throw new MatchError((Object)option3);
                    }
                    if (!(session = none$).isDefined()) continue;
                    if (afp) {
                        String string7 = chapter;
                        String string8 = AFP$.MODULE$.chapter();
                        if (string7 != null ? !string7.equals(string8) : string8 != null) continue;
                    }
                    if (profile.bulky() && !groups.exists(Sessions$.MODULE$.bulky_groups())) continue;
                    String string9 = (String)Predef$.MODULE$.ArrowAssoc((Object)data_name);
                    String string10 = (String)Predef$.MODULE$.ArrowAssoc((Object)session_name);
                    data_entries$4.elem = (Map)((Map)data_entries$4.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string9, (Object)sessions.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string10, session.get()))));
                }
            }));
        }));
        List sorted_entries = (List)((SeqOps)((Map)data_entries.elem).toList().withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Map sessions = (Map)tuple2._2();
                return true;
            }
            return false;
        }).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Map sessions = (Map)tuple2._2();
                return package$.MODULE$.proper_list((List)sessions.toList().map((Function1 & Serializable)_$10 -> (Build_Status.Session)_$10._2()).sortBy((Function1 & Serializable)_$11 -> _$11.order(), (Ordering)Ordering.Long$.MODULE$)).map((Function1 & Serializable)sorted_sessions -> {
                    List hosts = (List)this.get_hosts$1(data_hosts, name).toList().sorted((Ordering)Ordering.String$.MODULE$);
                    double stretch = BoxesRunTime.unboxToDouble((Object)((Map)data_stretch$5.elem).apply((Object)name));
                    return Build_Status$Data_Entry$.MODULE$.apply(name, (List<String>)hosts, stretch, (List<Build_Status.Session>)sorted_sessions);
                });
            }
            throw new MatchError((Object)tuple2);
        })).sortBy((Function1 & Serializable)_$12 -> _$12.name(), (Ordering)Ordering.String$.MODULE$);
        return Build_Status$Data$.MODULE$.apply(date, (List<Build_Status.Data_Entry>)sorted_entries);
    }

    public Progress read_data$default$2() {
        return new Progress();
    }

    public List<Build_Status.Profile> read_data$default$3() {
        return this.default_profiles();
    }

    public Set<String> read_data$default$4() {
        return Predef$.MODULE$.Set().empty();
    }

    public boolean read_data$default$5() {
        return false;
    }

    public Function1<String, Object> read_data$default$6() {
        return (Function1 & Serializable)_$8 -> true;
    }

    public void present_data(Build_Status.Data data, Progress progress, Path target_dir, Tuple2<Object, Object> image_size) {
        List list = (List)Predef$.MODULE$.ArrowAssoc(HTML$.MODULE$.text("status date:"));
        HTML$.MODULE$.write_document(target_dir, "index.html", (List<XML.Tree>)((List)new .colon.colon((Object)HTML$.MODULE$.title().apply("Isabelle build status"), (List)Nil$.MODULE$)), (List<XML.Tree>)((List)new .colon.colon((Object)HTML$.MODULE$.chapter().apply("Isabelle build status"), (List)new .colon.colon((Object)HTML$.MODULE$.par().apply((List<XML.Tree>)((List)new .colon.colon((Object)HTML$.MODULE$.description((List<Tuple2<List<XML.Tree>, List<XML.Tree>>>)((List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)list, HTML$.MODULE$.text(data.date().toString())), (List)Nil$.MODULE$))), (List)Nil$.MODULE$))), (List)new .colon.colon((Object)HTML$.MODULE$.par().apply((List<XML.Tree>)((List)new .colon.colon((Object)HTML$.MODULE$.itemize((List<List<XML.Tree>>)data.entries().map((Function1 & Serializable)data_entry -> {
            Nil$ nil$;
            List list = (List)new .colon.colon((Object)HTML$.MODULE$.link(this.clean_name$1(data_entry.name()) + "/index.html", HTML$.MODULE$.text(data_entry.name())), (List)Nil$.MODULE$);
            List<Build_Status.Session> list2 = data_entry.failed_sessions();
            Nil$ nil$2 = scala.package$.MODULE$.Nil();
            List<Build_Status.Session> list3 = list2;
            if (!(nil$2 != null ? !nil$2.equals(list3) : list3 != null)) {
                nil$ = scala.package$.MODULE$.Nil();
            } else {
                List<Build_Status.Session> sessions = list2;
                List<XML.Tree> list4 = HTML$.MODULE$.break();
                List list5 = (List)new .colon.colon((Object)HTML$.MODULE$.span().apply(HTML$.MODULE$.error_message(), HTML$.MODULE$.text("Failed sessions:")), (List)Nil$.MODULE$);
                nil$ = ((List)new .colon.colon((Object)HTML$.MODULE$.itemize((List<List<XML.Tree>>)sessions.map((Function1 & Serializable)s -> s.head().present_errors(s.name()))), (List)Nil$.MODULE$)).$colon$colon$colon(list5).$colon$colon$colon(list4);
            }
            return nil$.$colon$colon$colon(list);
        })), (List)Nil$.MODULE$))), (List)Nil$.MODULE$)))), HTML$.MODULE$.write_document$default$5(), HTML$.MODULE$.write_document$default$6(), HTML$.MODULE$.write_document$default$7(), HTML$.MODULE$.write_document$default$8());
        data.entries().foreach((Function1)(JProcedure1 & Serializable)data_entry -> {
            String data_name = data_entry.name();
            Tuple2 tuple2 = image_size;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int image_width = tuple2._1$mcI$sp();
            int image_height = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(image_width, image_height);
            int image_width2 = sp2._1$mcI$sp();
            int image_height2 = sp2._2$mcI$sp();
            int image_width_stretch = (int)((double)image_width2 * data_entry.stretch());
            progress.echo("output " + package$.MODULE$.quote().apply((Object)data_name), progress.echo$default$2());
            Path dir = Isabelle_System$.MODULE$.make_directory(target_dir.$plus(Path$.MODULE$.basic(this.clean_name$1(data_name))));
            Map data_files = data_entry.sessions().map((Function1 & Serializable)session -> {
                CSV.File csv_file = session.make_csv();
                csv_file.write(dir);
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)session.name());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)csv_file);
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Map session_plots = Par_List$.MODULE$.map((Function1 & Serializable)session -> (Tuple2)Isabelle_System$.MODULE$.with_tmp_file(session.name(), "data", Isabelle_System$.MODULE$.with_tmp_file$default$3(), (Function1 & Serializable)data_file -> (Tuple2)Isabelle_System$.MODULE$.with_tmp_file(session.name(), "gnuplot", Isabelle_System$.MODULE$.with_tmp_file$default$3(), (Function1 & Serializable)gnuplot_file -> {
                Nil$ nil$;
                Nil$ nil$2;
                File$.MODULE$.write((Path)data_file, (String)package$.MODULE$.cat_lines().apply((Object)session.finished_entries().map((Function1 & Serializable)entry -> ((IterableOnceOps)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{BoxesRunTime.boxToLong((long)entry.date()).toString(), BoxesRunTime.boxToDouble((double)Time$.MODULE$.minutes$extension(entry.timing().elapsed())).toString(), BoxesRunTime.boxToDouble((double)Time$.MODULE$.minutes$extension(entry.timing().resources())).toString(), BoxesRunTime.boxToDouble((double)Time$.MODULE$.minutes$extension(entry.ml_timing().elapsed())).toString(), BoxesRunTime.boxToDouble((double)Time$.MODULE$.minutes$extension(entry.ml_timing().resources())).toString(), BoxesRunTime.boxToDouble((double)Space$.MODULE$.MiB$extension(entry.maximum_code())).toString(), BoxesRunTime.boxToDouble((double)Space$.MODULE$.MiB$extension(entry.average_code())).toString(), BoxesRunTime.boxToDouble((double)Space$.MODULE$.MiB$extension(entry.maximum_stack())).toString(), BoxesRunTime.boxToDouble((double)Space$.MODULE$.MiB$extension(entry.average_stack())).toString(), BoxesRunTime.boxToDouble((double)Space$.MODULE$.MiB$extension(entry.maximum_heap())).toString(), BoxesRunTime.boxToDouble((double)Space$.MODULE$.MiB$extension(entry.average_heap())).toString(), BoxesRunTime.boxToDouble((double)Space$.MODULE$.MiB$extension(entry.stored_heap())).toString()}))).mkString(" "))));
                double max_time = RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(BoxesRunTime.unboxToDouble((Object)session.finished_entries().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(x$1, x$2) -> Build_Status$.$anonfun$21(BoxesRunTime.unboxToDouble((Object)x$1), (Build_Status.Entry)x$2)))), 0.1) * 1.1;
                String timing_range = "[0:" + max_time + "]";
                List plots1 = (List)new .colon.colon((Object)" using 1:2 smooth sbezier title \"elapsed time (smooth)\" ", (List)new .colon.colon((Object)" using 1:2 smooth csplines title \"elapsed time\" ", (List)Nil$.MODULE$));
                List plots2 = (List)new .colon.colon((Object)" using 1:3 smooth sbezier title \"cpu time (smooth)\" ", (List)new .colon.colon((Object)" using 1:3 smooth csplines title \"cpu time\" ", (List)Nil$.MODULE$));
                List timing_plots = session.threads() == 1 ? plots1 : plots2.$colon$colon$colon(plots1);
                List ml_timing_plots = (List)new .colon.colon((Object)" using 1:4 smooth sbezier title \"ML elapsed time (smooth)\" ", (List)new .colon.colon((Object)" using 1:4 smooth csplines title \"ML elapsed time\" ", (List)new .colon.colon((Object)" using 1:5 smooth sbezier title \"ML cpu time (smooth)\" ", (List)new .colon.colon((Object)" using 1:5 smooth csplines title \"ML cpu time\" ", (List)Nil$.MODULE$))));
                List heap_plots = (List)new .colon.colon((Object)" using 1:10 smooth sbezier title \"heap maximum (smooth)\" ", (List)new .colon.colon((Object)" using 1:10 smooth csplines title \"heap maximum\" ", (List)new .colon.colon((Object)" using 1:11 smooth sbezier title \"heap average (smooth)\" ", (List)new .colon.colon((Object)" using 1:11 smooth csplines title \"heap average\" ", (List)new .colon.colon((Object)" using 1:12 smooth sbezier title \"heap stored (smooth)\" ", (List)new .colon.colon((Object)" using 1:12 smooth csplines title \"heap stored\" ", (List)Nil$.MODULE$))))));
                Nil$ nil$3 = session.check_timing() ? (List)new .colon.colon((Object)this.gnuplot$1(image_width_stretch, image_height2, (Path)gnuplot_file, dir, (Build_Status.Session)session, (Path)data_file, data_name, this.plot_name$1((Build_Status.Session)session, "timing"), timing_plots, timing_range), (List)new .colon.colon((Object)this.gnuplot$1(image_width_stretch, image_height2, (Path)gnuplot_file, dir, (Build_Status.Session)session, (Path)data_file, data_name, this.plot_name$1((Build_Status.Session)session, "ml_timing"), ml_timing_plots, timing_range), (List)Nil$.MODULE$)) : scala.package$.MODULE$.Nil();
                Object object = nil$2 = session.check_heap() ? (List)new .colon.colon((Object)this.gnuplot$1(image_width_stretch, image_height2, (Path)gnuplot_file, dir, (Build_Status.Session)session, (Path)data_file, data_name, this.plot_name$1((Build_Status.Session)session, "heap"), heap_plots, "[0:]"), (List)Nil$.MODULE$) : scala.package$.MODULE$.Nil();
                if (session.ml_statistics().content().nonEmpty()) {
                    List list = (List)new .colon.colon((Object)this.jfreechart$1(image_width2, image_height2, (Build_Status.Session)session, dir, this.plot_name$1((Build_Status.Session)session, "heap_chart"), ML_Statistics$.MODULE$.heap_fields()), (List)new .colon.colon((Object)this.jfreechart$1(image_width2, image_height2, (Build_Status.Session)session, dir, this.plot_name$1((Build_Status.Session)session, "program_chart"), ML_Statistics$.MODULE$.program_fields()), (List)Nil$.MODULE$));
                    nil$ = (session.threads() > 1 ? (List)new .colon.colon((Object)this.jfreechart$1(image_width2, image_height2, (Build_Status.Session)session, dir, this.plot_name$1((Build_Status.Session)session, "tasks_chart"), ML_Statistics$.MODULE$.tasks_fields()), (List)new .colon.colon((Object)this.jfreechart$1(image_width2, image_height2, (Build_Status.Session)session, dir, this.plot_name$1((Build_Status.Session)session, "workers_chart"), ML_Statistics$.MODULE$.workers_fields()), (List)Nil$.MODULE$)) : scala.package$.MODULE$.Nil()).$colon$colon$colon(list);
                } else {
                    nil$ = scala.package$.MODULE$.Nil();
                }
                List images = nil$.$colon$colon$colon((List)nil$2).$colon$colon$colon((List)nil$3);
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)session.name());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)images);
            })), data_entry.sessions(), Par_List$.MODULE$.map$default$3(), Par_List$.MODULE$.map$default$4()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            XML.Elem elem = HTML$.MODULE$.chapter().apply("Isabelle build status for " + data_name);
            List list = (List)Predef$.MODULE$.ArrowAssoc(HTML$.MODULE$.text("status date:"));
            List list2 = (List)Predef$.MODULE$.ArrowAssoc(HTML$.MODULE$.text("build host:"));
            XML.Elem elem2 = HTML$.MODULE$.par().apply((List<XML.Tree>)((List)new .colon.colon((Object)HTML$.MODULE$.description((List<Tuple2<List<XML.Tree>, List<XML.Tree>>>)((List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)list, HTML$.MODULE$.text(data.date().toString())), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)list2, HTML$.MODULE$.text((String)package$.MODULE$.commas().apply(data_entry.hosts()))), (List)Nil$.MODULE$)))), (List)Nil$.MODULE$)));
            XML.Elem elem3 = HTML$.MODULE$.par().apply((List<XML.Tree>)((List)new .colon.colon((Object)HTML$.MODULE$.itemize((List<List<XML.Tree>>)data_entry.sessions().map((Function1 & Serializable)session -> {
                XML.Elem elem = HTML$.MODULE$.link("#session_" + session.name(), HTML$.MODULE$.text(session.name()));
                return HTML$.MODULE$.text(" (" + session.head().timing().message_resources() + ")").$colon$colon((Object)elem);
            })), (List)Nil$.MODULE$)));
            HTML$.MODULE$.write_document(dir, "index.html", (List<XML.Tree>)((List)new .colon.colon((Object)HTML$.MODULE$.title().apply("Isabelle build status for " + data_name), (List)Nil$.MODULE$)), (List<XML.Tree>)data_entry.sessions().flatMap((Function1 & Serializable)session -> {
                List list = (List)Predef$.MODULE$.ArrowAssoc(HTML$.MODULE$.text("data:"));
                List list2 = (List)Predef$.MODULE$.ArrowAssoc(HTML$.MODULE$.text("timing:"));
                List list3 = (List)Predef$.MODULE$.ArrowAssoc(HTML$.MODULE$.text("ML timing:"));
                List list4 = (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)list, (Object)new .colon.colon((Object)HTML$.MODULE$.link(((CSV.File)data_files.apply((Object)session.name())).file_name(), HTML$.MODULE$.text("CSV")), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)list2, HTML$.MODULE$.text(session.head().timing().message_resources())), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)list3, HTML$.MODULE$.text(session.head().ml_timing().message_resources())), (List)Nil$.MODULE$)));
                List list5 = Space$.MODULE$.print_relevant$extension(session.head().maximum_code()).map((Function1 & Serializable)s -> {
                    List list = (List)Predef$.MODULE$.ArrowAssoc(HTML$.MODULE$.text("code maximum:"));
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)list, HTML$.MODULE$.text((String)s));
                }).toList();
                List list6 = Space$.MODULE$.print_relevant$extension(session.head().average_code()).map((Function1 & Serializable)s -> {
                    List list = (List)Predef$.MODULE$.ArrowAssoc(HTML$.MODULE$.text("code average:"));
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)list, HTML$.MODULE$.text((String)s));
                }).toList();
                List list7 = Space$.MODULE$.print_relevant$extension(session.head().maximum_stack()).map((Function1 & Serializable)s -> {
                    List list = (List)Predef$.MODULE$.ArrowAssoc(HTML$.MODULE$.text("stack maximum:"));
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)list, HTML$.MODULE$.text((String)s));
                }).toList();
                List list8 = Space$.MODULE$.print_relevant$extension(session.head().average_stack()).map((Function1 & Serializable)s -> {
                    List list = (List)Predef$.MODULE$.ArrowAssoc(HTML$.MODULE$.text("stack average:"));
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)list, HTML$.MODULE$.text((String)s));
                }).toList();
                List list9 = Space$.MODULE$.print_relevant$extension(session.head().maximum_heap()).map((Function1 & Serializable)s -> {
                    List list = (List)Predef$.MODULE$.ArrowAssoc(HTML$.MODULE$.text("heap maximum:"));
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)list, HTML$.MODULE$.text((String)s));
                }).toList();
                List list10 = Space$.MODULE$.print_relevant$extension(session.head().average_heap()).map((Function1 & Serializable)s -> {
                    List list = (List)Predef$.MODULE$.ArrowAssoc(HTML$.MODULE$.text("heap average:"));
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)list, HTML$.MODULE$.text((String)s));
                }).toList();
                List list11 = Space$.MODULE$.print_relevant$extension(session.head().stored_heap()).map((Function1 & Serializable)s -> {
                    List list = (List)Predef$.MODULE$.ArrowAssoc(HTML$.MODULE$.text("heap stored:"));
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)list, HTML$.MODULE$.text((String)s));
                }).toList();
                List list12 = ((Option)package$.MODULE$.proper_string().apply((Object)session.head().isabelle_version())).map((Function1 & Serializable)s -> {
                    List list = (List)Predef$.MODULE$.ArrowAssoc(HTML$.MODULE$.text("Isabelle version:"));
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)list, HTML$.MODULE$.text((String)s));
                }).toList();
                XML.Elem elem = HTML$.MODULE$.description((List<Tuple2<List<XML.Tree>, List<XML.Tree>>>)((Option)package$.MODULE$.proper_string().apply((Object)session.head().afp_version())).map((Function1 & Serializable)s -> {
                    List list = (List)Predef$.MODULE$.ArrowAssoc(HTML$.MODULE$.text("AFP version:"));
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)list, HTML$.MODULE$.text((String)s));
                }).toList().$colon$colon$colon(list12).$colon$colon$colon(list11).$colon$colon$colon(list10).$colon$colon$colon(list9).$colon$colon$colon(list8).$colon$colon$colon(list7).$colon$colon$colon(list6).$colon$colon$colon(list5).$colon$colon$colon(list4));
                return (IterableOnce)new .colon.colon((Object)HTML$.MODULE$.section().apply(HTML$.MODULE$.id("session_" + session.name()), session.name()), (List)new .colon.colon((Object)HTML$.MODULE$.par().apply((List<XML.Tree>)((List)session_plots.getOrElse((Object)session.name(), Build_Status$::present_data$$anonfun$2$$anonfun$1$$anonfun$1)).map((Function1 & Serializable)image -> HTML$.MODULE$.size(image.width() / 2, image.height() / 2, HTML$.MODULE$.image(image.name(), HTML$.MODULE$.image$default$2()))).$colon$colon((Object)elem)), (List)Nil$.MODULE$));
            }).$colon$colon((Object)elem3).$colon$colon((Object)elem2).$colon$colon((Object)elem), HTML$.MODULE$.write_document$default$5(), HTML$.MODULE$.write_document$default$6(), HTML$.MODULE$.write_document$default$7(), HTML$.MODULE$.write_document$default$8());
        });
    }

    public Progress present_data$default$2() {
        return new Progress();
    }

    public Path present_data$default$3() {
        return this.default_target_dir();
    }

    public Tuple2<Object, Object> present_data$default$4() {
        return this.default_image_size();
    }

    public Isabelle_Tool isabelle_tool() {
        return isabelle_tool;
    }

    private final String $anonfun$1(ObjectRef options$2, ObjectRef image_size$2) {
        return "\nUsage: isabelle build_status [OPTIONS]\n\n  Options are:\n    -D DIR       target directory (default " + this.default_target_dir() + ")\n    -M           include full ML statistics\n    -S SESSIONS  only given SESSIONS (comma separated)\n    -l DAYS      length of relevant history (default " + ((Options)options$2.elem).int().apply("build_log_history") + ")\n    -o OPTION    override Isabelle system OPTION (via NAME=VAL or NAME)\n    -s WxH       size of PNG image (default " + ((Tuple2)image_size$2.elem)._1$mcI$sp() + "x" + ((Tuple2)image_size$2.elem)._2$mcI$sp() + ")\n    -v           verbose\n\n  Present performance statistics from build log database, which is specified\n  via system options build_log_database_host, build_log_database_user,\n  build_log_history etc.\n";
    }

    public static final String isabelle$Build_Status$Profile$$_$select$$anonfun$1(Set only_sessions$3) {
        return Build_Log$Column$.MODULE$.session_name().member((Iterable<String>)only_sessions$3);
    }

    public static final /* synthetic */ boolean isabelle$Build_Status$Data_Entry$$_$failed_sessions$$anonfun$1(Build_Status.Session _$2) {
        return _$2.head().failed();
    }

    public static final /* synthetic */ String isabelle$Build_Status$Data_Entry$$_$failed_sessions$$anonfun$2(Build_Status.Session _$3) {
        return _$3.name();
    }

    public static final /* synthetic */ long isabelle$Build_Status$Session$$_$sorted_entries$lzyINIT1$$anonfun$1(Build_Status.Entry entry) {
        return -entry.date();
    }

    public static final /* synthetic */ boolean isabelle$Build_Status$Session$$_$finished_entries$$anonfun$1(Build_Status.Entry _$4) {
        return _$4.finished();
    }

    public static final /* synthetic */ long isabelle$Build_Status$Session$$_$finished_entries_size$$anonfun$1(Build_Status.Entry _$5) {
        return _$5.date();
    }

    public static final /* synthetic */ boolean isabelle$Build_Status$Session$$_$check_heap$$anonfun$1(Build_Status.Entry entry) {
        return Space$.MODULE$.is_proper$extension(entry.maximum_heap()) || Space$.MODULE$.is_proper$extension(entry.average_heap()) || Space$.MODULE$.is_proper$extension(entry.stored_heap());
    }

    public static final /* synthetic */ List isabelle$Build_Status$Entry$$_$_$$anonfun$11(String s) {
        return HTML$.MODULE$.text(Symbol$.MODULE$.decode(s));
    }

    private static final String print_version$$anonfun$1(List body$1) {
        return body$1.mkString(" (", ", ", ")");
    }

    private static final Set get_hosts$1$$anonfun$1() {
        return Predef$.MODULE$.Set().empty();
    }

    private final Set get_hosts$1(ObjectRef data_hosts$1, String data_name) {
        return (Set)((Map)data_hosts$1.elem).getOrElse((Object)data_name, Build_Status$::get_hosts$1$$anonfun$1);
    }

    private static final int $anonfun$14() {
        return 1;
    }

    private static final Map $anonfun$15() {
        return Predef$.MODULE$.Map().empty();
    }

    private static final /* synthetic */ String clean_name$1$$anonfun$1(char c) {
        if (c == ' ' || c == '/') {
            return "_";
        }
        if (c == ',') {
            return "";
        }
        return BoxesRunTime.boxToCharacter((char)c).toString();
    }

    private final String clean_name$1(String name) {
        return StringOps$.MODULE$.flatMap$extension(Predef$.MODULE$.augmentString(name), (Function1 & Serializable)c -> Build_Status$.clean_name$1$$anonfun$1(BoxesRunTime.unboxToChar((Object)c)));
    }

    private final String plot_name$1(Build_Status.Session session$3, String kind) {
        return session$3.name() + "_" + kind + ".png";
    }

    private static final /* synthetic */ double $anonfun$21(double x$1, Build_Status.Entry x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)x$1), (Object)x$2);
        if (tuple2 != null) {
            double m = BoxesRunTime.unboxToDouble((Object)tuple2._1());
            Build_Status.Entry entry = (Build_Status.Entry)tuple2._2();
            return RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(m), Time$.MODULE$.minutes$extension(entry.timing().elapsed()))), Time$.MODULE$.minutes$extension(entry.timing().resources()))), Time$.MODULE$.minutes$extension(entry.ml_timing().elapsed()))), Time$.MODULE$.minutes$extension(entry.ml_timing().resources()));
        }
        throw new MatchError((Object)tuple2);
    }

    private final Build_Status.Image gnuplot$1(int image_width_stretch$4, int image_height$4, Path gnuplot_file$1, Path dir$5, Build_Status.Session session$4, Path data_file$2, String data_name$5, String plot_name, List plots, String range) {
        Build_Status.Image image = Build_Status$Image$.MODULE$.apply(plot_name, image_width_stretch$4, image_height$4);
        File$.MODULE$.write(gnuplot_file$1, "\nset terminal png size " + image.width() + "," + image.height() + "\nset output " + package$.MODULE$.quote().apply((Object)File$.MODULE$.standard_path(dir$5.$plus(image.path()))) + "\nset xdata time\nset timefmt \"%s\"\nset format x \"%d-%b\"\nset xlabel " + package$.MODULE$.quote().apply((Object)session$4.name()) + " noenhanced\nset key left bottom\nplot [] " + range + " " + plots.map((Function1 & Serializable)s -> (String)package$.MODULE$.quote().apply((Object)data_file$2.implode()) + " " + s).mkString(", ") + "\n");
        Process_Result result = Isabelle_System$.MODULE$.bash("\"$ISABELLE_GNUPLOT\" " + File$.MODULE$.bash_path(gnuplot_file$1), Isabelle_System$.MODULE$.bash$default$2(), Isabelle_System$.MODULE$.bash$default$3(), Isabelle_System$.MODULE$.bash$default$4(), Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), Isabelle_System$.MODULE$.bash$default$8(), Isabelle_System$.MODULE$.bash$default$9(), Isabelle_System$.MODULE$.bash$default$10(), Isabelle_System$.MODULE$.bash$default$11(), Isabelle_System$.MODULE$.bash$default$12());
        if (!result.ok()) {
            result.error("Gnuplot failed for " + data_name$5 + "/" + plot_name).check();
        }
        return image;
    }

    private final Build_Status.Image jfreechart$1(int image_width$4, int image_height$5, Build_Status.Session session$5, Path dir$6, String plot_name, ML_Statistics.Fields fields) {
        Build_Status.Image image = Build_Status$Image$.MODULE$.apply(plot_name, image_width$4, image_height$5);
        JFreeChart chart = session$5.ml_statistics().chart(fields.title() + ": " + session$5.ml_statistics().heading(), fields.names());
        Graphics_File$.MODULE$.write_chart_png(dir$6.$plus(image.path()).file(), chart, image.width(), image.height());
        return image;
    }

    private static final List present_data$$anonfun$2$$anonfun$1$$anonfun$1() {
        return scala.package$.MODULE$.Nil();
    }
}

