/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Bash$;
import isabelle.Bytes;
import isabelle.Bytes$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.Date$;
import isabelle.Date$Format$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.Isabelle_Tool$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Platform$;
import isabelle.Process_Result;
import isabelle.Progress;
import isabelle.SSH;
import isabelle.Scala_Project$;
import isabelle.package$;
import java.io.Serializable;
import java.util.Map;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class Component_Cygwin$
implements Serializable {
    private static final String default_mirror;
    private static final List packages;
    private static final Isabelle_Tool isabelle_tool;
    public static final Component_Cygwin$ MODULE$;

    private Component_Cygwin$() {
    }

    static {
        MODULE$ = new Component_Cygwin$();
        default_mirror = "https://isabelle.sketis.net/cygwin_2025-1";
        packages = (List)new .colon.colon((Object)"curl", (List)new .colon.colon((Object)"libgmp-devel", (List)new .colon.colon((Object)"nano", (List)new .colon.colon((Object)"openssh", (List)new .colon.colon((Object)"perl", (List)Nil$.MODULE$)))));
        isabelle_tool = Isabelle_Tool$.MODULE$.apply("component_cygwin", "produce pre-canned Cygwin distribution for Isabelle", Scala_Project$.MODULE$.here(), (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)args -> {
            ObjectRef target_dir = ObjectRef.create((Object)Path$.MODULE$.current());
            ObjectRef mirror = ObjectRef.create((Object)this.default_mirror());
            ObjectRef more_packages = ObjectRef.create((Object)scala.package$.MODULE$.Nil());
            Object[] objectArray = new Tuple2[3];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"D:");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)arg -> {
                target_dir$1.elem = Path$.MODULE$.explode((String)arg);
            });
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"R:");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (JProcedure1 & Serializable)arg -> {
                mirror$1.elem = arg;
            });
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"p:");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (JProcedure1 & Serializable)arg -> {
                more_packages$1.elem = ((List)more_packages$1.elem).$colon$colon(arg);
            });
            Getopts getopts = Getopts$.MODULE$.apply((Function0<String>)((Function0 & Serializable)this::$anonfun$1), (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            List<String> more_args = getopts.apply((List<String>)args);
            if (more_args.nonEmpty()) {
                throw getopts.usage(getopts.usage$default$1());
            }
            Console_Progress progress = new Console_Progress(Console_Progress$.MODULE$.$lessinit$greater$default$1(), Console_Progress$.MODULE$.$lessinit$greater$default$2(), Console_Progress$.MODULE$.$lessinit$greater$default$3(), Console_Progress$.MODULE$.$lessinit$greater$default$4());
            this.build_cygwin((Path)target_dir.elem, (String)mirror.elem, (List<String>)((List)more_packages.elem), progress);
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Component_Cygwin$.class);
    }

    public String default_mirror() {
        return default_mirror;
    }

    public List<String> packages() {
        return packages;
    }

    public void build_cygwin(Path target_dir, String mirror, List<String> more_packages, Progress progress) {
        Predef$.MODULE$.require(Platform$.MODULE$.is_windows(), Component_Cygwin$::build_cygwin$$anonfun$1);
        Isabelle_System$.MODULE$.with_tmp_dir("cygwin", Isabelle_System$.MODULE$.with_tmp_dir$default$2(), (Function1 & Serializable)tmp_dir -> {
            Bytes bytes;
            Path cygwin_exe;
            Path cygwin = tmp_dir.$plus(Path$.MODULE$.explode("cygwin"));
            Path cygwin_etc = cygwin.$plus(Path$.MODULE$.explode("etc"));
            Path cygwin_isabelle = Isabelle_System$.MODULE$.make_directory(cygwin.$plus(Path$.MODULE$.explode("isabelle")));
            String cygwin_exe_name = mirror + "/setup-x86_64.exe";
            Path path = cygwin_exe = cygwin_isabelle.$plus(Path$.MODULE$.explode("cygwin.exe"));
            Bytes$ bytes$ = Bytes$.MODULE$;
            try {
                bytes = Bytes$.MODULE$.read_url(cygwin_exe_name);
            }
            catch (Throwable throwable) {
                Option<String> option;
                Throwable throwable2 = throwable;
                if (throwable2 == null || (option = package$.MODULE$.ERROR().unapply(throwable2)).isEmpty()) {
                    throw throwable;
                }
                String string = (String)option.get();
                throw (Nothing$)package$.MODULE$.error().apply((Object)("Failed to download " + package$.MODULE$.quote().apply((Object)cygwin_exe_name)));
            }
            Bytes bytes2 = bytes;
            Bytes$ bytes$2 = bytes$;
            bytes$ = null;
            Path path2 = path;
            path = null;
            Bytes bytes3 = bytes2;
            bytes2 = null;
            bytes$2.write(path2, bytes3);
            File$.MODULE$.write(cygwin_isabelle.$plus(Path$.MODULE$.explode("cygwin_mirror")), mirror);
            File$.MODULE$.set_executable(cygwin_exe, File$.MODULE$.set_executable$default$2());
            Isabelle_System$.MODULE$.bash(File$.MODULE$.bash_path(cygwin_exe) + " -h </dev/null >/dev/null", Isabelle_System$.MODULE$.bash$default$2(), Isabelle_System$.MODULE$.bash$default$3(), Isabelle_System$.MODULE$.bash$default$4(), Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), Isabelle_System$.MODULE$.bash$default$8(), Isabelle_System$.MODULE$.bash$default$9(), Isabelle_System$.MODULE$.bash$default$10(), Isabelle_System$.MODULE$.bash$default$11(), Isabelle_System$.MODULE$.bash$default$12()).check();
            String string = File$.MODULE$.bash_path(cygwin_exe) + " --site " + Bash$.MODULE$.string(mirror) + " --no-verify --local-package-dir 'C:\\temp' --root " + File$.MODULE$.bash_platform_path(cygwin) + " --packages " + package$.MODULE$.quote().apply((Object)more_packages.$colon$colon$colon(MODULE$.packages()).mkString(",")) + " --no-shortcuts --no-startmenu --no-desktop --quiet-mode";
            SSH.System system = progress.bash$default$2();
            Path path3 = progress.bash$default$3();
            Map<String, String> map = progress.bash$default$4();
            boolean bl = progress.bash$default$5();
            long l = progress.bash$default$7();
            boolean bl2 = progress.bash$default$8();
            Process_Result res = progress.bash(string, system, path3, map, bl, true, l, bl2);
            if (!res.ok() || !cygwin_etc.is_dir()) {
                package$.MODULE$.error().apply((Object)"Failed");
            }
            ((List)new .colon.colon((Object)"hosts", (List)new .colon.colon((Object)"protocols", (List)new .colon.colon((Object)"services", (List)new .colon.colon((Object)"networks", (List)new .colon.colon((Object)"passwd", (List)new .colon.colon((Object)"group", (List)Nil$.MODULE$))))))).foreach((Function1 & Serializable)name -> cygwin_etc.$plus(Path$.MODULE$.explode((String)name)).file().delete());
            cygwin.$plus(Path$.MODULE$.explode("Cygwin.bat")).file().delete();
            Isabelle_System$.MODULE$.bash("rm -f cygwin/usr/share/man/man1/:.1.gz", Isabelle_System$.MODULE$.bash$default$2(), Isabelle_System$.MODULE$.bash$default$3(), (Path)tmp_dir, Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), Isabelle_System$.MODULE$.bash$default$8(), Isabelle_System$.MODULE$.bash$default$9(), Isabelle_System$.MODULE$.bash$default$10(), Isabelle_System$.MODULE$.bash$default$11(), Isabelle_System$.MODULE$.bash$default$12()).check();
            Path archive = target_dir.$plus(Path$.MODULE$.explode("cygwin-" + Date$Format$.MODULE$.alt_date().apply(Date$.MODULE$.now(Date$.MODULE$.now$default$1())) + ".tar.gz"));
            return Isabelle_System$.MODULE$.gnutar("-czf " + File$.MODULE$.bash_path(archive) + " cygwin", (Path)tmp_dir, Isabelle_System$.MODULE$.gnutar$default$3(), Isabelle_System$.MODULE$.gnutar$default$4(), Isabelle_System$.MODULE$.gnutar$default$5()).check();
        });
    }

    public Path build_cygwin$default$1() {
        return Path$.MODULE$.current();
    }

    public String build_cygwin$default$2() {
        return this.default_mirror();
    }

    public List<String> build_cygwin$default$3() {
        return scala.package$.MODULE$.Nil();
    }

    public Progress build_cygwin$default$4() {
        return new Progress();
    }

    public Isabelle_Tool isabelle_tool() {
        return isabelle_tool;
    }

    private final String $anonfun$1() {
        return "\nUsage: isabelle component_cygwin [OPTIONS]\n\n  Options are:\n    -D DIR       target directory (default \".\")\n    -R MIRROR    Cygwin mirror site (default " + package$.MODULE$.quote().apply((Object)this.default_mirror()) + ")\n    -p NAME      additional Cygwin package\n\n  Produce pre-canned Cygwin distribution for Isabelle: this requires\n  Windows administrator mode.\n";
    }

    private static final Object build_cygwin$$anonfun$1() {
        return "Windows platform expected";
    }
}

