/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Bytes$;
import isabelle.Components;
import isabelle.Components$Directory$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.Date$;
import isabelle.Date$Format$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Isabelle_Platform$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.Isabelle_Tool$;
import isabelle.Linux$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Progress;
import isabelle.SSH;
import isabelle.Scala_Project$;
import isabelle.Time$;
import isabelle.package$;
import java.io.Serializable;
import java.util.Map;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public final class Component_HOL_Light$
implements Serializable {
    private static final Path hol_import_dir;
    private static final String default_hol_light_url;
    private static final String default_hol_light_rev;
    private static final Isabelle_Tool isabelle_tool;
    public static final Component_HOL_Light$ MODULE$;

    private Component_HOL_Light$() {
    }

    static {
        MODULE$ = new Component_HOL_Light$();
        hol_import_dir = Path$.MODULE$.explode("~~/src/HOL/Import");
        default_hol_light_url = "https://github.com/jrh13/hol-light.git";
        default_hol_light_rev = "Release-3.0.0";
        isabelle_tool = Isabelle_Tool$.MODULE$.apply("component_hol_light_import", "build Isabelle component for HOL Light import", Scala_Project$.MODULE$.here(), (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)args -> {
            ObjectRef target_dir = ObjectRef.create((Object)Path$.MODULE$.current());
            ObjectRef load_more = ObjectRef.create((Object)scala.package$.MODULE$.List().empty());
            ObjectRef maps = ObjectRef.create((Object)Some$.MODULE$.apply((Object)this.default_maps()));
            BooleanRef only_offline = BooleanRef.create((boolean)false);
            BooleanRef preserve_raw = BooleanRef.create((boolean)false);
            ObjectRef hol_light_url = ObjectRef.create((Object)this.default_hol_light_url());
            ObjectRef hol_light_rev = ObjectRef.create((Object)this.default_hol_light_rev());
            BooleanRef verbose = BooleanRef.create((boolean)false);
            Object[] objectArray = new Tuple2[8];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"D:");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)arg -> {
                target_dir$1.elem = Path$.MODULE$.explode((String)arg);
            });
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"L:");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (JProcedure1 & Serializable)arg -> {
                List list = (List)load_more$1.elem;
                load_more$1.elem = ((List)new .colon.colon((Object)Path$.MODULE$.explode((String)arg), (List)Nil$.MODULE$)).$colon$colon$colon(list);
            });
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"M:");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (JProcedure1 & Serializable)arg -> {
                String string = arg;
                String string2 = ".";
                maps$1.elem = !(string != null ? !string.equals(string2) : string2 != null) ? None$.MODULE$ : Some$.MODULE$.apply((Object)Path$.MODULE$.explode((String)arg));
            });
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"O");
            objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (JProcedure1 & Serializable)_$2 -> {
                only_offline$1.elem = true;
            });
            String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"P");
            objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (JProcedure1 & Serializable)_$3 -> {
                preserve_raw$1.elem = true;
            });
            String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"U:");
            objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (JProcedure1 & Serializable)arg -> {
                hol_light_url$1.elem = arg;
            });
            String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)"r:");
            objectArray[6] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (JProcedure1 & Serializable)arg -> {
                hol_light_rev$1.elem = arg;
            });
            String string8 = (String)Predef$.MODULE$.ArrowAssoc((Object)"v");
            objectArray[7] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string8, (JProcedure1 & Serializable)_$4 -> {
                verbose$1.elem = true;
            });
            Getopts getopts = Getopts$.MODULE$.apply((Function0<String>)((Function0 & Serializable)this::$anonfun$1), (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            List<String> more_args = getopts.apply((List<String>)args);
            if (more_args.nonEmpty()) {
                throw getopts.usage(getopts.usage$default$1());
            }
            Console_Progress progress = new Console_Progress(verbose.elem, Console_Progress$.MODULE$.$lessinit$greater$default$2(), Console_Progress$.MODULE$.$lessinit$greater$default$3(), Console_Progress$.MODULE$.$lessinit$greater$default$4());
            this.build_hol_light_import(only_offline.elem, progress, (Path)target_dir.elem, (List<Path>)((List)load_more.elem), (Option<Path>)((Option)maps.elem), preserve_raw.elem, (String)hol_light_url.elem, (String)hol_light_rev.elem);
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Component_HOL_Light$.class);
    }

    public Path hol_import_dir() {
        return hol_import_dir;
    }

    public Path default_maps() {
        return this.hol_import_dir().$plus(Path$.MODULE$.explode("offline/maps.lst"));
    }

    public List<String> bundle_contents(boolean preserve_raw) {
        List list = (List)new .colon.colon((Object)"facts.lstN", (List)new .colon.colon((Object)"maps.lst", (List)new .colon.colon((Object)"proofsN.zst", (List)Nil$.MODULE$)));
        return (preserve_raw ? (List)new .colon.colon((Object)"facts.lst", (List)new .colon.colon((Object)"proofs", (List)Nil$.MODULE$)) : scala.package$.MODULE$.Nil()).$colon$colon$colon(list);
    }

    public boolean bundle_contents$default$1() {
        return false;
    }

    public String default_hol_light_url() {
        return default_hol_light_url;
    }

    public String default_hol_light_rev() {
        return default_hol_light_rev;
    }

    public void build_hol_light_import(boolean only_offline, Progress progress, Path target_dir, List<Path> load_more, Option<Path> maps, boolean preserve_raw, String hol_light_url, String hol_light_rev) {
        if (!only_offline) {
            Linux$.MODULE$.check_system();
            Isabelle_System$.MODULE$.require_command("bzip2", Isabelle_System$.MODULE$.require_command$default$2());
            Isabelle_System$.MODULE$.require_command("m4", Isabelle_System$.MODULE$.require_command$default$2());
            Isabelle_System$.MODULE$.require_command("patch", Isabelle_System$.MODULE$.require_command$default$2());
            Isabelle_System$.MODULE$.require_command("zstd", Isabelle_System$.MODULE$.require_command$default$2());
        }
        String component_name = "hol_light_import-" + Date$Format$.MODULE$.alt_date().apply(Date$.MODULE$.now(Date$.MODULE$.now$default$1()));
        Components.Directory directory = Components$Directory$.MODULE$.apply(target_dir.$plus(Path$.MODULE$.basic(component_name)), Components$Directory$.MODULE$.apply$default$2());
        Components.Directory component_dir = directory.create(progress, directory.create$default$2());
        String platform = Isabelle_Platform$.MODULE$.local().ISABELLE_PLATFORM(true, true);
        Path platform_dir = Isabelle_System$.MODULE$.make_directory(component_dir.path().$plus(Path$.MODULE$.basic(platform)));
        component_dir.write_settings("\nHOL_LIGHT_IMPORT=\"$COMPONENT\"\nHOL_LIGHT_BUNDLE=\"$HOL_LIGHT_IMPORT/bundle/proofsN.zst\"\nHOL_LIGHT_OFFLINE=\"$HOL_LIGHT_IMPORT/${ISABELLE_WINDOWS_PLATFORM64:-${ISABELLE_APPLE_PLATFORM64:-$ISABELLE_PLATFORM64}}/offline\"\n");
        File$.MODULE$.write(component_dir.README(), "Author: Cezary Kaliszyk, University of Innsbruck, 2013\nAuthor: Alexander Krauss, QAware GmbH, 2013\nAuthor: Sophie Tourret, INRIA, 2024\nAuthor: St\u00e9phane Glondu, INRIA, 2024\n\nLICENSE (export tools): BSD-3 from Isabelle\nLICENSE (HOL Light proofs): BSD-2 from HOL Light\n\n\nThis is an export of primitive proofs from HOL Light " + hol_light_rev + ".\n\nThe original repository " + hol_light_url + "\nhas been patched in 2 phases. The overall export process works like this:\n\n  isabelle ocaml_setup\n  isabelle ocaml_opam install -y camlp5\n  eval $(isabelle ocaml_opam env)\n\n  cd hol-light\n  make\n\n  patch -p1 < \"$HOL_LIGHT_IMPORT/patches/patch1\"\n  ./ocaml-hol -I +compiler-libs stage1.ml\n\n  patch -p1 < \"$HOL_LIGHT_IMPORT/patches/patch2\"\n  export MAXTMS=10000\n  ./ocaml-hol -I +compiler-libs stage2.ml\n\n  cp \"$HOL_LIGHT_IMPORT/bundle/maps.lst\" .\n  \"$HOL_LIGHT_IMPORT/x86_64-linux/offline\"\n\n\n      Makarius\n      " + Date$Format$.MODULE$.date().apply(Date$.MODULE$.now(Date$.MODULE$.now$default$1())) + "\n");
        Isabelle_System$.MODULE$.with_tmp_dir("build", Isabelle_System$.MODULE$.with_tmp_dir$default$2(), (JProcedure1 & Serializable)tmp_dir -> {
            progress.echo("Setup OCaml ...", progress.echo$default$2());
            String string = only_offline ? "isabelle ocaml_setup_base" : "isabelle ocaml_setup && isabelle ocaml_opam install -y camlp5";
            boolean bl = progress.verbose();
            SSH.System system = progress.bash$default$2();
            Path path2 = progress.bash$default$3();
            Map<String, String> map = progress.bash$default$4();
            boolean bl2 = progress.bash$default$5();
            long l = progress.bash$default$7();
            boolean bl3 = progress.bash$default$8();
            progress.bash(string, system, path2, map, bl2, bl, l, bl3).check();
            String opam_env = Isabelle_System$.MODULE$.bash("isabelle ocaml_opam env", Isabelle_System$.MODULE$.bash$default$2(), Isabelle_System$.MODULE$.bash$default$3(), Isabelle_System$.MODULE$.bash$default$4(), Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), Isabelle_System$.MODULE$.bash$default$8(), Isabelle_System$.MODULE$.bash$default$9(), Isabelle_System$.MODULE$.bash$default$10(), Isabelle_System$.MODULE$.bash$default$11(), Isabelle_System$.MODULE$.bash$default$12()).check().out();
            progress.echo("Building offline tool ...", progress.echo$default$2());
            Path offline_path = Path$.MODULE$.explode("offline");
            Path offline_exe = offline_path.platform_exe();
            Path offline_dir = Isabelle_System$.MODULE$.make_directory(tmp_dir.$plus(offline_path));
            Isabelle_System$.MODULE$.copy_dir(this.hol_import_dir().$plus(offline_path), offline_dir, true);
            boolean bl4 = progress.verbose();
            SSH.System system2 = progress.bash$default$2();
            Map<String, String> map2 = progress.bash$default$4();
            boolean bl5 = progress.bash$default$5();
            long l2 = progress.bash$default$7();
            boolean bl6 = progress.bash$default$8();
            progress.bash("ocamlc.opt offline.ml -o offline", system2, offline_dir, map2, bl5, bl4, l2, bl6).check();
            Isabelle_System$.MODULE$.copy_file(offline_dir.$plus(offline_exe), platform_dir.$plus(offline_exe));
            File$.MODULE$.set_executable(platform_dir.$plus(offline_exe), File$.MODULE$.set_executable$default$2());
            if (!only_offline) {
                Path hol_light_dir = tmp_dir.$plus(Path$.MODULE$.basic("hol-light"));
                Isabelle_System$.MODULE$.git_clone(hol_light_url, hol_light_dir, hol_light_rev, Isabelle_System$.MODULE$.git_clone$default$4(), progress);
                Isabelle_System$.MODULE$.make_directory(component_dir.path().$plus(Path$.MODULE$.basic("patches")));
                ((List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)1), (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)2), (List)Nil$.MODULE$))).foreach((Function1)(JFunction1.mcVI.sp & Serializable)n -> Isabelle_System$.MODULE$.copy_file(this.patch$1(component_dir, n, true), this.patch$1(component_dir, n, this.patch$default$2$1())));
                if (load_more.nonEmpty()) {
                    List bad = load_more.filter((Function1 & Serializable)path -> !hol_light_dir.$plus((Path)path).is_file());
                    if (bad.nonEmpty()) {
                        package$.MODULE$.error().apply((Object)("Bad HOL Light files: " + bad.mkString(", ")));
                    }
                    String more = load_more.map((Function1 & Serializable)path -> "needs " + path + ";; ").mkString("+", "", "");
                    Path path3 = this.patch$1(component_dir, 1, this.patch$default$2$1());
                    boolean bl7 = File$.MODULE$.change_lines$default$2();
                    File$.MODULE$.change_lines(path3, bl7, true, (Function1<List<String>, List<String>>)(Function1 & Serializable)_$1 -> _$1.map((Function1 & Serializable)line -> {
                        String string = line;
                        String string2 = "+(*LOAD MORE*)";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            return more;
                        }
                        return line;
                    }));
                }
                this.run$1(progress, opam_env, hol_light_dir, 0, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"make"}));
                this.run$1(progress, opam_env, hol_light_dir, 1, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"patch -p1 < " + File$.MODULE$.bash_path(this.patch$1(component_dir, 1, this.patch$default$2$1())), "./ocaml-hol -I +compiler-libs stage1.ml"}));
                this.run$1(progress, opam_env, hol_light_dir, 2, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"patch -p1 < " + File$.MODULE$.bash_path(this.patch$1(component_dir, 2, this.patch$default$2$1())), "export MAXTMS=10000", "./ocaml-hol -I +compiler-libs stage2.ml"}));
                Bytes$.MODULE$.write(hol_light_dir.$plus(Path$.MODULE$.explode("maps.lst")), maps.isEmpty() ? Bytes$.MODULE$.empty() : Bytes$.MODULE$.read((Path)maps.get()));
                this.run$1(progress, opam_env, hol_light_dir, 3, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{File$.MODULE$.bash_path(platform_dir.$plus(offline_exe)), "zstd -8 proofsN"}));
                Path bundle_dir = Isabelle_System$.MODULE$.make_directory(component_dir.path().$plus(Path$.MODULE$.explode("bundle")));
                this.bundle_contents(preserve_raw).foreach((Function1)(JProcedure1 & Serializable)name -> Isabelle_System$.MODULE$.copy_file(hol_light_dir.$plus(Path$.MODULE$.explode((String)name)), bundle_dir));
                return;
            }
        });
    }

    public boolean build_hol_light_import$default$1() {
        return false;
    }

    public Progress build_hol_light_import$default$2() {
        return new Progress();
    }

    public Path build_hol_light_import$default$3() {
        return Path$.MODULE$.current();
    }

    public List<Path> build_hol_light_import$default$4() {
        return scala.package$.MODULE$.Nil();
    }

    public Option<Path> build_hol_light_import$default$5() {
        return Some$.MODULE$.apply((Object)this.default_maps());
    }

    public boolean build_hol_light_import$default$6() {
        return false;
    }

    public String build_hol_light_import$default$7() {
        return this.default_hol_light_url();
    }

    public String build_hol_light_import$default$8() {
        return this.default_hol_light_rev();
    }

    public Isabelle_Tool isabelle_tool() {
        return isabelle_tool;
    }

    private final String $anonfun$1() {
        return "\nUsage: isabelle component_hol_light_import [OPTIONS]\n\n  Options are:\n    -D DIR       target directory (default \".\")\n    -L PATH      load additional HOL Light files, after \"hol.ml\"\n    -M PATH      alternative maps.lst for offline alignment of facts\n                 (\".\" means empty, default: " + this.default_maps() + ")\n    -O           only build the \"offline\" tool\n    -P           preserve raw proofs, before offline alignment of facts\n    -U URL       git URL for original HOL Light repository, default:\n                 " + this.default_hol_light_url() + "\n    -r REV       revision or branch to checkout HOL Light (default: " + this.default_hol_light_rev() + ")\n    -v           verbose\n\n  Build Isabelle component for HOL Light import. For example:\n\n    isabelle component_hol_light_import -L Logic/make.ml\n    isabelle component_hol_light_import -L 100/thales.ml -L 100/ceva.ml\n\n  The HOL Light build process uses OCaml/OPAM from Isabelle; this requires\n  C development tools with libgmp-dev.\n";
    }

    private final Path patch$1(Components.Directory component_dir$2, int n, boolean source) {
        return (source ? this.hol_import_dir() : component_dir$2.path()).$plus(Path$.MODULE$.explode("patches/patch" + n));
    }

    private final boolean patch$default$2$1() {
        return false;
    }

    private final void run$1(Progress progress$2, String opam_env$1, Path hol_light_dir$2, int n, Seq lines) {
        String title = "stage " + n;
        if (n > 0) {
            progress$2.echo("Running " + title + " ...", progress$2.echo$default$2());
        }
        long start = Time$.MODULE$.now();
        String string = (String)package$.MODULE$.cat_lines().apply((Object)lines.toList().$colon$colon((Object)opam_env$1).$colon$colon((Object)"set -e"));
        boolean bl = progress$2.verbose();
        SSH.System system = progress$2.bash$default$2();
        Map<String, String> map = progress$2.bash$default$4();
        boolean bl2 = progress$2.bash$default$5();
        long l = progress$2.bash$default$7();
        boolean bl3 = progress$2.bash$default$8();
        progress$2.bash(string, system, hol_light_dir$2, map, bl2, bl, l, bl3).check().timing();
        long elapsed = Time$.MODULE$.$minus$extension(Time$.MODULE$.now(), start);
        if (n > 0) {
            progress$2.echo("Finished " + title + " (" + Time$.MODULE$.message_hms$extension(elapsed) + " elapsed time)", progress$2.echo$default$2());
            return;
        }
    }
}

