/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Component_JCEF;
import isabelle.Component_JCEF$JCEF_Platform$;
import isabelle.Components;
import isabelle.Components$Directory$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.Date$;
import isabelle.Date$Format$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.Isabelle_Tool$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Progress;
import isabelle.Scala_Project$;
import isabelle.package$;
import java.io.File;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class Component_JCEF$
implements Serializable {
    public static final Component_JCEF$JCEF_Platform$ JCEF_Platform;
    private static final List platforms;
    private static final String default_url;
    private static final String default_version;
    private static final Isabelle_Tool isabelle_tool;
    public static final Component_JCEF$ MODULE$;

    private Component_JCEF$() {
    }

    static {
        MODULE$ = new Component_JCEF$();
        String linux_library = "ISABELLE_JCEF_LIBRARY=\"$ISABELLE_JCEF_LIB/libcef.so\"\n      export LD_LIBRARY_PATH=\"$ISABELLE_JCEF_LIB:$JAVA_HOME/lib:$LD_LIBRARY_PATH\"";
        String macos_library = "export JAVA_LIBRARY_PATH=\"$ISABELLE_JCEF_HOME/bin/jcef_app.app/Contents/Java:$ISABELLE_JCEF_LIB:$JAVA_LIBRARY_PATH\"";
        String windows_library = "export PATH=\"$ISABELLE_JCEF_LIB:$PATH\"";
        platforms = (List)new .colon.colon((Object)Component_JCEF$JCEF_Platform$.MODULE$.apply("x86_64-linux", "linux-amd64.tar.gz", "bin/lib/linux64", linux_library), (List)new .colon.colon((Object)Component_JCEF$JCEF_Platform$.MODULE$.apply("arm64-linux", "linux-arm64.tar.gz", "bin/lib/linux64", linux_library), (List)new .colon.colon((Object)Component_JCEF$JCEF_Platform$.MODULE$.apply("x86_64-darwin", "macosx-amd64.tar.gz", "bin/jcef_app.app/Contents/Frameworks/Chromium Embedded Framework.framework/Libraries", macos_library), (List)new .colon.colon((Object)Component_JCEF$JCEF_Platform$.MODULE$.apply("arm64-darwin", "macosx-arm64.tar.gz", "bin/jcef_app.app/Contents/Frameworks/Chromium Embedded Framework.framework/Libraries", macos_library), (List)new .colon.colon((Object)Component_JCEF$JCEF_Platform$.MODULE$.apply("x86_64-windows", "windows-amd64.tar.gz", "bin/lib/win64", windows_library), (List)Nil$.MODULE$)))));
        default_url = "https://github.com/jcefmaven/jcefbuild/releases/download";
        default_version = "1.0.68";
        isabelle_tool = Isabelle_Tool$.MODULE$.apply("component_jcef", "build component for Java Chromium Embedded Framework", Scala_Project$.MODULE$.here(), (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)args -> {
            ObjectRef target_dir = ObjectRef.create((Object)Path$.MODULE$.current());
            ObjectRef base_url = ObjectRef.create((Object)this.default_url());
            ObjectRef version = ObjectRef.create((Object)this.default_version());
            Object[] objectArray = new Tuple2[3];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"D:");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)arg -> {
                target_dir$1.elem = Path$.MODULE$.explode((String)arg);
            });
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"U:");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (JProcedure1 & Serializable)arg -> {
                base_url$1.elem = arg;
            });
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"V:");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (JProcedure1 & Serializable)arg -> {
                version$1.elem = arg;
            });
            Getopts getopts = Getopts$.MODULE$.apply((Function0<String>)((Function0 & Serializable)this::$anonfun$1), (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            List<String> more_args = getopts.apply((List<String>)args);
            if (more_args.nonEmpty()) {
                throw getopts.usage(getopts.usage$default$1());
            }
            Console_Progress progress = new Console_Progress(Console_Progress$.MODULE$.$lessinit$greater$default$1(), Console_Progress$.MODULE$.$lessinit$greater$default$2(), Console_Progress$.MODULE$.$lessinit$greater$default$3(), Console_Progress$.MODULE$.$lessinit$greater$default$4());
            this.build_jcef((String)base_url.elem, (String)version.elem, (Path)target_dir.elem, progress);
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Component_JCEF$.class);
    }

    public List<Component_JCEF.JCEF_Platform> platforms() {
        return platforms;
    }

    public String default_url() {
        return default_url;
    }

    public String default_version() {
        return default_version;
    }

    public void build_jcef(String base_url, String version, Path target_dir, Progress progress) {
        String component = "jcef-" + version;
        Components.Directory directory = Components$Directory$.MODULE$.apply(target_dir.$plus(Path$.MODULE$.basic(component)), Components$Directory$.MODULE$.apply$default$2());
        Components.Directory component_dir = directory.create(progress, directory.create$default$2());
        List platform_settings = this.platforms().map((Function1 & Serializable)platform -> (String)Isabelle_System$.MODULE$.with_tmp_file("archive", "tar.gz", Isabelle_System$.MODULE$.with_tmp_file$default$3(), (Function1 & Serializable)archive_file -> {
            String url = base_url + "/" + version + "/" + platform.archive();
            Isabelle_System$.MODULE$.download_file(url, (Path)archive_file, progress);
            Path platform_dir = component_dir.path().$plus(Path$.MODULE$.explode(platform.platform_name()));
            Isabelle_System$.MODULE$.make_directory(platform_dir);
            Isabelle_System$.MODULE$.gnutar("-xzf " + File$.MODULE$.bash_path((Path)archive_file), platform_dir, Isabelle_System$.MODULE$.gnutar$default$3(), Isabelle_System$.MODULE$.gnutar$default$4(), Isabelle_System$.MODULE$.gnutar$default$5()).check();
            File$.MODULE$.find_files(platform_dir.file(), File$.MODULE$.find_files$default$2(), File$.MODULE$.find_files$default$3(), File$.MODULE$.find_files$default$4()).iterator().map((Function1 & Serializable)file -> {
                String name = file.getName();
                return Tuple2$.MODULE$.apply(file, (Object)name);
            }).withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    File file = (File)tuple2._1();
                    String name = (String)tuple2._2();
                    return File$.MODULE$.is_dll(name) || File$.MODULE$.is_exe(name);
                }
                throw new MatchError((Object)tuple2);
            }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    File file = (File)tuple2._1();
                    String name = (String)tuple2._2();
                    File$.MODULE$.set_executable(File$.MODULE$.path(file), File$.MODULE$.set_executable$default$2());
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
            String classpath = ((List)File$.MODULE$.find_files(platform_dir.file(), (Function1<File, Object>)(Function1 & Serializable)file -> File$.MODULE$.is_jar(file.getName()), File$.MODULE$.find_files$default$3(), File$.MODULE$.find_files$default$4()).flatMap((Function1 & Serializable)file -> File$.MODULE$.relative_path(platform_dir, File$.MODULE$.path((File)file))).map((Function1 & Serializable)_$1 -> _$1.implode()).sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)jar -> "        " + package$.MODULE$.quote().apply((Object)("$ISABELLE_JCEF_HOME/" + jar))).mkString(" \\\n");
            return "    " + platform.platform_name() + ")\n      classpath \\\n" + classpath + "\n      ISABELLE_JCEF_LIB=\"$ISABELLE_JCEF_HOME/" + platform.lib() + "\"\n      " + platform.library() + "\n      ;;";
        }));
        File$.MODULE$.write(component_dir.settings(), "# -*- shell-script -*- :mode=shellscript:\n\nISABELLE_JCEF_PLATFORM=\"${ISABELLE_WINDOWS_PLATFORM64:-${ISABELLE_APPLE_PLATFORM64:-$ISABELLE_PLATFORM64}}\"\nif [ -d \"$COMPONENT/$ISABELLE_JCEF_PLATFORM\" ]\nthen\n  ISABELLE_JCEF_HOME=\"$COMPONENT/$ISABELLE_JCEF_PLATFORM\"\n  ISABELLE_JCEF_LIBRARY=\"\"\n  case \"$ISABELLE_JCEF_PLATFORM\" in\n" + package$.MODULE$.cat_lines().apply((Object)platform_settings) + "\n  esac\nfi\n");
        File$.MODULE$.write(component_dir.README(), "This distribution of Java Chromium Embedded Framework (JCEF)\nhas been assembled from the binary builds from\nhttps://github.com/jcefmaven/jcefbuild/releases/tag/" + version + "\n\nExamples invocations:\n\n* Command-line\n\n  isabelle env bash -c 'isabelle java -Djava.library.path=\"$(platform_path \"$ISABELLE_JCEF_LIB\")\" tests.detailed.MainFrame'\n\n* Scala REPL (e.g. Isabelle/jEdit Console)\n\n  import isabelle._\n  System.setProperty(\"java.library.path\", File.platform_path(Path.explode(\"$ISABELLE_JCEF_LIB\")))\n  org.cef.CefApp.startup(Array())\n  GUI_Thread.later { val frame = new tests.detailed.MainFrame(false, false, false, 60, Array()); frame.setSize(1200,900); frame.setVisible(true) }\n\n* Demo websites\n\n    https://mozilla.github.io/pdf.js/web/viewer.html\n    https://www.w3schools.com/w3css/w3css_demo.asp\n\n\n        Makarius\n        " + Date$Format$.MODULE$.date().apply(Date$.MODULE$.now(Date$.MODULE$.now$default$1())) + "\n");
    }

    public String build_jcef$default$1() {
        return this.default_url();
    }

    public String build_jcef$default$2() {
        return this.default_version();
    }

    public Path build_jcef$default$3() {
        return Path$.MODULE$.current();
    }

    public Progress build_jcef$default$4() {
        return new Progress();
    }

    public Isabelle_Tool isabelle_tool() {
        return isabelle_tool;
    }

    private final String $anonfun$1() {
        return "\nUsage: isabelle component_jcef [OPTIONS]\n\n  Options are:\n    -D DIR       target directory (default \".\")\n    -U URL       download URL (default: \"" + this.default_url() + "\")\n    -V VERSION   version (default: \"" + this.default_version() + "\")\n\n  Build component for Java Chromium Embedded Framework.\n";
    }
}

