/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Bash;
import isabelle.Bash$;
import isabelle.Components;
import isabelle.Components$Directory$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.Date$;
import isabelle.Date$Format$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Isabelle_Platform;
import isabelle.Isabelle_Platform$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.Isabelle_Tool$;
import isabelle.Library$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Progress;
import isabelle.SSH;
import isabelle.Scala_Project$;
import isabelle.Url$;
import java.io.Serializable;
import java.util.Map;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class Component_Rsync$
implements Serializable {
    private static final String default_version;
    private static final String default_download_url;
    private static final List default_build_options;
    private static final Isabelle_Tool isabelle_tool;
    public static final Component_Rsync$ MODULE$;

    private Component_Rsync$() {
    }

    static {
        MODULE$ = new Component_Rsync$();
        default_version = "3.2.7";
        default_download_url = "https://github.com/WayneD/rsync/archive/refs/tags";
        default_build_options = (List)new .colon.colon((Object)"--disable-acl-support", (List)new .colon.colon((Object)"--disable-lz4", (List)new .colon.colon((Object)"--disable-md2man", (List)new .colon.colon((Object)"--disable-openssl", (List)new .colon.colon((Object)"--disable-xattr-support", (List)new .colon.colon((Object)"--disable-xxhash", (List)new .colon.colon((Object)"--disable-zstd", (List)Nil$.MODULE$)))))));
        isabelle_tool = Isabelle_Tool$.MODULE$.apply("component_rsync", "build rsync component from source distribution", Scala_Project$.MODULE$.here(), (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)args -> {
            ObjectRef target_dir = ObjectRef.create((Object)Path$.MODULE$.current());
            ObjectRef build_options = ObjectRef.create(this.default_build_options());
            ObjectRef version = ObjectRef.create((Object)this.default_version());
            ObjectRef download_url = ObjectRef.create((Object)this.default_download_url());
            BooleanRef verbose = BooleanRef.create((boolean)false);
            Object[] objectArray = new Tuple2[6];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"D:");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)arg -> {
                target_dir$1.elem = Path$.MODULE$.explode((String)arg);
            });
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"O:");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (JProcedure1 & Serializable)arg -> {
                build_options$1.elem = Library$.MODULE$.insert(arg, (List)build_options$1.elem);
            });
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"R:");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (JProcedure1 & Serializable)arg -> {
                build_options$2.elem = Library$.MODULE$.remove(arg, (List)build_options$2.elem);
            });
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"U:");
            objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (JProcedure1 & Serializable)arg -> {
                download_url$1.elem = arg;
            });
            String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"V:");
            objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (JProcedure1 & Serializable)arg -> {
                version$1.elem = arg;
            });
            String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"v");
            objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (JProcedure1 & Serializable)_$3 -> {
                verbose$1.elem = true;
            });
            Getopts getopts = Getopts$.MODULE$.apply((Function0<String>)((Function0 & Serializable)this::$anonfun$1), (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            List<String> more_args = getopts.apply((List<String>)args);
            if (more_args.nonEmpty()) {
                throw getopts.usage(getopts.usage$default$1());
            }
            Console_Progress progress = new Console_Progress(verbose.elem, Console_Progress$.MODULE$.$lessinit$greater$default$2(), Console_Progress$.MODULE$.$lessinit$greater$default$3(), Console_Progress$.MODULE$.$lessinit$greater$default$4());
            this.build_rsync((String)version.elem, (String)download_url.elem, progress, (Path)target_dir.elem, (List<String>)((List)build_options.elem));
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Component_Rsync$.class);
    }

    public Path home() {
        return Path$.MODULE$.explode("$ISABELLE_RSYNC_HOME");
    }

    public Path local_program() {
        return Path$.MODULE$.explode("$ISABELLE_RSYNC");
    }

    public Path remote_program(Components.Directory directory) {
        Isabelle_Platform isabelle_Platform = directory.ssh().isabelle_platform();
        String platform = isabelle_Platform.ISABELLE_PLATFORM(isabelle_Platform.ISABELLE_PLATFORM$default$1(), true);
        return directory.path().$plus(Path$.MODULE$.basic(platform)).$plus(Path$.MODULE$.basic("rsync"));
    }

    public String default_version() {
        return default_version;
    }

    public String default_download_url() {
        return default_download_url;
    }

    public List<String> default_build_options() {
        return default_build_options;
    }

    public void build_rsync(String version, String download_url, Progress progress, Path target_dir, List<String> build_options) {
        Isabelle_System$.MODULE$.with_tmp_dir("build", Isabelle_System$.MODULE$.with_tmp_dir$default$2(), (JProcedure1 & Serializable)tmp_dir -> {
            String component_name = "rsync-" + version;
            Components.Directory directory = Components$Directory$.MODULE$.apply(target_dir.$plus(Path$.MODULE$.basic(component_name)), Components$Directory$.MODULE$.apply$default$2());
            Components.Directory directory2 = directory.create(progress, directory.create$default$2());
            Components.Directory component_dir = directory2.write_platforms(directory2.write_platforms$default$1());
            String platform_name = Isabelle_Platform$.MODULE$.local().ISABELLE_PLATFORM(Isabelle_Platform$.MODULE$.local().ISABELLE_PLATFORM$default$1(), true);
            Path platform_dir = Isabelle_System$.MODULE$.make_directory(component_dir.path().$plus(Path$.MODULE$.basic(platform_name)));
            String archive_name = "v" + version + ".tar.gz";
            Path archive_path = tmp_dir.$plus(Path$.MODULE$.explode(archive_name));
            String archive_url = Url$.MODULE$.append_path(download_url, archive_name);
            Isabelle_System$.MODULE$.download_file(archive_url, archive_path, progress);
            Isabelle_System$.MODULE$.extract(archive_path, (Path)tmp_dir, Isabelle_System$.MODULE$.extract$default$3());
            Path source_dir = File$.MODULE$.get_dir((Path)tmp_dir, archive_url);
            Isabelle_System$.MODULE$.extract(archive_path, component_dir.src(), true);
            progress.echo("Building rsync for " + platform_name + " ...", progress.echo$default$2());
            List build_script = (List)new .colon.colon((Object)("./configure " + Bash$.MODULE$.strings((Iterable<String>)((Iterable)build_options.sorted((Ordering)Ordering.String$.MODULE$)))), (List)new .colon.colon((Object)"make", (List)Nil$.MODULE$));
            String string = build_script.mkString(" && ");
            JProcedure1 & Serializable intersect = (JProcedure1 & Serializable)_$1 -> progress.echo((String)_$1, true);
            JProcedure1 & Serializable intersect2 = (JProcedure1 & Serializable)_$2 -> progress.echo((String)_$2, true);
            String string2 = Isabelle_System$.MODULE$.bash$default$2();
            SSH.System system = Isabelle_System$.MODULE$.bash$default$3();
            Map<String, String> map = Isabelle_System$.MODULE$.bash$default$5();
            boolean bl = Isabelle_System$.MODULE$.bash$default$6();
            String string3 = Isabelle_System$.MODULE$.bash$default$7();
            Bash.Watchdog watchdog = Isabelle_System$.MODULE$.bash$default$10();
            boolean bl2 = Isabelle_System$.MODULE$.bash$default$11();
            Function0<BoxedUnit> function0 = Isabelle_System$.MODULE$.bash$default$12();
            Isabelle_System$.MODULE$.bash(string, string2, system, source_dir, map, bl, string3, (Function1<String, BoxedUnit>)intersect, (Function1<String, BoxedUnit>)intersect2, watchdog, bl2, function0).check();
            Isabelle_System$.MODULE$.copy_file(source_dir.$plus(Path$.MODULE$.explode("COPYING")), component_dir.LICENSE());
            Isabelle_System$.MODULE$.copy_file(source_dir.$plus(Path$.MODULE$.explode("rsync").platform_exe()), platform_dir);
            component_dir.write_settings("\nISABELLE_RSYNC_HOME=\"$COMPONENT\"\nISABELLE_RSYNC=\"$ISABELLE_RSYNC_HOME/${ISABELLE_APPLE_PLATFORM64:-$ISABELLE_PLATFORM64}/rsync\"\n");
            File$.MODULE$.write(component_dir.README(), "This is rsync " + version + " from " + download_url + "\n\nThe distribution has been built like this:\n\n" + build_script.$colon$colon((Object)"cd src").map((Function1 & Serializable)s -> "  " + s + "\n").mkString() + "\nSee also:\n  * https://github.com/WayneD/rsync\n  * https://rsync.samba.org\n\n\n        Makarius\n        " + Date$Format$.MODULE$.date().apply(Date$.MODULE$.now(Date$.MODULE$.now$default$1())) + "\n");
        });
    }

    public String build_rsync$default$1() {
        return this.default_version();
    }

    public String build_rsync$default$2() {
        return this.default_download_url();
    }

    public Progress build_rsync$default$3() {
        return new Progress();
    }

    public Path build_rsync$default$4() {
        return Path$.MODULE$.current();
    }

    public List<String> build_rsync$default$5() {
        return this.default_build_options();
    }

    public Isabelle_Tool isabelle_tool() {
        return isabelle_tool;
    }

    private final String $anonfun$1() {
        return "\nUsage: isabelle component_rsync [OPTIONS]\n\n  Options are:\n    -D DIR       target directory (default \".\")\n    -O OPT       add build option\n    -R OPT       remove build option\n    -U URL       download URL\n                 (default: \"" + this.default_download_url() + "\")\n    -V VERSION   version (default: " + this.default_version() + ")\n    -v           verbose\n\n  Build rsync component from the specified source distribution.\n\n  The default build options (for ./configure) are:\n" + this.default_build_options().map((Function1 & Serializable)opt -> "    " + opt + "\n").mkString();
    }
}

