/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Component_Zstd;
import isabelle.Component_Zstd$Platform_Info$;
import isabelle.Components;
import isabelle.Components$Directory$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.Date$;
import isabelle.Date$Format$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.Isabelle_Tool$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Progress;
import isabelle.Scala_Project$;
import isabelle.package$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class Component_Zstd$
implements Serializable {
    public static final Component_Zstd$Platform_Info$ Platform_Info;
    private static final List<Component_Zstd.Platform_Info> platforms;
    private static final String license_url;
    private static final String default_download_url;
    private static final String default_version;
    private static final Isabelle_Tool isabelle_tool;
    public static final Component_Zstd$ MODULE$;

    private Component_Zstd$() {
    }

    static {
        MODULE$ = new Component_Zstd$();
        platforms = (List)new .colon.colon((Object)Component_Zstd$Platform_Info$.MODULE$.apply("arm64-darwin", "darwin/aarch64/libzstd-jni-{V}.dylib", Component_Zstd$Platform_Info$.MODULE$.$lessinit$greater$default$3()), (List)new .colon.colon((Object)Component_Zstd$Platform_Info$.MODULE$.apply("x86_64-darwin", "darwin/x86_64/libzstd-jni-{V}.dylib", Component_Zstd$Platform_Info$.MODULE$.$lessinit$greater$default$3()), (List)new .colon.colon((Object)Component_Zstd$Platform_Info$.MODULE$.apply("arm64-linux", "linux/aarch64/libzstd-jni-{V}.so", Component_Zstd$Platform_Info$.MODULE$.$lessinit$greater$default$3()), (List)new .colon.colon((Object)Component_Zstd$Platform_Info$.MODULE$.apply("x86_64-linux", "linux/amd64/libzstd-jni-{V}.so", Component_Zstd$Platform_Info$.MODULE$.$lessinit$greater$default$3()), (List)new .colon.colon((Object)Component_Zstd$Platform_Info$.MODULE$.apply("x86_64-windows", "win/amd64/libzstd-jni-{V}.dll", true), (List)Nil$.MODULE$)))));
        license_url = "https://raw.githubusercontent.com/luben/zstd-jni/master/LICENSE";
        default_download_url = "https://repo1.maven.org/maven2/com/github/luben/zstd-jni";
        default_version = "1.5.7-6";
        isabelle_tool = Isabelle_Tool$.MODULE$.apply("component_zstd", "build Isabelle zstd-jni component from official download", Scala_Project$.MODULE$.here(), (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)args -> {
            ObjectRef target_dir = ObjectRef.create((Object)Path$.MODULE$.current());
            ObjectRef download_url = ObjectRef.create((Object)this.default_download_url());
            ObjectRef version = ObjectRef.create((Object)this.default_version());
            Object[] objectArray = new Tuple2[3];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"D:");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)arg -> {
                target_dir$1.elem = Path$.MODULE$.explode((String)arg);
            });
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"U:");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (JProcedure1 & Serializable)arg -> {
                download_url$1.elem = arg;
            });
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"V:");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (JProcedure1 & Serializable)arg -> {
                version$1.elem = arg;
            });
            Getopts getopts = Getopts$.MODULE$.apply((Function0<String>)((Function0 & Serializable)this::$anonfun$1), (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            List<String> more_args = getopts.apply((List<String>)args);
            if (more_args.nonEmpty()) {
                throw getopts.usage(getopts.usage$default$1());
            }
            Console_Progress progress = new Console_Progress(Console_Progress$.MODULE$.$lessinit$greater$default$1(), Console_Progress$.MODULE$.$lessinit$greater$default$2(), Console_Progress$.MODULE$.$lessinit$greater$default$3(), Console_Progress$.MODULE$.$lessinit$greater$default$4());
            this.build_zstd((Path)target_dir.elem, (String)download_url.elem, (String)version.elem, progress);
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Component_Zstd$.class);
    }

    public String license_url() {
        return license_url;
    }

    public String default_download_url() {
        return default_download_url;
    }

    public String default_version() {
        return default_version;
    }

    public void build_zstd(Path target_dir, String download_url, String version, Progress progress) {
        String component_name = "zstd-jni-" + version;
        Components.Directory directory = Components$Directory$.MODULE$.apply(target_dir.$plus(Path$.MODULE$.basic(component_name)), Components$Directory$.MODULE$.apply$default$2());
        Components.Directory component_dir = directory.create(progress, directory.create$default$2());
        File$.MODULE$.write(component_dir.README(), "This is " + component_name + " from\n" + download_url + "\n\n        Makarius\n        " + Date$Format$.MODULE$.date().apply(Date$.MODULE$.now(Date$.MODULE$.now$default$1())) + "\n");
        Isabelle_System$.MODULE$.download_file(this.license_url(), component_dir.LICENSE(), progress);
        Isabelle_System$.MODULE$.make_directory(component_dir.lib());
        String jar_name = component_name + ".jar";
        Path jar = component_dir.lib().$plus(Path$.MODULE$.basic(jar_name));
        Isabelle_System$.MODULE$.download_file(download_url + "/" + version + "/" + jar_name, jar, progress);
        Isabelle_System$.MODULE$.with_tmp_dir("build", Isabelle_System$.MODULE$.with_tmp_dir$default$2(), (JProcedure1 & Serializable)jar_dir -> {
            Isabelle_System$.MODULE$.extract(jar, (Path)jar_dir, Isabelle_System$.MODULE$.extract$default$3());
            platforms.foreach((Function1)(JProcedure1 & Serializable)platform -> platform.install((Path)jar_dir, component_dir.path(), version));
        });
        component_dir.write_settings("\nISABELLE_ZSTD_HOME=\"$COMPONENT\"\n\nclasspath \"$ISABELLE_ZSTD_HOME/lib/" + jar_name + "\"\n");
    }

    public Path build_zstd$default$1() {
        return Path$.MODULE$.current();
    }

    public String build_zstd$default$2() {
        return this.default_download_url();
    }

    public String build_zstd$default$3() {
        return this.default_version();
    }

    public Progress build_zstd$default$4() {
        return new Progress();
    }

    public Isabelle_Tool isabelle_tool() {
        return isabelle_tool;
    }

    private final String $anonfun$1() {
        return "\nUsage: isabelle component_zstd [OPTIONS]\n\n  Options are:\n    -D DIR       target directory (default \".\")\n    -U URL       download URL (default: " + package$.MODULE$.quote().apply((Object)this.default_download_url()) + ")\n    -V VERSION   version (default: " + package$.MODULE$.quote().apply((Object)this.default_version()) + ")\n\n  Build zstd-jni component from the specified download base URL and VERSION,\n  see also https://github.com/luben/zstd-jni\n";
    }
}

