/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Bash$;
import isabelle.Command_Line$;
import isabelle.Components;
import isabelle.Components$Archive$;
import isabelle.Components$Directory$;
import isabelle.Components$Platforms$;
import isabelle.Components$SHA1_Entry$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.Isabelle_Tool$;
import isabelle.Library$;
import isabelle.Options;
import isabelle.Options$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Platform;
import isabelle.Platform$Family$;
import isabelle.Process_Result;
import isabelle.Progress;
import isabelle.SHA1$;
import isabelle.SSH;
import isabelle.SSH$;
import isabelle.SSH$Local$;
import isabelle.Scala_Project$;
import isabelle.Url$;
import isabelle.Word$;
import isabelle.package$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class Components$
implements Serializable {
    public static final Components$Archive$ Archive;
    public static final Components$Platforms$ Platforms;
    private static final Components.Platforms default_platforms;
    private static final Path default_components_base;
    private static final String dynamic_components_base;
    private static final Path classic_components_base;
    private static final List default_catalogs;
    private static final List optional_catalogs;
    public static final Components$Directory$ Directory;
    private static final Path components_sha1;
    public static final Components$SHA1_Entry$ SHA1_Entry;
    private static final Path components_path;
    private static final List<String> relevant_options;
    private static final Isabelle_Tool isabelle_tool;
    public static final Components$ MODULE$;

    private Components$() {
    }

    static {
        MODULE$ = new Components$();
        Object[] objectArray = new Tuple2[5];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)Platform$Family$.linux_arm.toString());
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)MODULE$.paths$1((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"arm64-linux", "arm64_32-linux"})));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)Platform$Family$.linux.toString());
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)MODULE$.paths$1((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x86_64-linux", "x86_64_32-linux"})));
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)Platform$Family$.macos.toString());
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)MODULE$.paths$1((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"arm64-darwin", "arm64_32-darwin", "x86_64-darwin", "x86_64_32-darwin"})));
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)Platform$Family$.windows.toString());
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)MODULE$.paths$1((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x86_64-cygwin", "x86_64-windows", "x86_64_32-windows", "x86-windows"})));
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"obsolete");
        objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)MODULE$.paths$1((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x86-linux", "x86-cygwin"})));
        default_platforms = Components$Platforms$.MODULE$.apply((Map<String, List<Path>>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
        default_components_base = Path$.MODULE$.explode("$ISABELLE_COMPONENTS_BASE");
        dynamic_components_base = "${ISABELLE_COMPONENTS_BASE:-$USER_HOME/.isabelle/contrib}";
        classic_components_base = Path$.MODULE$.explode("$USER_HOME/.isabelle/contrib");
        default_catalogs = (List)new .colon.colon((Object)"main", (List)Nil$.MODULE$);
        optional_catalogs = (List)new .colon.colon((Object)"main", (List)new .colon.colon((Object)"optional", (List)Nil$.MODULE$));
        components_sha1 = Path$.MODULE$.explode("~~/Admin/components/components.sha1");
        components_path = Path$.MODULE$.explode("$ISABELLE_HOME_USER/etc/components");
        relevant_options = (List)new .colon.colon((Object)"isabelle_components_server", (List)new .colon.colon((Object)"isabelle_components_dir", (List)new .colon.colon((Object)"isabelle_components_contrib_dir", (List)Nil$.MODULE$)));
        isabelle_tool = Isabelle_Tool$.MODULE$.apply("components_build", "build and publish Isabelle components", Scala_Project$.MODULE$.here(), (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)args -> {
            BooleanRef publish = BooleanRef.create((boolean)false);
            BooleanRef update_components_sha1 = BooleanRef.create((boolean)false);
            BooleanRef force = BooleanRef.create((boolean)false);
            ObjectRef options = ObjectRef.create((Object)Options$.MODULE$.init(Options$.MODULE$.init$default$1(), Options$.MODULE$.init$default$2()));
            Object[] objectArray = new Tuple2[4];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"P");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)_$9 -> {
                publish$1.elem = true;
            });
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"f");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (JProcedure1 & Serializable)_$10 -> {
                force$1.elem = true;
            });
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"o:");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (JProcedure1 & Serializable)arg -> {
                options$2.elem = ((Options)options$2.elem).$plus((String)arg);
            });
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"u");
            objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (JProcedure1 & Serializable)_$11 -> {
                update_components_sha1$1.elem = true;
            });
            Getopts getopts = Getopts$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> this.$anonfun$1(options)), (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            List<String> more_args = getopts.apply((List<String>)args);
            if (more_args.isEmpty() && !update_components_sha1.elem) {
                throw getopts.usage(getopts.usage$default$1());
            }
            Console_Progress progress = new Console_Progress(Console_Progress$.MODULE$.$lessinit$greater$default$1(), Console_Progress$.MODULE$.$lessinit$greater$default$2(), Console_Progress$.MODULE$.$lessinit$greater$default$3(), Console_Progress$.MODULE$.$lessinit$greater$default$4());
            this.components_build((Options)options.elem, (List<Path>)more_args.map((Function1 & Serializable)str -> Path$.MODULE$.explode((String)str)), progress, publish.elem, force.elem, update_components_sha1.elem);
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Components$.class);
    }

    public Components.Platforms default_platforms() {
        return default_platforms;
    }

    public String static_component_repository() {
        return Isabelle_System$.MODULE$.getenv("ISABELLE_COMPONENT_REPOSITORY", Isabelle_System$.MODULE$.getenv$default$2());
    }

    public Path default_components_base() {
        return default_components_base;
    }

    public String dynamic_components_base() {
        return dynamic_components_base;
    }

    public Path classic_components_base() {
        return classic_components_base;
    }

    public List<String> default_catalogs() {
        return default_catalogs;
    }

    public List<String> optional_catalogs() {
        return optional_catalogs;
    }

    public Path admin(Path dir) {
        return dir.$plus(Path$.MODULE$.explode("Admin/components"));
    }

    public Path contrib(Path dir, String name) {
        return dir.$plus(Path$.MODULE$.explode("contrib")).$plus(Path$.MODULE$.explode(name));
    }

    public Path contrib$default$1() {
        return Path$.MODULE$.current();
    }

    public String contrib$default$2() {
        return "";
    }

    public String unpack(Path dir, Path archive, SSH.System ssh, Progress progress) {
        String name = Components$Archive$.MODULE$.get_name(archive.file_name());
        progress.echo("Unpacking " + archive.base(), progress.echo$default$2());
        ssh.execute("tar -C " + ssh.bash_path(dir) + " -x -z -f " + ssh.bash_path(archive), (Function1<String, BoxedUnit>)(JProcedure1 & Serializable)_$1 -> progress.echo((String)_$1, progress.echo$default$2()), (Function1<String, BoxedUnit>)(JProcedure1 & Serializable)_$2 -> progress.echo((String)_$2, progress.echo$default$2()), ssh.execute$default$4(), ssh.execute$default$5(), ssh.execute$default$6()).check();
        return name;
    }

    public SSH.System unpack$default$3() {
        return SSH$Local$.MODULE$;
    }

    public Progress unpack$default$4() {
        return new Progress();
    }

    public void clean_base(Path base_dir, List<Platform.Family> platforms, SSH.System ssh, Progress progress) {
        ssh.read_dir(base_dir).map((Function1 & Serializable)name -> {
            Path dir = base_dir.$plus(Path$.MODULE$.basic((String)name));
            return Tuple2$.MODULE$.apply(name, (Object)dir);
        }).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Path dir = (Path)tuple2._2();
                return this.is_component_dir(dir, this.is_component_dir$default$2());
            }
            throw new MatchError((Object)tuple2);
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Path dir = (Path)tuple2._2();
                Components$Directory$.MODULE$.apply(dir, ssh).clean(platforms, progress);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public List<Platform.Family> clean_base$default$2() {
        return Platform$Family$.MODULE$.list();
    }

    public SSH.System clean_base$default$3() {
        return SSH$Local$.MODULE$;
    }

    public Progress clean_base$default$4() {
        return new Progress();
    }

    public void resolve(Path base_dir, String name, Option<Path> target_dir, Option<Path> copy_dir, Option<List<Platform.Family>> clean_platforms, boolean clean_archives, String component_repository, SSH.System ssh, Progress progress) {
        ssh.make_directory(base_dir);
        String archive_name = Components$Archive$.MODULE$.apply(name);
        Path archive = base_dir.$plus(Path$.MODULE$.basic(archive_name));
        if (!ssh.is_file(archive)) {
            String remote = Url$.MODULE$.append_path(component_repository, archive_name);
            ssh.download_file(remote, archive, progress);
        }
        copy_dir.foreach((Function1)(JProcedure1 & Serializable)dir -> {
            ssh.make_directory((Path)dir);
            ssh.copy_file(archive, (Path)dir);
        });
        Path unpack_dir = (Path)target_dir.getOrElse(() -> Components$.$anonfun$6(base_dir));
        this.unpack(unpack_dir, archive, ssh, progress);
        if (clean_platforms.isDefined()) {
            Components$Directory$.MODULE$.apply(unpack_dir.$plus(Path$.MODULE$.basic(name)), ssh).clean((List<Platform.Family>)((List)clean_platforms.get()), progress);
        }
        if (clean_archives) {
            progress.echo("Removing " + package$.MODULE$.quote().apply((Object)archive_name), progress.echo$default$2());
            ssh.delete((Seq<Path>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Path[]{archive}));
            return;
        }
    }

    public Option<Path> resolve$default$3() {
        return None$.MODULE$;
    }

    public Option<Path> resolve$default$4() {
        return None$.MODULE$;
    }

    public Option<List<Platform.Family>> resolve$default$5() {
        return None$.MODULE$;
    }

    public boolean resolve$default$6() {
        return false;
    }

    public String resolve$default$7() {
        return this.static_component_repository();
    }

    public SSH.System resolve$default$8() {
        return SSH$Local$.MODULE$;
    }

    public Progress resolve$default$9() {
        return new Progress();
    }

    public Components.Directory provide(Path local_dir, Path base_dir, SSH.System ssh, Progress progress) {
        Path base_name = local_dir.expand().base();
        Components$Directory$.MODULE$.apply(local_dir, Components$Directory$.MODULE$.apply$default$2()).check();
        Components.Directory remote_directory = Components$Directory$.MODULE$.apply(base_dir.$plus(base_name), ssh);
        if (remote_directory.ok()) {
            return remote_directory;
        }
        progress.echo("Providing " + base_name + ssh.print(), progress.echo$default$2());
        Isabelle_System$.MODULE$.with_tmp_file("tmp", "tar", Isabelle_System$.MODULE$.with_tmp_file$default$3(), (Function1 & Serializable)local_tmp_tar -> (Process_Result)ssh.with_tmp_dir((Function1 & Serializable)remote_tmp_dir -> {
            Path remote_tmp_tar = remote_tmp_dir.$plus(Path$.MODULE$.basic("tmp.tar"));
            Path remote_dir = ssh.make_directory(remote_directory.path());
            Isabelle_System$.MODULE$.gnutar("-cf " + File$.MODULE$.bash_path((Path)local_tmp_tar) + " .", local_dir, Isabelle_System$.MODULE$.gnutar$default$3(), Isabelle_System$.MODULE$.gnutar$default$4(), Isabelle_System$.MODULE$.gnutar$default$5()).check();
            ssh.write_file(remote_tmp_tar, (Path)local_tmp_tar);
            return ssh.execute("tar -C " + ssh.bash_path(remote_dir) + " -xf " + ssh.bash_path(remote_tmp_tar), ssh.execute$default$2(), ssh.execute$default$3(), ssh.execute$default$4(), ssh.execute$default$5(), ssh.execute$default$6()).check();
        }));
        return remote_directory.check();
    }

    public Path provide$default$2() {
        return this.classic_components_base();
    }

    public SSH.System provide$default$3() {
        return SSH$Local$.MODULE$;
    }

    public Progress provide$default$4() {
        return new Progress();
    }

    public List<Path> directories() {
        return Path$.MODULE$.split(Isabelle_System$.MODULE$.getenv_strict("ISABELLE_COMPONENTS", Isabelle_System$.MODULE$.getenv_strict$default$2()));
    }

    public boolean is_component_dir(Path dir, SSH.System ssh) {
        return ssh.is_file(dir.$plus(Path$.MODULE$.explode("etc/settings"))) || ssh.is_file(dir.$plus(Path$.MODULE$.explode("etc/components")));
    }

    public SSH.System is_component_dir$default$2() {
        return SSH$Local$.MODULE$;
    }

    public Path components_sha1() {
        return components_sha1;
    }

    public List<Components.SHA1_Entry> read_components_sha1(List<String> lines) {
        return ((List)package$.MODULE$.proper_list(lines).getOrElse(Components$::read_components_sha1$$anonfun$1)).flatMap((Function1 & Serializable)line -> {
            SeqOps seqOps;
            List<String> list = Word$.MODULE$.explode((String)line);
            Nil$ nil$ = scala.package$.MODULE$.Nil();
            List<String> list2 = list;
            if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                return None$.MODULE$;
            }
            if (list != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = scala.package$.MODULE$.List().unapplySeq(list), 2) == 0) {
                String string = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                String string2 = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 1);
                String sha1 = string;
                String name = string2;
                return Some$.MODULE$.apply((Object)Components$SHA1_Entry$.MODULE$.apply(SHA1$.MODULE$.fake_digest(sha1), name));
            }
            return (Option)package$.MODULE$.error().apply((Object)("Bad components.sha1 entry: " + package$.MODULE$.quote().apply(line)));
        });
    }

    public List<String> read_components_sha1$default$1() {
        return scala.package$.MODULE$.Nil();
    }

    public void write_components_sha1(List<Components.SHA1_Entry> entries) {
        File$.MODULE$.write(this.components_sha1(), ((IterableOnceOps)entries.sortBy((Function1 & Serializable)_$6 -> _$6.name(), (Ordering)Ordering.String$.MODULE$)).mkString());
    }

    public Path components_path() {
        return components_path;
    }

    public List<String> read_components() {
        if (this.components_path().is_file()) {
            return Library$.MODULE$.trim_split_lines(File$.MODULE$.read(this.components_path()));
        }
        return scala.package$.MODULE$.Nil();
    }

    public void write_components(List<String> lines) {
        Isabelle_System$.MODULE$.make_directory(this.components_path().dir());
        File$.MODULE$.write(this.components_path(), (String)package$.MODULE$.terminate_lines().apply(lines));
    }

    public void update_components(boolean add, Path path0, Progress progress) {
        Path path = path0.expand().absolute();
        if (add) {
            Components$Directory$.MODULE$.apply(path, Components$Directory$.MODULE$.apply$default$2()).check();
        }
        List<String> lines1 = this.read_components();
        List lines2 = lines1.filter((Function1 & Serializable)line -> line.isEmpty() || line.startsWith("#") || !File$.MODULE$.eq(Path$.MODULE$.explode((String)line), path));
        List lines3 = add ? ((List)new .colon.colon((Object)path.implode(), (List)Nil$.MODULE$)).$colon$colon$colon(lines2) : lines2;
        List<String> list = lines1;
        List list2 = lines3;
        if (list == null ? list2 != null : !list.equals((Object)list2)) {
            this.write_components((List<String>)lines3);
        }
        List<String> list3 = lines1;
        List list4 = lines3;
        String prefix = !(list3 != null ? !list3.equals((Object)list4) : list4 != null) ? "Unchanged" : (add ? "Added" : "Removed");
        progress.echo(prefix + " component " + path, progress.echo$default$2());
    }

    public Progress update_components$default$3() {
        return new Progress();
    }

    public void main(String[] args) {
        Command_Line$.MODULE$.tool((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            Components$.main$$anonfun$1(args);
            return BoxedUnit.UNIT;
        });
    }

    public void components_build(Options options, List<Path> components, Progress progress, boolean publish, boolean force, boolean update_components_sha1) {
        List archives = components.map((Function1 & Serializable)path -> {
            Option<String> option;
            String string = path.file_name();
            if (string != null && !(option = Components$Archive$.MODULE$.unapply(string)).isEmpty()) {
                String string2 = (String)option.get();
                return path;
            }
            String name = string;
            Components$Directory$.MODULE$.apply((Path)path, Components$Directory$.MODULE$.apply$default$2()).check();
            Path component_path = path.expand();
            Path archive_dir = component_path.dir();
            String archive_name = Components$Archive$.MODULE$.apply(name);
            Path archive = archive_dir.$plus(Path$.MODULE$.explode(archive_name));
            if (archive.is_file() && !force) {
                package$.MODULE$.error().apply((Object)("Component archive already exists: " + archive));
            }
            progress.echo("Packaging " + archive_name, progress.echo$default$2());
            Isabelle_System$.MODULE$.gnutar("-czf " + File$.MODULE$.bash_path(archive) + " " + Bash$.MODULE$.string(name), archive_dir, Isabelle_System$.MODULE$.gnutar$default$3(), Isabelle_System$.MODULE$.gnutar$default$4(), Isabelle_System$.MODULE$.gnutar$default$5()).check();
            return archive;
        });
        if (publish && archives.nonEmpty() || update_components_sha1) {
            String server = options.string().apply("isabelle_components_server");
            if (server.isEmpty()) {
                package$.MODULE$.error().apply((Object)"Undefined option isabelle_components_server");
            }
            package$.MODULE$.using(SSH$.MODULE$.open_session(options, server, SSH$.MODULE$.open_session$default$3(), SSH$.MODULE$.open_session$default$4(), SSH$.MODULE$.open_session$default$5()), (JProcedure1 & Serializable)ssh -> {
                Path components_dir = Path$.MODULE$.explode(options.string().apply("isabelle_components_dir"));
                Path contrib_dir = Path$.MODULE$.explode(options.string().apply("isabelle_components_contrib_dir"));
                ((IterableOps)new .colon.colon((Object)components_dir, (List)new .colon.colon((Object)contrib_dir, (List)Nil$.MODULE$))).withFilter((Function1 & Serializable)dir -> !ssh.is_dir((Path)dir)).foreach((Function1 & Serializable)dir -> package$.MODULE$.error().apply((Object)("Bad remote directory: " + dir)));
                if (publish) {
                    archives.foreach((Function1 & Serializable)archive -> {
                        String archive_name = archive.file_name();
                        String name = Components$Archive$.MODULE$.get_name(archive_name);
                        Path remote_component = components_dir.$plus(archive.base());
                        Path remote_contrib = contrib_dir.$plus(Path$.MODULE$.explode(name));
                        if (ssh.is_file(remote_component) && !force) {
                            package$.MODULE$.error().apply((Object)("Remote component archive already exists: " + remote_component));
                        }
                        progress.echo("Uploading " + archive_name, progress.echo$default$2());
                        ssh.write_file(remote_component, (Path)archive);
                        boolean is_standard_component = BoxesRunTime.unboxToBoolean(Isabelle_System$.MODULE$.with_tmp_dir("component", Isabelle_System$.MODULE$.with_tmp_dir$default$2(), (Function1 & Serializable)tmp_dir -> {
                            Isabelle_System$.MODULE$.extract((Path)archive, (Path)tmp_dir, Isabelle_System$.MODULE$.extract$default$3());
                            return Components$Directory$.MODULE$.apply(tmp_dir.$plus(Path$.MODULE$.explode(name)), Components$Directory$.MODULE$.apply$default$2()).ok();
                        }));
                        if (is_standard_component) {
                            if (ssh.is_dir(remote_contrib)) {
                                if (force) {
                                    ssh.rm_tree(remote_contrib);
                                } else {
                                    package$.MODULE$.error().apply((Object)("Remote component directory already exists: " + remote_contrib));
                                }
                            }
                            progress.echo("Unpacking remote " + archive_name, progress.echo$default$2());
                            return ssh.execute("tar -C " + ssh.bash_path(contrib_dir) + " -xzf " + ssh.bash_path(remote_component), ssh.execute$default$2(), ssh.execute$default$3(), ssh.execute$default$4(), ssh.execute$default$5(), ssh.execute$default$6()).check();
                        }
                        progress.echo_warning("No unpacking of non-standard component: " + archive_name, progress.echo_warning$default$2());
                        return BoxedUnit.UNIT;
                    });
                }
                if (update_components_sha1) {
                    List lines = (List)ssh.read_dir(components_dir).withFilter((Function1 & Serializable)entry -> ssh.is_file(components_dir.$plus(Path$.MODULE$.basic((String)entry))) && entry.endsWith(Components$Archive$.MODULE$.suffix())).map((Function1 & Serializable)entry -> {
                        progress.echo("Digesting remote " + entry, progress.echo$default$2());
                        return ssh.execute("cd " + ssh.bash_path(components_dir) + "; sha1sum " + Bash$.MODULE$.string((String)entry), ssh.execute$default$2(), ssh.execute$default$3(), ssh.execute$default$4(), ssh.execute$default$5(), ssh.execute$default$6()).check().out();
                    });
                    MODULE$.write_components_sha1(MODULE$.read_components_sha1((List<String>)lines));
                    return;
                }
            });
        }
        List new_entries = archives.map((Function1 & Serializable)archive -> {
            String name = archive.file_name();
            progress.echo("Digesting local " + name, progress.echo$default$2());
            return Components$SHA1_Entry$.MODULE$.apply(SHA1$.MODULE$.digest((Path)archive), name);
        });
        Set new_names = new_entries.map((Function1 & Serializable)_$7 -> _$7.name()).toSet();
        this.write_components_sha1((List<Components.SHA1_Entry>)this.read_components_sha1(this.read_components_sha1$default$1()).filterNot((Function1 & Serializable)entry -> new_names.contains((Object)entry.name())).$colon$colon$colon(new_entries));
    }

    public Progress components_build$default$3() {
        return new Progress();
    }

    public boolean components_build$default$4() {
        return false;
    }

    public boolean components_build$default$5() {
        return false;
    }

    public boolean components_build$default$6() {
        return false;
    }

    public Isabelle_Tool isabelle_tool() {
        return isabelle_tool;
    }

    private final List paths$1(Seq args) {
        return args.toList().map((Function1 & Serializable)str -> Path$.MODULE$.explode((String)str));
    }

    private final String show_options$1(ObjectRef options$1) {
        Options options = (Options)options$1.elem;
        return (String)package$.MODULE$.cat_lines().apply((Object)relevant_options.flatMap((Function1 & Serializable)name -> options.get((String)name)).map((Function1 & Serializable)_$8 -> _$8.print()));
    }

    private final String $anonfun$1(ObjectRef options$4) {
        return "\nUsage: isabelle components_build [OPTIONS] ARCHIVES... DIRS...\n\n  Options are:\n    -P           publish on SSH server (see options below)\n    -f           force: overwrite existing component archives and directories\n    -o OPTION    override Isabelle system OPTION (via NAME=VAL or NAME)\n    -u           update all SHA1 keys in Isabelle repository Admin/components\n\n  Build and publish Isabelle components as .tar.gz archives on SSH server,\n  depending on system options:\n\n" + Library$.MODULE$.indent_lines(2, this.show_options$1(options$4)) + "\n";
    }

    public static final /* synthetic */ Option isabelle$Components$Archive$$$_$unapply$$anonfun$1(String name0) {
        return ((Option)package$.MODULE$.proper_string().apply((Object)name0)).map((Function1 & Serializable)name -> name);
    }

    public static final String isabelle$Components$Archive$$$_$get_name$$anonfun$1(String archive$1) {
        return (String)package$.MODULE$.error().apply((Object)("Bad component archive name (expecting .tar.gz): " + package$.MODULE$.quote().apply((Object)archive$1)));
    }

    public static final List isabelle$Components$Platforms$$_$apply$$anonfun$1() {
        return scala.package$.MODULE$.Nil();
    }

    private static final Path $anonfun$6(Path base_dir$2) {
        return base_dir$2;
    }

    public static final /* synthetic */ String isabelle$Components$Directory$$_$write_platforms$default$1$$anonfun$1(Platform.Family family) {
        return family.toString() + " = ";
    }

    public static final /* synthetic */ boolean isabelle$Components$Directory$$_$_$$anonfun$7(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            String a = (String)tuple2._1();
            String b = (String)tuple2._2();
            return true;
        }
        return false;
    }

    public static final /* synthetic */ Tuple2 isabelle$Components$Directory$$_$_$$anonfun$8(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            String a = (String)tuple2._1();
            String b = (String)tuple2._2();
            if (!MODULE$.default_platforms().defined(a)) {
                package$.MODULE$.error().apply((Object)("Bad platform family " + package$.MODULE$.quote().apply((Object)a)));
            }
            List ps = Word$.MODULE$.explode(b).map((Function1 & Serializable)str -> Path$.MODULE$.explode((String)str));
            ps.withFilter((Function1 & Serializable)p -> !p.all_basic()).foreach((Function1 & Serializable)p -> package$.MODULE$.error().apply((Object)("Bad path outside component " + p)));
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)a);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)ps);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Components.Platforms isabelle$Components$Directory$$_$get_platforms$$anonfun$1(Components.Platforms _$3, Tuple2 _$4) {
        return _$3.$plus((Tuple2<String, List<Path>>)_$4);
    }

    public static final /* synthetic */ IterableOnce isabelle$Components$Directory$$_$_$$anonfun$10(Components.Platforms platforms$2, Platform.Family a) {
        return platforms$2.apply(a.toString()).map((Function1 & Serializable)p -> p);
    }

    public static final /* synthetic */ boolean isabelle$Components$Directory$$_$read_components$$anonfun$1(String _$5) {
        return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$5));
    }

    private static final List read_components_sha1$$anonfun$1() {
        return (List)package$.MODULE$.split_lines().apply((Object)File$.MODULE$.read(MODULE$.components_sha1()));
    }

    private static final void main$$anonfun$1(String[] args$1) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])args$1);
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)arg -> {
            boolean add = arg.startsWith("+") ? true : (arg.startsWith("-") ? false : BoxesRunTime.unboxToBoolean((Object)package$.MODULE$.error().apply((Object)("Bad argument: " + package$.MODULE$.quote().apply(arg)))));
            Path path = Path$.MODULE$.explode(arg.substring(1));
            MODULE$.update_components(add, path, new Console_Progress(Console_Progress$.MODULE$.$lessinit$greater$default$1(), Console_Progress$.MODULE$.$lessinit$greater$default$2(), Console_Progress$.MODULE$.$lessinit$greater$default$3(), Console_Progress$.MODULE$.$lessinit$greater$default$4()));
        });
    }
}

