/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Components$;
import isabelle.Components$Directory$;
import isabelle.Components$Platforms$;
import isabelle.Components$SHA1_Entry$;
import isabelle.File$;
import isabelle.Isabelle_Tool;
import isabelle.Options;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Platform;
import isabelle.Platform$Family$;
import isabelle.Position$;
import isabelle.Progress;
import isabelle.SHA1;
import isabelle.SHA1$;
import isabelle.SSH;
import isabelle.Sessions$;
import isabelle.package$;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class Components {
    public static Path admin(Path path) {
        return Components$.MODULE$.admin(path);
    }

    public static Path classic_components_base() {
        return Components$.MODULE$.classic_components_base();
    }

    public static void clean_base(Path path, List<Platform.Family> list, SSH.System system, Progress progress) {
        Components$.MODULE$.clean_base(path, list, system, progress);
    }

    public static void components_build(Options options, List<Path> list, Progress progress, boolean bl, boolean bl2, boolean bl3) {
        Components$.MODULE$.components_build(options, list, progress, bl, bl2, bl3);
    }

    public static Path components_path() {
        return Components$.MODULE$.components_path();
    }

    public static Path components_sha1() {
        return Components$.MODULE$.components_sha1();
    }

    public static Path contrib(Path path, String string) {
        return Components$.MODULE$.contrib(path, string);
    }

    public static List<String> default_catalogs() {
        return Components$.MODULE$.default_catalogs();
    }

    public static Path default_components_base() {
        return Components$.MODULE$.default_components_base();
    }

    public static Platforms default_platforms() {
        return Components$.MODULE$.default_platforms();
    }

    public static List<Path> directories() {
        return Components$.MODULE$.directories();
    }

    public static String dynamic_components_base() {
        return Components$.MODULE$.dynamic_components_base();
    }

    public static boolean is_component_dir(Path path, SSH.System system) {
        return Components$.MODULE$.is_component_dir(path, system);
    }

    public static Isabelle_Tool isabelle_tool() {
        return Components$.MODULE$.isabelle_tool();
    }

    public static void main(String[] stringArray) {
        Components$.MODULE$.main(stringArray);
    }

    public static List<String> optional_catalogs() {
        return Components$.MODULE$.optional_catalogs();
    }

    public static Directory provide(Path path, Path path2, SSH.System system, Progress progress) {
        return Components$.MODULE$.provide(path, path2, system, progress);
    }

    public static List<String> read_components() {
        return Components$.MODULE$.read_components();
    }

    public static List<SHA1_Entry> read_components_sha1(List<String> list) {
        return Components$.MODULE$.read_components_sha1(list);
    }

    public static void resolve(Path path, String string, Option<Path> option, Option<Path> option2, Option<List<Platform.Family>> option3, boolean bl, String string2, SSH.System system, Progress progress) {
        Components$.MODULE$.resolve(path, string, option, option2, option3, bl, string2, system, progress);
    }

    public static String static_component_repository() {
        return Components$.MODULE$.static_component_repository();
    }

    public static String unpack(Path path, Path path2, SSH.System system, Progress progress) {
        return Components$.MODULE$.unpack(path, path2, system, progress);
    }

    public static void update_components(boolean bl, Path path, Progress progress) {
        Components$.MODULE$.update_components(bl, path, progress);
    }

    public static void write_components(List<String> list) {
        Components$.MODULE$.write_components(list);
    }

    public static void write_components_sha1(List<SHA1_Entry> list) {
        Components$.MODULE$.write_components_sha1(list);
    }

    public static Path contrib$default$1() {
        return Components$.MODULE$.contrib$default$1();
    }

    public static List<String> read_components_sha1$default$1() {
        return Components$.MODULE$.read_components_sha1$default$1();
    }

    public static List<Platform.Family> clean_base$default$2() {
        return Components$.MODULE$.clean_base$default$2();
    }

    public static String contrib$default$2() {
        return Components$.MODULE$.contrib$default$2();
    }

    public static SSH.System is_component_dir$default$2() {
        return Components$.MODULE$.is_component_dir$default$2();
    }

    public static Path provide$default$2() {
        return Components$.MODULE$.provide$default$2();
    }

    public static SSH.System clean_base$default$3() {
        return Components$.MODULE$.clean_base$default$3();
    }

    public static Progress components_build$default$3() {
        return Components$.MODULE$.components_build$default$3();
    }

    public static SSH.System provide$default$3() {
        return Components$.MODULE$.provide$default$3();
    }

    public static Option<Path> resolve$default$3() {
        return Components$.MODULE$.resolve$default$3();
    }

    public static SSH.System unpack$default$3() {
        return Components$.MODULE$.unpack$default$3();
    }

    public static Progress update_components$default$3() {
        return Components$.MODULE$.update_components$default$3();
    }

    public static Progress clean_base$default$4() {
        return Components$.MODULE$.clean_base$default$4();
    }

    public static boolean components_build$default$4() {
        return Components$.MODULE$.components_build$default$4();
    }

    public static Progress provide$default$4() {
        return Components$.MODULE$.provide$default$4();
    }

    public static Option<Path> resolve$default$4() {
        return Components$.MODULE$.resolve$default$4();
    }

    public static Progress unpack$default$4() {
        return Components$.MODULE$.unpack$default$4();
    }

    public static boolean components_build$default$5() {
        return Components$.MODULE$.components_build$default$5();
    }

    public static Option<List<Platform.Family>> resolve$default$5() {
        return Components$.MODULE$.resolve$default$5();
    }

    public static boolean components_build$default$6() {
        return Components$.MODULE$.components_build$default$6();
    }

    public static boolean resolve$default$6() {
        return Components$.MODULE$.resolve$default$6();
    }

    public static String resolve$default$7() {
        return Components$.MODULE$.resolve$default$7();
    }

    public static SSH.System resolve$default$8() {
        return Components$.MODULE$.resolve$default$8();
    }

    public static Progress resolve$default$9() {
        return Components$.MODULE$.resolve$default$9();
    }

    public static class Directory {
        private final Path path;
        private final SSH.System ssh;

        public static Directory apply(Path path, SSH.System system) {
            return Components$Directory$.MODULE$.apply(path, system);
        }

        public static SSH.System apply$default$2() {
            return Components$Directory$.MODULE$.apply$default$2();
        }

        public Directory(Path path, SSH.System ssh) {
            this.path = path;
            this.ssh = ssh;
        }

        public Path path() {
            return this.path;
        }

        public SSH.System ssh() {
            return this.ssh;
        }

        public String toString() {
            return this.path().toString() + this.ssh().print();
        }

        public Path etc() {
            return this.path().$plus(Path$.MODULE$.basic("etc"));
        }

        public Path src() {
            return this.path().$plus(Path$.MODULE$.basic("src"));
        }

        public Path bin() {
            return this.path().$plus(Path$.MODULE$.basic("bin"));
        }

        public Path lib() {
            return this.path().$plus(Path$.MODULE$.basic("lib"));
        }

        public Path settings() {
            return this.etc().$plus(Path$.MODULE$.basic("settings"));
        }

        public Path components() {
            return this.etc().$plus(Path$.MODULE$.basic("components"));
        }

        public Path build_props() {
            return this.etc().$plus(Path$.MODULE$.basic("build.props"));
        }

        public Path platform_props() {
            return this.etc().$plus(Path$.MODULE$.basic("platform.props"));
        }

        public Path README() {
            return this.path().$plus(Path$.MODULE$.basic("README"));
        }

        public Path LICENSE() {
            return this.path().$plus(Path$.MODULE$.basic("LICENSE"));
        }

        public Directory create(Progress progress, boolean permissive) {
            if (!permissive || !this.ssh().is_dir(this.path())) {
                progress.echo("Creating component directory " + this.toString(), progress.echo$default$2());
                this.ssh().new_directory(this.path());
            }
            this.ssh().make_directory(this.etc());
            return this;
        }

        public Progress create$default$1() {
            return new Progress();
        }

        public boolean create$default$2() {
            return false;
        }

        public Directory write_platforms(List<String> lines) {
            File$.MODULE$.write(this.platform_props(), (String)package$.MODULE$.terminate_lines().apply(lines));
            return this;
        }

        public List<String> write_platforms$default$1() {
            return Platform$Family$.MODULE$.list().map(Components$::isabelle$Components$Directory$$_$write_platforms$default$1$$anonfun$1);
        }

        public Platforms get_platforms() {
            Nil$ nil$;
            Path props_path = this.platform_props().expand();
            if (props_path.is_file()) {
                try {
                    nil$ = (List)CollectionConverters$.MODULE$.PropertiesHasAsScala(File$.MODULE$.read_props(props_path)).asScala().toList().withFilter(Components$::isabelle$Components$Directory$$_$_$$anonfun$7).map(Components$::isabelle$Components$Directory$$_$_$$anonfun$8);
                }
                catch (Throwable throwable) {
                    String string;
                    Option<String> option;
                    Throwable throwable2 = throwable;
                    if (throwable2 == null || (option = package$.MODULE$.ERROR().unapply(throwable2)).isEmpty()) {
                        throw throwable;
                    }
                    String msg = string = (String)option.get();
                    throw (Nothing$)package$.MODULE$.error().apply((Object)(msg + Position$.MODULE$.here(Position$.MODULE$.File().apply(props_path.implode()), Position$.MODULE$.here$default$2())));
                }
            } else {
                nil$ = scala.package$.MODULE$.Nil();
            }
            Nil$ props = nil$;
            return (Platforms)props.foldLeft((Object)Components$.MODULE$.default_platforms(), Components$::isabelle$Components$Directory$$_$get_platforms$$anonfun$1);
        }

        public void clean(List<Platform.Family> preserve, Progress progress) {
            Platforms platforms = this.get_platforms();
            Set preserve_path = Predef$.MODULE$.Set().from((IterableOnce)preserve.flatMap(arg_0 -> Components$.isabelle$Components$Directory$$_$_$$anonfun$10(platforms, arg_0)));
            platforms.path_iterator().withFilter((Function1 & Serializable)dir -> !preserve_path.apply(dir) && this.ssh().is_dir(this.path().$plus((Path)dir))).foreach((Function1)(JProcedure1 & Serializable)dir -> {
                progress.echo("Removing " + this.path().base().$plus((Path)dir), progress.echo$default$2());
                this.ssh().rm_tree(this.path().$plus((Path)dir));
            });
        }

        public List<Platform.Family> clean$default$1() {
            return Platform$Family$.MODULE$.list();
        }

        public Progress clean$default$2() {
            return new Progress();
        }

        public boolean ok() {
            return this.ssh().is_file(this.settings()) || this.ssh().is_file(this.components()) || Sessions$.MODULE$.is_session_dir(this.path(), this.ssh());
        }

        public Directory check() {
            if (this.ok()) {
                return this;
            }
            if (!this.ssh().is_dir(this.path())) {
                return (Directory)package$.MODULE$.error().apply((Object)("Bad component directory: " + this.toString()));
            }
            return (Directory)package$.MODULE$.error().apply((Object)("Malformed component directory: " + this.toString() + "\n  (missing \"etc/settings\" or \"etc/components\" or \"ROOT\" or \"ROOTS\")"));
        }

        public List<String> read_components() {
            return ((List)package$.MODULE$.split_lines().apply((Object)this.ssh().read(this.components()))).filter(Components$::isabelle$Components$Directory$$_$read_components$$anonfun$1);
        }

        public void write_components(List<String> lines) {
            this.ssh().write(this.components(), (String)package$.MODULE$.terminate_lines().apply(lines));
        }

        public void write_settings(String text) {
            this.ssh().write(this.settings(), "# -*- shell-script -*- :mode=shellscript:\n" + text);
        }
    }

    public static class Platforms
    implements Product,
    Serializable {
        private final Map family_platforms;

        public static Platforms fromProduct(Product product) {
            return Components$Platforms$.MODULE$.fromProduct(product);
        }

        public static Platforms unapply(Platforms platforms) {
            return Components$Platforms$.MODULE$.unapply(platforms);
        }

        public Platforms(Map<String, List<Path>> family_platforms) {
            this.family_platforms = family_platforms;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Platforms)) return false;
            Platforms platforms = (Platforms)object;
            Map<String, List<Path>> map = this.family_platforms();
            Map<String, List<Path>> map2 = platforms.family_platforms();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            if (!platforms.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Platforms;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Platforms";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "family_platforms";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Map<String, List<Path>> family_platforms() {
            return this.family_platforms;
        }

        public Platforms $plus(Tuple2<String, List<Path>> entry) {
            return Components$Platforms$.MODULE$.apply((Map<String, List<Path>>)((Map)this.family_platforms().$plus(entry)));
        }

        public boolean defined(String family) {
            return this.family_platforms().isDefinedAt((Object)family);
        }

        public List<Path> apply(String family) {
            return (List)this.family_platforms().getOrElse((Object)family, Components$::isabelle$Components$Platforms$$_$apply$$anonfun$1);
        }

        public Iterator<Path> path_iterator() {
            return this.family_platforms().valuesIterator().flatten(Predef$.MODULE$.$conforms());
        }

        public Platforms copy(Map<String, List<Path>> family_platforms) {
            return new Platforms(family_platforms);
        }

        public Map<String, List<Path>> copy$default$1() {
            return this.family_platforms();
        }

        public Map<String, List<Path>> _1() {
            return this.family_platforms();
        }
    }

    public static class SHA1_Entry
    implements Product,
    Serializable {
        private final SHA1.Digest digest;
        private final String name;

        public static SHA1_Entry apply(SHA1.Digest digest, String string) {
            return Components$SHA1_Entry$.MODULE$.apply(digest, string);
        }

        public static SHA1_Entry fromProduct(Product product) {
            return Components$SHA1_Entry$.MODULE$.fromProduct(product);
        }

        public static SHA1_Entry unapply(SHA1_Entry sHA1_Entry) {
            return Components$SHA1_Entry$.MODULE$.unapply(sHA1_Entry);
        }

        public SHA1_Entry(SHA1.Digest digest, String name) {
            this.digest = digest;
            this.name = name;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SHA1_Entry)) return false;
            SHA1_Entry sHA1_Entry = (SHA1_Entry)object;
            SHA1.Digest digest = this.digest();
            SHA1.Digest digest2 = sHA1_Entry.digest();
            if (digest == null) {
                if (digest2 != null) {
                    return false;
                }
            } else if (!((Object)digest).equals(digest2)) return false;
            String string = this.name();
            String string2 = sHA1_Entry.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!sHA1_Entry.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof SHA1_Entry;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "SHA1_Entry";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "digest";
            }
            if (1 == n2) {
                return "name";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public SHA1.Digest digest() {
            return this.digest;
        }

        public String name() {
            return this.name;
        }

        public String toString() {
            return SHA1$.MODULE$.shasum(this.digest(), this.name()).toString();
        }

        public SHA1_Entry copy(SHA1.Digest digest, String name) {
            return new SHA1_Entry(digest, name);
        }

        public SHA1.Digest copy$default$1() {
            return this.digest();
        }

        public String copy$default$2() {
            return this.name();
        }

        public SHA1.Digest _1() {
            return this.digest();
        }

        public String _2() {
            return this.name();
        }
    }
}

