/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Date$;
import isabelle.Date$Daily$;
import isabelle.Date$Day$;
import isabelle.Date$Format$;
import isabelle.Date$Month$;
import isabelle.Date$Monthly$;
import isabelle.Date$Weekly$;
import isabelle.Date$Yearly$;
import isabelle.Time;
import isabelle.Time$;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import scala.Function1;
import scala.Int$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.collection.immutable.List;
import scala.reflect.Enum;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class Date
implements Product,
Serializable {
    private final ZonedDateTime rep;

    public static Date apply(long l, ZoneId zoneId) {
        return Date$.MODULE$.apply(l, zoneId);
    }

    public static Date apply(ZonedDateTime zonedDateTime) {
        return Date$.MODULE$.apply(zonedDateTime);
    }

    public static Date fromProduct(Product product) {
        return Date$.MODULE$.fromProduct(product);
    }

    public static Date now(ZoneId zoneId) {
        return Date$.MODULE$.now(zoneId);
    }

    public static ZoneId timezone_berlin() {
        return Date$.MODULE$.timezone_berlin();
    }

    public static ZoneId timezone_utc() {
        return Date$.MODULE$.timezone_utc();
    }

    public static Date unapply(Date date) {
        return Date$.MODULE$.unapply(date);
    }

    public static ZoneId now$default$1() {
        return Date$.MODULE$.now$default$1();
    }

    public static ZoneId apply$default$2() {
        return Date$.MODULE$.apply$default$2();
    }

    public static ZoneId instant$default$2() {
        return Date$.MODULE$.instant$default$2();
    }

    public Date(ZonedDateTime rep) {
        this.rep = rep;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Date)) return false;
        Date date = (Date)object;
        ZonedDateTime zonedDateTime = this.rep();
        ZonedDateTime zonedDateTime2 = date.rep();
        if (zonedDateTime == null) {
            if (zonedDateTime2 != null) {
                return false;
            }
        } else if (!((Object)zonedDateTime).equals(zonedDateTime2)) return false;
        if (!date.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof Date;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "Date";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "rep";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public ZonedDateTime rep() {
        return this.rep;
    }

    public Date shift(int days) {
        return Date$.MODULE$.apply(this.rep().plus(Int$.MODULE$.int2long(days), ChronoUnit.DAYS));
    }

    public Date midnight() {
        return new Date(ZonedDateTime.of(this.rep().toLocalDate(), LocalTime.MIDNIGHT, this.rep().getZone()));
    }

    public Date to(ZoneId other) {
        return new Date(this.rep().withZoneSameInstant(other));
    }

    public long unix_epoch() {
        return this.rep().toEpochSecond();
    }

    public long unix_epoch_day() {
        return this.rep().toLocalDate().toEpochDay();
    }

    public Instant instant() {
        return Instant.from(this.rep());
    }

    public long time() {
        return Time$.MODULE$.instant(this.instant());
    }

    public ZoneId timezone() {
        return this.rep().getZone();
    }

    public Date $plus(long t) {
        return Date$.MODULE$.apply(Time$.MODULE$.$plus$extension(this.time(), t), this.timezone());
    }

    public Date $minus(long t) {
        return Date$.MODULE$.apply(Time$.MODULE$.$minus$extension(this.time(), t), this.timezone());
    }

    public long $minus(Date d) {
        return Time$.MODULE$.$minus$extension(this.time(), d.time());
    }

    public String format(Format fmt) {
        return fmt.apply(this);
    }

    public Format format$default$1() {
        return Date$Format$.MODULE$.default();
    }

    public String toString() {
        return this.format(this.format$default$1());
    }

    public Date copy(ZonedDateTime rep) {
        return new Date(rep);
    }

    public ZonedDateTime copy$default$1() {
        return this.rep();
    }

    public ZonedDateTime _1() {
        return this.rep();
    }

    public static interface Cycle {
        public Date zero(Date var1);

        public Date next(Date var1);
    }

    public static class Daily
    implements Cycle,
    Product,
    Serializable {
        private final long at;

        public static Daily apply(long l) {
            return Date$Daily$.MODULE$.apply(l);
        }

        public static Daily fromProduct(Product product) {
            return Date$Daily$.MODULE$.fromProduct(product);
        }

        public static Daily unapply(Daily daily) {
            return Date$Daily$.MODULE$.unapply(daily);
        }

        public static long $lessinit$greater$default$1() {
            return Date$Daily$.MODULE$.$lessinit$greater$default$1();
        }

        public Daily(long at) {
            this.at = at;
            Predef$.MODULE$.require(Time$.MODULE$.$greater$eq$extension(at, Time$.MODULE$.zero()) && Time$.MODULE$.$less$extension(at, Time$.MODULE$.hms(24, 0, 0.0)));
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Daily)) return false;
            Daily daily = (Daily)object;
            if (this.at() != daily.at()) return false;
            if (!daily.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof Daily;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Daily";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return new Time(this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "at";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long at() {
            return this.at;
        }

        @Override
        public Date zero(Date date) {
            return date.midnight();
        }

        @Override
        public Date next(Date date) {
            Date start = this.zero(date).$plus(this.at());
            if (Time$.MODULE$.$less$extension(date.time(), start.time())) {
                return start;
            }
            return start.shift(1);
        }

        public String toString() {
            return "Daily(" + Date$Format$.MODULE$.time().apply(Date$.MODULE$.apply(this.at(), Date$.MODULE$.timezone_utc())) + ")";
        }

        public Daily copy(long at) {
            return new Daily(at);
        }

        public long copy$default$1() {
            return this.at();
        }

        public long _1() {
            return this.at();
        }
    }

    public static abstract class Day
    implements Product,
    Enum {
        public static Day fromOrdinal(int n) {
            return Date$Day$.MODULE$.fromOrdinal(n);
        }

        public static Day valueOf(String string) {
            return Date$Day$.MODULE$.valueOf(string);
        }

        public static Day[] values() {
            return Date$Day$.MODULE$.values();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static abstract class Format {
        public static Format alt_date() {
            return Date$Format$.MODULE$.alt_date();
        }

        public static Format date() {
            return Date$Format$.MODULE$.date();
        }

        public static Format default() {
            return Date$Format$.MODULE$.default();
        }

        public static Format make(List<DateTimeFormatter> list, Function1<String, String> function1) {
            return Date$Format$.MODULE$.make(list, function1);
        }

        public static Format time() {
            return Date$Format$.MODULE$.time();
        }

        public static Function1<String, String> make$default$2() {
            return Date$Format$.MODULE$.make$default$2();
        }

        public abstract String apply(Date var1);

        public abstract Date parse(String var1);

        public Option<Date> unapply(String str) {
            None$ none$;
            try {
                none$ = Some$.MODULE$.apply((Object)this.parse(str));
            }
            catch (DateTimeParseException dateTimeParseException) {
                none$ = None$.MODULE$;
            }
            return none$;
        }
    }

    public static abstract class Month
    implements Product,
    Enum {
        public static Month fromOrdinal(int n) {
            return Date$Month$.MODULE$.fromOrdinal(n);
        }

        public static Month valueOf(String string) {
            return Date$Month$.MODULE$.valueOf(string);
        }

        public static Month[] values() {
            return Date$Month$.MODULE$.values();
        }
    }

    public static class Monthly
    implements Cycle,
    Product,
    Serializable {
        private final int nth;
        private final Daily step;

        public static Monthly apply(int n, Daily daily) {
            return Date$Monthly$.MODULE$.apply(n, daily);
        }

        public static Monthly fromProduct(Product product) {
            return Date$Monthly$.MODULE$.fromProduct(product);
        }

        public static Monthly unapply(Monthly monthly) {
            return Date$Monthly$.MODULE$.unapply(monthly);
        }

        public static int $lessinit$greater$default$1() {
            return Date$Monthly$.MODULE$.$lessinit$greater$default$1();
        }

        public static Daily $lessinit$greater$default$2() {
            return Date$Monthly$.MODULE$.$lessinit$greater$default$2();
        }

        public Monthly(int nth, Daily step) {
            this.nth = nth;
            this.step = step;
            Predef$.MODULE$.require(nth > 0 && nth <= 31);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.nth());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.step()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Monthly)) return false;
            Monthly monthly = (Monthly)object;
            if (this.nth() != monthly.nth()) return false;
            Daily daily = this.step();
            Daily daily2 = monthly.step();
            if (daily == null) {
                if (daily2 != null) {
                    return false;
                }
            } else if (!((Object)daily).equals(daily2)) return false;
            if (!monthly.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Monthly;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Monthly";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToInteger((int)this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "nth";
            }
            if (1 == n2) {
                return "step";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int nth() {
            return this.nth;
        }

        public Daily step() {
            return this.step;
        }

        @Override
        public Date zero(Date date) {
            return date.shift(1 - date.rep().getDayOfMonth()).midnight();
        }

        @Override
        public Date next(Date date) {
            return this.find_next$1(date, this.zero(date));
        }

        public Monthly copy(int nth, Daily step) {
            return new Monthly(nth, step);
        }

        public int copy$default$1() {
            return this.nth();
        }

        public Daily copy$default$2() {
            return this.step();
        }

        public int _1() {
            return this.nth();
        }

        public Daily _2() {
            return this.step();
        }

        private final Date find_next$1(Date date$1, Date zero) {
            Date next;
            while ((next = this.step().next(zero.shift(this.nth() - 1).$minus(Time$.MODULE$.ms(1L)))).rep().getDayOfMonth() != this.nth() || !Time$.MODULE$.$less$extension(date$1.time(), next.time())) {
                zero = Date$.MODULE$.apply(zero.rep().plus(1L, ChronoUnit.MONTHS));
            }
            return next;
        }
    }

    public static class Weekly
    implements Cycle,
    Product,
    Serializable {
        private final Day on;
        private final Daily step;

        public static Weekly apply(Day day, Daily daily) {
            return Date$Weekly$.MODULE$.apply(day, daily);
        }

        public static Weekly fromProduct(Product product) {
            return Date$Weekly$.MODULE$.fromProduct(product);
        }

        public static Weekly unapply(Weekly weekly) {
            return Date$Weekly$.MODULE$.unapply(weekly);
        }

        public static Day $lessinit$greater$default$1() {
            return Date$Weekly$.MODULE$.$lessinit$greater$default$1();
        }

        public static Daily $lessinit$greater$default$2() {
            return Date$Weekly$.MODULE$.$lessinit$greater$default$2();
        }

        public Weekly(Day on, Daily step) {
            this.on = on;
            this.step = step;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Weekly)) return false;
            Weekly weekly = (Weekly)object;
            Day day = this.on();
            Day day2 = weekly.on();
            if (day == null) {
                if (day2 != null) {
                    return false;
                }
            } else if (!day.equals(day2)) return false;
            Daily daily = this.step();
            Daily daily2 = weekly.step();
            if (daily == null) {
                if (daily2 != null) {
                    return false;
                }
            } else if (!((Object)daily).equals(daily2)) return false;
            if (!weekly.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Weekly;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Weekly";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "on";
            }
            if (1 == n2) {
                return "step";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Day on() {
            return this.on;
        }

        public Daily step() {
            return this.step;
        }

        @Override
        public Date zero(Date date) {
            return date.shift(1 - date.rep().getDayOfWeek().getValue()).midnight();
        }

        @Override
        public Date next(Date date) {
            Date next = this.step().next(this.zero(date).shift(this.on().ordinal()).$minus(Time$.MODULE$.ms(1L)));
            if (Time$.MODULE$.$less$extension(date.time(), next.time())) {
                return next;
            }
            return Date$.MODULE$.apply(next.rep().plus(1L, ChronoUnit.WEEKS));
        }

        public Weekly copy(Day on, Daily step) {
            return new Weekly(on, step);
        }

        public Day copy$default$1() {
            return this.on();
        }

        public Daily copy$default$2() {
            return this.step();
        }

        public Day _1() {
            return this.on();
        }

        public Daily _2() {
            return this.step();
        }
    }

    public static class Yearly
    implements Cycle,
    Product,
    Serializable {
        private final Month in;
        private final Monthly step;

        public static Yearly apply(Month month, Monthly monthly) {
            return Date$Yearly$.MODULE$.apply(month, monthly);
        }

        public static Yearly fromProduct(Product product) {
            return Date$Yearly$.MODULE$.fromProduct(product);
        }

        public static Yearly unapply(Yearly yearly) {
            return Date$Yearly$.MODULE$.unapply(yearly);
        }

        public static Month $lessinit$greater$default$1() {
            return Date$Yearly$.MODULE$.$lessinit$greater$default$1();
        }

        public static Monthly $lessinit$greater$default$2() {
            return Date$Yearly$.MODULE$.$lessinit$greater$default$2();
        }

        public Yearly(Month in, Monthly step) {
            this.in = in;
            this.step = step;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Yearly)) return false;
            Yearly yearly = (Yearly)object;
            Month month = this.in();
            Month month2 = yearly.in();
            if (month == null) {
                if (month2 != null) {
                    return false;
                }
            } else if (!month.equals(month2)) return false;
            Monthly monthly = this.step();
            Monthly monthly2 = yearly.step();
            if (monthly == null) {
                if (monthly2 != null) {
                    return false;
                }
            } else if (!((Object)monthly).equals(monthly2)) return false;
            if (!yearly.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Yearly;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Yearly";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "in";
            }
            if (1 == n2) {
                return "step";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Month in() {
            return this.in;
        }

        public Monthly step() {
            return this.step;
        }

        @Override
        public Date zero(Date date) {
            return date.shift(1 - date.rep().getDayOfYear()).midnight();
        }

        @Override
        public Date next(Date date) {
            return this.find_next$2(date, this.zero(date));
        }

        public Yearly copy(Month in, Monthly step) {
            return new Yearly(in, step);
        }

        public Month copy$default$1() {
            return this.in();
        }

        public Monthly copy$default$2() {
            return this.step();
        }

        public Month _1() {
            return this.in();
        }

        public Monthly _2() {
            return this.step();
        }

        private final Date find_next$2(Date date$2, Date zero) {
            Date next;
            while ((next = this.step().next(Date$.MODULE$.apply(zero.rep().plus(Int$.MODULE$.int2long(this.in().ordinal()), ChronoUnit.MONTHS)).$minus(Time$.MODULE$.ms(1L)))).rep().getMonthValue() - 1 != this.in().ordinal() || !Time$.MODULE$.$less$extension(date$2.time(), next.time())) {
                zero = Date$.MODULE$.apply(zero.rep().plus(1L, ChronoUnit.YEARS));
            }
            return next;
        }
    }
}

