/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Bash$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.Isabelle_Tool$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Progress;
import isabelle.SSH;
import isabelle.Scala_Project$;
import isabelle.Url$;
import isabelle.package$;
import java.io.Serializable;
import java.util.Map;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.matching.Regex;

public final class Docker_Build$
implements Serializable {
    private static final String default_base;
    private static final Path default_work_dir;
    private static final Regex Isabelle_Name;
    private static final List packages;
    private static final scala.collection.immutable.Map package_collections;
    private static final Isabelle_Tool isabelle_tool;
    public static final Docker_Build$ MODULE$;

    private Docker_Build$() {
    }

    static {
        MODULE$ = new Docker_Build$();
        default_base = "ubuntu:24.04";
        default_work_dir = Path$.MODULE$.current();
        Isabelle_Name = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^.*?(Isabelle[^/\\\\:]+)_linux(?:_arm)?\\.tar\\.gz$"));
        packages = (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"curl", "less", "libfontconfig1", "libgomp1", "openssh-client", "perl", "pwgen", "rlwrap"}));
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"X11");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)new .colon.colon((Object)"libx11-6", (List)new .colon.colon((Object)"libxext6", (List)new .colon.colon((Object)"libxrender1", (List)new .colon.colon((Object)"libxtst6", (List)new .colon.colon((Object)"libxi6", (List)Nil$.MODULE$))))));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"latex");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)new .colon.colon((Object)"texlive-bibtex-extra", (List)new .colon.colon((Object)"texlive-fonts-extra", (List)new .colon.colon((Object)"texlive-font-utils", (List)new .colon.colon((Object)"texlive-latex-extra", (List)new .colon.colon((Object)"texlive-science", (List)Nil$.MODULE$))))));
        package_collections = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        isabelle_tool = Isabelle_Tool$.MODULE$.apply("docker_build", "build Isabelle docker image", Scala_Project$.MODULE$.here(), (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)args -> {
            String string;
            SeqOps seqOps;
            ObjectRef base = ObjectRef.create((Object)default_base);
            BooleanRef entrypoint = BooleanRef.create((boolean)false);
            ObjectRef work_dir = ObjectRef.create((Object)default_work_dir);
            ObjectRef logic = ObjectRef.create((Object)Isabelle_System$.MODULE$.default_logic((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])));
            BooleanRef no_build = BooleanRef.create((boolean)false);
            ObjectRef output = ObjectRef.create((Object)None$.MODULE$);
            ObjectRef more_packages = ObjectRef.create((Object)scala.package$.MODULE$.Nil());
            BooleanRef verbose = BooleanRef.create((boolean)false);
            ObjectRef tag = ObjectRef.create((Object)"");
            Object[] objectArray = new Tuple2[10];
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"B:");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (JProcedure1 & Serializable)arg -> {
                base$1.elem = arg;
            });
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"E");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (JProcedure1 & Serializable)_$2 -> {
                entrypoint$1.elem = true;
            });
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"P:");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (JProcedure1 & Serializable)arg -> {
                Option option = this.package_collections().get(arg);
                if (option instanceof Some) {
                    List ps = (List)((Some)option).value();
                    more_packages$1.elem = ((List)more_packages$1.elem).$colon$colon$colon(ps);
                    return;
                }
                if (None$.MODULE$.equals(option)) {
                    package$.MODULE$.error().apply((Object)("Unknown package collection " + package$.MODULE$.quote().apply(arg)));
                    return;
                }
                throw new MatchError((Object)option);
            });
            String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"W:");
            objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (JProcedure1 & Serializable)arg -> {
                work_dir$1.elem = Path$.MODULE$.explode((String)arg);
            });
            String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"l:");
            objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (JProcedure1 & Serializable)arg -> {
                logic$1.elem = arg;
            });
            String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)"n");
            objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (JProcedure1 & Serializable)_$3 -> {
                no_build$1.elem = true;
            });
            String string8 = (String)Predef$.MODULE$.ArrowAssoc((Object)"o:");
            objectArray[6] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string8, (JProcedure1 & Serializable)arg -> {
                output$1.elem = Some$.MODULE$.apply((Object)Path$.MODULE$.explode((String)arg));
            });
            String string9 = (String)Predef$.MODULE$.ArrowAssoc((Object)"p:");
            objectArray[7] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string9, (JProcedure1 & Serializable)arg -> {
                more_packages$2.elem = ((List)more_packages$2.elem).$colon$colon(arg);
            });
            String string10 = (String)Predef$.MODULE$.ArrowAssoc((Object)"t:");
            objectArray[8] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string10, (JProcedure1 & Serializable)arg -> {
                tag$1.elem = arg;
            });
            String string11 = (String)Predef$.MODULE$.ArrowAssoc((Object)"v");
            objectArray[9] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string11, (JProcedure1 & Serializable)_$4 -> {
                verbose$1.elem = true;
            });
            Getopts getopts = Getopts$.MODULE$.apply((Function0<String>)((Function0 & Serializable)this::$anonfun$1), (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            List<String> more_args = getopts.apply((List<String>)args);
            List<String> list = more_args;
            if (list == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = scala.package$.MODULE$.List().unapplySeq(list), 1) != 0) {
                throw getopts.usage(getopts.usage$default$1());
            }
            String arg2 = string = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
            String app_archive = arg2;
            Console_Progress progress = new Console_Progress(verbose.elem, Console_Progress$.MODULE$.$lessinit$greater$default$2(), Console_Progress$.MODULE$.$lessinit$greater$default$3(), Console_Progress$.MODULE$.$lessinit$greater$default$4());
            this.docker_build(progress, app_archive, (String)base.elem, (Path)work_dir.elem, (String)logic.elem, no_build.elem, entrypoint.elem, (Option<Path>)((Option)output.elem), (List<String>)((List)more_packages.elem), (String)tag.elem);
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Docker_Build$.class);
    }

    public List<String> packages() {
        return packages;
    }

    public scala.collection.immutable.Map<String, List<String>> package_collections() {
        return package_collections;
    }

    public List<String> all_packages() {
        return this.package_collections().valuesIterator().flatten(Predef$.MODULE$.$conforms()).toList().$colon$colon$colon(this.packages());
    }

    public void docker_build(Progress progress, String app_archive, String base, Path work_dir, String logic, boolean no_build, boolean entrypoint, Option<Path> output, List<String> more_packages, String tag) {
        String string;
        String name;
        List list;
        Option option;
        String string2 = app_archive;
        String isabelle_name = string2 != null && !(option = Isabelle_Name.unapplySeq((CharSequence)string2)).isEmpty() && (list = (List)option.get()).lengthCompare(1) == 0 ? (name = (string = (String)list.apply(0))) : (String)package$.MODULE$.error().apply((Object)("Cannot determine Isabelle distribution name from " + app_archive));
        boolean is_remote = Url$.MODULE$.is_wellformed(app_archive);
        String dockerfile = "## Dockerfile for " + isabelle_name + "\n\nFROM " + base + "\nSHELL [\"/bin/bash\", \"-c\"]\n\n# packages\nENV DEBIAN_FRONTEND=noninteractive\nRUN apt-get -y update && \\\n  apt-get install -y " + Bash$.MODULE$.strings((Iterable<String>)more_packages.$colon$colon$colon(this.packages())) + " && \\\n  apt-get clean\n\n# user\nRUN useradd -m isabelle && (echo isabelle:isabelle | chpasswd)\nUSER isabelle\n\n# Isabelle\nWORKDIR /home/isabelle\n" + (String)(is_remote ? "RUN curl --fail --silent --location " + Bash$.MODULE$.string(app_archive) + " > Isabelle.tar.gz" : "COPY Isabelle.tar.gz .") + "\nRUN tar xzf Isabelle.tar.gz && \\\n  mv " + isabelle_name + " Isabelle && \\\n  perl -pi -e 's,ISABELLE_HOME_USER=.*,ISABELLE_HOME_USER=\"\\$USER_HOME/.isabelle\",g;' Isabelle/etc/settings && \\\n  perl -pi -e 's,ISABELLE_LOGIC=.*,ISABELLE_LOGIC=" + logic + ",g;' Isabelle/etc/settings && \\\n  Isabelle/bin/isabelle build -o system_heaps -b " + logic + " && \\\n  rm Isabelle.tar.gz" + (entrypoint ? "\n\nENTRYPOINT [\"Isabelle/bin/isabelle\"]\n" : "");
        output.foreach((Function1)(JProcedure1 & Serializable)path -> {
            progress.echo("Dockerfile: " + path.absolute(), progress.echo$default$2());
            File$.MODULE$.write((Path)path, dockerfile);
        });
        if (!no_build) {
            Isabelle_System$.MODULE$.make_directory(work_dir);
            progress.echo("Docker working directory: " + work_dir.absolute(), progress.echo$default$2());
            Isabelle_System$.MODULE$.with_tmp_dir("docker_build", work_dir.file(), (Function1 & Serializable)tmp_dir -> {
                progress.echo("Docker temporary directory: " + tmp_dir.absolute(), progress.echo$default$2());
                File$.MODULE$.write(tmp_dir.$plus(Path$.MODULE$.explode("Dockerfile")), dockerfile);
                if (is_remote) {
                    if (!Url$.MODULE$.is_readable(app_archive)) {
                        package$.MODULE$.error().apply((Object)("Cannot access remote archive " + app_archive));
                    }
                } else {
                    Isabelle_System$.MODULE$.copy_file(Path$.MODULE$.explode(app_archive), tmp_dir.$plus(Path$.MODULE$.explode("Isabelle.tar.gz")));
                }
                String quiet_option = progress.verbose() ? "" : " -q";
                String tag_option = package$.MODULE$.if_proper(Predef$.MODULE$.wrapString(tag), (Function0<String>)((Function0 & Serializable)() -> Docker_Build$.$anonfun$12(tag)));
                String string = "docker build" + quiet_option + tag_option + " " + File$.MODULE$.bash_path((Path)tmp_dir);
                SSH.System system = progress.bash$default$2();
                Path path = progress.bash$default$3();
                Map<String, String> map = progress.bash$default$4();
                boolean bl = progress.bash$default$5();
                long l = progress.bash$default$7();
                boolean bl2 = progress.bash$default$8();
                return progress.bash(string, system, path, map, bl, true, l, bl2).check();
            });
            return;
        }
    }

    public String docker_build$default$3() {
        return default_base;
    }

    public Path docker_build$default$4() {
        return default_work_dir;
    }

    public String docker_build$default$5() {
        return Isabelle_System$.MODULE$.default_logic((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
    }

    public boolean docker_build$default$6() {
        return false;
    }

    public boolean docker_build$default$7() {
        return false;
    }

    public Option<Path> docker_build$default$8() {
        return None$.MODULE$;
    }

    public List<String> docker_build$default$9() {
        return scala.package$.MODULE$.Nil();
    }

    public String docker_build$default$10() {
        return "";
    }

    public Isabelle_Tool isabelle_tool() {
        return isabelle_tool;
    }

    private final String $anonfun$1() {
        return "\nUsage: isabelle docker_build [OPTIONS] APP_ARCHIVE\n\n  Options are:\n    -B NAME      base image (default " + package$.MODULE$.quote().apply((Object)default_base) + ")\n    -E           set Isabelle/bin/isabelle as entrypoint\n    -P NAME      additional Ubuntu package collection (" + ((List)this.package_collections().keySet().toList().sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)_$1 -> (String)package$.MODULE$.quote().apply(_$1)).mkString(", ") + ")\n    -W DIR       working directory that is accessible to docker,\n                 potentially via snap (default: " + default_work_dir + ")\n    -l NAME      default logic (default ISABELLE_LOGIC=" + package$.MODULE$.quote().apply((Object)Isabelle_System$.MODULE$.default_logic((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]))) + ")\n    -n           no docker build\n    -o FILE      output generated Dockerfile\n    -p NAME      additional Ubuntu package\n    -t TAG       docker build tag\n    -v           verbose\n\n  Build Isabelle docker image with default logic image, using a standard\n  Isabelle application archive for Linux (local file or remote URL).\n";
    }

    private static final String $anonfun$12(String tag$3) {
        return " -t " + Bash$.MODULE$.string(tag$3);
    }
}

