/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Bash;
import isabelle.Bash$;
import isabelle.Bash$Watchdog$;
import isabelle.Bytes;
import isabelle.Bytes$;
import isabelle.Classpath;
import isabelle.Classpath$;
import isabelle.File$;
import isabelle.HTTP;
import isabelle.HTTP$Client$;
import isabelle.Isabelle_System;
import isabelle.Isabelle_System$Bash_Functions$;
import isabelle.Isabelle_System$Copy_Dir$;
import isabelle.Isabelle_System$Copy_File$;
import isabelle.Isabelle_System$Copy_File_Base$;
import isabelle.Isabelle_System$Download$;
import isabelle.Isabelle_System$Isabelle_Id$;
import isabelle.Isabelle_System$Make_Directory$;
import isabelle.Isabelle_System$No_Env$;
import isabelle.Isabelle_System$Rm_Tree$;
import isabelle.Isabelle_System$Settings$;
import isabelle.Isabelle_Thread;
import isabelle.Isabelle_Thread$;
import isabelle.Library$;
import isabelle.Mercurial;
import isabelle.Mercurial$;
import isabelle.Mercurial$Server$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Platform$;
import isabelle.Process_Result;
import isabelle.Process_Result$RC$;
import isabelle.Progress;
import isabelle.Registry$;
import isabelle.SSH;
import isabelle.SSH$Local$;
import isabelle.Url;
import isabelle.Url$;
import isabelle.Word$;
import isabelle.package$;
import isabelle.setup.Environment;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.ServerSocket;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;

public final class Isabelle_System$
implements Serializable {
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(Isabelle_System$.class.getDeclaredField("gnutar_check$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Isabelle_System$.class.getDeclaredField("bash_functions$lzy1"));
    public static final Isabelle_System$No_Env$ No_Env;
    public static final Isabelle_System$Settings$ Settings;
    private static volatile Option<Classpath> _classpath;
    public static final Isabelle_System$Isabelle_Id$ Isabelle_Id;
    public static final Isabelle_System$Make_Directory$ Make_Directory;
    public static final Isabelle_System$Copy_Dir$ Copy_Dir;
    public static final Isabelle_System$Copy_File$ Copy_File;
    public static final Isabelle_System$Copy_File_Base$ Copy_File_Base;
    public static final Isabelle_System$Rm_Tree$ Rm_Tree;
    private volatile Object bash_functions$lzy1;
    public static final Isabelle_System$Bash_Functions$ Bash_Functions;
    private volatile Object gnutar_check$lzy1;
    public static final Isabelle_System$Download$ Download;
    private static final Mercurial.Server isabelle_repository;
    private static final Mercurial.Server afp_repository;
    public static final Isabelle_System$ MODULE$;

    private Isabelle_System$() {
    }

    static {
        MODULE$ = new Isabelle_System$();
        _classpath = None$.MODULE$;
        isabelle_repository = Mercurial$Server$.MODULE$.apply("https://isabelle.in.tum.de/repos/isabelle");
        afp_repository = Mercurial$Server$.MODULE$.apply("https://isabelle.sketis.net/repos/afp-devel");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Isabelle_System$.class);
    }

    public String getenv(String name, Isabelle_System.Settings env) {
        return env.get(name);
    }

    public Isabelle_System.Settings getenv$default$2() {
        return Isabelle_System$Settings$.MODULE$.apply(Isabelle_System$Settings$.MODULE$.apply$default$1());
    }

    public String getenv_strict(String name, Isabelle_System.Settings env) {
        return (String)((Option)package$.MODULE$.proper_string().apply((Object)this.getenv(name, env))).getOrElse(() -> Isabelle_System$.getenv_strict$$anonfun$1(name));
    }

    public Isabelle_System.Settings getenv_strict$default$2() {
        return Isabelle_System$Settings$.MODULE$.apply(Isabelle_System$Settings$.MODULE$.apply$default$1());
    }

    public String hostname(String string) {
        return (String)((Option)package$.MODULE$.proper_string().apply((Object)string)).getOrElse(this::hostname$$anonfun$1);
    }

    public String hostname$default$1() {
        return "";
    }

    public Classpath classpath() {
        if (_classpath.isEmpty()) {
            this.init(this.init$default$1(), this.init$default$2());
        }
        return (Classpath)_classpath.get();
    }

    public <C> List<C> make_services(Class<C> c) {
        return this.classpath().make_services(c);
    }

    public void init(String isabelle_root, String cygwin_root) {
        Environment.init((String)isabelle_root, (String)cygwin_root);
        Isabelle_System$ isabelle_System$ = this;
        synchronized (isabelle_System$) {
            if (_classpath.isEmpty()) {
                _classpath = Some$.MODULE$.apply((Object)Classpath$.MODULE$.apply(Classpath$.MODULE$.apply$default$1(), Classpath$.MODULE$.apply$default$2()));
                v0 = BoxedUnit.UNIT;
            } else {
                v0 = BoxedUnit.UNIT;
            }
        }
        Registry$.MODULE$.global();
    }

    public String init$default$1() {
        return "";
    }

    public String init$default$2() {
        return "";
    }

    public Option<String> getetc(String name, Path root) {
        Path path = root.$plus(Path$.MODULE$.basic("etc")).$plus(Path$.MODULE$.basic(name));
        if (path.is_file()) {
            SeqOps seqOps;
            List<String> list = Library$.MODULE$.trim_split_lines(File$.MODULE$.read(path));
            Nil$ nil$ = scala.package$.MODULE$.Nil();
            List<String> list2 = list;
            if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                return None$.MODULE$;
            }
            if (list != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = scala.package$.MODULE$.List().unapplySeq(list), 1) == 0) {
                String string;
                String s = string = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                return Some$.MODULE$.apply((Object)s);
            }
            return (Option)package$.MODULE$.error().apply((Object)("Single line expected in " + path.absolute()));
        }
        return None$.MODULE$;
    }

    public Path getetc$default$2() {
        return Path$.MODULE$.ISABELLE_HOME();
    }

    public String isabelle_id(Path root) {
        return (String)this.getetc("ISABELLE_ID", root).orElse(() -> Isabelle_System$.isabelle_id$$anonfun$1(root)).orElse(() -> Isabelle_System$.isabelle_id$$anonfun$2(root)).orElse(() -> Isabelle_System$.isabelle_id$$anonfun$3(root)).getOrElse(() -> Isabelle_System$.isabelle_id$$anonfun$4(root));
    }

    public Path isabelle_id$default$1() {
        return Path$.MODULE$.ISABELLE_HOME();
    }

    public String isabelle_tags(Path root) {
        return (String)this.getetc("ISABELLE_TAGS", root).orElse(() -> Isabelle_System$.isabelle_tags$$anonfun$1(root)).getOrElse(() -> Isabelle_System$.isabelle_tags$$anonfun$2(root));
    }

    public Path isabelle_tags$default$1() {
        return Path$.MODULE$.ISABELLE_HOME();
    }

    public Option<String> isabelle_identifier() {
        return (Option)package$.MODULE$.proper_string().apply((Object)this.getenv("ISABELLE_IDENTIFIER", this.getenv$default$2()));
    }

    public String isabelle_heading() {
        Option<String> option = this.isabelle_identifier();
        if (None$.MODULE$.equals(option)) {
            return "";
        }
        if (option instanceof Some) {
            String version = (String)((Some)option).value();
            return " (" + version + ")";
        }
        throw new MatchError(option);
    }

    public String isabelle_name() {
        return this.getenv_strict("ISABELLE_NAME", this.getenv_strict$default$2());
    }

    public String identification() {
        Object object;
        try {
            object = "/" + this.isabelle_id(this.isabelle_id$default$1());
        }
        catch (Throwable throwable) {
            Option<String> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = package$.MODULE$.ERROR().unapply(throwable2)).isEmpty()) {
                String string = (String)option.get();
                object = "";
            }
            throw throwable;
        }
        return "Isabelle" + (String)object + this.isabelle_heading();
    }

    private List<String> apply_paths(List<String> args, PartialFunction<List<Path>, BoxedUnit> fun) {
        fun.apply((Object)args.map((Function1 & Serializable)str -> Path$.MODULE$.explode((String)str)));
        return scala.package$.MODULE$.Nil();
    }

    public List<String> isabelle$Isabelle_System$$$apply_paths1(List<String> args, Function1<Path, BoxedUnit> fun) {
        return this.apply_paths(args, (PartialFunction<List<Path>, BoxedUnit>)new Serializable(fun){
            private final Function1 fun$1;
            {
                this.fun$1 = fun$4;
            }

            public final boolean isDefinedAt(List x) {
                SeqOps seqOps;
                List list = x;
                if (list != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = scala.package$.MODULE$.List().unapplySeq((SeqOps)list), 1) == 0) {
                    Path path;
                    Path path2 = path = (Path)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(List x, Function1 function1) {
                SeqOps seqOps;
                List list = x;
                if (list != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = scala.package$.MODULE$.List().unapplySeq((SeqOps)list), 1) == 0) {
                    Path path;
                    Path path2 = path = (Path)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                    return this.fun$1.apply((Object)path2);
                }
                return function1.apply((Object)x);
            }
        });
    }

    public List<String> isabelle$Isabelle_System$$$apply_paths2(List<String> args, Function2<Path, Path, BoxedUnit> fun) {
        return this.apply_paths(args, (PartialFunction<List<Path>, BoxedUnit>)new Serializable(fun){
            private final Function2 fun$2;
            {
                this.fun$2 = fun$5;
            }

            public final boolean isDefinedAt(List x) {
                SeqOps seqOps;
                List list = x;
                if (list != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = scala.package$.MODULE$.List().unapplySeq((SeqOps)list), 2) == 0) {
                    Path path = (Path)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                    Path path2 = (Path)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 1);
                    Path path1 = path;
                    Path path22 = path2;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(List x, Function1 function1) {
                SeqOps seqOps;
                List list = x;
                if (list != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = scala.package$.MODULE$.List().unapplySeq((SeqOps)list), 2) == 0) {
                    Path path = (Path)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                    Path path2 = (Path)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 1);
                    Path path1 = path;
                    Path path22 = path2;
                    return this.fun$2.apply((Object)path1, (Object)path22);
                }
                return function1.apply((Object)x);
            }
        });
    }

    public List<String> isabelle$Isabelle_System$$$apply_paths3(List<String> args, Function3<Path, Path, Path, BoxedUnit> fun) {
        return this.apply_paths(args, (PartialFunction<List<Path>, BoxedUnit>)new Serializable(fun){
            private final Function3 fun$3;
            {
                this.fun$3 = fun$6;
            }

            public final boolean isDefinedAt(List x) {
                SeqOps seqOps;
                List list = x;
                if (list != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = scala.package$.MODULE$.List().unapplySeq((SeqOps)list), 3) == 0) {
                    Path path = (Path)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                    Path path2 = (Path)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 1);
                    Path path3 = (Path)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 2);
                    Path path1 = path;
                    Path path22 = path2;
                    Path path32 = path3;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(List x, Function1 function1) {
                SeqOps seqOps;
                List list = x;
                if (list != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = scala.package$.MODULE$.List().unapplySeq((SeqOps)list), 3) == 0) {
                    Path path = (Path)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                    Path path2 = (Path)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 1);
                    Path path3 = (Path)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 2);
                    Path path1 = path;
                    Path path22 = path2;
                    Path path32 = path3;
                    return this.fun$3.apply((Object)path1, (Object)path22, (Object)path32);
                }
                return function1.apply((Object)x);
            }
        });
    }

    public void chmod(String arg, Path path) {
        this.bash("chmod " + arg + " " + File$.MODULE$.bash_path(path), this.bash$default$2(), this.bash$default$3(), this.bash$default$4(), this.bash$default$5(), this.bash$default$6(), this.bash$default$7(), this.bash$default$8(), this.bash$default$9(), this.bash$default$10(), this.bash$default$11(), this.bash$default$12()).check();
    }

    public void chown(String arg, Path path) {
        this.bash("chown " + arg + " " + File$.MODULE$.bash_path(path), this.bash$default$2(), this.bash$default$3(), this.bash$default$4(), this.bash$default$5(), this.bash$default$6(), this.bash$default$7(), this.bash$default$8(), this.bash$default$9(), this.bash$default$10(), this.bash$default$11(), this.bash$default$12()).check();
    }

    public Path make_directory(Path path) {
        if (!path.is_dir()) {
            try {
                Files.createDirectories(path.java_path(), new FileAttribute[0]);
            }
            catch (Throwable throwable) {
                Option<String> option;
                Throwable throwable2 = throwable;
                if (throwable2 == null || (option = package$.MODULE$.ERROR().unapply(throwable2)).isEmpty()) {
                    throw throwable;
                }
                String string = (String)option.get();
                throw (Nothing$)package$.MODULE$.error().apply((Object)("Failed to create directory: " + path.absolute()));
            }
        }
        return path;
    }

    public Path new_directory(Path path) {
        if (path.is_dir()) {
            return (Path)package$.MODULE$.error().apply((Object)("Directory already exists: " + path.absolute()));
        }
        return this.make_directory(path);
    }

    public void copy_dir(Path dir1, Path dir2, boolean direct) {
        String p1 = this.make_path$1(direct, dir1);
        String p2 = this.make_path$1(direct, dir2);
        this.make_directory(direct ? dir2.absolute() : dir2.absolute().dir());
        Process_Result res = this.bash("cp -a " + Bash$.MODULE$.string(p1) + " " + Bash$.MODULE$.string(p2), this.bash$default$2(), this.bash$default$3(), this.bash$default$4(), this.bash$default$5(), this.bash$default$6(), this.bash$default$7(), this.bash$default$8(), this.bash$default$9(), this.bash$default$10(), this.bash$default$11(), this.bash$default$12());
        if (!res.ok()) {
            throw package$.MODULE$.cat_error((scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to copy " + package$.MODULE$.quote().apply((Object)p1) + " to " + package$.MODULE$.quote().apply((Object)p2), res.err()}));
        }
    }

    public boolean copy_dir$default$3() {
        return false;
    }

    public <A> A with_copy_dir(Path dir1, Path dir2, Function0<A> body) {
        Object object;
        this.new_directory(dir2);
        try {
            this.copy_dir(dir1, dir2, true);
            object = body.apply();
        }
        finally {
            this.rm_tree(dir2);
        }
        return (A)object;
    }

    public void copy_file(File src, File dst) {
        File target;
        File file = target = dst.isDirectory() ? new File(dst, src.getName()) : dst;
        if (!File$.MODULE$.eq(src, target)) {
            try {
                Files.copy(src.toPath(), target.toPath(), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable) {
                String string;
                Option<String> option;
                Throwable throwable2 = throwable;
                if (throwable2 == null || (option = package$.MODULE$.ERROR().unapply(throwable2)).isEmpty()) {
                    throw throwable;
                }
                String msg = string = (String)option.get();
                throw package$.MODULE$.cat_error((scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to copy file " + File$.MODULE$.path(src).absolute() + " to " + File$.MODULE$.path(target).absolute(), msg}));
            }
            return;
        }
    }

    public void copy_file(Path src, Path dst) {
        this.copy_file(src.file(), dst.file());
    }

    public void copy_file_base(Path base_dir, Path src, Path target_dir) {
        Path src1 = src.expand();
        Path src1_dir = src1.dir();
        if (!src1.starts_basic()) {
            package$.MODULE$.error().apply((Object)("Illegal path specification " + src1 + " beyond base directory " + base_dir.absolute()));
        }
        this.copy_file(base_dir.$plus(src1), this.make_directory(target_dir.$plus(src1_dir)));
    }

    public void move_file(File src, File dst) {
        File target;
        File file = target = dst.isDirectory() ? new File(dst, src.getName()) : dst;
        if (!File$.MODULE$.eq(src, target)) {
            Files.move(src.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return;
        }
    }

    public void move_file(Path src, Path dst) {
        this.move_file(src.file(), dst.file());
    }

    public void symlink(Path src, Path dst, boolean force, boolean bl) {
        File target;
        File src_file = src.file();
        File dst_file = dst.file();
        File file = target = dst_file.isDirectory() ? new File(dst_file, src_file.getName()) : dst_file;
        if (force) {
            target.delete();
        }
        try {
            Files.createSymbolicLink(target.toPath(), src_file.toPath(), new FileAttribute[0]);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof UnsupportedOperationException && Platform$.MODULE$.is_windows()) {
                this.cygwin_link$1(bl, src_file, src, target);
            }
            if (throwable2 instanceof FileSystemException && Platform$.MODULE$.is_windows()) {
                this.cygwin_link$1(bl, src_file, src, target);
            }
            throw throwable;
        }
    }

    public boolean symlink$default$3() {
        return false;
    }

    public boolean symlink$default$4() {
        return false;
    }

    public File isabelle_tmp_prefix() {
        Path path = Path$.MODULE$.explode("$ISABELLE_TMP_PREFIX");
        path.file().mkdirs();
        return File$.MODULE$.platform_file(path);
    }

    public File tmp_file(String name, String ext, File base_dir, boolean initialized) {
        String suffix = package$.MODULE$.if_proper(Predef$.MODULE$.wrapString(ext), (Function0<String>)((Function0 & Serializable)() -> Isabelle_System$.$anonfun$1(ext)));
        File file = Files.createTempFile(base_dir.toPath(), name, suffix, new FileAttribute[0]).toFile();
        if (initialized) {
            file.deleteOnExit();
            v0 = BoxedUnit.UNIT;
        } else {
            v0 = BoxesRunTime.boxToBoolean((boolean)file.delete());
        }
        return file;
    }

    public String tmp_file$default$2() {
        return "";
    }

    public File tmp_file$default$3() {
        return this.isabelle_tmp_prefix();
    }

    public boolean tmp_file$default$4() {
        return true;
    }

    public <A> A with_tmp_file(String name, String ext, File base_dir, Function1<Path, A> body) {
        Object object;
        File file = this.tmp_file(name, ext, base_dir, this.tmp_file$default$4());
        try {
            object = body.apply((Object)File$.MODULE$.path(file));
        }
        finally {
            file.delete();
        }
        return (A)object;
    }

    public <A> String with_tmp_file$default$2() {
        return "";
    }

    public <A> File with_tmp_file$default$3() {
        return this.isabelle_tmp_prefix();
    }

    public void rm_tree(File root) {
        root.delete();
        if (root.isDirectory()) {
            Files.walkFileTree(root.toPath(), (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

                public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) {
                    Boolean bl;
                    try {
                        bl = BoxesRunTime.boxToBoolean((boolean)Files.deleteIfExists(file));
                    }
                    catch (IOException iOException) {
                        bl = BoxedUnit.UNIT;
                    }
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult postVisitDirectory(java.nio.file.Path dir, IOException e) {
                    if (e == null) {
                        Boolean bl;
                        try {
                            bl = BoxesRunTime.boxToBoolean((boolean)Files.deleteIfExists(dir));
                        }
                        catch (IOException iOException) {
                            bl = BoxedUnit.UNIT;
                        }
                        return FileVisitResult.CONTINUE;
                    }
                    throw e;
                }
            });
            return;
        }
    }

    public void rm_tree(Path root) {
        this.rm_tree(root.file());
    }

    public File tmp_dir(String name, File base_dir) {
        File dir = Files.createTempDirectory(base_dir.toPath(), name, new FileAttribute[0]).toFile();
        dir.deleteOnExit();
        return dir;
    }

    public File tmp_dir$default$2() {
        return this.isabelle_tmp_prefix();
    }

    public <A> A with_tmp_dir(String name, File base_dir, Function1<Path, A> body) {
        Object object;
        File dir = this.tmp_dir(name, base_dir);
        try {
            object = body.apply((Object)File$.MODULE$.path(dir));
        }
        finally {
            this.rm_tree(dir);
        }
        return (A)object;
    }

    public <A> File with_tmp_dir$default$2() {
        return this.isabelle_tmp_prefix();
    }

    public void update_directory(Path dir, Function1<Path, BoxedUnit> f) {
        Path new_dir = dir.ext("new");
        Path old_dir = dir.ext("old");
        this.rm_tree(new_dir);
        this.rm_tree(old_dir);
        f.apply((Object)new_dir);
        if (dir.is_dir()) {
            this.move_file(dir, old_dir);
        }
        this.move_file(new_dir, dir);
        this.rm_tree(old_dir);
    }

    public int local_port() {
        ServerSocket socket = new ServerSocket(0);
        int port = socket.getLocalPort();
        socket.close();
        return port;
    }

    public Thread create_shutdown_hook(Function0<BoxedUnit> body) {
        Isabelle_Thread shutdown_hook = Isabelle_Thread$.MODULE$.create(new Runnable(body){
            private final Function0 body$1;
            {
                this.body$1 = body$2;
            }

            public void run() {
                this.body$1.apply$mcV$sp();
            }
        }, Isabelle_Thread$.MODULE$.create$default$2(), Isabelle_Thread$.MODULE$.create$default$3(), Isabelle_Thread$.MODULE$.create$default$4(), Isabelle_Thread$.MODULE$.create$default$5(), Isabelle_Thread$.MODULE$.create$default$6());
        try {
            Runtime.getRuntime().addShutdownHook(shutdown_hook);
        }
        catch (IllegalStateException illegalStateException) {}
        return shutdown_hook;
    }

    public void remove_shutdown_hook(Thread shutdown_hook) {
        try {
            Runtime.getRuntime().removeShutdownHook(shutdown_hook);
        }
        catch (IllegalStateException illegalStateException) {}
    }

    public Process_Result bash(String script, String description, SSH.System ssh, Path cwd, Map<String, String> env, boolean redirect, String input, Function1<String, BoxedUnit> progress_stdout, Function1<String, BoxedUnit> progress_stderr, Bash.Watchdog watchdog, boolean strict, Function0<BoxedUnit> cleanup) {
        return Bash$.MODULE$.process(script, description, ssh, cwd, env, redirect, cleanup).result(input, progress_stdout, progress_stderr, watchdog, strict);
    }

    public String bash$default$2() {
        return "";
    }

    public SSH.System bash$default$3() {
        return SSH$Local$.MODULE$;
    }

    public Path bash$default$4() {
        return Path$.MODULE$.current();
    }

    public Map<String, String> bash$default$5() {
        return Isabelle_System$Settings$.MODULE$.env(Isabelle_System$Settings$.MODULE$.env$default$1());
    }

    public boolean bash$default$6() {
        return false;
    }

    public String bash$default$7() {
        return "";
    }

    public Function1<String, BoxedUnit> bash$default$8() {
        return (JProcedure1 & Serializable)_$3 -> {};
    }

    public Function1<String, BoxedUnit> bash$default$9() {
        return (JProcedure1 & Serializable)_$4 -> {};
    }

    public Bash.Watchdog bash$default$10() {
        return Bash$Watchdog$.MODULE$.none();
    }

    public boolean bash$default$11() {
        return true;
    }

    public Function0<BoxedUnit> bash$default$12() {
        return (JFunction0.mcV.sp & Serializable)() -> {};
    }

    public List<String> bash_functions() {
        Object object = this.bash_functions$lzy1;
        if (object instanceof List) {
            return (List)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (List)this.bash_functions$lzyINIT1();
    }

    private Object bash_functions$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.bash_functions$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    List list = null;
                    try {
                        list = this.bash("declare -Fx", this.bash$default$2(), this.bash$default$3(), this.bash$default$4(), this.bash$default$5(), this.bash$default$6(), this.bash$default$7(), this.bash$default$8(), this.bash$default$9(), this.bash$default$10(), this.bash$default$11(), this.bash$default$12()).check().out_lines().flatMap((Function1 & Serializable)s -> Word$.MODULE$.explode((String)s).lastOption());
                        object2 = list == null ? LazyVals.NullValue$.MODULE$ : list;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.bash_functions$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.bash_functions$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return list;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public List<String> no_bash_functions() {
        return this.bash_functions().map((Function1 & Serializable)_$5 -> "-" + _$5);
    }

    public void require_command(String cmd, String test) {
        if (!this.bash(Bash$.MODULE$.string(cmd) + " " + test, this.bash$default$2(), this.bash$default$3(), this.bash$default$4(), this.bash$default$5(), this.bash$default$6(), this.bash$default$7(), this.bash$default$8(), this.bash$default$9(), this.bash$default$10(), this.bash$default$11(), this.bash$default$12()).ok()) {
            package$.MODULE$.error().apply((Object)("Missing system command: " + package$.MODULE$.quote().apply((Object)cmd)));
            return;
        }
    }

    public String require_command$default$2() {
        return "--version";
    }

    private boolean gnutar_check() {
        Object object = this.gnutar_check$lzy1;
        if (object instanceof Boolean) {
            return BoxesRunTime.unboxToBoolean((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToBoolean(null);
        }
        return BoxesRunTime.unboxToBoolean((Object)this.gnutar_check$lzyINIT1());
    }

    private Object gnutar_check$lzyINIT1() {
        Object object;
        block10: {
            while (true) {
                if ((object = this.gnutar_check$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Boolean bl = null;
                    try {
                        boolean bl2;
                        try {
                            bl2 = Predef$.MODULE$.wrapString(this.bash("tar --version", this.bash$default$2(), this.bash$default$3(), this.bash$default$4(), this.bash$default$5(), this.bash$default$6(), this.bash$default$7(), this.bash$default$8(), this.bash$default$9(), this.bash$default$10(), this.bash$default$11(), this.bash$default$12()).check().out()).containsSlice((Seq)Predef$.MODULE$.wrapString("GNU tar")) || BoxesRunTime.unboxToBoolean((Object)package$.MODULE$.error().apply((Object)""));
                        }
                        catch (Throwable throwable) {
                            Option<String> option;
                            Throwable throwable2 = throwable;
                            if (throwable2 != null && !(option = package$.MODULE$.ERROR().unapply(throwable2)).isEmpty()) {
                                String string = (String)option.get();
                                bl2 = false;
                            }
                            throw throwable;
                        }
                        bl = BoxesRunTime.boxToBoolean((boolean)bl2);
                        object2 = bl == null ? LazyVals.NullValue$.MODULE$ : bl;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.gnutar_check$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.gnutar_check$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return bl;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block10;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Process_Result gnutar(String args, Path dir, boolean original_owner, boolean strip, boolean redirect) {
        String options = (String)(dir.is_current() ? "" : "-C " + File$.MODULE$.bash_path(dir) + " ") + (original_owner ? "" : "--owner=root --group=staff ") + (!strip ? "" : "--strip-components=1 ");
        if (this.gnutar_check()) {
            String string = "tar " + options + args;
            String string2 = this.bash$default$2();
            SSH.System system = this.bash$default$3();
            Path path = this.bash$default$4();
            Map<String, String> map = this.bash$default$5();
            String string3 = this.bash$default$7();
            Function1<String, BoxedUnit> function1 = this.bash$default$8();
            Function1<String, BoxedUnit> function12 = this.bash$default$9();
            Bash.Watchdog watchdog = this.bash$default$10();
            boolean bl = this.bash$default$11();
            Function0<BoxedUnit> function0 = this.bash$default$12();
            return this.bash(string, string2, system, path, map, redirect, string3, function1, function12, watchdog, bl, function0);
        }
        return (Process_Result)package$.MODULE$.error().apply((Object)"Expected to find GNU tar executable");
    }

    public Path gnutar$default$2() {
        return Path$.MODULE$.current();
    }

    public boolean gnutar$default$3() {
        return false;
    }

    public boolean gnutar$default$4() {
        return false;
    }

    public boolean gnutar$default$5() {
        return false;
    }

    public void extract(Path archive, Path dir, boolean strip) {
        String extr;
        String name = archive.file_name();
        this.make_directory(dir);
        if (File$.MODULE$.is_zip(name) || File$.MODULE$.is_jar(name)) {
            package$.MODULE$.using(new ZipFile(archive.file()), (JProcedure1 & Serializable)zip_file -> {
                List items = CollectionConverters$.MODULE$.EnumerationHasAsScala(zip_file.entries()).asScala().toList().map((Function1 & Serializable)entry -> {
                    java.nio.file.Path input = java.nio.file.Path.of(entry.getName(), new String[0]);
                    int count = input.getNameCount();
                    None$ output = strip && count <= 1 ? None$.MODULE$ : (strip ? Some$.MODULE$.apply((Object)input.subpath(1, count)) : Some$.MODULE$.apply((Object)input));
                    Option result = output.map((Function1 & Serializable)_$6 -> dir.java_path().resolve((java.nio.file.Path)_$6));
                    result.foreach((Function1 & Serializable)res -> {
                        if (entry.isDirectory()) {
                            return Files.createDirectories(res, new FileAttribute[0]);
                        }
                        Bytes bytes = (Bytes)package$.MODULE$.using(zip_file.getInputStream((ZipEntry)entry), (Function1 & Serializable)_$7 -> Bytes$.MODULE$.read_stream((InputStream)_$7, Bytes$.MODULE$.read_stream$default$2(), Bytes$.MODULE$.read_stream$default$3()));
                        Files.createDirectories(res.getParent(), new FileAttribute[0]);
                        return Files.write(res, bytes.make_array(), new OpenOption[0]);
                    });
                    return Tuple2$.MODULE$.apply(entry, (Object)result);
                });
                items.withFilter((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Option option = (Option)tuple2._2();
                        ZipEntry entry = (ZipEntry)tuple2._1();
                        if (option instanceof Some) {
                            java.nio.file.Path res = (java.nio.file.Path)((Some)option).value();
                            return true;
                        }
                    }
                    return false;
                }).withFilter((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Option option = (Option)tuple2._2();
                        ZipEntry entry = (ZipEntry)tuple2._1();
                        if (option instanceof Some) {
                            java.nio.file.Path res = (java.nio.file.Path)((Some)option).value();
                            return !entry.isDirectory();
                        }
                    }
                    throw new MatchError((Object)tuple2);
                }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Option option = (Option)tuple2._2();
                        ZipEntry entry = (ZipEntry)tuple2._1();
                        if (option instanceof Some) {
                            java.nio.file.Path res = (java.nio.file.Path)((Some)option).value();
                            Option$.MODULE$.apply((Object)entry.getLastModifiedTime()).foreach((Function1 & Serializable)t -> Files.setLastModifiedTime(res, t));
                            return;
                        }
                    }
                    throw new MatchError((Object)tuple2);
                });
            });
            return;
        }
        String string = File$.MODULE$.is_tar_bz2(name) ? "-xjf" : (File$.MODULE$.is_tgz(name) || File$.MODULE$.is_tar_gz(name) ? "-xzf" : (extr = File$.MODULE$.is_tar_xz(name) ? "--xz -xf" : ""));
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(extr))) {
            String string2 = extr + " " + File$.MODULE$.bash_path(archive);
            boolean bl = this.gnutar$default$3();
            boolean bl2 = this.gnutar$default$5();
            this.gnutar(string2, dir, bl, strip, bl2).check();
            return;
        }
        package$.MODULE$.error().apply((Object)("Cannot extract " + archive));
    }

    public boolean extract$default$3() {
        return false;
    }

    public String make_patch(Path base_dir, Path src, Path dst, String diff_options) {
        String string = "diff -Nru" + package$.MODULE$.if_proper(Predef$.MODULE$.wrapString(diff_options), (Function0<String>)((Function0 & Serializable)() -> Isabelle_System$.$anonfun$5(diff_options))) + " -- " + File$.MODULE$.bash_path(src) + " " + File$.MODULE$.bash_path(dst);
        String string2 = this.bash$default$2();
        SSH.System system = this.bash$default$3();
        Map<String, String> map = this.bash$default$5();
        boolean bl = this.bash$default$6();
        String string3 = this.bash$default$7();
        Function1<String, BoxedUnit> function1 = this.bash$default$8();
        Function1<String, BoxedUnit> function12 = this.bash$default$9();
        Bash.Watchdog watchdog = this.bash$default$10();
        boolean bl2 = this.bash$default$11();
        Function0<BoxedUnit> function0 = this.bash$default$12();
        List<String> lines = this.bash(string, string2, system, base_dir, map, bl, string3, function1, function12, watchdog, bl2, function0).check_rc((Function1<Object, Object>)Process_Result$RC$.MODULE$.regular()).out_lines();
        return Library$.MODULE$.terminate_lines((IterableOnce<String>)lines);
    }

    public String make_patch$default$4() {
        return "";
    }

    public void apply_patch(Path base_dir, String patch, int strip, Progress progress) {
        this.require_command("patch", this.require_command$default$2());
        this.with_tmp_file("patch", "rej", this.with_tmp_file$default$3(), (Function1)(JProcedure1 & Serializable)rej -> {
            Function0<BoxedUnit> function0;
            boolean bl;
            Bash.Watchdog watchdog;
            Function1<String, BoxedUnit> function1;
            boolean bl2;
            Map<String, String> map;
            SSH.System system;
            String string = "patch -f -p" + strip + " -r " + File$.MODULE$.bash_path((Path)rej);
            JProcedure1 & Serializable intersect = (JProcedure1 & Serializable)_$8 -> progress.echo_if(progress.verbose(), (String)_$8);
            String string2 = MODULE$.bash$default$2();
            Process_Result result = MODULE$.bash(string, string2, system = MODULE$.bash$default$3(), base_dir, map = MODULE$.bash$default$5(), bl2 = MODULE$.bash$default$6(), patch, (Function1<String, BoxedUnit>)intersect, function1 = MODULE$.bash$default$9(), watchdog = MODULE$.bash$default$10(), bl = MODULE$.bash$default$11(), function0 = MODULE$.bash$default$12());
            if (!result.ok()) {
                List<String> lines = rej.is_file() ? Library$.MODULE$.trim_split_lines(File$.MODULE$.read((Path)rej)) : scala.package$.MODULE$.Nil();
                package$.MODULE$.error().apply((Object)("Failed to apply patch" + package$.MODULE$.if_proper(lines, (Function0<String>)((Function0 & Serializable)Isabelle_System$::apply_patch$$anonfun$1$$anonfun$1)) + package$.MODULE$.cat_lines().apply(lines)));
                return;
            }
        });
    }

    public int apply_patch$default$3() {
        return 1;
    }

    public Progress apply_patch$default$4() {
        return new Progress();
    }

    public void git_clone(String url, Path target, String checkout, SSH.System ssh, Progress progress) {
        progress.echo("Cloning " + package$.MODULE$.quote().apply((Object)url) + " ...", progress.echo$default$2());
        String string = "git clone --quiet --no-checkout " + Bash$.MODULE$.string(url) + " . && git checkout --quiet --detach " + Bash$.MODULE$.string(checkout);
        Path path = ssh.make_directory(target);
        String string2 = this.bash$default$2();
        Map<String, String> map = this.bash$default$5();
        boolean bl = this.bash$default$6();
        String string3 = this.bash$default$7();
        Function1<String, BoxedUnit> function1 = this.bash$default$8();
        Function1<String, BoxedUnit> function12 = this.bash$default$9();
        Bash.Watchdog watchdog = this.bash$default$10();
        boolean bl2 = this.bash$default$11();
        Function0<BoxedUnit> function0 = this.bash$default$12();
        this.bash(string, string2, ssh, path, map, bl, string3, function1, function12, watchdog, bl2, function0).check();
    }

    public String git_clone$default$3() {
        return "HEAD";
    }

    public SSH.System git_clone$default$4() {
        return SSH$Local$.MODULE$;
    }

    public Progress git_clone$default$5() {
        return new Progress();
    }

    public void open(String arg) {
        this.bash("exec \"$ISABELLE_OPEN\" " + Bash$.MODULE$.string(arg) + " >/dev/null 2>/dev/null &", this.bash$default$2(), this.bash$default$3(), this.bash$default$4(), this.bash$default$5(), this.bash$default$6(), this.bash$default$7(), this.bash$default$8(), this.bash$default$9(), this.bash$default$10(), this.bash$default$11(), this.bash$default$12());
    }

    public void pdf_viewer(Path arg) {
        this.bash("exec \"$PDF_VIEWER\" " + File$.MODULE$.bash_path(arg) + " >/dev/null 2>/dev/null &", this.bash$default$2(), this.bash$default$3(), this.bash$default$4(), this.bash$default$5(), this.bash$default$6(), this.bash$default$7(), this.bash$default$8(), this.bash$default$9(), this.bash$default$10(), this.bash$default$11(), this.bash$default$12());
    }

    public boolean open_external_file(String name) {
        boolean external;
        String ext = ((IterableOnceOps)Library$.MODULE$.take_suffix((Function1 & Serializable)c -> Isabelle_System$.$anonfun$7(BoxesRunTime.unboxToChar((Object)c)), Predef$.MODULE$.wrapString(name).toList())._2()).mkString();
        boolean bl = external = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(ext)) && ((List)package$.MODULE$.space_explode().apply((Object)BoxesRunTime.boxToCharacter((char)':'), (Object)this.getenv("ISABELLE_EXTERNAL_FILES", this.getenv$default$2()))).contains((Object)ext);
        if (external) {
            String string = ext;
            String string2 = "pdf";
            if (!(string != null ? !string.equals(string2) : string2 != null) && Path$.MODULE$.is_wellformed(name)) {
                this.pdf_viewer(Path$.MODULE$.explode(name));
            } else {
                this.open(name);
            }
        }
        return external;
    }

    public boolean admin() {
        return Path$.MODULE$.explode("~~/Admin").is_dir();
    }

    public String default_logic(scala.collection.immutable.Seq<String> args) {
        return (String)args.find((Function1 & Serializable)_$9 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$9))).getOrElse(this::default_logic$$anonfun$2);
    }

    public HTTP.Content download(String url_name, Progress progress) {
        HTTP.Content content;
        Url url = Url$.MODULE$.apply(url_name);
        progress.echo("Getting " + package$.MODULE$.quote().apply((Object)url_name), progress.echo$default$2());
        try {
            content = HTTP$Client$.MODULE$.get(url, HTTP$Client$.MODULE$.get$default$2(), HTTP$Client$.MODULE$.get$default$3());
        }
        catch (Throwable throwable) {
            String string;
            Option<String> option;
            Throwable throwable2 = throwable;
            if (throwable2 == null || (option = package$.MODULE$.ERROR().unapply(throwable2)).isEmpty()) {
                throw throwable;
            }
            String msg = string = (String)option.get();
            throw package$.MODULE$.cat_error((scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to download " + package$.MODULE$.quote().apply((Object)url_name), msg}));
        }
        return content;
    }

    public Progress download$default$2() {
        return new Progress();
    }

    public void download_file(String url_name, Path file, Progress progress) {
        Bytes$.MODULE$.write(file, this.download(url_name, progress).bytes());
    }

    public Progress download_file$default$3() {
        return new Progress();
    }

    public Mercurial.Server isabelle_repository() {
        return isabelle_repository;
    }

    public Mercurial.Server afp_repository() {
        return afp_repository;
    }

    public List<String> official_releases() {
        return Library$.MODULE$.trim_split_lines(this.isabelle_repository().read_file(Path$.MODULE$.explode("Admin/Release/official"), this.isabelle_repository().read_file$default$2()));
    }

    public static final String isabelle$Isabelle_System$Env$$_$get$$anonfun$1() {
        return "";
    }

    public static final /* synthetic */ boolean isabelle$Isabelle_System$Settings$$$_$env$$anonfun$1(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            String a = (String)tuple2._1();
            String b = (String)tuple2._2();
            return true;
        }
        return false;
    }

    public static final /* synthetic */ String isabelle$Isabelle_System$Settings$$$_$env$$anonfun$2(HashMap env$5, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            String a = (String)tuple2._1();
            String b = (String)tuple2._2();
            return env$5.put(a, b);
        }
        throw new MatchError((Object)tuple2);
    }

    private static final String getenv_strict$$anonfun$1(String name$1) {
        return (String)package$.MODULE$.error().apply((Object)("Undefined Isabelle environment variable: " + package$.MODULE$.quote().apply((Object)name$1)));
    }

    private final String hostname$$anonfun$1() {
        return this.getenv_strict("ISABELLE_HOSTNAME", this.getenv_strict$default$2());
    }

    private static final Option isabelle_id$$anonfun$1(Path root$1) {
        return Mercurial$.MODULE$.archive_id(root$1);
    }

    private static final Option isabelle_id$$anonfun$2(Path root$2) {
        return Mercurial$.MODULE$.id_repository(root$2, Mercurial$.MODULE$.id_repository$default$2(), "");
    }

    private static final Option isabelle_id$$anonfun$3(Path root$3) {
        return Mercurial$.MODULE$.sync_id(root$3, Mercurial$.MODULE$.sync_id$default$2());
    }

    private static final String isabelle_id$$anonfun$4(Path root$4) {
        return (String)package$.MODULE$.error().apply((Object)("Failed to identify Isabelle distribution " + root$4.expand()));
    }

    private static final Option isabelle_tags$$anonfun$1(Path root$5) {
        return Mercurial$.MODULE$.archive_tags(root$5);
    }

    private static final String isabelle_tags$$anonfun$2(Path root$6) {
        if (Mercurial$.MODULE$.is_repository(root$6, Mercurial$.MODULE$.is_repository$default$2())) {
            Mercurial.Repository hg = Mercurial$.MODULE$.repository(root$6, Mercurial$.MODULE$.repository$default$2());
            return hg.tags(hg.parent());
        }
        return "";
    }

    private final String make_path$1(boolean direct$1, Path dir) {
        return Url$.MODULE$.dir_path(File$.MODULE$.standard_path(dir.absolute()), direct$1);
    }

    public static final /* synthetic */ void isabelle$Isabelle_System$Make_Directory$$$_$apply$$anonfun$1(Path path) {
        MODULE$.make_directory(path);
    }

    public final /* synthetic */ void isabelle$Isabelle_System$Copy_Dir$$$_$apply$$anonfun$2(Path _$1, Path _$2) {
        this.copy_dir(_$1, _$2, this.copy_dir$default$3());
    }

    public static final /* synthetic */ void isabelle$Isabelle_System$Copy_File$$$_$apply$$anonfun$3(Path src, Path dst) {
        MODULE$.copy_file(src, dst);
    }

    public static final /* synthetic */ void isabelle$Isabelle_System$Copy_File_Base$$$_$apply$$anonfun$4(Path base_dir, Path src, Path target_dir) {
        MODULE$.copy_file_base(base_dir, src, target_dir);
    }

    private final void cygwin_link$1(boolean native$1, File src_file$1, Path src$1, File target$1) {
        if (native$1) {
            package$.MODULE$.error().apply((Object)("Failed to create native symlink on Windows: " + package$.MODULE$.quote().apply((Object)src_file$1.toString()) + "\n(but it could work as Administrator)"));
            return;
        }
        Environment.cygwin_link((String)File$.MODULE$.standard_path(src$1), (File)target$1);
    }

    private static final String $anonfun$1(String ext$1) {
        return "." + ext$1;
    }

    public static final /* synthetic */ void isabelle$Isabelle_System$Rm_Tree$$$_$apply$$anonfun$5(Path root) {
        MODULE$.rm_tree(root);
    }

    private static final String $anonfun$5(String diff_options$1) {
        return " " + diff_options$1;
    }

    private static final String apply_patch$$anonfun$1$$anonfun$1() {
        return ":\n";
    }

    private static final /* synthetic */ boolean $anonfun$7(char c) {
        return c != '.';
    }

    private final String default_logic$$anonfun$2() {
        return this.getenv_strict("ISABELLE_LOGIC", this.getenv_strict$default$2());
    }

    public final /* synthetic */ Bytes isabelle$Isabelle_System$Download$$$_$invoke$$anonfun$1(Bytes url) {
        return this.download(url.text(), this.download$default$2()).bytes();
    }
}

