/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Byte_Message$;
import isabelle.Bytes;
import isabelle.Isabelle_System$;
import isabelle.Server$;
import isabelle.System_Channel$;
import isabelle.UUID$;
import isabelle.package$;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ProtocolFamily;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.net.UnixDomainSocketAddress;
import java.nio.channels.Channels;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

public abstract class System_Channel {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(System_Channel.class.getDeclaredField("password$lzy1"));
    private final ServerSocketChannel server;
    private volatile Object password$lzy1;

    public static System_Channel apply(boolean bl) {
        return System_Channel$.MODULE$.apply(bl);
    }

    public static Integer buffer_size() {
        return System_Channel$.MODULE$.buffer_size();
    }

    public static boolean apply$default$1() {
        return System_Channel$.MODULE$.apply$default$1();
    }

    public System_Channel(ProtocolFamily protocol_family) {
        this.server = ServerSocketChannel.open(protocol_family);
    }

    public ServerSocketChannel server() {
        return this.server;
    }

    public abstract String address();

    public String password() {
        Object object = this.password$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.password$lzyINIT1();
    }

    private Object password$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.password$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = UUID$.MODULE$.random_string();
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.password$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String toString() {
        return this.address();
    }

    public void shutdown() {
        this.server().close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Tuple2<OutputStream, InputStream> rendezvous() {
        SocketChannel socket = this.server().accept();
        try {
            Tuple2 tuple2;
            OutputStream out_stream = Channels.newOutputStream(socket);
            InputStream in_stream = Channels.newInputStream(socket);
            Option<Bytes> option = Byte_Message$.MODULE$.read_line(in_stream);
            if (option instanceof Some) {
                Bytes bs = (Bytes)((Some)option).value();
                String string = bs.text();
                String string2 = this.password();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    tuple2 = Tuple2$.MODULE$.apply((Object)out_stream, (Object)in_stream);
                    return tuple2;
                }
            }
            out_stream.close();
            in_stream.close();
            tuple2 = (Tuple2)package$.MODULE$.error().apply((Object)"Failed to connect system channel: bad password");
            return tuple2;
        }
        finally {
            this.shutdown();
        }
    }

    public static class Inet
    extends System_Channel {
        public Inet() {
            super(StandardProtocolFamily.INET);
            this.server().bind(new InetSocketAddress(Server$.MODULE$.localhost(), 0), 50);
            this.server().setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, System_Channel$.MODULE$.buffer_size());
        }

        @Override
        public String address() {
            return Server$.MODULE$.print_address(((InetSocketAddress)this.server().getLocalAddress()).getPort());
        }
    }

    public static class Unix
    extends System_Channel {
        private final File socket_file = Isabelle_System$.MODULE$.tmp_file("socket", Isabelle_System$.MODULE$.tmp_file$default$2(), Isabelle_System$.MODULE$.tmp_file$default$3(), false);
        private final String socket_file_name = this.socket_file.getPath();

        public Unix() {
            super(StandardProtocolFamily.UNIX);
            this.server().bind(UnixDomainSocketAddress.of(this.socket_file_name));
            this.server().setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, System_Channel$.MODULE$.buffer_size());
        }

        @Override
        public String address() {
            return this.socket_file_name;
        }

        @Override
        public void shutdown() {
            super.shutdown();
            this.socket_file.delete();
        }
    }
}

