/*
 * Decompiled with CFR 0.152.
 */
package isabelle.graphview;

import isabelle.Graph;
import isabelle.Graph_Display;
import isabelle.Options;
import isabelle.XML;
import isabelle.graphview.Layout$;
import isabelle.graphview.Layout$Dummy$;
import isabelle.graphview.Layout$Info$;
import isabelle.graphview.Layout$Node$;
import isabelle.graphview.Layout$Vertex$;
import isabelle.graphview.Metrics;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class Layout {
    private final Metrics metrics;
    private final Graph input_graph;
    private final Graph output_graph;

    public static Layout empty() {
        return Layout$.MODULE$.empty();
    }

    public static Graph<Vertex, Info> empty_graph() {
        return Layout$.MODULE$.empty_graph();
    }

    public static Layout make(Options options, Metrics metrics, Function2<Graph_Display.Node, List<XML.Tree>, String> function2, Graph<Graph_Display.Node, List<XML.Tree>> graph) {
        return Layout$.MODULE$.make(options, metrics, function2, graph);
    }

    public static Graph<Vertex, Info> make_graph(List<Tuple2<Tuple2<Vertex, Info>, List<Vertex>>> list) {
        return Layout$.MODULE$.make_graph(list);
    }

    public Layout(Metrics metrics, Graph<Graph_Display.Node, List<XML.Tree>> input_graph, Graph<Vertex, Info> output_graph) {
        this.metrics = metrics;
        this.input_graph = input_graph;
        this.output_graph = output_graph;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public Graph<Graph_Display.Node, List<XML.Tree>> input_graph() {
        return this.input_graph;
    }

    public Graph<Vertex, Info> output_graph() {
        return this.output_graph;
    }

    public Layout translate_vertex(Vertex v, double dx, double dy) {
        if (dx == 0.0 && dy == 0.0 || !this.output_graph().defined(v)) {
            return this;
        }
        Graph<Vertex, Info> output_graph1 = this.output_graph().map_node(v, (Function1<Info, Info>)(Function1 & Serializable)info -> info.copy(info.x() + dx, info.y() + dy, info.copy$default$3(), info.copy$default$4(), info.copy$default$5()));
        return new Layout(this.metrics(), this.input_graph(), output_graph1);
    }

    public Info get_node(Graph_Display.Node node) {
        return this.output_graph().get_node(Layout$Node$.MODULE$.apply(node));
    }

    public Iterator<Info> nodes_iterator() {
        return this.output_graph().iterator().withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple2._1() instanceof Node && tuple22 != null) {
                    Info info = (Info)tuple22._1();
                    return true;
                }
            }
            return false;
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple2._1() instanceof Node && tuple22 != null) {
                    Info info = (Info)tuple22._1();
                    return info;
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Iterator<Info> dummies_iterator() {
        return this.output_graph().iterator().withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple2._1() instanceof Dummy && tuple22 != null) {
                    Info info = (Info)tuple22._1();
                    return true;
                }
            }
            return false;
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple2._1() instanceof Dummy && tuple22 != null) {
                    Info info = (Info)tuple22._1();
                    return info;
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Iterator<Info> dummies_iterator(Tuple2<Graph_Display.Node, Graph_Display.Node> edge) {
        return new Iterator<Info>(edge, this){
            private final Tuple2 edge$1;
            private int index;
            private final /* synthetic */ Layout $outer;
            {
                this.edge$1 = edge$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
                this.index = 0;
            }

            public boolean hasNext() {
                return this.$outer.output_graph().defined(Layout$Dummy$.MODULE$.apply((Graph_Display.Node)this.edge$1._1(), (Graph_Display.Node)this.edge$1._2(), this.index));
            }

            public Info next() {
                Info info = this.$outer.output_graph().get_node(Layout$Dummy$.MODULE$.apply((Graph_Display.Node)this.edge$1._1(), (Graph_Display.Node)this.edge$1._2(), this.index));
                ++this.index;
                return info;
            }
        };
    }

    public static class Dummy
    extends Vertex
    implements Product,
    Serializable {
        private final Graph_Display.Node node1;
        private final Graph_Display.Node node2;
        private final int index;

        public static Dummy apply(Graph_Display.Node node, Graph_Display.Node node2, int n) {
            return Layout$Dummy$.MODULE$.apply(node, node2, n);
        }

        public static Dummy fromProduct(Product product) {
            return Layout$Dummy$.MODULE$.fromProduct(product);
        }

        public static Dummy unapply(Dummy dummy) {
            return Layout$Dummy$.MODULE$.unapply(dummy);
        }

        public Dummy(Graph_Display.Node node1, Graph_Display.Node node2, int index) {
            this.node1 = node1;
            this.node2 = node2;
            this.index = index;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.node1()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.node2()));
            n = Statics.mix((int)n, (int)this.index());
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Dummy)) return false;
            Dummy dummy = (Dummy)object;
            if (this.index() != dummy.index()) return false;
            Graph_Display.Node node = this.node1();
            Graph_Display.Node node2 = dummy.node1();
            if (node == null) {
                if (node2 != null) {
                    return false;
                }
            } else if (!((Object)node).equals(node2)) return false;
            Graph_Display.Node node3 = this.node2();
            Graph_Display.Node node4 = dummy.node2();
            if (node3 == null) {
                if (node4 != null) {
                    return false;
                }
            } else if (!((Object)node3).equals(node4)) return false;
            if (!dummy.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Dummy;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Dummy";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "node1";
                }
                case 1: {
                    return "node2";
                }
                case 2: {
                    return "index";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Graph_Display.Node node1() {
            return this.node1;
        }

        public Graph_Display.Node node2() {
            return this.node2;
        }

        public int index() {
            return this.index;
        }

        public Dummy copy(Graph_Display.Node node1, Graph_Display.Node node2, int index) {
            return new Dummy(node1, node2, index);
        }

        public Graph_Display.Node copy$default$1() {
            return this.node1();
        }

        public Graph_Display.Node copy$default$2() {
            return this.node2();
        }

        public int copy$default$3() {
            return this.index();
        }

        public Graph_Display.Node _1() {
            return this.node1();
        }

        public Graph_Display.Node _2() {
            return this.node2();
        }

        public int _3() {
            return this.index();
        }
    }

    public static class Info
    implements Product,
    Serializable {
        private final double x;
        private final double y;
        private final double width2;
        private final double height2;
        private final List lines;

        public static Info apply(double d, double d2, double d3, double d4, List<String> list) {
            return Layout$Info$.MODULE$.apply(d, d2, d3, d4, list);
        }

        public static Info fromProduct(Product product) {
            return Layout$Info$.MODULE$.fromProduct(product);
        }

        public static Info unapply(Info info) {
            return Layout$Info$.MODULE$.unapply(info);
        }

        public Info(double x, double y, double width2, double height2, List<String> lines) {
            this.x = x;
            this.y = y;
            this.width2 = width2;
            this.height2 = height2;
            this.lines = lines;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.x()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.y()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.width2()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.height2()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.lines()));
            return Statics.finalizeHash((int)n, (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Info)) return false;
            Info info = (Info)object;
            if (this.x() != info.x()) return false;
            if (this.y() != info.y()) return false;
            if (this.width2() != info.width2()) return false;
            if (this.height2() != info.height2()) return false;
            List<String> list = this.lines();
            List<String> list2 = info.lines();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            if (!info.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Info;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "Info";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToDouble((double)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToDouble((double)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToDouble((double)this._3());
                }
                case 3: {
                    return BoxesRunTime.boxToDouble((double)this._4());
                }
                case 4: {
                    return this._5();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "x";
                }
                case 1: {
                    return "y";
                }
                case 2: {
                    return "width2";
                }
                case 3: {
                    return "height2";
                }
                case 4: {
                    return "lines";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public double x() {
            return this.x;
        }

        public double y() {
            return this.y;
        }

        public double width2() {
            return this.width2;
        }

        public double height2() {
            return this.height2;
        }

        public List<String> lines() {
            return this.lines;
        }

        public double left() {
            return this.x() - this.width2();
        }

        public double right() {
            return this.x() + this.width2();
        }

        public double width() {
            return (double)2 * this.width2();
        }

        public double height() {
            return (double)2 * this.height2();
        }

        public Info copy(double x, double y, double width2, double height2, List<String> lines) {
            return new Info(x, y, width2, height2, lines);
        }

        public double copy$default$1() {
            return this.x();
        }

        public double copy$default$2() {
            return this.y();
        }

        public double copy$default$3() {
            return this.width2();
        }

        public double copy$default$4() {
            return this.height2();
        }

        public List<String> copy$default$5() {
            return this.lines();
        }

        public double _1() {
            return this.x();
        }

        public double _2() {
            return this.y();
        }

        public double _3() {
            return this.width2();
        }

        public double _4() {
            return this.height2();
        }

        public List<String> _5() {
            return this.lines();
        }
    }

    public static class Node
    extends Vertex
    implements Product,
    Serializable {
        private final Graph_Display.Node node;

        public static Node apply(Graph_Display.Node node) {
            return Layout$Node$.MODULE$.apply(node);
        }

        public static Node fromProduct(Product product) {
            return Layout$Node$.MODULE$.fromProduct(product);
        }

        public static Node unapply(Node node) {
            return Layout$Node$.MODULE$.unapply(node);
        }

        public Node(Graph_Display.Node node) {
            this.node = node;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Node)) return false;
            Node node = (Node)object;
            Graph_Display.Node node2 = this.node();
            Graph_Display.Node node3 = node.node();
            if (node2 == null) {
                if (node3 != null) {
                    return false;
                }
            } else if (!((Object)node2).equals(node3)) return false;
            if (!node.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Node;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Node";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "node";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Graph_Display.Node node() {
            return this.node;
        }

        public Node copy(Graph_Display.Node node) {
            return new Node(node);
        }

        public Graph_Display.Node copy$default$1() {
            return this.node();
        }

        public Graph_Display.Node _1() {
            return this.node();
        }
    }

    public static class Region {
        private final List content;

        public Region(List<Vertex> content) {
            this.content = content;
        }

        public List<Vertex> content() {
            return this.content;
        }

        public double distance(Metrics metrics, Graph<Vertex, Info> graph, Region that) {
            return Layout$.MODULE$.isabelle$graphview$Layout$$$vertex_left(graph, (Vertex)that.content().head()) - Layout$.MODULE$.isabelle$graphview$Layout$$$vertex_right(graph, (Vertex)this.content().last()) - metrics.gap();
        }

        public double deflection(Graph<Vertex, Info> graph, boolean top_down) {
            return RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(BoxesRunTime.unboxToDouble((Object)this.content().iterator().map(arg_0 -> Layout$.isabelle$graphview$Layout$Region$$_$deflection$$anonfun$1(graph, top_down, arg_0)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)this.content().length()));
        }

        public Graph<Vertex, Info> move(Graph<Vertex, Info> graph, double dx) {
            if (dx == 0.0) {
                return graph;
            }
            return (Graph)this.content().foldLeft(graph, (arg_0, arg_1) -> Layout$.isabelle$graphview$Layout$Region$$_$move$$anonfun$1(dx, arg_0, arg_1));
        }

        public Region combine(Region that) {
            return new Region((List<Vertex>)that.content().$colon$colon$colon(this.content()));
        }
    }

    public static abstract class Vertex {
        public static int ordinal(Vertex vertex) {
            return Layout$Vertex$.MODULE$.ordinal(vertex);
        }
    }
}

