/*
 * Decompiled with CFR 0.152.
 */
package isabelle.setup;

import dotty.tools.dotc.Driver;
import dotty.tools.dotc.interfaces.Diagnostic;
import dotty.tools.dotc.interfaces.SimpleReporter;
import dotty.tools.dotc.reporting.Reporter;
import isabelle.setup.Environment;
import isabelle.setup.Library;
import java.io.BufferedOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class Build {
    public static String BUILD_PROPS = "build.props";
    public static String COMPONENT_BUILD_PROPS = "etc/build.props";
    public static String META_INFO = "<meta_info>";
    public static String TITLE = "title";
    public static String MODULE = "module";
    public static String NO_BUILD = "no_build";
    private static String SHASUM = "META-INF/isabelle/shasum";
    private static String SERVICES = "META-INF/isabelle/services";

    public static String make_digest(Digest_Body digest_Body) throws NoSuchAlgorithmException, IOException, InterruptedException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA");
        digest_Body.apply(messageDigest);
        return String.format(Locale.ROOT, "%040x", new BigInteger(1, messageDigest.digest()));
    }

    public static String make_shasum(String string, Digest_Body digest_Body) throws NoSuchAlgorithmException, IOException, InterruptedException {
        return Build.make_digest(digest_Body) + " " + string + "\n";
    }

    public static Context component_context(Path path) throws IOException {
        Properties properties = new Properties();
        Path path2 = path.resolve(COMPONENT_BUILD_PROPS);
        properties.load(Files.newBufferedReader(path2));
        return new Context(path, properties, path2.toString());
    }

    public static List<Context> component_contexts() throws IOException, InterruptedException {
        LinkedList<Context> linkedList = new LinkedList<Context>();
        for (String string : Environment.getenv("ISABELLE_COMPONENTS").split(":", -1)) {
            Path path;
            if (string.isEmpty() || !Files.isRegularFile((path = Path.of(Environment.platform_path(string), new String[0])).resolve(COMPONENT_BUILD_PROPS), new LinkOption[0])) continue;
            linkedList.add(Build.component_context(path));
        }
        return List.copyOf(linkedList);
    }

    private static void add_options(List<String> list, String string) {
        if (string != null) {
            for (String string2 : string.split("\\s+")) {
                if (string2.isEmpty()) continue;
                list.add(string2);
            }
        }
    }

    public static void compile_scala_sources(final PrintStream printStream, Path path, String string, List<Path> list, List<Path> list2) throws IOException, InterruptedException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Build.add_options(arrayList, Environment.getenv("ISABELLE_SCALAC_OPTIONS"));
        Build.add_options(arrayList, string);
        arrayList.add("-d");
        arrayList.add(path.toString());
        arrayList.add("-bootclasspath");
        arrayList.add(Environment.join_platform_paths(list));
        arrayList.add("--");
        boolean bl = false;
        for (Path object : list2) {
            arrayList.add(object.toString());
            if (!object.toString().endsWith(".scala")) continue;
            bl = true;
        }
        if (bl) {
            String[] stringArray = (String[])arrayList.toArray(String[]::new);
            SimpleReporter simpleReporter = new SimpleReporter(){

                public void report(Diagnostic diagnostic) {
                    printStream.println(diagnostic.message());
                }
            };
            new Driver().process(stringArray, simpleReporter, null);
            Reporter reporter = new Driver().process(stringArray);
            if (reporter.hasErrors()) {
                throw new RuntimeException("Failed to compile Scala sources");
            }
        }
    }

    public static void compile_java_sources(PrintStream printStream, Path path, String string, List<Path> list, List<Path> list2) throws IOException, InterruptedException {
        JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager standardJavaFileManager = javaCompiler.getStandardFileManager(null, Locale.ROOT, StandardCharsets.UTF_8);
        LinkedList<String> linkedList = new LinkedList<String>();
        Build.add_options(linkedList, Environment.getenv("ISABELLE_JAVAC_OPTIONS"));
        Build.add_options(linkedList, string);
        linkedList.add("-d");
        linkedList.add(path.toString());
        linkedList.add("-classpath");
        linkedList.add(Environment.join_platform_paths(list));
        LinkedList<JavaFileObject> linkedList2 = new LinkedList<JavaFileObject>();
        for (Path path2 : list2) {
            if (!path2.toString().endsWith(".java")) continue;
            for (JavaFileObject javaFileObject : standardJavaFileManager.getJavaFileObjectsFromPaths((Collection<? extends Path>)List.of(path2))) {
                linkedList2.add(javaFileObject);
            }
        }
        if (!linkedList2.isEmpty()) {
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            boolean bl = javaCompiler.getTask(charArrayWriter, standardJavaFileManager, null, linkedList, null, linkedList2).call();
            charArrayWriter.flush();
            String string2 = Library.trim_line(charArrayWriter.toString());
            if (bl) {
                if (!string2.isEmpty()) {
                    printStream.print((String)string2 + "\n");
                }
            } else {
                throw new RuntimeException((String)(string2.isEmpty() ? "" : (String)string2 + "\n") + "Failed to compile Java sources");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String get_shasum(Path path) {
        try (JarFile jarFile = new JarFile(path.toFile());){
            JarEntry jarEntry = jarFile.getJarEntry(SHASUM);
            if (jarEntry != null) {
                byte[] byArray = jarFile.getInputStream(jarEntry).readAllBytes();
                String string = new String(byArray, StandardCharsets.UTF_8);
                return string;
            }
            String string = "";
            return string;
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static void create_shasum(Path path, String string) throws IOException {
        Path path2 = path.resolve(SHASUM);
        Files.createDirectories(path2.getParent(), new FileAttribute[0]);
        Files.writeString(path2, (CharSequence)string, new OpenOption[0]);
    }

    public static List<String> get_services(Path path) throws IOException {
        if (Files.isRegularFile(path, new LinkOption[0])) {
            try (JarFile jarFile = new JarFile(path.toFile());){
                JarEntry jarEntry = jarFile.getJarEntry(SERVICES);
                if (jarEntry != null) {
                    byte[] byArray = jarFile.getInputStream(jarEntry).readAllBytes();
                    List<String> list = Library.split_lines(new String(byArray, StandardCharsets.UTF_8));
                    return list;
                }
                List<String> list = List.of();
                return list;
            }
        }
        return List.of();
    }

    public static void create_services(Path path, List<String> list) throws IOException {
        if (!list.isEmpty()) {
            Path path2 = path.resolve(SERVICES);
            Files.createDirectories(path2.getParent(), new FileAttribute[0]);
            Files.writeString(path2, (CharSequence)Library.cat_lines(list), new OpenOption[0]);
        }
    }

    public static void create_jar(Path path, String string, Path path2) throws IOException {
        Files.createDirectories(path.resolve(path2).getParent(), new FileAttribute[0]);
        Files.deleteIfExists(path2);
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attributes.put(new Attributes.Name("Created-By"), System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")");
        if (!string.isEmpty()) {
            attributes.put(Attributes.Name.MAIN_CLASS, string);
        }
        try (JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)new BufferedOutputStream(Files.newOutputStream(path2, new OpenOption[0])), manifest);){
            for (Path path3 : (Path[])Files.walk(path, new FileVisitOption[0]).sorted().toArray(Path[]::new)) {
                String string2;
                boolean bl = Files.isDirectory(path3, new LinkOption[0]);
                boolean bl2 = Files.isRegularFile(path3, new LinkOption[0]);
                if (!bl && !bl2 || (string2 = Environment.slashes(path.relativize(path3).toString())).isEmpty()) continue;
                JarEntry jarEntry = new JarEntry((String)(bl ? string2 + "/" : string2));
                jarEntry.setTime(path3.toFile().lastModified());
                jarOutputStream.putNextEntry(jarEntry);
                if (bl2) {
                    jarOutputStream.write(Files.readAllBytes(path3));
                }
                jarOutputStream.closeEntry();
            }
        }
    }

    public static List<Path> classpath() throws IOException, InterruptedException {
        LinkedList<Path> linkedList = new LinkedList<Path>();
        for (Context context : Build.component_contexts()) {
            String string = context.module_result();
            if (string.isEmpty()) continue;
            linkedList.add(context.path(string));
        }
        return List.copyOf(linkedList);
    }

    public static List<String> services() throws IOException, InterruptedException {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Context context : Build.component_contexts()) {
            for (String string : context.services()) {
                linkedList.add(string);
            }
        }
        return List.copyOf(linkedList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void build(List<Path> list, PrintStream printStream, Context context, boolean bl) throws NoSuchAlgorithmException, IOException, InterruptedException {
        String string = context.module_result();
        if (!string.isEmpty()) {
            String string2 = context.title();
            Path path = context.path(string);
            String string3 = path.toString();
            if (!string3.endsWith(".jar")) {
                throw new RuntimeException(context.error_message("Bad jar module " + Library.quote(string3)));
            }
            if (context.is_vacuous()) {
                Files.deleteIfExists(path);
            } else {
                List<String> list2 = context.requirements();
                List<String> list3 = context.resources();
                List<String> list4 = context.sources();
                String string4 = Build.get_shasum(path);
                LinkedList<Path> linkedList = new LinkedList<Path>();
                Comparable<StringBuilder> comparable = new StringBuilder();
                ((StringBuilder)comparable).append(context.shasum_meta_info());
                for (String iterator : list2) {
                    List<Path> list5 = context.requirement_paths(iterator);
                    linkedList.addAll(list5);
                    ((StringBuilder)comparable).append(context.shasum(iterator, list5));
                }
                for (String string5 : list3) {
                    ((StringBuilder)comparable).append(context.shasum(context.item_name(string5)));
                }
                for (String string6 : list4) {
                    ((StringBuilder)comparable).append(context.shasum(string6));
                }
                String string7 = ((StringBuilder)comparable).toString();
                if (bl || !string4.equals(string7)) {
                    Stream<Path> stream;
                    if (!string2.isEmpty()) {
                        printStream.print("### Building " + string2 + " (" + String.valueOf(path) + ") ...\n");
                    }
                    comparable = Files.createTempDirectory("isabelle", new FileAttribute[0]);
                    try {
                        linkedList.addAll(list);
                        stream = new LinkedList();
                        for (String string8 : list4) {
                            stream.add(context.path(string8));
                        }
                        Build.compile_scala_sources(printStream, (Path)comparable, context.scalac_options(), linkedList, (List<Path>)((Object)stream));
                        linkedList.add((Path)comparable);
                        Build.compile_java_sources(printStream, (Path)comparable, context.javac_options(), linkedList, (List<Path>)((Object)stream));
                        for (String string9 : context.resources()) {
                            Path path2;
                            Path path3;
                            String string10 = context.item_name(string9);
                            String string11 = context.item_target(string9);
                            Path path4 = Path.of(string10, new String[0]).normalize().getFileName();
                            Path path5 = Path.of(string11, new String[0]).normalize();
                            if (string11.endsWith("/") || string11.endsWith("/.")) {
                                path3 = comparable.resolve(path5);
                                path2 = path3.resolve(path4);
                            } else {
                                path2 = comparable.resolve(path5);
                                path3 = path2.getParent();
                            }
                            Files.createDirectories(path3, new FileAttribute[0]);
                            Files.copy(context.path(string10), path2, StandardCopyOption.COPY_ATTRIBUTES);
                        }
                        Build.create_shasum((Path)comparable, string7);
                        Build.create_services((Path)comparable, context.services());
                        Build.create_jar((Path)comparable, context.main(), path);
                    }
                    finally {
                        stream = Files.walk((Path)comparable, new FileVisitOption[0]);
                        try {
                            stream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                        }
                        finally {
                            if (stream != null) {
                                stream.close();
                            }
                        }
                    }
                }
            }
        }
    }

    public static void build_components(PrintStream printStream, boolean bl) throws NoSuchAlgorithmException, IOException, InterruptedException {
        LinkedList<Path> linkedList = new LinkedList<Path>();
        for (String string : Environment.getenv("ISABELLE_CLASSPATH").split(":", -1)) {
            if (string.isEmpty()) continue;
            linkedList.add(Path.of(Environment.platform_path(string), new String[0]));
        }
        for (Context context : Build.component_contexts()) {
            Build.build(linkedList, printStream, context, bl);
        }
    }

    @FunctionalInterface
    public static interface Digest_Body {
        public void apply(MessageDigest var1) throws IOException, InterruptedException;
    }

    public static class Context {
        private final Path _dir;
        private final Properties _props;
        private final String _location;

        public Context(Path path, Properties properties, String string) {
            this._dir = path;
            this._props = properties;
            this._location = string;
        }

        public String toString() {
            return this._dir.toString();
        }

        public String error_message(String string) {
            if (this._location == null || this._location.isEmpty()) {
                return string;
            }
            return string + " (in " + Library.quote(this._location) + ")";
        }

        public boolean get_bool(String string) {
            String string2;
            switch (string2 = this._props.getProperty(string, "false")) {
                case "true": {
                    return true;
                }
                case "false": {
                    return false;
                }
            }
            throw new RuntimeException(this.error_message("Bad boolean property " + Library.quote(string) + ": " + Library.quote(string2)));
        }

        public String title() {
            return this._props.getProperty(TITLE, "");
        }

        public String module_name() {
            return this._props.getProperty(MODULE, "");
        }

        public String module_result() {
            return this.get_bool(NO_BUILD) ? "" : this.module_name();
        }

        public String scalac_options() {
            return this._props.getProperty("scalac_options", "");
        }

        public String javac_options() {
            return this._props.getProperty("javac_options", "");
        }

        public String main() {
            return this._props.getProperty("main", "");
        }

        private List<String> get_list(String string) {
            LinkedList<String> linkedList = new LinkedList<String>();
            for (String string2 : this._props.getProperty(string, "").split("\\s+")) {
                if (string2.isEmpty()) continue;
                linkedList.add(string2);
            }
            return List.copyOf(linkedList);
        }

        public List<String> requirements() {
            return this.get_list("requirements");
        }

        public List<String> sources() {
            return this.get_list("sources");
        }

        public List<String> resources() {
            return this.get_list("resources");
        }

        public List<String> services() {
            return this.get_list("services");
        }

        public boolean is_vacuous() {
            return this.sources().isEmpty() && this.resources().isEmpty() && this.services().isEmpty();
        }

        public Path path(String string) throws IOException, InterruptedException {
            return this._dir.resolve(Environment.expand_platform_path(string));
        }

        public List<Path> requirement_paths(String string) throws IOException, InterruptedException {
            if (string.startsWith("env:")) {
                LinkedList<Path> linkedList = new LinkedList<Path>();
                for (String string2 : Environment.getenv(string.substring(4)).split(":", -1)) {
                    if (string2.isEmpty()) continue;
                    Path path = Path.of(Environment.platform_path(string2), new String[0]);
                    linkedList.add(path);
                }
                return List.copyOf(linkedList);
            }
            return List.of(this.path(string));
        }

        public String item_name(String string) {
            int n = string.indexOf(58);
            return n > 0 ? string.substring(0, n) : string;
        }

        public String item_target(String string) {
            int n = string.indexOf(58);
            return n > 0 ? string.substring(n + 1) : string;
        }

        public String shasum(String string, List<Path> list) throws NoSuchAlgorithmException, IOException, InterruptedException {
            return Build.make_shasum(string, messageDigest -> {
                for (Path path : list) {
                    if (Files.isRegularFile(path, new LinkOption[0])) {
                        messageDigest.update(Files.readAllBytes(path));
                        continue;
                    }
                    throw new RuntimeException(this.error_message("Bad input file " + Library.quote(path.toString())));
                }
            });
        }

        public String shasum(String string) throws NoSuchAlgorithmException, IOException, InterruptedException {
            return this.shasum(string, List.of(this.path(string)));
        }

        public String shasum_meta_info() throws NoSuchAlgorithmException, IOException, InterruptedException {
            TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
            for (Map.Entry<Object, Object> entry : this._props.entrySet()) {
                treeMap.put(entry.toString(), this._props.get(entry));
            }
            return Build.make_shasum(META_INFO, messageDigest -> messageDigest.update(treeMap.toString().getBytes(StandardCharsets.UTF_8)));
        }
    }
}

