/*
 * Decompiled with CFR 0.152.
 */
package sidekick;

import errorlist.DefaultErrorSource;
import errorlist.ErrorSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.tree.DefaultMutableTreeNode;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.BufferAdapter;
import org.gjt.sp.jedit.buffer.BufferListener;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferChanging;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.EditorExiting;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.util.Log;
import sidekick.AbstractModeOptionPane;
import sidekick.SideKickParsedData;
import sidekick.SideKickParser;
import sidekick.SideKickPlugin;
import sidekick.SideKickTree;
import sidekick.SideKickUpdate;

public class SideKick {
    public static final String BUFFER_CHANGE = "sidekick.buffer-change-parse";
    public static final String BUFFER_SAVE = "sidekick.buffer-save-parse";
    public static final String FOLLOW_CARET = "sidekick-tree.follows-caret";
    public static final String AUTO_EXPAND_DEPTH = "sidekick-tree.auto-expand-tree-depth";
    public static final String SHOW_STATUS = "sidekick.showStatusWindow.label";
    public static final String FILTER_VISIBLE = "sidekick.filter-visible-assets";
    public static final String SHOW_FILTER = "sidekick.showFilter";
    private static boolean exiting = false;
    private View view;
    private EditPane editPane;
    private Buffer buffer;
    private SideKickParser parser;
    private DefaultErrorSource errorSource;
    private boolean showParsingMessage;
    private int delay;
    private Timer keystrokeTimer;
    private BufferChangeListener bufferListener;
    private boolean addedBufferListener;

    SideKick(View view) {
        this.view = view;
        this.editPane = view.getEditPane();
        this.bufferListener = new BufferChangeListener();
        this.propertiesChanged();
        this.keystrokeTimer = new Timer(0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SideKick.this.parse(false);
            }
        });
        this.buffer = view.getBuffer();
        EditBus.addToBus((Object)this);
    }

    public static boolean isFollowCaret() {
        try {
            String currentMode = jEdit.getActiveView().getBuffer().getMode().getName();
            return AbstractModeOptionPane.getBooleanProperty(currentMode, FOLLOW_CARET);
        }
        catch (NullPointerException npe) {
            return jEdit.getBooleanProperty((String)FOLLOW_CARET);
        }
    }

    public static boolean isGlobalFollowCaret() {
        return jEdit.getBooleanProperty((String)FOLLOW_CARET);
    }

    public static void setGlobalFollowCaret(boolean fc) {
        jEdit.setBooleanProperty((String)FOLLOW_CARET, (boolean)fc);
    }

    public static void setParseOnSave(boolean val) {
        jEdit.setBooleanProperty((String)BUFFER_SAVE, (boolean)val);
    }

    public static void setParseOnChange(boolean val) {
        jEdit.setBooleanProperty((String)BUFFER_CHANGE, (boolean)val);
    }

    public static boolean isParseOnSave() {
        return jEdit.getBooleanProperty((String)BUFFER_SAVE);
    }

    public static boolean isParseOnChange() {
        return jEdit.getBooleanProperty((String)BUFFER_CHANGE);
    }

    void parse(boolean showParsingMessage) {
        if (this.keystrokeTimer.isRunning()) {
            this.keystrokeTimer.stop();
        }
        if (!this.buffer.isLoaded()) {
            return;
        }
        if (SideKickPlugin.isParsingBuffer(this.buffer)) {
            return;
        }
        SideKickPlugin.startParsingBuffer(this.buffer);
        this.showParsingMessage = showParsingMessage;
        this.parser = SideKickPlugin.getParserForBuffer(this.buffer);
        if (this.parser == null) {
            Log.log((int)1, (Object)this, (Object)"No parser");
            this.setErrorSource(null);
            this.showNotParsedMessage();
            SideKickPlugin.finishParsingBuffer(this.buffer);
            return;
        }
        if (showParsingMessage) {
            SideKickParsedData data = new SideKickParsedData(this.buffer.getName());
            data.root.add(new DefaultMutableTreeNode(jEdit.getProperty((String)"sidekick-tree.parsing")));
            SideKickParsedData.setParsedData(this.view, data);
            this.sendUpdate();
        }
        ParseRequestWorker parseRequest = new ParseRequestWorker(this.parser, this.buffer);
        SideKickPlugin.execute(this.view, parseRequest);
    }

    void dispose() {
        this.setErrorSource(null);
        EditBus.removeFromBus((Object)this);
        this.removeBufferChangeListener(this.buffer);
    }

    SideKickParser getParser() {
        return this.parser;
    }

    void setParser(Buffer newBuffer) {
        this.deactivateParser();
        if (newBuffer != null) {
            this.buffer = newBuffer;
        }
        this.parser = SideKickPlugin.getParserForBuffer(this.buffer);
        this.activateParser();
    }

    @EditBus.EBHandler
    public void handlePropertiesChanged(PropertiesChanged msg) {
        this.propertiesChanged();
    }

    @EditBus.EBHandler
    public void handleEditorExiting(EditorExiting msg) {
        exiting = true;
    }

    @EditBus.EBHandler
    public void handleBufferUpdate(BufferUpdate bmsg) {
        if (bmsg.getWhat() == BufferUpdate.PROPERTIES_CHANGED && this.view.getBuffer() == bmsg.getBuffer()) {
            String currMode;
            String prevMode = this.buffer.getStringProperty("sidekick.parser-mode");
            String string = currMode = this.buffer.getMode() != null ? this.buffer.getMode().getName() : "";
            if (!currMode.equals(prevMode)) {
                this.buffer.unsetProperty("sidekick.parser");
                this.setParser(this.view.getBuffer());
            }
        }
        if (bmsg.getView() != this.view && (bmsg.getView() != null || bmsg.getBuffer() != this.view.getBuffer())) {
            return;
        }
        if (bmsg.getWhat() == BufferUpdate.SAVED && SideKick.isParseOnSave()) {
            this.setParser(this.buffer);
        } else if (bmsg.getWhat() == BufferUpdate.LOADED && SideKick.isParseOnChange()) {
            this.parse(true);
        } else if (bmsg.getWhat() == BufferUpdate.CLOSED) {
            this.setErrorSource(null);
        }
    }

    @EditBus.EBHandler
    public void handleBufferChange(BufferChanging bmsg) {
        this.buffer = bmsg.getBuffer();
    }

    @EditBus.EBHandler
    public void handleEditPaneUpdate(EditPaneUpdate epu) {
        this.editPane = epu.getEditPane();
        View v = this.editPane.getView();
        if (v == null) {
            v = jEdit.getActiveView();
        }
        if (v == null || v != this.view) {
            return;
        }
        if (epu.getWhat() == EditPaneUpdate.DESTROYED) {
            if (this.editPane == v.getEditPane()) {
                this.removeBufferChangeListener(this.buffer);
                this.deactivateParser();
            }
        } else if (epu.getWhat() == EditPaneUpdate.BUFFER_CHANGED) {
            if (!SideKick.isParseOnChange()) {
                SideKickTree tree = (SideKickTree)this.view.getDockableWindowManager().getDockable("sidekick");
                if (tree != null) {
                    tree.reloadParserCombo();
                }
                return;
            }
            if (this.editPane == this.view.getEditPane()) {
                this.removeBufferChangeListener(this.buffer);
                this.deactivateParser();
                this.buffer = this.editPane.getBuffer();
                if (!this.buffer.isLoaded()) {
                    return;
                }
                this.parser = SideKickPlugin.getParserForBuffer(this.buffer);
                this.activateParser();
                this.parse(true);
            }
        }
    }

    @EditBus.EBHandler
    public void handleViewUpdate(ViewUpdate vu) {
        if (vu.getView() == this.view && this.buffer != this.view.getBuffer() && vu.getWhat() == ViewUpdate.EDIT_PANE_CHANGED) {
            if (!SideKick.isParseOnChange()) {
                return;
            }
            this.removeBufferChangeListener(this.buffer);
            this.deactivateParser();
            this.buffer = this.view.getBuffer();
            this.editPane = this.view.getEditPane();
            this.parser = SideKickPlugin.getParserForBuffer(this.buffer);
            this.activateParser();
            this.parse(true);
        }
    }

    @EditBus.EBHandler
    public void handlePluginUpdate(PluginUpdate pmsg) {
        if (!(exiting || pmsg.getWhat() != PluginUpdate.UNLOADED && pmsg.getWhat() != PluginUpdate.LOADED)) {
            this.setParser(null);
        }
    }

    private void setErrorSource(DefaultErrorSource errorSource) {
        int errorCount;
        if (this.errorSource != null) {
            ErrorSource.unregisterErrorSource((ErrorSource)this.errorSource);
            this.errorSource.clear();
        }
        this.errorSource = errorSource;
        if (errorSource != null && (errorCount = errorSource.getErrorCount()) != 0) {
            ErrorSource.registerErrorSource((ErrorSource)errorSource);
        }
    }

    private void addBufferChangeListener(Buffer buffer) {
        if (!this.addedBufferListener) {
            this.bufferListener = new BufferChangeListener();
            buffer.addBufferListener((BufferListener)this.bufferListener);
            this.addedBufferListener = true;
        }
    }

    private void removeBufferChangeListener(Buffer buffer) {
        if (this.addedBufferListener) {
            buffer.removeBufferListener((BufferListener)this.bufferListener);
            this.addedBufferListener = false;
        }
    }

    @EditBus.EBHandler
    private void propertiesChanged() {
        if (!SideKick.isParseOnChange()) {
            return;
        }
        try {
            this.delay = Integer.parseInt(jEdit.getProperty((String)"sidekick.auto-parse-delay"));
        }
        catch (NumberFormatException nf) {
            this.delay = 1500;
        }
    }

    private void showNotParsedMessage() {
        this.setErrorSource(null);
        SideKickParsedData data = new SideKickParsedData(this.buffer.getName());
        data.root.add(new DefaultMutableTreeNode(jEdit.getProperty((String)"sidekick-tree.not-parsed")));
        SideKickParsedData.setParsedData(this.view, data);
        this.sendUpdate();
    }

    private void parseWithDelay() {
        if (this.parser != null) {
            this.parser.stop();
            if (this.keystrokeTimer.isRunning()) {
                this.keystrokeTimer.stop();
            }
            this.keystrokeTimer.setInitialDelay(this.delay);
            this.keystrokeTimer.setRepeats(false);
            this.keystrokeTimer.start();
        }
    }

    void cancelParseWithDelay() {
        if (this.keystrokeTimer != null) {
            this.keystrokeTimer.stop();
        }
    }

    void parseOnKeyStroke(JEditBuffer buffer) {
        if (buffer != this.buffer) {
            return;
        }
        if (buffer.getBooleanProperty("sidekick.keystroke-parse")) {
            this.parseWithDelay();
        }
    }

    private void sendUpdate() {
        if (this.view.isClosed()) {
            return;
        }
        EditBus.send((EBMessage)new SideKickUpdate(this.view));
    }

    private void deactivateParser() {
        if (this.parser != null) {
            if (this.editPane == null) {
                Log.log((int)9, (Object)this, (Object)"Null editPane!");
            } else {
                this.parser.deactivate(this.editPane);
            }
            SideKickTree tree = (SideKickTree)this.view.getDockableWindowManager().getDockable("sidekick-tree");
            if (tree == null) {
                return;
            }
            tree.removeParserPanel();
        }
    }

    private void activateParser() {
        EditPane editPane = this.view.getEditPane();
        if (this.parser != null) {
            this.addBufferChangeListener(this.buffer);
            this.editPane = editPane;
            this.parser.activate(editPane);
        } else {
            this.removeBufferChangeListener(this.buffer);
        }
        SideKickTree tree = (SideKickTree)this.view.getDockableWindowManager().getDockable("sidekick-tree");
        if (tree == null) {
            return;
        }
        tree.reloadParserCombo();
        if (this.parser != null) {
            tree.addParserPanel(this.parser);
        }
        this.parse(true);
    }

    class BufferChangeListener
    extends BufferAdapter {
        BufferChangeListener() {
        }

        public void contentInserted(JEditBuffer buffer, int startLine, int offset, int numLines, int length) {
            SideKick.this.parseOnKeyStroke(buffer);
        }

        public void contentRemoved(JEditBuffer buffer, int startLine, int offset, int numLines, int length) {
            SideKick.this.parseOnKeyStroke(buffer);
        }
    }

    class ParseRequestWorker
    extends SwingWorker<SideKickParsedData, Object> {
        SideKickParser parser;
        Buffer buffer;
        DefaultErrorSource errorSource;

        ParseRequestWorker(SideKickParser parser, Buffer buffer) {
            this.parser = parser;
            this.buffer = buffer;
            this.errorSource = new DefaultErrorSource("SideKick", SideKick.this.view);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SideKickParsedData doInBackground() {
            SideKickTree tree = (SideKickTree)SideKick.this.view.getDockableWindowManager().getDockable("sidekick-tree");
            if (tree != null) {
                tree.showStopButton(true);
            }
            try {
                SideKickParsedData data;
                this.buffer.readLock();
                SideKickParsedData sideKickParsedData = data = this.parser.parse(this.buffer, this.errorSource);
                return sideKickParsedData;
            }
            finally {
                this.buffer.readUnlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void done() {
            SideKickPlugin.cleanup(SideKick.this.view);
            try {
                if (this.isCancelled()) {
                    this.parser.stop();
                    return;
                }
                SideKickParsedData data = (SideKickParsedData)this.get();
                SideKick.this.setErrorSource(this.errorSource);
                int errorCount = this.errorSource.getErrorCount();
                if (SideKick.this.showParsingMessage || errorCount != 0) {
                    String label = jEdit.getProperty((String)("sidekick.parser." + this.parser.getName() + ".label"));
                    Object[] pp = new Object[]{label, errorCount};
                    SideKick.this.view.getStatus().setMessageAndClear(jEdit.getProperty((String)"sidekick.parsing-complete", (Object[])pp));
                }
                this.buffer.setProperty("sidekick.parsed-data", (Object)data);
                if (this.buffer.getProperty((Object)"folding").equals("sidekick")) {
                    this.buffer.invalidateCachedFoldLevels();
                }
                for (View _view = jEdit.getFirstView(); _view != null; _view = _view.getNext()) {
                    if (_view.getBuffer() != this.buffer) continue;
                    SideKickParsedData.setParsedData(_view, data);
                }
                SideKick.this.sendUpdate();
            }
            catch (Exception ie) {
                SideKick.this.showNotParsedMessage();
            }
            finally {
                SideKickPlugin.finishParsingBuffer(this.buffer);
                SideKickTree tree = (SideKickTree)SideKick.this.view.getDockableWindowManager().getDockable("sidekick-tree");
                if (tree != null) {
                    tree.showStopButton(false);
                }
            }
        }
    }
}

