/*
 * Decompiled with CFR 0.152.
 */
package sidekick.enhanced;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import marker.MarkerSetsPlugin;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.FileCellRenderer;
import org.gjt.sp.jedit.gui.DockableWindowFactory;
import org.gjt.sp.jedit.gui.KeyEventTranslator;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.util.EnhancedTreeCellRenderer;
import sidekick.IAsset;
import sidekick.SideKickPlugin;
import sidekick.SideKickTree;

public class SourceTree
extends SideKickTree {
    private static boolean _hasMarker;
    private static boolean _showMarkers;
    private static Color _markerColor;
    private HashMap _actionShortcuts = new HashMap();
    public JPopupMenu popup;

    public SourceTree(View view, boolean docked) {
        super(view, docked);
        this.tree.setCellRenderer((TreeCellRenderer)((Object)new Renderer()));
        this.tree.addKeyListener(new KeyHandler());
        MouseHandler mh = new MouseHandler();
        this.tree.addMouseListener(mh);
        if (docked) {
            this.tree.addMouseMotionListener(mh);
        }
        this.update();
    }

    protected void createPopup() {
        Mode mode = this.view.getBuffer().getMode();
        String modename = mode == null ? "" : "." + mode.getName();
        String menu = "sidekick-tree" + modename + ".menu";
        if (jEdit.getProperty((String)menu) == null) {
            menu = "sidekick-tree.menu";
        }
        this.popup = GUIUtilities.loadPopupMenu((String)menu);
    }

    @Override
    protected void update() {
        super.update();
        this.createPopup();
    }

    private boolean hasMarker(int start, int end) {
        EditPlugin markerSets = SideKickPlugin.getMarkerSetsPlugin();
        if (markerSets != null && ((MarkerSetsPlugin)markerSets).hasMarker(this.view.getBuffer(), start, end)) {
            return true;
        }
        return this.view.getBuffer().getMarkerInRange(start, end) != null;
    }

    public static void toggleMarkersFlag() {
        _showMarkers = !_showMarkers;
    }

    public static boolean isRegisteredDockable(String name) {
        String[] dockables = DockableWindowFactory.getInstance().getRegisteredDockableWindows();
        boolean _found = false;
        for (int i = 0; i < dockables.length; ++i) {
            if (!dockables[i].equals(name)) continue;
            _found = true;
            break;
        }
        return _found;
    }

    public static boolean isMarkersFlagSet() {
        return _showMarkers;
    }

    @EditBus.EBHandler
    public void handleBufferUpdate(BufferUpdate upd) {
        if (upd.getWhat() == BufferUpdate.MARKERS_CHANGED) {
            this.update();
        }
    }

    public void handleKey(KeyEvent evt) {
        int _code = evt.getKeyCode();
        KeyEventTranslator.Key _key = KeyEventTranslator.translateKeyEvent((KeyEvent)evt);
        if (this._actionShortcuts.containsKey(_key)) {
            this.view.getInputHandler().handleKey(_key);
        } else if (!(_code != 27 && _code != 3 || evt.isConsumed())) {
            this.view.getTextArea().requestFocus();
        }
    }

    public void handleMouse(MouseEvent evt) {
        if (GUIUtilities.isPopupTrigger((MouseEvent)evt)) {
            GUIUtilities.showPopupMenu((JPopupMenu)this.popup, (Component)this, (int)evt.getX(), (int)evt.getY());
            this.view.getTextArea().requestFocus();
        }
    }

    @Override
    protected void propertiesChanged() {
        super.propertiesChanged();
        Color c = jEdit.getColorProperty((String)"view.gutter.markerColor");
        if (!_markerColor.equals(c)) {
            _markerColor = c;
            this.repaint();
        }
        if (jEdit.getBooleanProperty((String)"sidekick.showToolTips")) {
            ToolTipManager.sharedInstance().registerComponent(this.tree);
        } else {
            ToolTipManager.sharedInstance().unregisterComponent(this.tree);
        }
    }

    static {
        _showMarkers = true;
        _markerColor = jEdit.getColorProperty((String)"view.gutter.markerColor");
    }

    protected class Renderer
    extends EnhancedTreeCellRenderer {
        protected Renderer() {
        }

        protected void configureTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object nodeValue = node.getUserObject();
            _hasMarker = false;
            if (node.getParent() == null) {
                this.setIcon(FileCellRenderer.fileIcon);
            }
            if (nodeValue instanceof IAsset) {
                IAsset _asset = (IAsset)node.getUserObject();
                this.setIcon(_asset.getIcon());
                this.setText(_asset.getShortString());
                _hasMarker = SourceTree.this.hasMarker(_asset.getStart().getOffset(), _asset.getEnd().getOffset());
                this.setToolTipText(this.getToolTipText(node, _asset));
            } else {
                this.setIcon(null);
            }
        }

        private void wrap(StringBuffer sb, String indent, String s) {
            StringTokenizer st = new StringTokenizer(s, " \t\n", false);
            StringBuilder line = new StringBuilder();
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                if (line.length() + t.length() >= 80) {
                    sb.append(line + "<br>" + indent);
                    line.setLength(0);
                }
                line.append(t + " ");
            }
            sb.append((CharSequence)line);
        }

        private String getToolTipText(DefaultMutableTreeNode node, IAsset asset) {
            StringBuffer sb = new StringBuffer("<html><body>");
            sb.append(asset.getLongString());
            sb.append("<br><br>");
            StringBuffer indent = new StringBuffer();
            for (TreeNode n : node.getPath()) {
                boolean last;
                DefaultMutableTreeNode tn = (DefaultMutableTreeNode)n;
                Object o = tn.getUserObject();
                boolean bl = last = n == node;
                if (last) {
                    sb.append("<b>");
                }
                String s = o instanceof IAsset ? ((IAsset)o).getShortString() : o.toString();
                this.wrap(sb, indent.toString(), s);
                if (last) {
                    sb.append("</b>");
                }
                if (last) continue;
                sb.append("<br>");
                indent.append("&nbsp;&nbsp;");
                sb.append(indent.toString());
            }
            sb.append("</body></html>");
            return sb.toString();
        }

        public void paintComponent(Graphics g) {
            if (SourceTree.isMarkersFlagSet() && _hasMarker) {
                FontMetrics fm = this.getFontMetrics(this.getFont());
                int y = this.getHeight() - 3;
                int x = this.getIcon() == null ? 0 : this.getIcon().getIconWidth() + this.getIconTextGap();
                g.setColor(_markerColor);
                g.fillRect(x, y, fm.stringWidth(this.getText()), 3);
            }
            super.paintComponent(g);
        }

        protected TreeCellRenderer newInstance() {
            return new Renderer();
        }
    }

    protected class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        protected MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            SourceTree.this.handleMouse(evt);
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
            TreePath path = SourceTree.this.tree.getPathForLocation(evt.getX(), evt.getY());
            if (path == null) {
                SourceTree.this.view.getStatus().setMessage(null);
            } else {
                Object value = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
                if (value instanceof IAsset) {
                    IAsset as = (IAsset)value;
                    SourceTree.this.view.getStatus().setMessage(as.getShortString());
                    SourceTree.this.setStatus(as.getLongString() == null ? as.getShortString() : as.getLongString());
                }
            }
        }
    }

    protected class KeyHandler
    extends KeyAdapter {
        protected KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            SourceTree.this.handleKey(evt);
        }
    }
}

