/*
 * Decompiled with CFR 0.152.
 */
package sidekick.util;

import sidekick.util.Location;
import sidekick.util.Range;

public class ParseError {
    public String message = "";
    public Range range = null;
    private int lineNumber;
    private int column;
    private int length;

    public ParseError(String message) {
        this(message, new Range());
    }

    public ParseError(String message, Range range) {
        this.message = message;
        this.range = range;
        if (range != null) {
            this.lineNumber = range.getStartLocation().line;
            this.column = range.getStartLocation().column;
            this.length = 1;
        }
    }

    public ParseError(String message, int lineNumber, int column, int length) {
        this.message = message;
        this.lineNumber = lineNumber;
        this.column = column;
        this.length = length;
        this.range = new Range(new Location(lineNumber, column), new Location(lineNumber, column + length));
    }

    public String getMessage() {
        return this.message;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumn() {
        return this.column;
    }

    public int getLength() {
        return this.length;
    }

    public Range getRange() {
        return this.range;
    }

    public String toString() {
        return "ParseError:[message=" + this.message + ", " + this.lineNumber + ':' + this.column + ']';
    }
}

