/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.Component;
import java.lang.ref.SoftReference;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bsh.BshMethod;
import org.gjt.sp.jedit.bsh.NameSpace;
import org.gjt.sp.jedit.bsh.UtilEvalError;
import org.gjt.sp.jedit.gui.BeanShellErrorDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class BeanShellAction
extends EditAction {
    private final boolean noRepeat;
    private final boolean noRecord;
    private final boolean noRememberLast;
    private final CachedBshMethod code;
    private CachedBshMethod isSelected;

    public BeanShellAction(String name, String code, String isSelected, boolean noRepeat, boolean noRecord, boolean noRememberLast) {
        super(name);
        String sanitizedName = name.replace('.', '_').replace('-', '_');
        this.code = new CachedBshMethod("action_" + sanitizedName, code);
        if (isSelected != null) {
            this.isSelected = new CachedBshMethod("selected_" + sanitizedName, isSelected);
        }
        this.noRepeat = noRepeat;
        this.noRecord = noRecord;
        this.noRememberLast = noRememberLast;
        jEdit.setTemporaryProperty(name + ".toggle", isSelected != null ? "true" : "false");
    }

    @Override
    public void invoke(View view) {
        try {
            BeanShell.runCachedBlock(this.code.get(), view, new NameSpace(BeanShell.getNameSpace(), "BeanShellAction.invoke()"));
        }
        catch (Throwable e) {
            Log.log(9, this, e);
            new BeanShellErrorDialog(view, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSelected(Component comp) {
        if (this.isSelected == null) {
            return false;
        }
        NameSpace global = BeanShell.getNameSpace();
        try {
            View view = GUIUtilities.getView(comp);
            if (view == null) {
                view = jEdit.getActiveView();
            }
            global.setVariable("_comp", comp);
            boolean bl = Boolean.TRUE.equals(BeanShell.runCachedBlock(this.isSelected.get(), view, new NameSpace(BeanShell.getNameSpace(), "BeanShellAction.isSelected()")));
            return bl;
        }
        catch (Throwable e) {
            Log.log(9, this, e);
            this.isSelected = null;
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                global.setVariable("_comp", null);
            }
            catch (UtilEvalError err) {
                Log.log(9, this, err);
            }
        }
    }

    @Override
    public boolean noRepeat() {
        return this.noRepeat;
    }

    @Override
    public boolean noRecord() {
        return this.noRecord;
    }

    @Override
    public boolean noRememberLast() {
        return this.noRememberLast;
    }

    @Override
    public String getCode() {
        return this.code.getSource().trim();
    }

    private static class CachedBshMethod {
        private final String name;
        private final String source;
        private SoftReference<BshMethod> cache;

        CachedBshMethod(String name, String source) {
            this.name = name;
            this.source = source;
            this.cache = null;
        }

        public BshMethod get() throws Exception {
            BshMethod cached;
            if (this.cache != null && (cached = this.cache.get()) != null) {
                return cached;
            }
            BshMethod newOne = BeanShell.cacheBlock(this.name, this.source, true);
            this.cache = new SoftReference<BshMethod>(newOne);
            return newOne;
        }

        public String getSource() {
            return this.source;
        }
    }
}

