/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.BufferHistory;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPaneMouseHandlerFactory;
import org.gjt.sp.jedit.Marker;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bufferset.BufferSet;
import org.gjt.sp.jedit.bufferset.BufferSetListener;
import org.gjt.sp.jedit.gui.BufferSwitcher;
import org.gjt.sp.jedit.gui.StatusBar;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferChanging;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PositionChanging;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.options.GutterOptionPane;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.textarea.AntiAlias;
import org.gjt.sp.jedit.textarea.Gutter;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.JEditTextAreaFactory;
import org.gjt.sp.jedit.textarea.MouseHandler;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.StatusListener;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;
import org.gjt.sp.jedit.textarea.TextAreaMouseHandler;
import org.gjt.sp.jedit.textarea.TextAreaPainter;
import org.gjt.sp.jedit.textarea.TextAreaTransferHandler;
import org.gjt.sp.util.SyntaxUtilities;
import org.gjt.sp.util.ThreadUtilities;

public class EditPane
extends JPanel
implements BufferSetListener {
    private boolean init;
    private final View view;
    private final BufferSet bufferSet;
    private Buffer buffer;
    private Buffer recentBuffer;
    private BufferSwitcher bufferSwitcher;
    private final JEditTextArea textArea;
    private final MarkerHighlight markerHighlight;
    private final Map<String, CaretInfo> caretsForPath = new HashMap<String, CaretInfo>();

    public View getView() {
        return this.view;
    }

    public static EditPane get(TextArea ta) {
        if (ta == null) {
            return null;
        }
        return (EditPane)SwingUtilities.getAncestorOfClass(EditPane.class, ta);
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(@Nonnull Buffer buffer) {
        this.setBuffer(buffer, true);
    }

    public void setBuffer(@Nonnull Buffer buffer, boolean requestFocus) {
        if (this.buffer == buffer) {
            return;
        }
        if (!this.bufferSet.contains(buffer)) {
            jEdit.getBufferSetManager().addBuffer(this, buffer);
        }
        EditBus.send(new BufferChanging(this, buffer));
        if (this.bufferSet.contains(this.buffer)) {
            this.recentBuffer = this.buffer;
        }
        if (this.recentBuffer != null) {
            this.saveCaretInfo();
        }
        this.buffer = buffer;
        this.textArea.setBuffer(buffer);
        if (!this.init) {
            this.view.updateTitle();
            if (this.bufferSwitcher != null) {
                if (this.bufferSwitcher.getSelectedItem() != buffer) {
                    this.bufferSwitcher.setSelectedItem(buffer);
                }
                this.bufferSwitcher.updateStyle(buffer);
            }
            EditBus.send(new EditPaneUpdate(this, EditPaneUpdate.BUFFER_CHANGED));
        }
        if (requestFocus) {
            SwingUtilities.invokeLater(() -> {
                if (!(this.view.getEditPane() != this || this.bufferSwitcher != null && this.bufferSwitcher.isPopupVisible())) {
                    this.textArea.requestFocus();
                }
            });
        }
        if (!buffer.isLoading()) {
            ThreadUtilities.runInDispatchThread(() -> {
                if (buffer == this.getBuffer()) {
                    this.loadCaretInfo();
                }
                int check = jEdit.getIntegerProperty("checkFileStatus");
                if (jEdit.isStartupDone() && (check & 2) > 0) {
                    jEdit.checkBufferStatus(this.view, true);
                }
            });
        }
    }

    public void prevBuffer() {
        Buffer buffer = this.bufferSet.getPreviousBuffer(this.bufferSet.indexOf(this.buffer));
        this.setBuffer(buffer);
    }

    public void nextBuffer() {
        Buffer buffer = this.bufferSet.getNextBuffer(this.bufferSet.indexOf(this.buffer));
        this.setBuffer(buffer);
    }

    public void recentBuffer() {
        if (this.recentBuffer != null) {
            this.setBuffer(this.recentBuffer);
        } else {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
        }
    }

    public void focusOnTextArea() {
        SwingUtilities.invokeLater(this.textArea::requestFocus);
    }

    public JEditTextArea getTextArea() {
        return this.textArea;
    }

    public BufferSwitcher getBufferSwitcher() {
        return this.bufferSwitcher;
    }

    public void focusBufferSwitcher() {
        if (this.bufferSwitcher == null) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
        } else {
            SwingUtilities.invokeLater(() -> {
                this.bufferSwitcher.requestFocus();
                this.bufferSwitcher.showPopup();
            });
        }
    }

    public void saveCaretInfo() {
        if (!this.buffer.isLoaded()) {
            return;
        }
        this.buffer.setIntegerProperty("Buffer__caret", this.textArea.getCaretPosition());
        CaretInfo caretInfo = this.caretsForPath.get(this.buffer.getPath());
        if (caretInfo == null) {
            caretInfo = new CaretInfo();
            this.caretsForPath.put(this.buffer.getPath(), caretInfo);
        }
        caretInfo.caret = this.textArea.getCaretPosition();
        Selection[] selection = this.textArea.getSelection();
        for (int i = 0; i < selection.length; ++i) {
            selection[i] = (Selection)selection[i].clone();
        }
        this.buffer.setProperty("Buffer__selection", selection);
        caretInfo.selection = selection;
        caretInfo.rectangularSelection = this.textArea.isRectangularSelectionEnabled();
        caretInfo.multipleSelection = this.textArea.isMultipleSelectionEnabled();
        this.buffer.setIntegerProperty("Buffer__scrollVert", this.textArea.getFirstPhysicalLine());
        caretInfo.scrollVert = this.textArea.getFirstPhysicalLine();
        this.buffer.setIntegerProperty("Buffer__scrollHoriz", this.textArea.getHorizontalOffset());
        caretInfo.scrollHoriz = this.textArea.getHorizontalOffset();
        if (!this.buffer.isUntitled()) {
            BufferHistory.setEntry(this.buffer.getPath(), this.textArea.getCaretPosition(), (Selection[])this.buffer.getProperty("Buffer__selection"), this.buffer.getStringProperty("encoding"), this.buffer.getMode().getName());
        }
    }

    public void loadCaretInfo() {
        int horizontalOffset;
        Selection[] selection;
        int caret;
        CaretInfo caretInfo = this.caretsForPath.get(this.buffer.getPath());
        if (caretInfo == null) {
            caretInfo = new CaretInfo();
        }
        if ((caret = caretInfo.caret) == -1 || this.buffer.getBooleanProperty("Buffer__caretPositioned")) {
            Integer i = (Integer)this.buffer.getProperty("Buffer__caret");
            caret = i == null ? -1 : i;
        }
        this.buffer.unsetProperty("Buffer__caretPositioned");
        if (caret != -1) {
            this.textArea.setCaretPosition(Math.min(caret, this.buffer.getLength()));
            EditBus.send(new PositionChanging(this));
        }
        if ((selection = caretInfo.selection) == null) {
            selection = (Selection[])this.buffer.getProperty("Buffer__selection");
        }
        if (selection != null) {
            for (int i = 0; i < selection.length; ++i) {
                Selection s = selection[i];
                if (s == null) continue;
                int max = this.buffer.getLength();
                if (s.getStart() <= max && s.getEnd() <= max) continue;
                selection[i] = null;
            }
        }
        this.textArea.setSelection(selection);
        this.textArea.setRectangularSelectionEnabled(caretInfo.rectangularSelection);
        this.textArea.setMultipleSelectionEnabled(caretInfo.multipleSelection);
        int firstLine = caretInfo.scrollVert;
        if (firstLine == -1) {
            Integer i = (Integer)this.buffer.getProperty("Buffer__scrollVert");
            int n = firstLine = i == null ? -1 : i;
        }
        if (firstLine != -1) {
            this.textArea.setFirstPhysicalLine(firstLine);
        }
        if ((horizontalOffset = caretInfo.scrollHoriz) == -1) {
            Integer i = (Integer)this.buffer.getProperty("Buffer__scrollHoriz");
            int n = horizontalOffset = i == null ? -1 : i;
        }
        if (horizontalOffset != -1) {
            this.textArea.setHorizontalOffset(horizontalOffset);
        }
        this.view.getStatus().setMessage(null);
    }

    void bufferRenamed(String oldPath, String newPath) {
        CaretInfo caretInfo = this.caretsForPath.remove(oldPath);
        if (caretInfo != null) {
            this.caretsForPath.put(newPath, caretInfo);
        }
    }

    public void goToNextMarker(boolean select) {
        Vector<Marker> markers = this.buffer.getMarkers();
        if (markers.isEmpty()) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
        Marker marker = null;
        int caret = this.textArea.getCaretPosition();
        for (Marker _marker : markers) {
            if (_marker.getPosition() <= caret) continue;
            marker = _marker;
            break;
        }
        if (marker == null) {
            marker = (Marker)markers.get(0);
        }
        if (select) {
            this.textArea.extendSelection(caret, marker.getPosition());
        } else if (!this.textArea.isMultipleSelectionEnabled()) {
            this.textArea.selectNone();
        }
        this.textArea.moveCaretPosition(marker.getPosition());
    }

    public void goToPrevMarker(boolean select) {
        Vector<Marker> markers = this.buffer.getMarkers();
        if (markers.isEmpty()) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
        int caret = this.textArea.getCaretPosition();
        Marker marker = null;
        for (int i = markers.size() - 1; i >= 0; --i) {
            Marker _marker = (Marker)markers.get(i);
            if (_marker.getPosition() >= caret) continue;
            marker = _marker;
            break;
        }
        if (marker == null) {
            marker = (Marker)markers.get(markers.size() - 1);
        }
        if (select) {
            this.textArea.extendSelection(caret, marker.getPosition());
        } else if (!this.textArea.isMultipleSelectionEnabled()) {
            this.textArea.selectNone();
        }
        this.textArea.moveCaretPosition(marker.getPosition());
    }

    public void goToMarker(char shortcut, boolean select) {
        Marker marker = this.buffer.getMarker(shortcut);
        if (marker == null) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
        int pos = marker.getPosition();
        if (select) {
            this.textArea.extendSelection(this.textArea.getCaretPosition(), pos);
        } else if (!this.textArea.isMultipleSelectionEnabled()) {
            this.textArea.selectNone();
        }
        this.textArea.moveCaretPosition(pos);
    }

    public void addMarker() {
        Selection[] selection;
        int caretLine = this.textArea.getCaretLine();
        for (Selection s : selection = this.textArea.getSelection()) {
            int startLine = s.getStartLine();
            if (startLine != s.getEndLine() && startLine != caretLine) {
                this.buffer.addMarker('\u0000', s.getStart());
            }
            if (s.getEndLine() == caretLine) continue;
            this.buffer.addMarker('\u0000', s.getEnd());
        }
        this.buffer.addOrRemoveMarker('\u0000', this.textArea.getCaretPosition());
    }

    public void swapMarkerAndCaret(char shortcut) {
        Marker marker = this.buffer.getMarker(shortcut);
        if (marker == null) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
        int caret = this.textArea.getCaretPosition();
        this.textArea.setCaretPosition(marker.getPosition());
        this.buffer.addMarker(shortcut, caret);
    }

    @EditBus.EBHandler
    public void handlePropertiesChanged(PropertiesChanged msg) {
        this.propertiesChanged();
        this.loadBufferSwitcher();
    }

    @Override
    public final Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public BufferSet getBufferSet() {
        return this.bufferSet;
    }

    @Override
    public void bufferAdded(Buffer buffer, int index) {
        if (buffer == null) {
            return;
        }
        if (this.bufferSwitcher != null) {
            this.bufferSwitcher.updateBufferList();
        }
        if (!this.bufferSet.contains(this.buffer)) {
            this.setBuffer(buffer);
        }
    }

    @Override
    public void bufferRemoved(Buffer buffer, int index) {
        if (buffer.isUntitled()) {
            this.caretsForPath.remove(buffer.getPath());
        }
        if (buffer == this.buffer) {
            Buffer newBuffer;
            Buffer buffer2 = newBuffer = this.recentBuffer != null ? this.recentBuffer : this.bufferSet.getPreviousBuffer(index);
            if (newBuffer != null && !newBuffer.isClosed()) {
                this.setBuffer(newBuffer);
                if (this.bufferSet.size() > 1) {
                    this.recentBuffer = this.bufferSet.getPreviousBuffer(index - 1);
                }
            } else if (this.bufferSet.size() != 0) {
                this.setBuffer(this.bufferSet.getBuffer(0));
                this.recentBuffer = null;
            }
        }
        if (buffer == this.recentBuffer) {
            this.recentBuffer = null;
        }
        if (this.bufferSwitcher != null) {
            this.bufferSwitcher.updateBufferList();
        }
    }

    @Override
    public void bufferMoved(Buffer buffer, int oldIndex, int newIndex) {
        if (this.bufferSwitcher != null) {
            this.bufferSwitcher.updateBufferList();
        }
    }

    @Override
    public void bufferSetSorted() {
        if (this.bufferSwitcher != null) {
            this.bufferSwitcher.updateBufferList();
        }
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[" + (this.view.getEditPane() == this ? "active]" : "inactive]");
    }

    public EditPane(@Nonnull View view, @Nullable BufferSet bufferSetSource, @Nonnull Buffer buffer) {
        super(new BorderLayout());
        BufferSet.Scope scope = jEdit.getBufferSetManager().getScope();
        BufferSet source = bufferSetSource;
        switch (scope) {
            case editpane: {
                break;
            }
            case view: {
                EditPane editPane = view.getEditPane();
                if (editPane == null) break;
                source = editPane.getBufferSet();
                break;
            }
            case global: {
                EditPane editPane;
                View activeView = jEdit.getActiveView();
                if (activeView == null || (editPane = activeView.getEditPane()) == null) break;
                source = editPane.getBufferSet();
            }
        }
        this.bufferSet = new BufferSet(source);
        this.init = true;
        this.view = view;
        JEditTextAreaFactory textAreaFactory = ServiceManager.getService(JEditTextAreaFactory.class, "textarea-factory");
        this.textArea = textAreaFactory == null ? new JEditTextArea(view) : textAreaFactory.create(view);
        this.bufferSet.addBufferSetListener(this);
        this.textArea.getPainter().setAntiAlias(new AntiAlias(jEdit.getProperty("view.antiAlias")));
        EditPaneMouseHandlerFactory mouseHandlerFactory = ServiceManager.getService(EditPaneMouseHandlerFactory.class, "mouse-handler-factory");
        TextAreaMouseHandler mouseHandler = mouseHandlerFactory == null ? new MouseHandler(this.textArea) : mouseHandlerFactory.create(this);
        this.textArea.setMouseHandler(mouseHandler);
        this.textArea.setTransferHandler(new TextAreaTransferHandler());
        this.markerHighlight = new MarkerHighlight();
        Gutter gutter = this.textArea.getGutter();
        gutter.setGutterEnabled(GutterOptionPane.isGutterEnabled());
        gutter.setMinLineNumberDigitCount(GutterOptionPane.getMinLineNumberDigits());
        gutter.setSelectionAreaEnabled(GutterOptionPane.isSelectionAreaEnabled());
        gutter.addExtension(this.markerHighlight);
        gutter.setSelectionPopupHandler((x, y, line) -> {
            Buffer buffer1 = this.getBuffer();
            buffer1.addOrRemoveMarker('\u0000', buffer1.getLineStartOffset(line));
        });
        this.textArea.addStatusListener(new StatusHandler());
        this.add("Center", this.textArea);
        this.propertiesChanged();
        this.setBuffer(buffer);
        if (!this.bufferSet.contains(buffer)) {
            this.bufferSet.addBuffer(buffer);
        }
        this.loadBufferSwitcher();
        this.init = false;
        EditBus.addToBus(this);
    }

    void close() {
        this.saveCaretInfo();
        EditBus.send(new EditPaneUpdate(this, EditPaneUpdate.DESTROYED));
        EditBus.removeFromBus(this);
        this.textArea.dispose();
    }

    private void propertiesChanged() {
        TextAreaPainter painter = this.textArea.getPainter();
        EditPane.initPainter(painter);
        Gutter gutter = this.textArea.getGutter();
        gutter.setExpanded(jEdit.getBooleanProperty("view.gutter.lineNumbers"));
        int interval = jEdit.getIntegerProperty("view.gutter.highlightInterval", 5);
        gutter.setHighlightInterval(interval);
        gutter.setCurrentLineHighlightEnabled(jEdit.getBooleanProperty("view.gutter.highlightCurrentLine"));
        gutter.setStructureHighlightEnabled(jEdit.getBooleanProperty("view.gutter.structureHighlight"));
        gutter.setStructureHighlightColor(jEdit.getColorProperty("view.gutter.structureHighlightColor"));
        Color backgroundColor = jEdit.getColorProperty("view.gutter.bgColor");
        gutter.setBackground(backgroundColor);
        gutter.setForeground(jEdit.getColorProperty("view.gutter.fgColor"));
        gutter.setHighlightedForeground(jEdit.getColorProperty("view.gutter.highlightColor"));
        gutter.setFoldColor(jEdit.getColorProperty("view.gutter.foldColor"));
        this.markerHighlight.setMarkerHighlightColor(jEdit.getColorProperty("view.gutter.markerColor"));
        this.markerHighlight.setMarkerHighlightEnabled(jEdit.getBooleanProperty("view.gutter.markerHighlight"));
        gutter.setCurrentLineForeground(jEdit.getColorProperty("view.gutter.currentLineColor"));
        String alignment = jEdit.getProperty("view.gutter.numberAlignment");
        if ("right".equals(alignment)) {
            gutter.setLineNumberAlignment(4);
        } else if ("center".equals(alignment)) {
            gutter.setLineNumberAlignment(0);
        } else {
            gutter.setLineNumberAlignment(2);
        }
        gutter.setFont(jEdit.getFontProperty("view.gutter.font"));
        gutter.setGutterEnabled(GutterOptionPane.isGutterEnabled());
        gutter.setMinLineNumberDigitCount(GutterOptionPane.getMinLineNumberDigits());
        gutter.setSelectionAreaEnabled(GutterOptionPane.isSelectionAreaEnabled());
        gutter.setSelectionAreaBackground(GutterOptionPane.getSelectionAreaBackground());
        gutter.setSelectionAreaWidth(GutterOptionPane.getSelectionAreaWidth());
        int width = jEdit.getIntegerProperty("view.gutter.borderWidth", 3);
        gutter.setBorder(width, jEdit.getColorProperty("view.gutter.focusBorderColor"), jEdit.getColorProperty("view.gutter.noFocusBorderColor"), this.textArea.getPainter().getBackground());
        gutter.setFoldPainter(this.textArea.getFoldPainter());
        this.textArea.setCaretBlinkEnabled(jEdit.getBooleanProperty("view.caretBlink"));
        this.textArea.setElectricScroll(jEdit.getIntegerProperty("view.electricBorders", 0));
        this.textArea.createPopupMenu(null);
        this.textArea.setQuickCopyEnabled(jEdit.getBooleanProperty("view.middleMousePaste"));
        this.textArea.setDragEnabled(jEdit.getBooleanProperty("view.dragAndDrop"));
        this.textArea.setJoinNonWordChars(jEdit.getBooleanProperty("view.joinNonWordChars"));
        this.textArea.setCtrlForRectangularSelection(jEdit.getBooleanProperty("view.ctrlForRectangularSelection"));
        this.textArea.setBackground(UIManager.getDefaults().getColor("ScrollBar.background"));
        this.textArea.propertiesChanged();
        if (this.bufferSwitcher != null) {
            this.bufferSwitcher.setMaximumRowCount(jEdit.getIntegerProperty("bufferSwitcher.maxRowCount", 10));
        }
    }

    public static void initPainter(TextAreaPainter painter) {
        painter.setFont(jEdit.getFontProperty("view.font"));
        painter.setStructureHighlightEnabled(jEdit.getBooleanProperty("view.structureHighlight"));
        painter.setStructureHighlightColor(jEdit.getColorProperty("view.structureHighlightColor"));
        painter.setEOLMarkersPainted(jEdit.getBooleanProperty("view.eolMarkers"));
        painter.setEOLMarkerChar(jEdit.getProperty("view.eolMarkerChar", "\u00b7"));
        painter.setEOLMarkerColor(jEdit.getColorProperty("view.eolMarkerColor"));
        painter.setWrapGuidePainted(jEdit.getBooleanProperty("view.wrapGuide"));
        painter.setWrapGuideColor(jEdit.getColorProperty("view.wrapGuideColor"));
        painter.setCaretColor(jEdit.getColorProperty("view.caretColor"));
        painter.setSelectionColor(jEdit.getColorProperty("view.selectionColor"));
        painter.setMultipleSelectionColor(jEdit.getColorProperty("view.multipleSelectionColor"));
        painter.setBackground(jEdit.getColorProperty("view.bgColor"));
        painter.setForeground(jEdit.getColorProperty("view.fgColor"));
        painter.setBlockCaretEnabled(jEdit.getBooleanProperty("view.blockCaret"));
        painter.setThickCaretEnabled(jEdit.getBooleanProperty("view.thickCaret"));
        painter.setLineHighlightEnabled(jEdit.getBooleanProperty("view.lineHighlight"));
        painter.setLineHighlightColor(jEdit.getColorProperty("view.lineHighlightColor"));
        painter.setAntiAlias(new AntiAlias(jEdit.getProperty("view.antiAlias")));
        painter.setFractionalFontMetricsEnabled(jEdit.getBooleanProperty("view.fracFontMetrics"));
        painter.setSelectionFgColor(jEdit.getColorProperty("view.selectionFgColor"));
        painter.setSelectionFgColorEnabled(jEdit.getBooleanProperty("view.selectionFg"));
        String defaultFont = jEdit.getProperty("view.font");
        int defaultFontSize = jEdit.getIntegerProperty("view.fontsize", 12);
        painter.setStyles(SyntaxUtilities.loadStyles(defaultFont, defaultFontSize));
        SyntaxStyle[] foldLineStyle = new SyntaxStyle[4];
        for (int i = 0; i <= 3; ++i) {
            foldLineStyle[i] = SyntaxUtilities.parseStyle(jEdit.getThemeProperty("view.style.foldLine." + i), defaultFont, defaultFontSize, true);
        }
        painter.setFoldLineStyle(foldLineStyle);
    }

    void loadBufferSwitcher() {
        if (jEdit.getBooleanProperty("view.showBufferSwitcher")) {
            if (this.bufferSwitcher == null) {
                this.bufferSwitcher = new BufferSwitcher(this);
                EditBus.addToBus(this.bufferSwitcher);
                this.add("North", this.bufferSwitcher);
                this.bufferSwitcher.updateBufferList();
                this.revalidate();
            }
        } else if (this.bufferSwitcher != null) {
            EditBus.removeFromBus(this.bufferSwitcher);
            this.remove(this.bufferSwitcher);
            this.revalidate();
            this.bufferSwitcher = null;
        }
    }

    @EditBus.EBHandler
    public void handleBufferUpdate(BufferUpdate msg) {
        Buffer _buffer = msg.getBuffer();
        if (msg.getWhat() == BufferUpdate.CREATED) {
            if (this.bufferSwitcher != null) {
                this.bufferSwitcher.updateBufferList();
            }
            if (this.buffer.isClosed()) {
                this.recentBuffer = null;
            }
        } else if (msg.getWhat() == BufferUpdate.CLOSED) {
            if (this.bufferSwitcher != null) {
                this.bufferSwitcher.updateBufferList();
            }
            if (_buffer == this.buffer) {
                Buffer newBuffer;
                Buffer buffer = newBuffer = this.recentBuffer != null ? this.recentBuffer : _buffer.getPrev();
                if (newBuffer != null && !newBuffer.isClosed()) {
                    this.setBuffer(newBuffer);
                    this.recentBuffer = newBuffer.getPrev();
                }
            } else if (_buffer == this.recentBuffer) {
                this.recentBuffer = null;
            }
            Buffer closedBuffer = msg.getBuffer();
            if (closedBuffer.isUntitled()) {
                this.caretsForPath.remove(closedBuffer.getPath());
            }
        } else if (msg.getWhat() == BufferUpdate.LOAD_STARTED) {
            if (_buffer == this.buffer) {
                this.textArea.setCaretPosition(0);
                this.textArea.getPainter().repaint();
            }
        } else if (msg.getWhat() == BufferUpdate.LOADED) {
            if (_buffer == this.buffer) {
                this.textArea.repaint();
                if (this.bufferSwitcher != null) {
                    this.bufferSwitcher.updateBufferList();
                }
                if (this.view.getEditPane() == this) {
                    StatusBar status = this.view.getStatus();
                    status.updateCaretStatus();
                    status.updateBufferStatus();
                    status.updateMiscStatus();
                }
                this.loadCaretInfo();
            }
        } else if (msg.getWhat() == BufferUpdate.DIRTY_CHANGED) {
            if (_buffer == this.buffer && this.bufferSwitcher != null) {
                if (this.buffer.isDirty()) {
                    this.bufferSwitcher.repaint();
                } else {
                    this.bufferSwitcher.updateBufferList();
                }
            }
        } else if (msg.getWhat() == BufferUpdate.MARKERS_CHANGED) {
            if (_buffer == this.buffer) {
                this.textArea.getGutter().repaint();
            }
        } else if (msg.getWhat() == BufferUpdate.PROPERTIES_CHANGED) {
            if (_buffer == this.buffer && this.buffer.isLoaded()) {
                this.textArea.propertiesChanged();
                if (this.view.getEditPane() == this) {
                    this.view.getStatus().updateBufferStatus();
                }
            }
        } else if (msg.getWhat() == BufferUpdate.SAVED && _buffer == this.buffer) {
            this.textArea.propertiesChanged();
        }
    }

    private static class CaretInfo {
        public int caret = -1;
        public Selection[] selection;
        public int scrollVert = -1;
        public int scrollHoriz = -1;
        public boolean rectangularSelection;
        public boolean multipleSelection;

        private CaretInfo() {
        }
    }

    class MarkerHighlight
    extends TextAreaExtension {
        private boolean markerHighlight;
        private Color markerHighlightColor;

        MarkerHighlight() {
        }

        public Color getMarkerHighlightColor() {
            return this.markerHighlightColor;
        }

        public void setMarkerHighlightColor(Color markerHighlightColor) {
            this.markerHighlightColor = markerHighlightColor;
        }

        public boolean isMarkerHighlightEnabled() {
            return this.markerHighlight;
        }

        public void setMarkerHighlightEnabled(boolean markerHighlight) {
            this.markerHighlight = markerHighlight;
        }

        @Override
        public void paintValidLine(Graphics2D gfx, int screenLine, int physicalLine, int start, int end, int y) {
            Buffer buffer;
            if (this.isMarkerHighlightEnabled() && (buffer = (Buffer)EditPane.this.textArea.getBuffer()).getMarkerInRange(start, end) != null) {
                gfx.setColor(this.getMarkerHighlightColor());
                int height = EditPane.this.textArea.getPainter().getLineHeight();
                gfx.fillRect(0, y, EditPane.this.textArea.getGutter().getWidth(), height);
            }
        }

        @Override
        public String getToolTipText(int x, int y) {
            if (this.isMarkerHighlightEnabled()) {
                int lineHeight = EditPane.this.textArea.getPainter().getLineHeight();
                if (lineHeight == 0) {
                    return null;
                }
                int line = y / lineHeight;
                int start = EditPane.this.textArea.getScreenLineStartOffset(line);
                int end = EditPane.this.textArea.getScreenLineEndOffset(line);
                if (start == -1 || end == -1) {
                    return null;
                }
                Buffer buffer = (Buffer)EditPane.this.textArea.getBuffer();
                Marker marker = buffer.getMarkerInRange(start, end);
                if (marker != null) {
                    char shortcut = marker.getShortcut();
                    if (shortcut == '\u0000') {
                        return jEdit.getProperty("view.gutter.marker.no-name");
                    }
                    Object[] args = new String[]{String.valueOf(shortcut)};
                    return jEdit.getProperty("view.gutter.marker", args);
                }
            }
            return null;
        }
    }

    class StatusHandler
    implements StatusListener {
        StatusHandler() {
        }

        @Override
        public void statusChanged(TextArea textArea, int flag, boolean value) {
            StatusBar status = EditPane.this.view.getStatus();
            if (status == null) {
                return;
            }
            switch (flag) {
                case 0: {
                    status.setMessageAndClear(jEdit.getProperty("view.status.overwrite-changed", new Integer[]{value ? 1 : 0}));
                    break;
                }
                case 1: {
                    status.setMessageAndClear(jEdit.getProperty("view.status.multi-changed", new Integer[]{value ? 1 : 0}));
                    break;
                }
                case 2: {
                    status.setMessageAndClear(jEdit.getProperty("view.status.rect-select-changed", new Integer[]{value ? 1 : 0}));
                }
            }
            status.updateMiscStatus();
        }

        @Override
        public void bracketSelected(TextArea textArea, int line, String text) {
            StatusBar status = EditPane.this.view.getStatus();
            if (status == null) {
                return;
            }
            status.setMessageAndClear(jEdit.getProperty("view.status.bracket", new Object[]{line, text}));
        }

        @Override
        public void narrowActive(TextArea textArea) {
            StatusBar status = EditPane.this.view.getStatus();
            if (status == null) {
                return;
            }
            status.setMessageAndClear(jEdit.getProperty("view.status.narrow"));
        }
    }
}

