/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gjt.sp.jedit.ActionListHandler;
import org.gjt.sp.jedit.JEditAbstractEditAction;
import org.gjt.sp.jedit.JEditActionContext;
import org.gjt.sp.jedit.JEditBeanShellAction;
import org.gjt.sp.jedit.input.AbstractInputHandler;
import org.gjt.sp.jedit.input.InputHandlerProvider;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.XMLUtilities;

public abstract class JEditActionSet<E extends JEditAbstractEditAction>
implements InputHandlerProvider {
    JEditActionContext context;
    protected HashMap<String, JEditAbstractEditAction> actions = new HashMap();
    protected URL uri;
    protected boolean loaded = true;
    protected static final JEditAbstractEditAction placeholder = new JEditAbstractEditAction("__PLACEHOLDER__"){

        public void invoke(Object arg) {
        }
    };

    protected JEditActionSet() {
    }

    protected JEditActionSet(String[] cachedActionNames, URL uri) {
        this();
        this.uri = uri;
        if (cachedActionNames != null) {
            for (String cachedActionName : cachedActionNames) {
                this.actions.put(cachedActionName, placeholder);
            }
        }
        this.loaded = false;
    }

    public void addAction(E action) {
        this.actions.put(((JEditAbstractEditAction)action).getName(), (JEditAbstractEditAction)action);
        if (this.context != null) {
            this.context.actionNames = null;
            this.context.actionHash.put(((JEditAbstractEditAction)action).getName(), this);
        }
    }

    public void removeAction(String name) {
        this.actions.remove(name);
        if (this.context != null) {
            this.context.actionNames = null;
            this.context.actionHash.remove(name);
        }
    }

    public void removeAllActions() {
        if (this.context != null) {
            String[] actions;
            this.context.actionNames = null;
            for (String action : actions = this.getActionNames()) {
                this.context.actionHash.remove(action);
            }
        }
        this.actions.clear();
    }

    public E getAction(String name) {
        JEditAbstractEditAction obj = this.actions.get(name);
        if (obj == placeholder) {
            this.load();
            obj = this.actions.get(name);
            if (obj == placeholder) {
                Log.log(7, this, "Outdated cache");
                obj = null;
            }
        }
        return (E)obj;
    }

    public int getActionCount() {
        return this.actions.size();
    }

    public String[] getActionNames() {
        String[] retVal = new String[this.actions.size()];
        Set<String> keys = this.actions.keySet();
        int i = 0;
        for (String key : keys) {
            retVal[i++] = key;
        }
        return retVal;
    }

    public String[] getCacheableActionNames() {
        LinkedList<String> retVal = new LinkedList<String>();
        for (JEditAbstractEditAction obj : this.actions.values()) {
            if (obj == placeholder) {
                Log.log(7, this, "Action set not up to date");
                continue;
            }
            if (!(obj instanceof JEditBeanShellAction)) continue;
            retVal.add(((JEditBeanShellAction)obj).getName());
        }
        return retVal.toArray(StandardUtilities.EMPTY_STRING_ARRAY);
    }

    protected abstract E[] getArray(int var1);

    public E[] getActions() {
        this.load();
        JEditAbstractEditAction[] retVal = this.getArray(this.actions.size());
        Collection<JEditAbstractEditAction> values = this.actions.values();
        int i = 0;
        for (JEditAbstractEditAction value : values) {
            retVal[i++] = value;
        }
        return retVal;
    }

    public boolean contains(String action) {
        boolean retval = this.actions.containsKey(action);
        return retval;
    }

    public int size() {
        return this.actions.size();
    }

    public void load() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        if (this.uri == null) {
            return;
        }
        try {
            InputStream in;
            Log.log(1, this, "Loading actions from " + String.valueOf(this.uri));
            ActionListHandler ah = new ActionListHandler(this.uri.toString(), this);
            try {
                in = this.uri.openStream();
            }
            catch (FileNotFoundException e) {
                in = null;
                Log.log(7, this, "Unable to open: " + String.valueOf(this.uri));
            }
            if (in != null && XMLUtilities.parseXML(in, ah)) {
                Log.log(9, this, "Unable to parse: " + String.valueOf(this.uri));
            }
        }
        catch (IOException e) {
            Log.log(9, this, this.uri, e);
        }
    }

    protected abstract JEditAbstractEditAction createBeanShellAction(String var1, String var2, String var3, boolean var4, boolean var5, boolean var6);

    public void initKeyBindings() {
        AbstractInputHandler inputHandler = this.getInputHandler();
        Set<Map.Entry<String, JEditAbstractEditAction>> entries = this.actions.entrySet();
        for (Map.Entry<String, JEditAbstractEditAction> entry : entries) {
            String shortcut2;
            String name = entry.getKey();
            String shortcut1 = this.getProperty(name + ".shortcut");
            if (shortcut1 != null) {
                inputHandler.addKeyBinding(shortcut1, name);
            }
            if ((shortcut2 = this.getProperty(name + ".shortcut2")) == null) continue;
            inputHandler.addKeyBinding(shortcut2, name);
        }
    }

    protected abstract String getProperty(String var1);

    void getActionNames(List<String> list) {
        list.addAll(this.actions.keySet());
    }
}

