/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

class JEditMode
extends Mode {
    private boolean initialized;

    JEditMode(String name) {
        super(name);
    }

    @Override
    public void setProperty(String key, Object value) {
        if (this.initialized) {
            jEdit.setProperty("mode." + this.name + "." + key, value.toString());
        }
        this.props.put(key, value);
    }

    @Override
    public void unsetProperty(String key) {
        if (this.initialized) {
            jEdit.unsetProperty("mode." + this.name + "." + key);
        }
        this.props.remove(key);
    }

    @Override
    public Object getProperty(String key) {
        String property = jEdit.getProperty("mode." + this.name + "." + key);
        if (property != null) {
            Object value;
            try {
                value = Integer.valueOf(property);
            }
            catch (NumberFormatException nf) {
                value = property;
            }
            return value;
        }
        Object value = this.props.get(key);
        if (value != null) {
            return value;
        }
        String global = jEdit.getProperty("buffer." + key);
        if (global != null) {
            try {
                return Integer.valueOf(global);
            }
            catch (NumberFormatException nf) {
                return global;
            }
        }
        return null;
    }

    @Override
    public void init() {
        this.initialized = true;
        super.init();
    }

    @Override
    public void loadIfNecessary() {
        if (this.marker == null) {
            jEdit.loadMode(this);
            if (this.marker == null) {
                Log.log(9, this, "Mode not correctly loaded, token marker is still null");
            }
        }
    }
}

