/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.gjt.sp.jedit.ActionContext;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.browser.BrowserView;
import org.gjt.sp.jedit.browser.FileCellRenderer;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.browser.VFSDirectoryEntryTableModel;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.VFSPathSelected;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ThreadUtilities;

public class VFSDirectoryEntryTable
extends JTable {
    private final BrowserView browserView;
    private final JTableHeader header;
    private final FileCellRenderer renderer;
    private final StringBuffer typeSelectBuffer = new StringBuffer();
    private final Timer timer = new Timer(0, e -> this.typeSelectBuffer.setLength(0));
    private boolean resizingColumns;
    static final Icon ASC_ICON = GUIUtilities.loadIcon("arrow-asc.png");
    static final Icon DESC_ICON = GUIUtilities.loadIcon("arrow-desc.png");

    VFSDirectoryEntryTable(BrowserView browserView) {
        super(new VFSDirectoryEntryTableModel());
        this.browserView = browserView;
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.renderer = new FileCellRenderer();
        this.setDefaultRenderer(VFSDirectoryEntryTableModel.Entry.class, this.renderer);
        this.header = this.getTableHeader();
        this.header.setReorderingAllowed(true);
        this.addMouseListener(new MainMouseHandler());
        this.header.addMouseListener(new MouseHandler());
        this.header.setDefaultRenderer(new HeaderRenderer((DefaultTableCellRenderer)this.header.getDefaultRenderer()));
        this.setRowSelectionAllowed(true);
        this.getColumnModel().addColumnModelListener(new ColumnHandler());
        this.setAutoResizeMode(0);
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        JTableHeader header = new JTableHeader(this.getColumnModel()){
            ColumnDragHook hook;

            @Override
            public void updateUI() {
                if (this.hook != null) {
                    this.hook.uninstallHook();
                    this.hook = null;
                }
                super.updateUI();
                this.hook = new ColumnDragHook(this);
            }
        };
        return header;
    }

    public boolean selectFile(String path) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            VFSDirectoryEntryTableModel.Entry entry = (VFSDirectoryEntryTableModel.Entry)this.getValueAt(i, 1);
            if (!entry.dirEntry.getPath().equals(path)) continue;
            this.setSelectedRow(i);
            return true;
        }
        return false;
    }

    public void doTypeSelect(String str, boolean dirsOnly) {
        if (str.isEmpty()) {
            this.clearSelection();
        } else if (this.getSelectedRow() == -1) {
            this.doTypeSelect(str, 0, this.getRowCount(), dirsOnly);
        } else {
            int start = this.getSelectionModel().getMaxSelectionIndex();
            boolean retVal = this.doTypeSelect(str, start, this.getRowCount(), dirsOnly);
            if (!retVal) {
                this.doTypeSelect(str, 0, start, dirsOnly);
            }
        }
    }

    public VFSFile[] getSelectedFiles() {
        int[] selectedRows;
        VFSDirectoryEntryTableModel model = (VFSDirectoryEntryTableModel)this.getModel();
        LinkedList<VFSFile> returnValue = new LinkedList<VFSFile>();
        for (int selectedRow : selectedRows = this.getSelectedRows()) {
            returnValue.add(model.files[selectedRow].dirEntry);
        }
        return returnValue.toArray(new VFSFile[0]);
    }

    public void getExpandedDirectories(Set<String> set) {
        VFSDirectoryEntryTableModel model = (VFSDirectoryEntryTableModel)this.getModel();
        if (model.files != null) {
            for (int i = 0; i < model.files.length; ++i) {
                if (!model.files[i].expanded) continue;
                set.add(model.files[i].dirEntry.getPath());
            }
        }
    }

    public void toggleExpanded(int row) {
        VFSDirectoryEntryTableModel model = (VFSDirectoryEntryTableModel)this.getModel();
        VFSDirectoryEntryTableModel.Entry entry = model.files[row];
        if (entry.dirEntry.getType() == 0) {
            return;
        }
        if (entry.expanded) {
            model.collapse(VFSManager.getVFSForPath(entry.dirEntry.getPath()), row);
            this.resizeColumns();
            ThreadUtilities.runInDispatchThread(() -> this.setSelectedRow(row));
        } else {
            this.browserView.clearExpansionState();
            this.browserView.loadDirectory(entry, entry.dirEntry.getPath(), false, () -> this.setSelectedRow(row));
        }
    }

    public void setDirectory(VFS vfs, Object node, List<VFSFile> list, Set<String> tmpExpanded) {
        int startIndex;
        this.timer.stop();
        this.typeSelectBuffer.setLength(0);
        VFSDirectoryEntryTableModel model = (VFSDirectoryEntryTableModel)this.getModel();
        if (node == null) {
            startIndex = 0;
            model.setRoot(vfs, list);
        } else {
            startIndex = model.expand(vfs, (VFSDirectoryEntryTableModel.Entry)node, list);
            ++startIndex;
        }
        for (int i = 0; i < list.size(); ++i) {
            VFSDirectoryEntryTableModel.Entry e = model.files[startIndex + i];
            String path = e.dirEntry.getPath();
            if (!tmpExpanded.contains(path)) continue;
            this.browserView.loadDirectory(e, path, false);
            tmpExpanded.remove(path);
        }
        this.resizeColumns();
    }

    public void maybeReloadDirectory(String path) {
        VFSDirectoryEntryTableModel model = (VFSDirectoryEntryTableModel)this.getModel();
        for (int i = 0; i < model.files.length; ++i) {
            VFSFile dirEntry;
            String otherPath;
            VFSDirectoryEntryTableModel.Entry e = model.files[i];
            if (!e.expanded || e.dirEntry.getType() == 0 || !MiscUtilities.pathsEqual(path, otherPath = (dirEntry = e.dirEntry).getSymlinkPath() == null ? dirEntry.getPath() : dirEntry.getSymlinkPath())) continue;
            this.browserView.saveExpansionState();
            this.browserView.loadDirectory(e, path, false);
            return;
        }
    }

    public void propertiesChanged() {
        this.renderer.propertiesChanged();
        VFSFile template = new VFSFile("foo", "foo", "foo", 0, 0L, false);
        this.setRowHeight(this.renderer.getTableCellRendererComponent((JTable)this, (Object)new VFSDirectoryEntryTableModel.Entry((VFSFile)template, (int)0), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().height);
        Dimension prefSize = this.getPreferredSize();
        this.setPreferredScrollableViewportSize(new Dimension(prefSize.width, this.getRowHeight() * 12));
    }

    @Override
    public void scrollRectToVisible(Rectangle rect) {
        rect.width = 0;
        super.scrollRectToVisible(rect);
    }

    @Override
    public void processKeyEvent(KeyEvent evt) {
        if (evt.getID() == 401) {
            VFSDirectoryEntryTableModel model = (VFSDirectoryEntryTableModel)this.getModel();
            int row = this.getSelectedRow();
            ActionContext ac = VFSBrowser.getActionContext();
            ActionContext jac = jEdit.getActionContext();
            EditAction browserUp = ac.getAction("vfs.browser.up");
            VFSBrowser browser = this.browserView.getBrowser();
            switch (evt.getKeyCode()) {
                case 37: {
                    evt.consume();
                    if ((evt.getModifiersEx() & 0x200) == 512) {
                        browser.previousDirectory();
                        break;
                    }
                    if (row != -1) {
                        if (model.files[row].expanded) {
                            this.toggleExpanded(row);
                            return;
                        }
                        for (int i = row - 1; i >= 0; --i) {
                            if (!model.files[i].expanded || model.files[i].level >= model.files[row].level) continue;
                            this.setSelectedRow(i);
                            return;
                        }
                    }
                    String dir2 = this.browserView.getBrowser().getDirectory();
                    dir2 = MiscUtilities.getParentOfPath(dir2);
                    this.browserView.getBrowser().setDirectory(dir2);
                    break;
                }
                case 9: {
                    evt.consume();
                    if ((evt.getModifiersEx() & 0x40) == 64) {
                        this.browserView.getParentDirectoryList().requestFocus();
                        break;
                    }
                    browser.focusOnDefaultComponent();
                    break;
                }
                case 8: {
                    evt.consume();
                    ac.invokeAction(evt, browserUp);
                    break;
                }
                case 38: {
                    if ((evt.getModifiersEx() & 0x200) != 512) break;
                    evt.consume();
                    ac.invokeAction(evt, browserUp);
                    break;
                }
                case 127: {
                    evt.consume();
                    EditAction deleteAct = ac.getAction("vfs.browser.delete");
                    ac.invokeAction(evt, deleteAct);
                    break;
                }
                case 78: {
                    if ((evt.getModifiersEx() & 0x80) != 128) break;
                    evt.consume();
                    EditAction ea = ac.getAction("vfs.browser.new-file");
                    ac.invokeAction(evt, ea);
                    break;
                }
                case 155: {
                    evt.consume();
                    EditAction newDir = ac.getAction("vfs.browser.new-directory");
                    ac.invokeAction(evt, newDir);
                    break;
                }
                case 27: {
                    EditAction cda = ac.getAction("vfs.browser.closedialog");
                    ac.invokeAction(evt, cda);
                    break;
                }
                case 113: {
                    EditAction ren = ac.getAction("vfs.browser.rename");
                    evt.consume();
                    ac.invokeAction(evt, ren);
                    break;
                }
                case 116: {
                    evt.consume();
                    EditAction reload = ac.getAction("vfs.browser.reload");
                    ac.invokeAction(evt, reload);
                    break;
                }
                case 39: 
                case 117: {
                    evt.consume();
                    if ((evt.getModifiersEx() & 0x200) == 512) {
                        browser.nextDirectory();
                        break;
                    }
                    if (row == -1 || model.files[row].expanded) break;
                    this.toggleExpanded(row);
                    break;
                }
                case 10: {
                    evt.consume();
                    this.browserView.getBrowser().filesActivated(evt.isShiftDown() ? 1 : 0, false);
                }
            }
        } else if (evt.getID() == 400) {
            if (evt.isControlDown() || evt.isAltDown() || evt.isMetaDown()) {
                evt.consume();
                return;
            }
            if (evt.isShiftDown() && evt.getKeyChar() == '\n') {
                evt.consume();
                return;
            }
            VFSBrowser browser = this.browserView.getBrowser();
            switch (evt.getKeyChar()) {
                case '~': {
                    evt.consume();
                    if (browser.getMode() != 2) break;
                    browser.setDirectory(System.getProperty("user.home"));
                    break;
                }
                case '/': {
                    evt.consume();
                    if (browser.getMode() != 2) break;
                    browser.rootDirectory();
                    break;
                }
                case '-': {
                    evt.consume();
                    if (browser.getMode() != 2) break;
                    browser.setDirectory(browser.getView().getBuffer().getDirectory());
                    break;
                }
                default: {
                    evt.consume();
                    this.typeSelectBuffer.append(evt.getKeyChar());
                    this.doTypeSelect(this.typeSelectBuffer.toString(), browser.getMode() == 3);
                    this.timer.stop();
                    this.timer.setInitialDelay(750);
                    this.timer.setRepeats(false);
                    this.timer.start();
                    return;
                }
            }
        }
        if (!evt.isConsumed()) {
            super.processKeyEvent(evt);
        }
    }

    public void setSelectedRow(int row) {
        this.getSelectionModel().setSelectionInterval(row, row);
        this.scrollRectToVisible(this.getCellRect(row, 0, true));
    }

    private boolean doTypeSelect(String str, int start, int end, boolean dirsOnly) {
        VFSFile[] files = ((VFSDirectoryEntryTableModel)this.getModel()).getFiles();
        int index = VFSFile.findCompletion(files, start, end, str, dirsOnly);
        if (index != -1) {
            this.setSelectedRow(index);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resizeColumns() {
        int i;
        VFSDirectoryEntryTableModel model = (VFSDirectoryEntryTableModel)this.getModel();
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, false);
        int[] widths = new int[model.getColumnCount()];
        for (i = 0; i < widths.length; ++i) {
            String columnName = model.getColumnName(i);
            if (columnName == null) continue;
            widths[i] = (int)this.renderer.plainFont.getStringBounds(columnName, fontRenderContext).getWidth();
        }
        for (i = 1; i < widths.length; ++i) {
            widths[i] = Math.max(widths[i], model.getColumnWidth(i));
        }
        for (i = 0; i < model.files.length; ++i) {
            VFSDirectoryEntryTableModel.Entry entry = model.files[i];
            Font font = entry.dirEntry.getType() == 0 ? this.renderer.plainFont : this.renderer.boldFont;
            widths[0] = Math.max(widths[0], this.renderer.getEntryWidth(entry, font, fontRenderContext));
        }
        widths[0] = widths[0] + 10;
        TableColumnModel columns = this.getColumnModel();
        try {
            this.resizingColumns = true;
            for (int i2 = 0; i2 < widths.length; ++i2) {
                columns.getColumn(i2).setPreferredWidth(widths[i2]);
                columns.getColumn(i2).setWidth(widths[i2]);
            }
        }
        finally {
            this.resizingColumns = false;
        }
        this.doLayout();
    }

    private void saveWidths() {
        if (this.resizingColumns) {
            return;
        }
        VFSDirectoryEntryTableModel model = (VFSDirectoryEntryTableModel)this.getModel();
        TableColumnModel columns = this.getColumnModel();
        for (int i = 1; i < model.getColumnCount(); ++i) {
            model.saveColumnWidth(i, columns.getColumn(i).getWidth());
        }
    }

    private class MainMouseHandler
    extends MouseInputAdapter {
        private MainMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            if (VFSDirectoryEntryTable.this.browserView.getBrowser().getMode() != 2) {
                return;
            }
            int ind = VFSDirectoryEntryTable.this.getSelectionModel().getMinSelectionIndex();
            if (ind == -1) {
                return;
            }
            VFSDirectoryEntryTableModel.Entry node = (VFSDirectoryEntryTableModel.Entry)VFSDirectoryEntryTable.this.getModel().getValueAt(ind, 0);
            boolean isDir = node.dirEntry.getType() == 1;
            EditBus.send(new VFSPathSelected(VFSDirectoryEntryTable.this.browserView.getBrowser().getView(), node.dirEntry.getPath(), isDir));
        }
    }

    private class MouseHandler
    extends MouseInputAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (evt.getSource() == VFSDirectoryEntryTable.this.header && evt.getClickCount() == 2) {
                int viewColumnIndex;
                VFSDirectoryEntryTableModel model = (VFSDirectoryEntryTableModel)VFSDirectoryEntryTable.this.header.getTable().getModel();
                TableColumnModel columnModel = VFSDirectoryEntryTable.this.header.getColumnModel();
                int modelColumnIndex = viewColumnIndex = columnModel.getColumnIndexAtX(evt.getX());
                VFSDirectoryEntryTable.this.saveWidths();
                if (model.sortByColumn(modelColumnIndex)) {
                    VFSDirectoryEntryTable.this.resizeColumns();
                    Log.log(1, this, "VFSDirectoryEntryTable sorted by " + model.getColumnName(modelColumnIndex) + (model.getAscending() ? " ascending" : " descending"));
                }
            }
        }
    }

    private static class HeaderRenderer
    extends DefaultTableCellRenderer {
        private final DefaultTableCellRenderer tcr;

        HeaderRenderer(DefaultTableCellRenderer tcr) {
            this.tcr = tcr;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel l = (JLabel)this.tcr.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            VFSDirectoryEntryTableModel model = (VFSDirectoryEntryTableModel)table.getModel();
            Icon icon = column == model.getSortColumnIndex() ? (model.getAscending() ? ASC_ICON : DESC_ICON) : null;
            l.setIcon(icon);
            return l;
        }
    }

    private class ColumnHandler
    implements TableColumnModelListener {
        private ColumnHandler() {
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
            ((VFSDirectoryEntryTableModel)VFSDirectoryEntryTable.this.getModel()).columnMoved(e.getFromIndex(), e.getToIndex());
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
            VFSDirectoryEntryTable.this.saveWidths();
        }
    }

    private static class ColumnDragHook
    implements MouseInputListener {
        private final JTableHeader header;
        private MouseListener mouseDelegate;
        private MouseMotionListener mouseMotionDelegate;
        private int minMouseX;

        ColumnDragHook(JTableHeader header) {
            this.header = header;
            this.installHook();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int index = this.header.columnAtPoint(e.getPoint());
            boolean reorderingAllowed = this.header.getReorderingAllowed();
            if (index == 0) {
                this.header.setReorderingAllowed(false);
            }
            this.mouseDelegate.mousePressed(e);
            if (index == 0) {
                this.header.setReorderingAllowed(reorderingAllowed);
            }
            if (this.header.getDraggedColumn() != null) {
                int draggedColumnX = this.header.getHeaderRect((int)index).x;
                int firstColumnWidth = this.header.getColumnModel().getColumn(0).getWidth();
                this.minMouseX = firstColumnWidth + (e.getX() - draggedColumnX) - 1;
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int index;
            TableColumn dragged = this.header.getDraggedColumn();
            if (dragged != null && (index = this.header.getTable().convertColumnIndexToView(dragged.getModelIndex())) == 1 && e.getX() < this.minMouseX) {
                return;
            }
            this.mouseMotionDelegate.mouseDragged(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.mouseDelegate.mouseReleased(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.mouseDelegate.mouseClicked(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.mouseDelegate.mouseEntered(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.mouseDelegate.mouseExited(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.mouseMotionDelegate.mouseMoved(e);
        }

        protected void installHook() {
            this.installMouseHook();
            this.installMouseMotionHook();
        }

        protected void installMouseMotionHook() {
            MouseMotionListener[] listeners = this.header.getMouseMotionListeners();
            for (int i = 0; i < listeners.length; ++i) {
                MouseMotionListener l = listeners[i];
                if (l.getClass().getName().contains("TableHeaderUI")) {
                    this.mouseMotionDelegate = l;
                    listeners[i] = this;
                }
                this.header.removeMouseMotionListener(l);
            }
            Arrays.stream(listeners).forEach(this.header::addMouseMotionListener);
        }

        protected void installMouseHook() {
            MouseListener[] listeners = this.header.getMouseListeners();
            for (int i = 0; i < listeners.length; ++i) {
                MouseListener l = listeners[i];
                if (l.getClass().getName().contains("TableHeaderUI")) {
                    this.mouseDelegate = l;
                    listeners[i] = this;
                }
                this.header.removeMouseListener(l);
            }
            Arrays.stream(listeners).forEach(this.header::addMouseListener);
        }

        public void uninstallHook() {
            this.uninstallMouseHook();
            this.uninstallMouseMotionHook();
        }

        protected void uninstallMouseMotionHook() {
            MouseMotionListener[] listeners = this.header.getMouseMotionListeners();
            for (int i = 0; i < listeners.length; ++i) {
                MouseMotionListener l = listeners[i];
                if (l == this) {
                    listeners[i] = this.mouseMotionDelegate;
                }
                this.header.removeMouseMotionListener(l);
            }
            Arrays.stream(listeners).forEach(this.header::addMouseMotionListener);
        }

        protected void uninstallMouseHook() {
            MouseListener[] listeners = this.header.getMouseListeners();
            for (int i = 0; i < listeners.length; ++i) {
                MouseListener l = listeners[i];
                if (l == this) {
                    listeners[i] = this.mouseDelegate;
                }
                this.header.removeMouseListener(l);
            }
            Arrays.stream(listeners).forEach(this.header::addMouseListener);
        }
    }
}

