/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bsh;

import java.util.Vector;
import org.gjt.sp.jedit.bsh.BSHBlock;
import org.gjt.sp.jedit.bsh.BSHFormalParameter;
import org.gjt.sp.jedit.bsh.BlockNameSpace;
import org.gjt.sp.jedit.bsh.CallStack;
import org.gjt.sp.jedit.bsh.EvalError;
import org.gjt.sp.jedit.bsh.Interpreter;
import org.gjt.sp.jedit.bsh.InterpreterError;
import org.gjt.sp.jedit.bsh.Modifiers;
import org.gjt.sp.jedit.bsh.NameSpace;
import org.gjt.sp.jedit.bsh.Node;
import org.gjt.sp.jedit.bsh.Primitive;
import org.gjt.sp.jedit.bsh.ReturnControl;
import org.gjt.sp.jedit.bsh.SimpleNode;
import org.gjt.sp.jedit.bsh.TargetError;
import org.gjt.sp.jedit.bsh.Types;
import org.gjt.sp.jedit.bsh.UtilEvalError;

class BSHTryStatement
extends SimpleNode {
    BSHTryStatement(int id) {
        super(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object eval(CallStack callstack, Interpreter interpreter) throws EvalError {
        BSHBlock tryBlock = (BSHBlock)this.jjtGetChild(0);
        Vector<Node> catchParams = new Vector<Node>();
        Vector<Node> catchBlocks = new Vector<Node>();
        int nchild = this.jjtGetNumChildren();
        Node node = null;
        int i = 1;
        while (i < nchild && (node = this.jjtGetChild(i++)) instanceof BSHFormalParameter) {
            catchParams.addElement(node);
            catchBlocks.addElement(this.jjtGetChild(i++));
            node = null;
        }
        BSHBlock finallyBlock = null;
        if (node != null) {
            finallyBlock = (BSHBlock)node;
        }
        TargetError target = null;
        Throwable thrown = null;
        Object ret = null;
        int callstackDepth = callstack.depth();
        try {
            ret = tryBlock.eval(callstack, interpreter);
        }
        catch (TargetError e) {
            target = e;
            Object stackInfo = "Bsh Stack: ";
            while (callstack.depth() > callstackDepth) {
                stackInfo = (String)stackInfo + "\t" + String.valueOf(callstack.pop()) + "\n";
            }
        }
        if (target != null) {
            thrown = target.getTarget();
        }
        if (thrown != null) {
            int n = catchParams.size();
            for (i = 0; i < n; ++i) {
                BSHFormalParameter fp = (BSHFormalParameter)catchParams.elementAt(i);
                fp.eval(callstack, interpreter);
                if (fp.type == null && interpreter.getStrictJava()) {
                    throw new EvalError("(Strict Java) Untyped catch block", this, callstack);
                }
                if (fp.type != null) {
                    try {
                        thrown = (Throwable)Types.castObject(thrown, fp.type, 1);
                    }
                    catch (UtilEvalError e) {
                        continue;
                    }
                }
                BSHBlock cb = (BSHBlock)catchBlocks.elementAt(i);
                NameSpace enclosingNameSpace = callstack.top();
                BlockNameSpace cbNameSpace = new BlockNameSpace(enclosingNameSpace);
                try {
                    if (fp.type == BSHFormalParameter.UNTYPED) {
                        cbNameSpace.setBlockVariable(fp.name, thrown);
                    } else {
                        Modifiers modifiers = new Modifiers();
                        cbNameSpace.setTypedVariable(fp.name, fp.type, (Object)thrown, new Modifiers());
                    }
                }
                catch (UtilEvalError e) {
                    throw new InterpreterError("Unable to set var in catch block namespace.");
                }
                callstack.swap(cbNameSpace);
                try {
                    ret = cb.eval(callstack, interpreter);
                }
                finally {
                    callstack.swap(enclosingNameSpace);
                }
                target = null;
                break;
            }
        }
        if (finallyBlock != null) {
            ret = finallyBlock.eval(callstack, interpreter);
        }
        if (target != null) {
            throw target;
        }
        if (ret instanceof ReturnControl) {
            return ret;
        }
        return Primitive.VOID;
    }
}

