/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bsh;

import java.util.Hashtable;
import org.gjt.sp.jedit.bsh.UtilEvalError;

public class Capabilities {
    private static boolean accessibility = false;
    private static Hashtable classes = new Hashtable();

    public static boolean haveSwing() {
        return Capabilities.classExists("javax.swing.JButton");
    }

    public static boolean canGenerateInterfaces() {
        return Capabilities.classExists("java.lang.reflect.Proxy");
    }

    public static boolean haveAccessibility() {
        return accessibility;
    }

    public static void setAccessibility(boolean b) throws Unavailable {
        if (b) {
            throw new Unavailable("Accessibility unavailable");
        }
        accessibility = false;
    }

    public static boolean classExists(String name) {
        Object c = classes.get(name);
        if (c == null) {
            try {
                c = Class.forName(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (c != null) {
                classes.put(c, "unused");
            }
        }
        return c != null;
    }

    public static class Unavailable
    extends UtilEvalError {
        public Unavailable(String s) {
            super(s);
        }
    }
}

