/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.buffer;

import javax.swing.text.Segment;
import org.gjt.sp.jedit.buffer.BufferSegment;

class ContentManager {
    private static final char[] EMPTY_TEXT = new char[0];
    private char[] text = EMPTY_TEXT;
    private int gapStart;
    private int length;

    ContentManager() {
    }

    public final int getLength() {
        return this.length;
    }

    public String getText(int start, int len) {
        if (start >= this.gapStart) {
            return new String(this.text, start + this.gapLength(), len);
        }
        if (start + len <= this.gapStart) {
            return new String(this.text, start, len);
        }
        return new String(this.text, start, this.gapStart - start).concat(new String(this.text, this.gapEnd(), start + len - this.gapStart));
    }

    public void getText(int start, int len, Segment seg) {
        if (start >= this.gapStart) {
            seg.array = this.text;
            seg.offset = start + this.gapLength();
            seg.count = len;
        } else if (start + len <= this.gapStart) {
            seg.array = this.text;
            seg.offset = start;
            seg.count = len;
        } else {
            seg.array = new char[len];
            System.arraycopy(this.text, start, seg.array, 0, this.gapStart - start);
            System.arraycopy(this.text, this.gapEnd(), seg.array, this.gapStart - start, len + start - this.gapStart);
            seg.offset = 0;
            seg.count = len;
        }
    }

    public CharSequence getSegment(int start, int len) {
        if (start >= this.gapStart) {
            return new BufferSegment(this.text, start + this.gapLength(), len);
        }
        if (start + len <= this.gapStart) {
            return new BufferSegment(this.text, start, len);
        }
        return new BufferSegment(this.text, start, this.gapStart - start, new BufferSegment(this.text, this.gapEnd(), start + len - this.gapStart));
    }

    public void insert(int start, String str) {
        int len = str.length();
        this.prepareGapForInsertion(start, len);
        str.getChars(0, len, this.text, start);
        this.gapStart += len;
        this.length += len;
    }

    public void insert(int start, CharSequence str) {
        int len = str.length();
        this.prepareGapForInsertion(start, len);
        for (int i = 0; i < len; ++i) {
            this.text[start + i] = str.charAt(i);
        }
        this.gapStart += len;
        this.length += len;
    }

    public void insert(int start, Segment seg) {
        this.prepareGapForInsertion(start, seg.count);
        System.arraycopy(seg.array, seg.offset, this.text, start, seg.count);
        this.gapStart += seg.count;
        this.length += seg.count;
    }

    public void _setContent(char[] text, int length) {
        assert (text != null);
        assert (text.length >= length);
        this.text = text;
        this.gapStart = length;
        this.length = length;
    }

    public void remove(int start, int len) {
        this.moveGapStart(start);
        this.length -= len;
    }

    private int gapEnd() {
        return this.gapStart + this.gapLength();
    }

    private int gapLength() {
        return this.text.length - this.length;
    }

    private void moveGapStart(int newStart) {
        int gapEnd = this.gapEnd();
        int newEnd = gapEnd + (newStart - this.gapStart);
        if (newStart != this.gapStart) {
            if (newStart > this.gapStart) {
                System.arraycopy(this.text, gapEnd, this.text, this.gapStart, newStart - this.gapStart);
            } else if (newStart < this.gapStart) {
                System.arraycopy(this.text, newStart, this.text, newEnd, this.gapStart - newStart);
            }
        }
        this.gapStart = newStart;
    }

    private void ensureCapacity(int capacity) {
        if (capacity >= this.text.length) {
            int gapEndOld = this.gapEnd();
            char[] textN = new char[capacity * 2];
            System.arraycopy(this.text, 0, textN, 0, this.text.length);
            this.text = textN;
            int gapEndNew = this.gapEnd();
            System.arraycopy(this.text, gapEndOld, this.text, gapEndNew, this.text.length - gapEndNew);
        }
    }

    private void prepareGapForInsertion(int start, int len) {
        this.moveGapStart(start);
        if (this.gapLength() < len) {
            this.ensureCapacity(this.length + len);
        }
    }
}

