/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import org.gjt.sp.jedit.gui.DockablePanel;

public class DockableLayout
implements LayoutManager2 {
    static final String CENTER = "Center";
    static final String TOP_BUTTONS = "top-buttons";
    static final String LEFT_BUTTONS = "left-buttons";
    static final String BOTTOM_BUTTONS = "bottom-buttons";
    static final String RIGHT_BUTTONS = "right-buttons";
    private boolean alternateLayout;
    private Component center;
    private DockablePanel top;
    private DockablePanel left;
    private DockablePanel bottom;
    private DockablePanel right;
    private Component topButtons;
    private Component leftButtons;
    private Component bottomButtons;
    private Component rightButtons;

    public boolean isAlternateLayout() {
        return this.alternateLayout;
    }

    public void setAlternateLayout(boolean alternateLayout) {
        this.alternateLayout = alternateLayout;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        this.addLayoutComponent(comp, name);
    }

    @Override
    public void addLayoutComponent(Component comp, Object cons) {
        if (cons == null || CENTER.equals(cons)) {
            this.center = comp;
        } else if ("top".equals(cons)) {
            this.top = (DockablePanel)comp;
        } else if ("left".equals(cons)) {
            this.left = (DockablePanel)comp;
        } else if ("bottom".equals(cons)) {
            this.bottom = (DockablePanel)comp;
        } else if ("right".equals(cons)) {
            this.right = (DockablePanel)comp;
        } else if (TOP_BUTTONS.equals(cons)) {
            this.topButtons = comp;
        } else if (LEFT_BUTTONS.equals(cons)) {
            this.leftButtons = comp;
        } else if (BOTTOM_BUTTONS.equals(cons)) {
            this.bottomButtons = comp;
        } else if (RIGHT_BUTTONS.equals(cons)) {
            this.rightButtons = comp;
        }
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        if (this.center == comp) {
            this.center = null;
        } else if (comp == this.top) {
            this.top = null;
        } else if (comp == this.left) {
            this.left = null;
        } else if (comp == this.bottom) {
            this.bottom = null;
        } else if (comp == this.right) {
            this.right = null;
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension prefSize = new Dimension(0, 0);
        Dimension _top = this.top.getPreferredSize();
        Dimension _left = this.left.getPreferredSize();
        Dimension _bottom = this.bottom.getPreferredSize();
        Dimension _right = this.right.getPreferredSize();
        Dimension _topButtons = this.topButtons.getPreferredSize();
        Dimension _leftButtons = this.leftButtons.getPreferredSize();
        Dimension _bottomButtons = this.bottomButtons.getPreferredSize();
        Dimension _rightButtons = this.rightButtons.getPreferredSize();
        Dimension _center = this.center == null ? new Dimension(0, 0) : this.center.getPreferredSize();
        Dimension _topToolbars = new Dimension(0, 0);
        Dimension _bottomToolbars = new Dimension(0, 0);
        prefSize.height = _top.height + _bottom.height + _center.height + _topButtons.height + _bottomButtons.height + _topToolbars.height + _bottomToolbars.height;
        prefSize.width = _left.width + _right.width + Math.max(_center.width, Math.max(_topToolbars.width, _bottomToolbars.width)) + _leftButtons.width + _rightButtons.width;
        return prefSize;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public Dimension maximumLayoutSize(Container parent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public void layoutContainer(Container parent) {
        int rightButtonWidth;
        int leftButtonWidth;
        int bottomButtonHeight;
        int topButtonHeight;
        Dimension size = parent.getSize();
        Dimension _topToolbars = new Dimension(0, 0);
        Dimension _bottomToolbars = new Dimension(0, 0);
        Dimension _top = this.top.getPreferredSize();
        Dimension _left = this.left.getPreferredSize();
        Dimension _bottom = this.bottom.getPreferredSize();
        Dimension _right = this.right.getPreferredSize();
        int topHeight = _top.height;
        int bottomHeight = _bottom.height;
        int leftWidth = _left.width;
        int rightWidth = _right.width;
        boolean topEmpty = ((Container)this.topButtons).getComponentCount() <= 2;
        boolean leftEmpty = ((Container)this.leftButtons).getComponentCount() <= 2;
        boolean bottomEmpty = ((Container)this.bottomButtons).getComponentCount() <= 2;
        boolean rightEmpty = ((Container)this.rightButtons).getComponentCount() <= 2;
        Dimension closeBoxSize = ((Container)this.topButtons).getComponentCount() == 0 ? new Dimension(0, 0) : ((Container)this.topButtons).getComponent(0).getPreferredSize();
        int closeBoxWidth = Math.max(closeBoxSize.width, closeBoxSize.height) + 1;
        if (this.alternateLayout) {
            int _width = size.width;
            int padding = leftEmpty && rightEmpty ? 0 : closeBoxWidth;
            topButtonHeight = this.top.getWindowContainer().getWrappedDimension(this.top.getSize().width - closeBoxWidth * 2);
            this.topButtons.setBounds(padding, 0, size.width - padding * 2, topButtonHeight);
            bottomButtonHeight = this.bottom.getWindowContainer().getWrappedDimension(this.bottom.getSize().width);
            this.bottomButtons.setBounds(padding, size.height - bottomButtonHeight, size.width - padding * 2, bottomButtonHeight);
            int _height = size.height - topButtonHeight - bottomButtonHeight;
            leftButtonWidth = this.left.getWindowContainer().getWrappedDimension(this.left.getSize().height);
            this.leftButtons.setBounds(0, topHeight + topButtonHeight, leftButtonWidth, _height - topHeight - bottomHeight);
            rightButtonWidth = this.right.getWindowContainer().getWrappedDimension(this.right.getSize().height);
            this.rightButtons.setBounds(size.width - rightButtonWidth, topHeight + topButtonHeight, rightButtonWidth, _height - topHeight - bottomHeight);
            int[] dimensions = this.adjustDockingAreasToFit(size, topHeight, leftWidth, bottomHeight, rightWidth, topButtonHeight, leftButtonWidth, bottomButtonHeight, rightButtonWidth, _topToolbars, _bottomToolbars);
            topHeight = dimensions[0];
            leftWidth = dimensions[1];
            bottomHeight = dimensions[2];
            rightWidth = dimensions[3];
            this.top.setBounds(0, topButtonHeight, size.width, topHeight);
            this.bottom.setBounds(0, size.height - bottomHeight - bottomButtonHeight, size.width, bottomHeight);
            this.left.setBounds(leftButtonWidth, topButtonHeight + topHeight, leftWidth, _height - topHeight - bottomHeight);
            this.right.setBounds(_width - rightButtonWidth - rightWidth, topButtonHeight + topHeight, rightWidth, _height - topHeight - bottomHeight);
        } else {
            int _height = size.height;
            int padding = topEmpty && bottomEmpty ? 0 : closeBoxWidth;
            leftButtonWidth = this.left.getWindowContainer().getWrappedDimension(this.left.getSize().height - closeBoxWidth * 2);
            this.leftButtons.setBounds(0, padding, leftButtonWidth, _height - padding * 2);
            rightButtonWidth = this.right.getWindowContainer().getWrappedDimension(this.right.getSize().height);
            this.rightButtons.setBounds(size.width - rightButtonWidth, padding, rightButtonWidth, _height - padding * 2);
            int _width = size.width - leftButtonWidth - rightButtonWidth;
            topButtonHeight = this.top.getWindowContainer().getWrappedDimension(this.top.getSize().width);
            this.topButtons.setBounds(leftButtonWidth + leftWidth, 0, _width - leftWidth - rightWidth, topButtonHeight);
            bottomButtonHeight = this.bottom.getWindowContainer().getWrappedDimension(this.bottom.getSize().width);
            this.bottomButtons.setBounds(leftButtonWidth + leftWidth, _height - bottomButtonHeight, _width - leftWidth - rightWidth, bottomButtonHeight);
            int[] dimensions = this.adjustDockingAreasToFit(size, topHeight, leftWidth, bottomHeight, rightWidth, topButtonHeight, leftButtonWidth, bottomButtonHeight, rightButtonWidth, _topToolbars, _bottomToolbars);
            topHeight = dimensions[0];
            leftWidth = dimensions[1];
            bottomHeight = dimensions[2];
            rightWidth = dimensions[3];
            this.top.setBounds(leftButtonWidth + leftWidth, topButtonHeight, _width - leftWidth - rightWidth, topHeight);
            this.bottom.setBounds(leftButtonWidth + leftWidth, size.height - bottomHeight - bottomButtonHeight, _width - leftWidth - rightWidth, bottomHeight);
            this.left.setBounds(leftButtonWidth, 0, leftWidth, _height);
            this.right.setBounds(size.width - rightWidth - rightButtonWidth, 0, rightWidth, _height);
        }
        if (this.center != null) {
            this.center.setBounds(leftButtonWidth + leftWidth, topButtonHeight + topHeight + _topToolbars.height, size.width - leftWidth - rightWidth - leftButtonWidth - rightButtonWidth, size.height - topHeight - topButtonHeight - bottomHeight - bottomButtonHeight - _topToolbars.height - _bottomToolbars.height);
        }
    }

    private int[] adjustDockingAreasToFit(Dimension size, int topHeight, int leftWidth, int bottomHeight, int rightWidth, int topButtonHeight, int leftButtonWidth, int bottomButtonHeight, int rightButtonWidth, Dimension _topToolbars, Dimension _bottomToolbars) {
        int maxTopHeight = size.height - bottomHeight - topButtonHeight - bottomButtonHeight - _topToolbars.height - _bottomToolbars.height;
        topHeight = Math.min(Math.max(0, maxTopHeight), topHeight);
        leftWidth = Math.min(Math.max(0, size.width - leftButtonWidth - rightButtonWidth - rightWidth), leftWidth);
        int maxBottomHeight = size.height - topHeight - topButtonHeight - bottomButtonHeight - _topToolbars.height - _bottomToolbars.height;
        bottomHeight = Math.min(Math.max(0, maxBottomHeight), bottomHeight);
        rightWidth = Math.min(Math.max(0, size.width - leftButtonWidth - rightButtonWidth - leftWidth), rightWidth);
        this.top.getWindowContainer().setDimension(topHeight);
        this.left.getWindowContainer().setDimension(leftWidth);
        this.bottom.getWindowContainer().setDimension(bottomHeight);
        this.right.getWindowContainer().setDimension(rightWidth);
        return new int[]{topHeight, leftWidth, bottomHeight, rightWidth};
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }
}

