/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.gui.NumericTextField;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.GenericGUIUtilities;

public class SelectLineRange
extends EnhancedDialog
implements ActionListener {
    private final View view;
    private NumericTextField startField;
    private NumericTextField endField;
    private final JButton ok;
    private final JButton cancel;

    public SelectLineRange(View view) {
        super(view, jEdit.getProperty("selectlinerange.title"), true);
        this.view = view;
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(new EmptyBorder(12, 12, 11, 11));
        this.setContentPane(content);
        JLabel label = new JLabel(jEdit.getProperty("selectlinerange.caption"));
        label.setBorder(new EmptyBorder(0, 0, 6, 12));
        content.add("North", label);
        JPanel panel = this.createFieldPanel();
        content.add("Center", panel);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBorder(new EmptyBorder(17, 0, 0, 0));
        this.ok = new JButton(jEdit.getProperty("common.ok"));
        this.ok.addActionListener(this);
        this.getRootPane().setDefaultButton(this.ok);
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.cancel.addActionListener(this);
        GenericGUIUtilities.makeSameSize(this.ok, this.cancel);
        panel.add(Box.createGlue());
        panel.add(this.ok);
        panel.add(Box.createHorizontalStrut(6));
        panel.add(this.cancel);
        content.add((Component)panel, "South");
        GenericGUIUtilities.requestFocus(this, this.startField);
        this.pack();
        this.setLocationRelativeTo(view);
        this.setVisible(true);
    }

    @Override
    public void ok() {
        int endLine;
        int startLine;
        try {
            startLine = Integer.parseInt(this.startField.getText()) - 1;
            endLine = Integer.parseInt(this.endField.getText()) - 1;
        }
        catch (NumberFormatException nf) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
        Buffer buffer = this.view.getBuffer();
        if (startLine < 0 || endLine >= buffer.getLineCount() || startLine > endLine) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
        JEditTextArea textArea = this.view.getTextArea();
        Selection.Range s = new Selection.Range(buffer.getLineStartOffset(startLine), buffer.getLineEndOffset(endLine) - 1);
        if (textArea.isMultipleSelectionEnabled()) {
            textArea.addToSelection(s);
        } else {
            textArea.setSelection(s);
        }
        textArea.moveCaretPosition(buffer.getLineEndOffset(endLine) - 1);
        this.dispose();
    }

    @Override
    public void cancel() {
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.ok) {
            this.ok();
        } else if (source == this.cancel) {
            this.cancel();
        }
    }

    private JPanel createFieldPanel() {
        GridBagLayout layout = new GridBagLayout();
        JPanel panel = new JPanel(layout);
        GridBagConstraints cons = new GridBagConstraints();
        cons.insets = new Insets(0, 0, 6, 6);
        cons.gridheight = 1;
        cons.gridwidth = 1;
        cons.gridy = 0;
        cons.gridx = 0;
        cons.fill = 1;
        JLabel label = new JLabel(jEdit.getProperty("selectlinerange.start"), 4);
        layout.setConstraints(label, cons);
        panel.add(label);
        this.startField = new NumericTextField("0", 10, true);
        FocusListener focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent fe) {
                ((JTextField)fe.getSource()).selectAll();
            }

            @Override
            public void focusLost(FocusEvent fe) {
                JTextField source = (JTextField)fe.getSource();
                source.setCaretPosition(source.getText().length());
            }
        };
        this.startField.addFocusListener(focusListener);
        cons.gridx = 1;
        cons.weightx = 1.0;
        layout.setConstraints(this.startField, cons);
        panel.add(this.startField);
        label = new JLabel(jEdit.getProperty("selectlinerange.end"), 4);
        cons.gridx = 0;
        cons.weightx = 0.0;
        cons.gridy = 1;
        layout.setConstraints(label, cons);
        panel.add(label);
        this.endField = new NumericTextField("0", 10, true);
        this.endField.addFocusListener(focusListener);
        cons.gridx = 1;
        cons.weightx = 1.0;
        layout.setConstraints(this.endField, cons);
        panel.add(this.endField);
        return panel;
    }
}

