/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.EventQueue;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.JList;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.BufferOptions;
import org.gjt.sp.jedit.gui.DialogChooser;
import org.gjt.sp.jedit.gui.statusbar.AbstractLabelWidget;
import org.gjt.sp.jedit.gui.statusbar.StatusBarEventType;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.util.StandardUtilities;

public class EncodingWidgetFactory
implements StatusWidgetFactory {
    @Override
    public Widget getWidget(View view) {
        return new EncodingWidget(view);
    }

    private static class EncodingWidget
    extends AbstractLabelWidget {
        EncodingWidget(View view) {
            super(view);
            this.label.setToolTipText(jEdit.getProperty("view.status.encoding-tooltip"));
        }

        @Override
        protected void singleClick(MouseEvent e) {
            Object[] encodings = MiscUtilities.getEncodings(true);
            Arrays.sort(encodings, String.CASE_INSENSITIVE_ORDER);
            Buffer buffer = this.view.getBuffer();
            String currentEncoding = buffer.getStringProperty("encoding");
            DialogChooser.openListChooserWindow(this.label, currentEncoding, listSelectionEvent -> EventQueue.invokeLater(() -> {
                JList list = (JList)StandardUtilities.castUnchecked(listSelectionEvent.getSource());
                String selectedValue = (String)list.getSelectedValue();
                int selectedOption = DialogChooser.openChooserWindow(this.view, jEdit.getProperty("buffer.encoding.reload", new String[]{selectedValue}), jEdit.getProperty("buffer.encoding.change", new String[]{selectedValue}));
                switch (selectedOption) {
                    case 0: {
                        buffer.reloadWithEncoding(this.view, selectedValue);
                        break;
                    }
                    case 1: {
                        buffer.setStringProperty("encoding", selectedValue);
                        buffer.setDirty(true);
                        buffer.setBooleanProperty("encodingAutodetect", false);
                        EditBus.send(new BufferUpdate(buffer, null, BufferUpdate.PROPERTIES_CHANGED));
                    }
                }
            }), encodings);
        }

        @Override
        protected void rightClick(MouseEvent e) {
            new BufferOptions(this.view, this.view.getBuffer());
        }

        @Override
        public void update() {
            Buffer buffer = this.view.getBuffer();
            if (buffer.isLoaded()) {
                this.label.setText(buffer.getStringProperty("encoding"));
            }
        }

        @Override
        public boolean test(StatusBarEventType statusBarEventType) {
            return statusBarEventType == StatusBarEventType.Buffer;
        }
    }
}

