/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.event.MouseEvent;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.statusbar.AbstractLabelWidget;
import org.gjt.sp.jedit.gui.statusbar.StatusBarEventType;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;

public class RectSelectWidgetFactory
implements StatusWidgetFactory {
    @Override
    public Widget getWidget(View view) {
        return new RectSelectWidget(view);
    }

    private static class RectSelectWidget
    extends AbstractLabelWidget {
        RectSelectWidget(View view) {
            super(view);
            this.label.setToolTipText(jEdit.getProperty("view.status.rect-tooltip"));
        }

        @Override
        protected void singleClick(MouseEvent e) {
            JEditTextArea textArea = this.view.getTextArea();
            if (textArea != null) {
                textArea.toggleRectangularSelectionEnabled();
            }
        }

        @Override
        public void update() {
            JEditTextArea textArea = this.view.getTextArea();
            if (textArea != null) {
                this.label.setEnabled(textArea.isRectangularSelectionEnabled());
                this.label.setText("Rect sel: " + textArea.isRectangularSelectionEnabled());
            }
        }

        @Override
        public boolean test(StatusBarEventType statusBarEventType) {
            return statusBarEventType == StatusBarEventType.Misc;
        }
    }
}

