/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import javax.swing.JComponent;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.ToolTipLabel;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.TextArea;

public class SelectionLengthWidgetFactory
implements StatusWidgetFactory {
    @Override
    public Widget getWidget(View view) {
        return new SelectionLengthWidget(view);
    }

    public static class SelectionLengthWidget
    implements Widget {
        private final SelectionLength selectionLength;
        private final View view;
        private TextArea textArea;

        SelectionLengthWidget(View view) {
            this.view = view;
            this.textArea = view.getTextArea();
            this.selectionLength = new SelectionLength();
            this.selectionLength.setForeground(jEdit.getColorProperty("view.status.foreground"));
            this.selectionLength.setBackground(jEdit.getColorProperty("view.status.background"));
            EditBus.addToBus(this);
        }

        @Override
        public JComponent getComponent() {
            return this.selectionLength;
        }

        @Override
        public void update() {
            Selection selection = this.textArea.getSelectionAtOffset(this.textArea.getCaretPosition());
            if (selection == null) {
                this.selectionLength.setText("0");
            } else {
                int len;
                int selectionEnd = selection.getEnd();
                int selectionStart = selection.getStart();
                if (selection instanceof Selection.Rect) {
                    int startLine = selection.getStartLine();
                    int endLine = selection.getEndLine();
                    JEditTextArea textArea = this.view.getTextArea();
                    int startLineOffset = textArea.getLineStartOffset(startLine);
                    int endLineOffset = textArea.getLineStartOffset(endLine);
                    int lines = endLine - startLine + 1;
                    int columns = selectionEnd - endLineOffset - (selectionStart - startLineOffset);
                    len = lines * columns;
                } else {
                    len = selectionEnd - selectionStart;
                }
                this.selectionLength.setText(Integer.toString(len));
            }
        }

        @EditBus.EBHandler
        public void handleViewUpdate(ViewUpdate viewUpdate) {
            if (viewUpdate.getView() == this.view && viewUpdate.getWhat() == ViewUpdate.EDIT_PANE_CHANGED) {
                if (this.textArea != null) {
                    this.textArea.removeCaretListener(this.selectionLength);
                }
                this.textArea = this.view.getTextArea();
                if (this.selectionLength.visible) {
                    this.textArea.addCaretListener(this.selectionLength);
                }
            }
        }

        private class SelectionLength
        extends ToolTipLabel
        implements CaretListener {
            boolean visible;

            private SelectionLength() {
            }

            @Override
            public void addNotify() {
                super.addNotify();
                this.visible = true;
                SelectionLengthWidget.this.textArea.addCaretListener(this);
            }

            @Override
            public void removeNotify() {
                this.visible = false;
                SelectionLengthWidget.this.textArea.removeCaretListener(this);
                super.removeNotify();
            }

            @Override
            public void caretUpdate(CaretEvent e) {
                SelectionLengthWidget.this.update();
            }
        }
    }
}

