/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.help;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Stack;
import javax.swing.tree.DefaultMutableTreeNode;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class HelpTOCLoader {
    private final Map<String, DefaultMutableTreeNode> nodes;
    private final String baseURL;

    public HelpTOCLoader(Map<String, DefaultMutableTreeNode> nodes, String baseURL) {
        this.nodes = nodes;
        this.baseURL = baseURL;
    }

    public DefaultMutableTreeNode createTOC() {
        EditPlugin[] plugins = jEdit.getPlugins();
        Arrays.sort(plugins, new PluginCompare());
        DefaultMutableTreeNode tocRoot = new DefaultMutableTreeNode();
        tocRoot.add(this.createNode("welcome.html", jEdit.getProperty("helpviewer.toc.welcome")));
        tocRoot.add(this.createNode("README.txt", jEdit.getProperty("helpviewer.toc.readme")));
        tocRoot.add(this.createNode("CHANGES.txt", jEdit.getProperty("helpviewer.toc.changes")));
        tocRoot.add(this.createNode("TODO.txt", jEdit.getProperty("helpviewer.toc.todo")));
        tocRoot.add(this.createNode("COPYING.txt", jEdit.getProperty("helpviewer.toc.copying")));
        tocRoot.add(this.createNode("COPYING.DOC.txt", jEdit.getProperty("helpviewer.toc.copying-doc")));
        tocRoot.add(this.createNode("Apache.LICENSE.txt", jEdit.getProperty("helpviewer.toc.copying-apache")));
        tocRoot.add(this.createNode("COPYING.PLUGINS.txt", jEdit.getProperty("helpviewer.toc.copying-plugins")));
        this.loadTOC(tocRoot, "whatsnew/toc.xml");
        this.loadTOC(tocRoot, "users-guide/toc.xml");
        this.loadTOC(tocRoot, "FAQ/toc.xml");
        DefaultMutableTreeNode pluginTree = new DefaultMutableTreeNode(jEdit.getProperty("helpviewer.toc.plugins"), true);
        for (EditPlugin plugin : plugins) {
            String name = plugin.getClassName();
            String docs = jEdit.getProperty("plugin." + name + ".docs");
            String label = jEdit.getProperty("plugin." + name + ".name");
            if (label == null || docs == null) continue;
            String path = plugin.getPluginJAR().getClassLoader().getResourceAsPath(docs);
            pluginTree.add(this.createNode(path, label));
        }
        if (pluginTree.getChildCount() != 0) {
            tocRoot.add(pluginTree);
        }
        this.loadTOC(tocRoot, "api/toc.xml");
        return tocRoot;
    }

    private DefaultMutableTreeNode createNode(String href, String title) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new HelpNode(href, title), true);
        if (this.nodes != null) {
            this.nodes.put(href, node);
        }
        return node;
    }

    private void loadTOC(DefaultMutableTreeNode root, String path) {
        TOCHandler h = new TOCHandler(root, MiscUtilities.getParentOfPath(path));
        try {
            XMLUtilities.parseXML(new URL(this.baseURL + "/" + path).openStream(), h);
        }
        catch (FileNotFoundException e) {
            if ("api/toc.xml".equals(path)) {
                Log.log(5, this, "The API docs for jEdit will not be available (reinstall jEdit if you want them)");
                root.add(this.createNode("http://www.jedit.org/api/overview-summary.html", jEdit.getProperty("helpviewer.toc.online-apidocs")));
            } else {
                Log.log(9, this, e);
            }
        }
        catch (IOException e) {
            Log.log(9, this, e);
        }
    }

    static class PluginCompare
    implements Comparator<EditPlugin> {
        PluginCompare() {
        }

        @Override
        public int compare(EditPlugin p1, EditPlugin p2) {
            return StandardUtilities.compareStrings(jEdit.getProperty("plugin." + p1.getClassName() + ".name"), jEdit.getProperty("plugin." + p2.getClassName() + ".name"), true);
        }
    }

    public static class HelpNode {
        public final String href;
        public final String title;

        HelpNode(String href, String title) {
            this.href = href;
            this.title = title;
        }

        public String toString() {
            return this.title;
        }
    }

    class TOCHandler
    extends DefaultHandler {
        String dir;
        private String tag;
        private final StringBuilder title = new StringBuilder();
        private String href;
        private DefaultMutableTreeNode node;
        private final Stack<DefaultMutableTreeNode> nodes = new Stack();

        TOCHandler(DefaultMutableTreeNode root, String dir2) {
            this.node = root;
            this.dir = dir2;
        }

        @Override
        public void characters(char[] c, int off, int len) {
            if (this.tag.equals("TITLE")) {
                boolean firstNonWhitespace = false;
                for (int i = 0; i < len; ++i) {
                    char ch = c[off + i];
                    if (!firstNonWhitespace && Character.isWhitespace(ch)) continue;
                    firstNonWhitespace = true;
                    this.title.append(ch);
                }
            }
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attrs) {
            this.tag = name;
            if (name.equals("ENTRY")) {
                this.href = attrs.getValue("HREF");
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) {
            if (name == null) {
                return;
            }
            if (name.equals("TITLE")) {
                DefaultMutableTreeNode newNode = HelpTOCLoader.this.createNode(this.dir + this.href, this.title.toString());
                this.node.add(newNode);
                this.nodes.push(this.node);
                this.node = newNode;
                this.title.setLength(0);
            } else if (name.equals("ENTRY")) {
                this.node = this.nodes.pop();
                this.href = null;
            }
        }
    }
}

