/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.CharBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.gjt.sp.jedit.io.EncodingDetector;
import org.gjt.sp.jedit.io.EncodingServer;

public class RegexEncodingDetector
implements EncodingDetector {
    public static final String VALID_ENCODING_PATTERN = "\\p{Alnum}[\\p{Alnum}\\-.:_]*";
    private final Pattern pattern;
    private final String replacement;

    public RegexEncodingDetector(String pattern, String replacement) {
        this.pattern = Pattern.compile(pattern);
        this.replacement = replacement;
    }

    @Override
    @Nullable
    public String detectEncoding(InputStream sample) throws IOException {
        InputStreamReader reader = new InputStreamReader(sample);
        int bufferSize = 1024;
        char[] buffer = new char[1024];
        int readSize = reader.read(buffer, 0, 1024);
        if (readSize > 0) {
            Matcher matcher = this.pattern.matcher(CharBuffer.wrap(buffer, 0, readSize));
            int appendPosition = 0;
            while (matcher.find()) {
                String extracted = RegexEncodingDetector.extractReplacement(matcher, appendPosition, this.replacement);
                if (EncodingServer.hasEncoding(extracted)) {
                    return extracted;
                }
                appendPosition = matcher.end();
            }
        }
        return null;
    }

    private static String extractReplacement(Matcher found, int appendPosition, String replacement) {
        int found_start = found.start();
        int found_end = found.end();
        int source_length = found_end - found_start;
        int length_before_match = found_start - appendPosition;
        StringBuilder replaced = new StringBuilder(length_before_match + source_length * 2);
        found.appendReplacement(replaced, replacement);
        return replaced.substring(length_before_match);
    }

    public String toString() {
        return "RegexEncodingDetector{pattern=" + String.valueOf(this.pattern) + ", replacement='" + this.replacement + "'}";
    }
}

