/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.menu;

import java.io.File;
import java.util.Arrays;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.FileCellRenderer;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.DynamicMenuProvider;
import org.gjt.sp.util.StandardUtilities;

public class DirectoryProvider
implements DynamicMenuProvider {
    private final String dir;

    public DirectoryProvider(String dir2) {
        this.dir = dir2;
    }

    @Override
    public boolean updateEveryTime() {
        return true;
    }

    @Override
    public void update(JMenu menu) {
        View view = GUIUtilities.getView(menu);
        String path = this.dir == null ? view.getBuffer().getDirectory() : this.dir;
        JMenuItem mi = new JMenuItem(path + ":");
        mi.setActionCommand(path);
        mi.setIcon(FileCellRenderer.openDirIcon);
        mi.addActionListener(evt -> VFSBrowser.browseDirectory(view, evt.getActionCommand()));
        menu.add(mi);
        menu.addSeparator();
        if (this.dir == null && !(view.getBuffer().getVFS() instanceof FileVFS)) {
            mi = new JMenuItem(jEdit.getProperty("directory.not-local"));
            mi.setEnabled(false);
            menu.add(mi);
            return;
        }
        File directory = new File(path);
        JMenu current = menu;
        String backupPrefix = jEdit.getProperty("backup.prefix");
        String backupSuffix = jEdit.getProperty("backup.suffix");
        File[] list = directory.listFiles();
        if (list == null || list.length == 0) {
            mi = new JMenuItem(jEdit.getProperty("directory.no-files"));
            mi.setEnabled(false);
            menu.add(mi);
        } else {
            int maxItems = jEdit.getIntegerProperty("menu.spillover", 20);
            Arrays.sort(list, new StandardUtilities.StringCompare(true));
            for (int i = 0; i < list.length; ++i) {
                File file = list[i];
                String name = file.getName();
                if (name.endsWith(".marks") || name.startsWith("#") && name.endsWith("#") || !backupPrefix.isEmpty() && name.startsWith(backupPrefix) || !backupSuffix.isEmpty() && name.endsWith(backupSuffix)) continue;
                mi = new JMenuItem(name);
                mi.setActionCommand(file.getPath());
                if (file.isDirectory()) {
                    mi.addActionListener(evt -> VFSBrowser.browseDirectory(view, evt.getActionCommand()));
                    mi.setIcon(FileCellRenderer.dirIcon);
                } else {
                    mi.addActionListener(evt -> jEdit.openFile(view, evt.getActionCommand()));
                    mi.setIcon(FileCellRenderer.fileIcon);
                }
                if (current.getItemCount() >= maxItems && i != list.length - 1) {
                    JMenu newCurrent = new JMenu(jEdit.getProperty("common.more"));
                    current.add(newCurrent);
                    current = newCurrent;
                }
                current.add(mi);
            }
        }
    }
}

